    INCLUDE 'mkl_vsl.f90'
    !INCLUDE 'link_fnl_static.h'
    !!DEC$ OBJCOMMENT LIB:'libiomp5md.lib'

    PROGRAM estimation

    USE random
    USE TOOL
    USE lapack95
    USE MKL_VSL_TYPE
    USE MKL_VSL
    !USE LFDRG_INT
    !USE LFTRG_INT
    !USE UMACH_INT
    USE omp_lib
    IMPLICIT NONE


    !****************** GENERAL VARIABLES ****************!
    CHARACTER(100) :: path1='/home/research/social_preference_and_social_interaction/empirical/'
    CHARACTER(100) :: path2='/data/'
    CHARACTER(100) :: path3='/result/social_preference/'
    INTEGER, PARAMETER :: GG=24, TT=50000, MAX=300, THIN=100, Nthreads=125, H=10, H1=20, burn=5000, dep=15
    REAL, PARAMETER    :: pi=3.14159265
    REAL               :: c_0a(GG), c_0z(GG), c_1, c_2, c_3, acc_1, acc_2, rand, rand1(1), acc_4, acc_3(GG), acc_0v, acc_0a(GG), acc_0z(GG), kk, AICM
    INTEGER            :: NN, N(GG),  k, censor(GG), flag(GG)
    INTEGER            :: brng, method, me, i, j, g, t, d, ier,  r, seedsize, seed(2), errorflag, INFO, seed_mkl, t_round
    INTEGER            :: clock_max, clock_rate, clock_start, clock_stop, ithread, iblock,ibegin,iend
    REAL, DIMENSION(MAX,MAX,GG):: age, sex, race, network
    REAL, DIMENSION(MAX,16,GG):: group
    REAL, ALLOCATABLE:: C1(:,:), C2(:,:), C3(:,:), W(:,:), Wt(:,:), W_altru(:,:), W_altru1(:,:), W_altru2(:,:), IPIV(:), Y(:), X(:,:), FACT(:,:)
    REAL                 :: DET1, DET2
    REAL(kind=8)         :: pp
    INTEGER, ALLOCATABLE :: INDX(:), p_dim(:), IPVT(:)
    INTEGER              ::  errcode, CODE, DD1, DD2, SEED_PERM
    LOGICAL              :: first=.true.
    TYPE (VSL_STREAM_STATE) :: stream


    !*** hyperparameters in the prior distribution ***!
    REAL, DIMENSION(28)    :: beta_0
    REAL, DIMENSION(28,28) :: B_0, INV_B_0
    REAL                   :: sigma_0, Sig_0, a_0, eta_0, ALPHA_0
    INTEGER                :: rho_0

    !*** posterior draws of parameters *******!

    REAL, DIMENSION(2,TT)       :: lambda_T
    REAL, DIMENSION(TT)         :: acc_rate1, acc_rate2
    REAL(kind=8), DIMENSION(TT) :: logp_T
    REAL, DIMENSION(28, TT)     :: beta_T
    REAL, DIMENSION(TT)         :: sigma_T
    REAL, DIMENSION(GG,TT)      :: alpha_T
    REAL, DIMENSION(GG,TT)      :: acc_rate0a, acc_rate0z, acc_rate3
    !REAL, DIMENSION(MAX,GG,TT/THIN):: zz_T


    !*****************************************************************!

    REAL, ALLOCATABLE  :: V1(:,:), V2(:,:), V(:,:), S1(:,:), S2(:,:), XX(:,:)
    REAL, ALLOCATABLE  :: psi(:,:), psi_1(:,:), psi_2(:,:), zero(:)
    REAL, ALLOCATABLE  :: ep(:), ep_1(:), ep_2(:)
    REAL, ALLOCATABLE  :: ep_1v(:), ep_2v(:)
    REAL(kind=8)       :: q_1, q_2, like_Y1, like_Y2, pp_w, q

    !REAL, DIMENSION(MAX,DD,GG,TT/THIN):: zz_T

    !********VARIABLE IN M-H FOR GAMMA & LAMBDA   ***************!

    REAL      :: lambda_1(2), lambda_2(2), lambda_0(2), COV_lambda_1(2,2)
    REAL(kind=8)  :: pp_l(GG), pp_G(GG), pp_sig(GG)

    !*************VARIABLE IN M-H FOR BETA **************!

    REAL :: XVX(28,28,GG), XVY(28,GG), INV_B(28,28), INV_B2(28,28), beta_temp(28)
    REAL, ALLOCATABLE ::  XX2(:,:), YY(:), S(:,:)

    !*************VARIABLE IN M-H FOR SIGMA_E & SIGMA_EZ & ALPHA_G**************!

    REAL              :: R_g, sigma_1
    REAL, ALLOCATABLE :: ep_v(:)
    INTEGER           :: rho_1, stack

    !*******************************************************************************************************!

    INTEGER :: N_1, N_2, T_1, T_2

    !*******************************************************************************************************!

100 format (14f10.4)
200 format (4f10.4)

    seedsize=2
    seed(1)=2.1103e+005
    seed(2)=2.1103e+005
    CALL RANDOM_SEED
    CALL RANDOM_SEED(SIZE=seedsize)
    CALL RANDOM_SEED(PUT=seed)

    seed_mkl=12345
    brng=VSL_BRNG_MCG31
    method=VSL_RNG_METHOD_GAUSSIANMV_BOXMULLER
    me=VSL_MATRIX_STORAGE_FULL

    errcode=vslnewstream(stream,brng,seed_mkl)

    CALL networksize(GG, MAX, path1, path2, N)
    CALL define_variable(GG, age, sex, race, network, group, N, path1, path2, MAX)

    lambda_0=0.0
    beta_0=0.0
    sigma_0=0.0
    eta_0=0.1
    rho_0=2
    B_0=eye(28)*100.0
    Sig_0=100.0
    CALL FINDInv(B_0,INV_B_0,28,ier)
    ALPHA_0=400.0
    a_0=0.0
    censor=0
     
    c_3=0.1
    acc_1=0.0;acc_2=0.0;acc_3=0
    acc_rate1=0.0
    acc_rate2=0.0
    acc_rate3=0.0


    ! initial value of the draws !

    beta_T(:,1)=0.0
    sigma_T(1)=0.4
    lambda_T(:,1)=(/ 0.050, 0.050 /)

    OPEN (2000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'lambda.txt', status='unknown')
    OPEN (3000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'beta.txt', status='unknown')
    OPEN (4000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'sigma.txt', status='unknown')
    OPEN (6000, file =  trim(adjustl(path1)) // trim(adjustl(path3)) // 'alpha.txt', status='unknown')
    
    DO t=2, TT

        call system_clock ( clock_start, clock_rate, clock_max )

        DO
            COV_lambda_1=EYE(2)*5e-5
            call spotrf('U',2, COV_lambda_1, 2, info)
            errcode=vsrnggaussianmv(method,stream,1,lambda_1, 2, me, lambda_0, COV_lambda_1)
            lambda_1=lambda_1+lambda_T(:,t-1)
            IF (t>1000) THEN
                COV_lambda_1=cov(lambda_T(:,1:t-1),2,t-1)*2.38**2/2.0
                call spotrf('U',2, COV_lambda_1, 2, info)
                errcode=vsrnggaussianmv(method,stream,1,lambda_2, 2, me, lambda_0, COV_lambda_1)
                lambda_2=lambda_2+lambda_T(:,t-1)
                lambda_1=0.95*lambda_2+0.05*lambda_1
            END IF
            IF ((abs(lambda_1(1))<=0.1) .and. (abs(lambda_1(1))>=abs(lambda_1(2))))  EXIT
        END DO



        Call OMP_SET_NUM_THREADS(Nthreads)
        !$omp parallel default(shared) private(g, NN, Y, X, XX, W, Wt, IPVT, FACT, &
        !$omp & ep_1, ep_2, S1, S2, INFO, CODE, DD1, DD2, &
        !$omp & IPIV, INDX, DET1, DET2, q_1, q_2, &
        !$omp & pp, i, j, like_Y1, like_Y2, rand, rand1, &
        !$omp & ithread, iblock, ibegin, iend)

        ithread = OMP_GET_THREAD_NUM()
        iblock = (GG+Nthreads-1)/Nthreads
        ibegin = ithread*iblock+1
        iend = min((ithread+1)*iblock,GG)

        DO g = ibegin,iend

            NN=N(g)
            ALLOCATE(S1(NN,NN));       ALLOCATE(S2(NN,NN));
            ALLOCATE(Y(NN));
            ALLOCATE(X(NN,14)) ;       ALLOCATE(XX(NN,28)) ;
            ALLOCATE(W(NN,NN));        ALLOCATE(Wt(NN,NN));
            ALLOCATE(ep_1(NN));        ALLOCATE(ep_2(NN));
            ALLOCATE(IPIV(NN));        ALLOCATE(INDX(NN));
            ALLOCATE(FACT(NN,NN));     ALLOCATE(IPVT(NN))

            Y=group(1:NN,dep,g)
            X(:,1:14)=group(1:NN,1:14,g)
            W=network(1:NN,1:NN,g)
            Wt=transpose(W)
            XX(:,1:14)=X
            XX(:,15:28)=matmul(W,X)

            !***** THE M-H ALGORITHM FOR SAMPLING LAMBDA ******!

            S1=eye(NN)-lambda_1(1)*W-lambda_1(2)*Wt
            S2=eye(NN)-lambda_T(1,t-1)*W-lambda_T(2,t-1)*Wt

            ep_1=matmul(S1,Y)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)
            ep_2=matmul(S2,Y)-matmul(XX,beta_T(:,t-1))-alpha_T(g,t-1)

            !CALL LFTRG (S1, FACT,IPVT)
            !CALL LFDRG (FACT, IPVT,DET1, DET2)
            like_Y1=log(FindDet(S1,NN))-dot_product(ep_1, ep_1)/(2*sigma_T(t-1))
            !like_Y1=log(DET1*10**DET2)-dot_product(ep_1, ep_1)/(2*sigma_T(t-1))

            !CALL LFTRG (S2, FACT,IPVT)
            !CALL LFDRG (FACT, IPVT,DET1, DET2)
            like_Y2=log(FindDet(S2,NN))-dot_product(ep_2, ep_2)/(2*sigma_T(t-1))
            !like_Y2=log(DET1*10**DET2)-dot_product(ep_2, ep_2)/(2*sigma_T(t-1))

            pp_l(g)=(like_Y1-like_Y2)

            DEALLOCATE(S1,S2,Y,X,XX,W,Wt,ep_1,ep_2,IPIV,INDX,FACT,IPVT)
        END DO
        !$omp end parallel

        pp=sum(pp_l) 

        CALL random_number(rand)
        IF (log(rand)<=pp) THEN
            lambda_T(:,t)=lambda_1
            acc_2=acc_2+1.0
        ELSE
            lambda_T(:,t)=lambda_T(:,t-1)
        END IF
        acc_rate2(t)=acc_2/t


        !***************GIBBS STEP TO SIMULTE BETA *********************!

        XVX=0.0
        XVY=0.0

        Call OMP_SET_NUM_THREADS(Nthreads)
        !$omp parallel default(shared) private(g,NN, Y, YY, W, Wt,  &
        !$omp & X, XX, XX2, S, V, V1, V2, IPIV, INFO, i, j, &
        !$omp & ithread, iblock, ibegin, iend)

        ithread = OMP_GET_THREAD_NUM()
        iblock = (GG+Nthreads-1)/Nthreads
        ibegin = ithread*iblock+1
        iend = min((ithread+1)*iblock,GG)

        DO g = ibegin,iend

            NN=N(g)
            ALLOCATE(Y(NN));        ALLOCATE(YY(NN))
            ALLOCATE(X(NN,14)) ;
            ALLOCATE(XX(NN,28));    ALLOCATE(XX2(NN,28)) ;
            ALLOCATE(W(NN,NN));     ALLOCATE(Wt(NN,NN));
            ALLOCATE(S(NN,NN));
            ALLOCATE(V(NN,NN));
            ALLOCATE(V1(NN,NN)); ALLOCATE(V2(NN,NN))
            ALLOCATE(IPIV(NN))

            V=sigma_T(t-1)*EYE(NN)
            Y=group(1:NN,dep,g)
            X(:,1:14)=group(1:NN,1:14,g)
            W=network(1:NN,1:NN,g)
            Wt=transpose(W)
            XX(:,1:14)=X
            XX(:,15:28)=matmul(W,X)


            S=eye(NN)-lambda_T(1,t)*W-lambda_T(2,t)*Wt

            XX2=XX
            V1=V
            CALL SGESV(NN,28,V1,NN,IPIV,XX2,NN,INFO)
            YY=matmul(S,Y)-alpha_T(g,t-1)
            V2=V
            CALL SGESV(NN,1,V2,NN,IPIV,YY,NN,INFO)

            XVX(:,:,g)=matmul(transpose(XX) , XX2)
            XVY(:,g)=matmul(transpose(XX) , YY)

            DEALLOCATE(Y,YY,X,XX,XX2,W,Wt,S,V,V1,V2,IPIV)
        END DO
        !$omp end parallel

        CALL FINDInv(sum(XVX,3)+INV_B_0,INV_B,28,ier)
        INV_B2=INV_B
        CALL spotrf('U',28, INV_B2, 28, info)
        errcode=vsrnggaussianmv(method, stream, 1, beta_temp, 28, me, beta_0,  INV_B2)
        beta_T(:,t)=beta_temp+matmul(INV_B,sum(XVY,2))



        !*************GIBBS STEP FOR sigma*********************!

        rho_1=0
        ALLOCATE(ep_v(sum(N)))
        stack=0
        DO g=1,GG
            NN=N(G)
            ALLOCATE(Y(NN))
            ALLOCATE(X(NN,14))
            ALLOCATE(XX(NN,28))
            ALLOCATE(W(NN,NN))
            ALLOCATE(Wt(NN,NN))
            ALLOCATE(S(NN,NN))
            ALLOCATE(ep(NN))

            Y=group(1:NN,dep,g)
            X(:,1:14)=group(1:NN,1:14,g)
            W=network(1:NN,1:NN,g)
            Wt=transpose(W)
            XX(:,1:14)=X
            XX(:,15:28)=matmul(W,X)

            S=eye(NN)-lambda_T(1,t)*W-lambda_T(2,t)*Wt

            ep=matmul(S,Y)-matmul(XX,beta_T(:,t))-alpha_T(g,t-1)
            ep_v(stack+1:stack+NN)=ep
            rho_1=rho_1+NN
            stack=stack+NN
            DEALLOCATE(Y,X,XX,W,Wt,S,ep)
        END DO
        sigma_T(t)=(dot_product(ep_v,ep_v)+eta_0)/random_chisq(rho_1+rho_0, first)
        DEALLOCATE(ep_v)


        !*************GIBBS STEP FOR ALPHA_G*********************!


        Call OMP_SET_NUM_THREADS(Nthreads)
        !$omp parallel default(shared) private(g,NN, Y, YY, &
        !$omp & X, XX, W, Wt, S, IPIV, R_g, i,j, &
        !$omp & ithread, iblock, ibegin, iend)

        ithread = OMP_GET_THREAD_NUM()
        iblock = (GG+Nthreads-1)/Nthreads
        ibegin = ithread*iblock+1
        iend = min((ithread+1)*iblock,GG)

        DO g = ibegin,iend

            NN=N(g)
            ALLOCATE(Y(NN));
            ALLOCATE(YY(NN));
            ALLOCATE(X(NN,14))
            ALLOCATE(XX(NN,28))
            ALLOCATE(W(NN,NN));
            ALLOCATE(Wt(NN,NN));
            ALLOCATE(S(NN,NN));

            R_g=(ALPHA_0**(-1)+sigma_T(t)**(-1.0)*NN)**(-1.0)
            Y=group(1:NN,dep,g)
            X(:,1:14)=group(1:NN,1:14,g)
            W=network(1:NN,1:NN,g)
            Wt=transpose(W)
            XX(:,1:14)=X
            XX(:,15:28)=matmul(W,X)

            S=eye(NN)-lambda_T(1,t)*W-lambda_T(2,t)*Wt

            YY=matmul(S,Y)
            alpha_T(g,t)=R_g*(ALPHA_0**(-1)*a_0+(sigma_T(t))**(-1.0)*sum((YY-matmul(XX,beta_T(:,t)))))+random_normal()*sqrt(R_g)

            DEALLOCATE(Y,YY,X,XX,W,Wt,S)
        END DO
        !$omp end parallel


        call system_clock ( clock_stop, clock_rate, clock_max )
        t_round=t/10
        IF (t-t_round*10==0) THEN
            WRITE(*,*)   'T=', t
            WRITE(*,'(a10, f10.4)') 'Time:', real ( clock_stop - clock_start ) / real ( clock_rate )
            WRITE(*,'(a10,3f10.4)') 'LAMBDA:', lambda_T(:,t)
            !WRITE(*,'(a10,17f10.4)') 'BETA:',   beta_T(1:17,t)
            !WRITE(*,'(a10,17f10.4)') 'BETA:',   beta_T(37:28,t)
            WRITE(*,'(a10, f10.4)') 'SIGMA:',  sigma_T(t)
            WRITE(*,'(a10,f10.4)') 'acc_2:',  acc_rate2(t)
          
            WRITE(2000,'(3f10.4)')  lambda_T(:,t)
            WRITE(3000,'(30f10.4)') beta_T(:,t)
            WRITE(4000,'(f12.4)')   sigma_T(t)
            WRITE(6000,'(34f10.4)') alpha_T(:,t)
        END IF

    END DO


    END PROGRAM estimation



