
function [y,x,beta] = simulate_Pesaran_nIcce_simplified(t,n,exp,expA,gam,ro_v)
% t = 200;
% n = 50;   % indexed by i
nf = 3;   % number of factors, always indexed by k
nx = 2;   % always indexed by j

% exp = 1; % running experiment 1 or 2, exp = 1 heterogeneous beta, exp = 2 homogeneous beta
% expA  = 1; % running experiment A or B, if 1 we run full rank condition, if 2, we run rank deficient version
% 
% The line up is always T,N,nx for three dimensional matrices

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fixed over simulations, treated as fixed effects
% alpha1 = randn(n,1)+1;   % IIDN(1,1)
% A = zeros(n,nx,4);
% for i = 1:n
% %     for r = 1:4
%         A(i,:,:) = randn(nx,4).*sqrt(0.5)+0.5; % these are (a_i11,a_i21,a_i12,a_i22), all are nx times N
% %     end
% end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% d1 = 1;
% ro_d = 0.5;
% nu_d = randn(T,1).*sqrt(1-ro_d^2);   % IIDN(0,1-ro_d^2)
% d2 = zeros(T,1);
% 
% for t = 2:T
%   d2(t) = ro_d*d2(t-1) + nu_d(t); 
% end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ro_f = 0.5;

f = zeros(t,nf);
for k = 1:nf
    nu_f = randn(t,1).*sqrt(1-ro_f^2);  % IIDN(0,1-ro_f^2)
    for t = 2:t
        f(t,k) = ro_f*f(t-1,k) + nu_f(t);
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

nu_v = zeros(t,n,nx);
v = zeros(t,n,nx);

for i = 1:n
    for j = 1:nx
%           ro_v(j) = (0.95-0.05).*rand(1)+0.05;  % IIDU(0.05 0.95)
          nu_v(:,:,j) = randn(t,n).*sqrt(1- ro_v(j).^2);  % vv is a T x N x nX matrix, % IIDN(0,1-ro_v^2)
          for t = 2:t
              v(t,i,j) = ro_v(j)*v(t-1,j) + nu_v(t,i,j);
          end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
eps = randn(t,n);

% eps = zeros(T,N);
% for i = 1:N/2
%   xsi = randn(T,1); % IIDN(0,1)
%   ro_eps = (0.95-0.05).*rand(1)+0.05; % IIDU(0.05 0.95)
%   sigmasq = ((1.5-0.5).*rand(1)+0.5).^(1/2); % sigma^2 ~ IIDU(0.5 1.5)
%   for t = 2:T
%       eps(t,i) = ro_eps* eps(t-1,i) + sqrt(sigmasq)*(1 - ro_eps^2)^(1/2)*xsi(t,:);
%   end
% end
% 
% for i = N/2+1:N
%    xsi = randn(T,1);
%    ro_eps = (0.95-0.05).*rand(1)+0.05;
%    sigma = ((1.5-0.5).*rand(1)+0.5).^(1/2);
%    theta_eps = randn(1);
%    for t = 2:T
%        eps(t,i) = sigma*(1 + theta_eps^2)^(-1/2)*(xsi(t,:)+theta_eps*xsi(t-1,:));
%    end
% end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% For the x equation
    phi1(:,1) = randn(n,1)*sqrt(0.5)+0.5;
    phi1(:,2) = randn(n,1)*sqrt(0.5);
    phi3(:,1) = randn(n,1)*sqrt(0.5)+0.5;  % changed compared to Pesaran, added N(0.5,0.5) instead of N(0,0.5)
    phi3(:,2) = randn(n,1)*sqrt(0.5)+0.5;

% For the y equation
    phi_y1 = randn(n,1)*sqrt(0.2)+1;
    % different sets A and B, A satisfies the rank condition, B doesn't
    phi_y2A = randn(n,1)*sqrt(0.2)+1;
    phi_y2B = randn(n,1);
    
    beta = zeros(n,nx);
    
    if exp == 1
        for j = 1:nx
            nu = randn(n,1)*sqrt(0.04);
            beta(:,j) = 1+nu;
        end
    else
        beta = ones(n,nx);
    end
    


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
x = zeros(t,n,nx);
for i = 1:n
    for j = 1:nx
        x(:,i,j) = phi1(i,j).*f(:,1) + phi3(i,j)*f(:,3) + v(:,i,j);
%                 x(:,i,j) = A(i,j,1)*d1 + A(i,j,2)*d2 + phi1(i,j).*f(:,1) + phi3(i,j)*f(:,3) + v(:,i,j);
    end
end

% x = x(:,:,1); % we only take one x into account. the second beta created for x2 is used for g

for i = 1:n
%     tran(:,i) = g(gam,x(:,i,1));
    if expA == 1
        y(:,i) = beta(i,1)*x(:,i,1) + beta(i,2).*g(gam,x(:,i,1)) + phi_y1(i)*f(:,1) + phi_y2A(i)*f(:,2)+ eps(:,i);
        %     y(:,i) = alpha1(i)*d1 + beta(i,1)*x(:,i,1) + beta(i,2).*g(gam,x(:,i,1)) + phi_y1(i)*f(:,1)  + phi_y2A(i)*f(:,2)+ eps(:,i);
    else
        y(:,i) = beta(i,1)*x(:,i,1) + beta(i,2).*g(gam,x(:,i,1))+ phi_y1(i)*f(:,1) + phi_y2B(i)*f(:,2)+ eps(:,i);
    end
end

x = x(:,:,1); % we only take one x into account. the second beta created for x2 is used for g

x = squeeze(x); 





