function [alpha,beta,lambda,gamma,c,fX,yhat,ehat,G,W]=parestlm(y,X,W,q,T,nX,nW,m,gamma,c,L,NN, opt) 

% Compute starting values
% -----------------------
[alpha,beta,lambda,gamma,c,bestcost] = startval(y,X,W,q,m,gamma,c);
PSI = setpar(gamma,c);

options = optimset('Display','off','Jacobian','on','MaxFunEvals',1e10,...
        'LargeScale','off','MaxIter',4000,'TolFun',1e-10,...
        'DerivativeCheck','off',...
        'TolX',1e-10,'TolCon',1e-10);
    

% options = optimset('Display','off','Jacobian','on','MaxFunEvals',1e10,...
%         'LargeScale','off','MaxIter',4000,'TolFun',1e-10,...
%         'DerivativeCheck','off','LevenbergMarquardt','on',...
%         'LineSearchType','cubicpoly','TolX',1e-10,'TolCon',1e-10);
 
% Adding wbar
if opt == 3
        WW       = X.*siglog(gamma*(q-c));
        WW       = reshape(WW,T/NN,NN);
        m_ww     = repmat(mean(WW,2),1,NN);
        W        = [W vec(m_ww)];   % extra line to include (x*g)bar=wbar
        nW       = size(W,2);
end

PSI = fmincon('msecost',PSI,[],[],[],[],...
             [zeros(m,1);ones(m,1)*prctile(q,10)],...
             [inf(m,1);ones(m,1)*prctile(q,90)],[],options,...
              y,X,W,q,m);

[gamma,c] = getpar(PSI);

aux   = [gamma c];
aux   = sortrows(aux,2);
gamma = aux(:,1);
c     = aux(:,2);

Z = [X W];
fX = zeros(T,m);
dfX = zeros(T,m);
for i=1:m
    fX(:,i)  = siglog(gamma(i)*(q-c(i)));       % 1 ./ (1 + exp(-(gamma(i)*(q-c(i)))));
    dfX(:,i) = dsiglog(fX(:,i));                % fX.*(1-fX);
    A = repmat(fX(:,i),1,nX).*X;
   % m_A = [repmat(mean(A(1:L)),L,1);repmat(mean(A(L+1:2*L)),L,1);repmat(mean(A(2*L+1:3*L)),L,1);repmat(mean(A(3*L+1:4*L)),L,1);repmat(mean(A(4*L+1:5*L)),L,1)];
   % Z = [Z (A-m_A)];  %  
   Z        = [Z repmat(fX(:,i),1,nX).*X];
end
theta  = inv(Z'*Z)*Z'*y;
alpha  = theta(1:nX);
if isempty(W)==1
    beta=[];
else
    beta   = theta(nX+1:nX+nW);
end
lambda = reshape(theta(nX+nW+1:end),nX,m);
if isempty(W)==1
    yhat   = X*alpha + sum((fX*lambda').*X,2);
else
    yhat   = X*alpha + W*beta + sum((fX*lambda').*X,2);
end; 
ehat   = y - yhat;

PSI = setpar(gamma,c);

[ggamma,gc] = gradG(PSI,X,q,lambda,dfX,m); %  ggamma(:,i) = (X*lambda(:,i)).*(dfX(:,i).*(q-c(i)));   gc(:,i) = -(X*lambda(:,i)).*(gamma(i)*dfX(:,i));

galpha  = X;
glambda = Z(:,nX+nW+1:end); %repmat(fX(:,i),1,nX).*X
gbeta   = W;
G = [galpha,gbeta,glambda,ggamma,gc];



