function [scale]=scaling_factor_general(q,Gamma);

% Calculates the scaling factor for an n variables with horizon q
% INPUT: n x nq matrix of autocovariance matrices [Gamma_0 Gamma_1 ...
% Gamma_q-1]
% OUTPUT n x n scaling matrix
n=length(Gamma(:,1));
scale=Gamma(1:n,1:n);
for i=1:(q-1)
    scale = scale+(1-i/q)*(Gamma(1:n,i*n+1:(i+1)*n)+Gamma(1:n,i*n+1:(i+1)*n)');
end
scale=scale/Gamma(1:n,1:n);


end