## Assessing the true lag-lead order DGP: MARX(1,1,1)##
#set.seed()

sim = 10000

L.selX <- c()
L.selXs <- c()
L.sel <- c()

for (iter in 1:sim){
  r=s=1;
  obs <- (500+r+s)
  vect <- rt((obs+1),3)
  eps <- matrix(data = vect, nr=(obs+1), nc=1)
  
  x <- rt(obs,2)
  phi <- 0.3; psi <- 0.5; beta <- 0.3
  u <- matrix(data=0, nr=(obs+2), nc=1)
  v <- matrix(data=0, nr=(obs+2), nc=1)
  y <- matrix(data=0, nr=(obs+1), nc=1)
  y1 <- matrix(data=0,nr=(obs+1),nc=1)
  stvalX <- rep(1,4)
  
  
  ## ------------------------------------------------------------------ ##
  ##                         SIMULATING DATA                            ##
  ## --------------------- Generating u,v and y ----------------------- ##  
  ## ------------------------------------------------------------------ ##
  
  ## Generating v - epsilon causal part 
  v_0 <- 0
  v[1] <- v_0
  for (j in 1:obs){
    v[(j+1)] <-  eps[(j+1)] + phi*v[j]
  } 
  
  v <- v[1:obs]
  length(v)
  
  ## Generating u - epsilon noncausal part
  u_last <- 0
  u[(obs+1)] <- u_last
  for(j in (obs+1):2){
    u[j-1] <- eps[j-1] + psi*u[j]
  } 
  
  u <- u[1:(obs+1)]
  
  
  for (i in obs:1){
    y[i] <- psi*y[i+1] + beta*x[i] + v[i]
    y1[i] <- psi*y1[i+1] + v[i]
    
  }
  y <- y[1:obs]
  y1 <- y1[1:obs]
  
  MARX20 <- cbind(y[3:(obs-2)], y[2:(obs-3)], y[1:(obs-4)],x[3:(obs-2)])
  MARX11 <- cbind(y[3:(obs-2)], y[2:(obs-3)], y[4:(obs-1)],x[3:(obs-2)])
  MARX02 <- cbind(y[3:(obs-2)], y[4:(obs-1)], y[5:obs],x[3:(obs-2)])
  
  MARX20s <- cbind(y[3:(obs-2)], y[2:(obs-3)], y[1:(obs-4)],x[2:(obs-3)])
  MARX11s <- cbind(y[3:(obs-2)], y[2:(obs-3)], y[4:(obs-1)],x[3:(obs-2)])
  MARX02s <- cbind(y[3:(obs-2)], y[4:(obs-1)], y[5:obs],x[4:(obs-1)])
  
  MAR20 <- cbind(y1[3:(obs-2)], y1[2:(obs-3)], y1[1:(obs-4)])
  MAR11 <- cbind(y1[3:(obs-2)], y1[2:(obs-3)], y1[4:(obs-1)])
  MAR02 <- cbind(y1[3:(obs-2)], y1[4:(obs-1)], y1[5:obs])
  
  stval <- rep(1,3)
  stvalX <- rep(1,4)
  
  lik2X <- function(param,y){
    theta <- c(1, -param[1], -param[2], -param[3])
    input <- y %*% theta
    logl <- sum(dt(input,df=param[4],log=TRUE))
    return(-logl)
  }
  
  lik2 <- function(param,y){
    theta <- c(1, -param[1], -param[2])
    input <- y %*% theta
    logl <- sum(dt(input,df=param[3],log=TRUE))
    return(-logl)
  }
  
  lik11X <- function(param,y){
    theta <- c((1+param[1]*param[2]), -param[1], -param[2], -param[3])
    input <- y %*% theta
    logl <- sum(dt(input,df=param[4],log=TRUE))
    return(-logl)
  }
  
  lik11 <- function(param,y){
    theta <- c((1+param[1]*param[2]), -param[1], -param[2])
    input <- y %*% theta
    logl <- sum(dt(input,df=param[3],log=TRUE))
    return(-logl)
  }
  
  mle20X <- optim(stvalX,lik2X, y=MARX20, method="BFGS",hessian=T)
  mle11X <- optim(stvalX,lik11X, y=MARX11, method="BFGS", hessian=T)
  mle02X <- optim(stvalX,lik2X, y=MARX02, method="BFGS",hessian=T)
  
  mle20Xs <- optim(stvalX,lik2X, y=MARX20s, method="BFGS",hessian=T)
  mle11Xs <- optim(stvalX,lik11X, y=MARX11s, method="BFGS", hessian=T)
  mle02Xs <- optim(stvalX,lik2X, y=MARX02s, method="BFGS",hessian=T)
  
  mle20 <- optim(stval,lik2, y=MAR20, method="BFGS",hessian=T)
  mle11 <- optim(stval,lik11, y=MAR11, method="BFGS", hessian=T)
  mle02 <- optim(stval,lik2, y=MAR02, method="BFGS",hessian=T)
  
  LvecX <- c(-mle20X$value,-mle11X$value,-mle02X$value)
  LvecXs <- c(-mle20Xs$value,-mle11Xs$value,-mle02Xs$value)
  Lvec <- c(-mle20$value,-mle11$value,-mle02$value)
  
  L.selX[iter] <- which.max(LvecX)
  L.selXs[iter] <- which.max(LvecXs)
  L.sel[iter] <- which.max(Lvec)
  
  print(iter)
  flush.console()
}

sum(L.selX == 1)
sum(L.selX == 2)
sum(L.selX == 3)

sum(L.selXs == 1)
sum(L.selXs == 2)
sum(L.selXs == 3)

sum(L.sel == 1)
sum(L.sel == 2)
sum(L.sel == 3)
  