library(MARX)
#set.seed()

## Number of time observations, truncation, simulations 
T = 1000
m = 100
obs <- T + m
sim <- 100

## Parameter values
df <- 3
phi <- 0.3
psi <- 0.5
beta <- 0.5

## Initialization process
u <- c()
u[obs+1] = 0
y <- c()
y[1] = 0
stval <- rep(0.5,5)
ll.val <- matrix(data=0, nr=sim,nc=3)
phi.par <- matrix(data=0, nr=sim,nc=3)
psi.par <- matrix(data=0, nr=sim,nc=3)
beta.par <- matrix(data=0, nr=sim,nc=3)
mu.par <- matrix(data=0, nr=sim,nc=3)
sigma.par <- matrix(data=0, nr=sim,nc=3)

count <- c()

for (iter in 1:sim){
## Generate eps
eps <- rt(obs,df)

## Generate x (standard normal)
x <- rnorm(obs,0,1)

## Generate x (AR process)
# x <- rep(0,obs)
# 
# w <- rnorm((obs+1),0,5)
# x <- c(0)
# 
# for (i in 2:(obs+1)){
#   x[i] <- 0.6*x[i-1] + w[i]
# }
# x <- x[2:length(x)]

## Generate u
for (i in obs:1){
  u[i] = psi[1]*u[i+1] + beta*x[i] + eps[i]
}

## Generate y
for (i in 2:obs){
  y[i] = phi[1]*y[i-1] + u[i]
}

y <- y[(0.5*m+1):(obs-0.5*m)]
x <- x[(0.5*m+1):(obs-0.5*m)]

##  Datasets
data.c <- cbind(y[3:(T-2)],y[2:(T-3)],y[1:(T-4)],x[3:(T-2)])
data.n <- cbind(y[3:(T-2)],y[4:(T-1)],y[5:T],x[3:(T-2)])
data.m <- cbind(y[3:(T-2)],y[2:(T-3)],y[4:(T-1)],x[3:(T-2)])

## Likelihoods
norm.lik_ARX2 <- function(param, y){
  theta <- c(1, -param[1], -param[2], -param[3])
  input <- y %*% theta
  logl <- sum(dnorm(input, mean=param[4], sd=param[5], log=TRUE))
  return(-logl)
}

norm.lik_ARX11 <- function(param, y){
  theta <- c((1 + param[1]*param[2]), -param[1], -param[2], -param[3])
  input <- y %*% theta
  logl <- sum(dnorm(input, mean=param[4], sd=param[5], log=TRUE))
  return(-logl)
}
  
## Estimation
mle.ARX20 <- optim(stval, norm.lik_ARX2, y=data.c, method="BFGS", hessian=TRUE)
mle.ARX02 <- optim(stval, norm.lik_ARX2, y=data.n, method="BFGS", hessian=TRUE)
mle.ARX11 <- optim(stval, norm.lik_ARX11, y=data.m, method="BFGS", hessian=TRUE)


ll.val[iter,1:3] <- c(-mle.ARX20$value,-mle.ARX11$value, -mle.ARX02$value)
phi.par[iter,1:3] <- c(mle.ARX20$par[1],mle.ARX11$par[1], mle.ARX02$par[1])
psi.par[iter,1:3] <- c(mle.ARX20$par[2],mle.ARX11$par[2], mle.ARX02$par[2])
beta.par[iter,1:3] <- c(mle.ARX20$par[3],mle.ARX11$par[3], mle.ARX02$par[3])
mu.par[iter,1:3] <- c(mle.ARX20$par[4],mle.ARX11$par[4], mle.ARX02$par[4])
sigma.par[iter,1:3] <- c(mle.ARX20$par[5],mle.ARX11$par[5], mle.ARX02$par[5])

print(iter)
}

for(iter in 1:sim){
count[iter] <- which.max(ll.val[iter,])
}

table(count)


