library(fBasics)
library(MARX)

set.seed(9999)
order <- c(0,1)
sim <- 10000
rmsfe1 <- c()
rmsfe2 <- c()
rmsfe3 <- c()
rmsfe4 <- c()

for (iter in 1:sim){
  ## Simulating x_t ##
  n <- 400
  x <- c(0)
  w <- rnorm(n,0,1)
  beta <- 0.3
    for (i in 2:n){
      x[i] <- beta*x[i-1] + w[i]
    }

  ## Simulating y_t ##
  eps <- rt(n,3)
  y <- rep(0,(n+1))
    for (i in n:1){
      y[i] <- 0.7*y[i+1] + 0.8*x[i] + eps[i]
    }

  ## (1) Forecasting x_t ##
  x.for <- x[300]
  M <- 50
    for (i in 1:M){
      x.for[i+1] <- beta*x.for[i]
    }
    x.for <- x.for[2:length(x.for)]


  ## (2) Known values of x_t ##
  x.real <- x[301:350]
  y.real <- y[301:308]

  ## Data to be used ##
  x <- x[101:300]
  y <- y[101:300]


  result1 <- forecast3.marx(y=y, X=x, p_C = order[1], p_NC=order[2], X.for=x.for,  h=8, M=50, N=10000) # MARX forecasted X
  result2 <- forecast3.marx(y=y, X=x, p_C = order[1], p_NC=order[2], X.for=x.real, h=8, M=50, N=10000) # MARX known X
  result3 <- forecast3.marx(y=y, X=NULL, p_C=order[1], p_NC=order[2], X.for=NULL, h=8, M=50, N=10000)  # MAR
  result4 <- forecast4.marx(y=y, X=NULL, p_C=order[1], p_NC=order[2], X.for=NULL, h=8, M=50, N=10000)  # MAR
  

  rmsfe1[iter] <- rmsfe(y.real,result1)
  rmsfe2[iter] <- rmsfe(y.real,result2)
  rmsfe3[iter] <- rmsfe(y.real,result3)
  rmsfe4[iter] <- rmsfe(y.real,result4)
  
  print(iter)
}

forecast3.marx <- function(y,X,p_C,p_NC,X.for,h,M,N){

  if (missing(X) == TRUE){
    X = NULL
  }

  if (missing(N) == TRUE){
    N = 10000
  }

  object <- mixed(y,X,p_C,p_NC)
  obs <- length(y)

  ## Check whether there are exogenous variables and whether truncation M is known

  if (missing(X.for) == TRUE && missing(M) == TRUE){
    X.for = NULL
    M = 50
  }
  else if(missing(X.for) == TRUE && missing(M) == FALSE){
    X.for = NULL
    M = M
  }
  else if(missing(X.for) == FALSE && missing(M) == TRUE){
    if (NCOL(X.for) == 1){
      if(is.null(X.for) == TRUE){
        M = 50
      }
      else{
        M = length(X.for)
      }
    }
    else{
      M = length(X.for[,1])
    }
  }
  else if(missing(X.for) == FALSE && missing(M) == FALSE){
    if (NCOL(X.for) == 1){
      if(is.null(X.for) == TRUE){
        M = M
      }
      else{
        M = min(length(X.for), M)
      }
    }
    else{
      M = min(length(X.for[,1]),M)
    }
  }

  coef.caus <- c()
  if (object$order[1] == 0){
    r = 1
    coef.caus <- object$coefficients[(r+1)]
  }
  else{
    r = object$order[1]
    coef.caus <- object$coefficients[2:(r+1)]
  }

  coef.noncaus <- c()
  if (object$order[2] == 0){
    s = 1
    coef.noncaus <- object$coefficients[(r+1+s)]
  }
  else{
    s = object$order[2]
    coef.noncaus <- object$coefficients[(r+2):(r+1+s)]
  }

  coef.exo <- c()
  if (object$order[3] == 0){
    q = 1
    coef.exo <- object$coefficients[(r+1+s+q)]
  }
  else{
    q = object$order[3]
    coef.exo <- object$coefficients[(r+1+s+1):(r+s+1+q)]
  }

  ## Simulate future epsilon and use forecasted X
  hve <- c()
  hve2 <- matrix(data=0, nrow=N,ncol=h)

  for (iter in 1:N){

    eps.sim <- object$coefficients["scale",]*stats::rt(M,object$coefficients["df",])

    z2 <- c()
    for (i in 1:M){
      if(is.null(X.for) == TRUE){
        z2[i] <- eps.sim[i]
      }
      else{
        if(NCOL(X.for) > 1){
          z2[i] <- eps.sim[i] +  coef.exo %*% X.for[i,]
        }
        else{
          z2[i] <- eps.sim[i] + coef.exo * X.for[i]
        }
      }
    }

    ## Compute filtered values u = phi(L)y and moving average values
    phi <- c(1, -coef.caus)

    u <- c()
    for (i in (r+1):obs){
      u[i] <- phi %*% y[i:(i-r)]
    }
    w <- c(u[(obs-s+1):obs],z2)

    C <- matrix(data=0, nrow=(M+s), ncol=(M+s))
    C[1,] <- compute.MA(coef.noncaus,(M+s-1))

    if (s > 1){
      for (i in 2:s){
        C[i,] <- c(0, C[(i-1),1:(length(C[(i-1),])-1)])
      }
    }

    for (i in (s+1):(M+s)){
      C[i,] <- c(rep(0,(i-1)),1,rep(0,(M+s-i)))
    }

    D = solve(C)

    if (is.null(X) == TRUE){
      X.bar <- rep(0,(M+s))
    }
    else{
      if(NCOL(X) > 1){
        X.bar <- matrix(data=0,nrow=(M+s),ncol=NCOL(X))
          for(j in 1:NCOL(X)){
            X.bar[,j] <- c(X[(obs-s+1):obs,j],X.for[1:M,j])
          }
        X.bar <- coef.exo %*% t(X.bar)
        X.bar <- vec(X.bar)
      }
      else{
        X.bar <- c(X[(obs-s+1):obs],X.for[1:M])
        X.bar <- coef.exo * X.bar
      }
    }

  e <- D %*% w - X.bar

  h1 <- c()

  for (i in 1:s){
      h1[i] <- metRology::dt.scaled(e[i], df=object$coefficients["df",], sd=object$coefficients["scale",])
  }

  hve[iter] = prod(h1)

  for (j in 1:h){
    mov.av <-  C[1,1:(M-j+1)] %*% z2[j:M]
    hve2[iter,j] <- mov.av * hve[iter]
  }
}

  y.star <- y[(obs-r+1):obs]
  y.for <- c()
  exp <- c()

  for (j in 1:h){
    exp[j] = ((1/N)*sum(hve2[,j]))/((1/N)*sum(hve))

    if(length(coef.caus) == 1){
      y.for[j] <-  object$coefficients[1]/(1-sum(coef.noncaus)) + coef.caus * y.star + exp[j]
    }
    else{
      y.for[j] <-  object$coefficients[1]/(1-sum(coef.noncaus)) + t(coef.caus) %*% y.star + exp[j]
    }

    #y.star <- c(y.for[j], y.star[1:(length(y.star)-1)])
  }

  return(y.for)
}

forecast4.marx <- function(y,X,p_C,p_NC,X.for,h,M,N){
  
  if (missing(X) == TRUE){
    X = NULL
  }
  
  if (missing(N) == TRUE){
    N = 10000
  }
  
  #object <- mixed(y,X,p_C,p_NC)
  obs <- length(y)
  
  ## Check whether there are exogenous variables and whether truncation M is known
  
  if (missing(X.for) == TRUE && missing(M) == TRUE){
    X.for = NULL
    M = 50
  }
  else if(missing(X.for) == TRUE && missing(M) == FALSE){
    X.for = NULL
    M = M
  }
  else if(missing(X.for) == FALSE && missing(M) == TRUE){
    if (NCOL(X.for) == 1){
      if(is.null(X.for) == TRUE){
        M = 50
      }
      else{
        M = length(X.for)
      }
    }
    else{
      M = length(X.for[,1])
    }
  }
  else if(missing(X.for) == FALSE && missing(M) == FALSE){
    if (NCOL(X.for) == 1){
      if(is.null(X.for) == TRUE){
        M = M
      }
      else{
        M = min(length(X.for), M)
      }
    }
    else{
      M = min(length(X.for[,1]),M)
    }
  }
  
  r = 1
  s = 1
  q = 1
  int <- 0
  coef.caus <- 0
  coef.noncaus <- 0.7
  coef.exo <- 0
  scale <- 1
  df.err <- 3
  
  ## Simulate future epsilon and use forecasted X
  hve <- c()
  hve2 <- matrix(data=0, nrow=N,ncol=h)
  
  for (iter in 1:N){
    
    eps.sim <- scale*stats::rt(M,df.err)
    
    z2 <- c()
    for (i in 1:M){
      if(is.null(X.for) == TRUE){
        z2[i] <- eps.sim[i]
      }
      else{
        if(NCOL(X.for) > 1){
          z2[i] <- eps.sim[i] +  coef.exo %*% X.for[i,]
        }
        else{
          z2[i] <- eps.sim[i] + coef.exo * X.for[i]
        }
      }
    }
    
    ## Compute filtered values u = phi(L)y and moving average values
    phi <- c(1, -coef.caus)
    
    u <- c()
    for (i in (r+1):obs){
      u[i] <- phi %*% y[i:(i-r)]
    }
    w <- c(u[(obs-s+1):obs],z2)
    
    C <- matrix(data=0, nrow=(M+s), ncol=(M+s))
    C[1,] <- compute.MA(coef.noncaus,(M+s-1))
    
    if (s > 1){
      for (i in 2:s){
        C[i,] <- c(0, C[(i-1),1:(length(C[(i-1),])-1)])
      }
    }
    
    for (i in (s+1):(M+s)){
      C[i,] <- c(rep(0,(i-1)),1,rep(0,(M+s-i)))
    }
    
    D = solve(C)
    
    if (is.null(X) == TRUE){
      X.bar <- rep(0,(M+s))
    }
    else{
      if(NCOL(X) > 1){
        X.bar <- matrix(data=0,nrow=(M+s),ncol=NCOL(X))
        for(j in 1:NCOL(X)){
          X.bar[,j] <- c(X[(obs-s+1):obs,j],X.for[1:M,j])
        }
        X.bar <- coef.exo %*% t(X.bar)
        X.bar <- vec(X.bar)
      }
      else{
        X.bar <- c(X[(obs-s+1):obs],X.for[1:M])
        X.bar <- coef.exo * X.bar
      }
    }
    
    e <- D %*% w - X.bar
    
    h1 <- c()
    
    for (i in 1:s){
      h1[i] <- metRology::dt.scaled(e[i], df=df.err, sd=scale)
    }
    
    hve[iter] = prod(h1)
    
    for (j in 1:h){
      mov.av <-  C[1,1:(M-j+1)] %*% z2[j:M]
      hve2[iter,j] <- mov.av * hve[iter]
    }
  }
  
  y.star <- y[(obs-r+1):obs]
  y.for <- c()
  exp <- c()
  
  for (j in 1:h){
    exp[j] = ((1/N)*sum(hve2[,j]))/((1/N)*sum(hve))
    
    if(length(coef.caus) == 1){
      y.for[j] <-  int/(1-sum(coef.noncaus)) + coef.caus * y.star + exp[j]
    }
    else{
      y.for[j] <-  int/(1-sum(coef.noncaus)) + t(coef.caus) %*% y.star + exp[j]
    }
    
    #y.star <- c(y.for[j], y.star[1:(length(y.star)-1)])
  }
  
  return(y.for)
}

rmsfe <- function(y,y.for){
  a <- (y-y.for)^2
  b <- sum(a)
  rmsfe.y <- sqrt(b/length(y.for))
  
  return(rmsfe.y)
}
