###--------------------------------------------------------------------------------------------------------###
###--------------------- EX-POST parsification and forecasting function -----------------------------------###
###--------------------------------------------------------------------------------------------------------###

# Inputs from 03_SAVS_expost and previously estimated VAR: 
## coeff.list <- list(ALPHA.store = ALPHA.store, SIGMA.store = SIGMA.store, hyperpara.summary = hyperpara.summary, eht.store = eht.store, eig = eig, delta.store = delta.store, epsilon.store = epsilon.store, X = X, Y = Y, K = K, T=T, M = M, Y.out = Y.out, cons = cons, var.names = colnames(Y), duration = duration)

## sparsify.setup <- list(wo1own = wo1own, sparse.values = sparse.values, sparse.pen = sparse.pen, cov.sparse = cov.sparse, cov.glasso = cov.glasso, loss.iter = loss.iter, eval.loss = eval.loss)

# In principle any posterior draws in ALPHA.store and SIGMA.store can be used:
## ALPHA.store is a nsave x K x M matrix
## SIGMA.store is a nsave x M x M matrix


post.func <- function(coeff.list = coeff.list, trans = trans, sparsify.setup = sparsify.setup)
{
  #---------------------------------------------------Data Settings---------------------------------
  
  list2env(x = coeff.list, envir = .GlobalEnv)
  list2env(x = sparsify.setup, envir = .GlobalEnv)
  
  nsave <- dim(ALPHA.store)[[1]]
  
  lambda.v <- sparse.values["lambda"]/100
  lambda <- sparse.values["lambda"]
  kappa.v <- kappa <- sparse.values["kappa"]
  kappa.pen <- sparse.pen["kappa"]
  lambda.pen <- sparse.pen["lambda"]
  
  if(eval.loss) Z <- Matrix::Matrix(kronecker(diag(1,M), X), sparse = T)
  n <- K*M
  v <- (M*(M-1))/2
  
  if(trans == "I0") prmean <- 0 else if(trans == "I1") prmean <- 0.9

#---------------------------------------------------SAVS Setting---------------------------------
  
  # Create lagwise structure 
  if(p > 1){
    kappa.p <- kappa
    for(jj in 2:p){
      kappa.p[jj] <- (kappa.p[jj-1]*kappa)^kappa.pen
    }
    
    lambda.p <- lambda*(1:p)^lambda.pen  
    
    
    kappa <- rep(kappa.p, each = M)
    lambda <- rep(lambda.p, each = M)
    
    if(cons){
      kappa <- matrix(c(kappa, kappa[1]), K, 1)
      lambda <- matrix(c(lambda, 1e-20), K, 1)
    }else{
      kappa <- matrix(kappa, K, 1)
      lambda <- matrix(lambda, K, 1)
    }
    
  }else{
    kappa <- matrix(kappa,K,1)
    lambda <- matrix(lambda,K,1)
  }
  
  
  # Create kappa/lambda matrices corresponding to coefficient matrices (K x M)
  lambda.mat <- kappa.mat <- matrix(NA, K, M)
  for(mm in 1:M){
    lambda.temp <- lambda
    if(wo1own) lambda.temp[mm] <- 1e-20
    kappa.mat[,mm] <- kappa
    lambda.mat[,mm] <- lambda.temp
  }
  
  # Vectorize them corresponding to vectorized coefficient matrices (KM x 1)
  lambda.vec <- as.vector(lambda.mat)
  kappa.vec <- as.vector(kappa.mat)

    
###--------------------- Sparsify median estimates   

  ALPHA.median <- apply(ALPHA.store,c(2,3),median)
  ALPHA.sd <- apply(ALPHA.store,c(2,3),sd)
  SIGMA.median <- apply(SIGMA.store, c(2,3), median)
  SIGMA.sd <- apply(SIGMA.store, c(2,3), sd)
  
  norm.full <- rep(apply(X,2,norm_vec)^2, M)
  #norm.full <- apply(Z,2,norm_vec)^2
  a.exp.median <- alpha.median <-  as.vector(ALPHA.median) #exp-post median 
  mu.vec <- log(lambda.vec) - kappa.vec*(log(abs(alpha.median))) #does not change with iterations
  mu.vec <- exp(mu.vec)
  mu.mat <- matrix(mu.vec, K, M)
  
  ind.change <- (abs(alpha.median)*norm.full)>mu.vec
  a.exp.median[ind.change] <- (sign(alpha.median)*1/norm.full * ((abs(alpha.median)*norm.full)-mu.vec))[ind.change]
  a.exp.median[!ind.change] <- 0  
  A.exp.median <- matrix(a.exp.median, K, M)  
  delta.exp.mean <- (A.exp.median != 0)*(A.exp.median != 0)
  
  sig.pen <- try(lambda.v/abs(solve(SIGMA.median))^(kappa.v*0.5), silent = TRUE)
  if(is(sig.pen, "try-error")) sig.pen <- lambda.v/abs(MASS::ginv(SIGMA.median))^(kappa.v*0.5)
  
  # computationally very demanding, probably Sigma.median is too dense!
  if(M < 100) S.exp.median <- glasso::glasso(SIGMA.median, rho = sig.pen, maxit = loss.iter)$w else S.exp.median <- SIGMA.median
  #S.exp.median <- glasso::glasso(SIGMA.median, rho = sig.pen, maxit = loss.iter)$w 
  epsilon.exp.mean <- (S.exp.median != 0)*(S.exp.median != 0)
  
#--------Create storage arrays for Sigma, S (sparsified Sigma), Alpha, and A (sparsified Alpha) ---- 
  
  A.store  <- delta.store <- array(0,c(nsave,K,M))
  S.store  <- epsilon.store <- array(NA,c(nsave,M,M))
  loss.store <- matrix(0, nsave, loss.iter)
  colnames(loss.store) <- 0:(loss.iter-1)
  niter.sig.store <- matrix(0, nsave, 1)
  
#--------Create storage arrays for predictions  ----  
  stab.ind <- eig <- eig.sps <- stab.sps.ind <- matrix(0,nsave,1)
  
  pred.store <- pred.sps.store <- array(NA, c(nsave,length(forc.var), fhorz))
  lps.tot.store <- lps.sps.tot.store <- matrix(NA, nsave,fhorz)
  lps.mar.store <- lps.sps.mar.store <- array(NA, c(nsave,length(forc.var), fhorz))
  
  dimnames(lps.mar.store) <- dimnames(lps.sps.mar.store) <- list(1:nsave,forc.var,1:fhorz)
  colnames(lps.tot.store) <- colnames(lps.sps.tot.store) <- 1:fhorz
  
  start <- Sys.time()
  pb <- txtProgressBar(min = 0, max = nsave, style = 3) #start progress bar
  
  for (irep in seq_len(nsave)){
    Alpha.draw <- ALPHA.store[irep,,]
    Sigma.draw <- SIGMA.store[irep,,]
    #Sig2.t <- eht.store[irep,]
    Sig2.t <- rep(1,T)
    #normalizer <- 1/sqrt(Sig2.t)
    
    #Step 1: Sparsify coefficients for each draw
    norm.full <- rep(apply(X,2,norm_vec)^2, M)
    #norm.full <- apply(Z,2,norm_vec)^2
    a.draw <- alpha.draw <-  as.vector(Alpha.draw)
    mu.vec <- log(lambda.vec) - kappa.vec*(log(abs(alpha.draw))) #does not change with iterations
    mu.vec <- exp(mu.vec)
    mu.mat <- matrix(mu.vec, K, M)
    
    if(eval.loss){
      a.draw.temp <- alpha.draw.temp <- alpha.draw
      for(jj in seq_len(loss.iter)){
        alpha.draw.temp <- a.draw.temp
        loss <- loss.func(Z = Z, alpha.draw = alpha.draw, a.draw = alpha.draw.temp, mu = mu.vec)
        print(loss)
        
        Alpha.draw.temp <- matrix(alpha.draw.temp, K, M)
        #R.list <- list()
        ZR.list <- list()
        for(ii in 1: M){
          R.i <-  part.res.func(Z = X, alpha.draw = Alpha.draw[,ii], a.draw = Alpha.draw.temp[,ii])
          ZR.list[[ii]] <- diag(as.matrix(Matrix::crossprod(X, R.i)))
          #R.list[[ii]] <- R.i
        }
        
        #R <- Matrix::bdiag(R.list)
        ZR <- unlist(ZR.list)
        
        ind.change <- abs(ZR) > mu.vec
        a.draw.temp[ind.change] <- (sign(ZR)*1/norm.full * (abs(ZR) - mu.vec))[ind.change]
        a.draw.temp[!ind.change] <- 0
        
        loss.store[irep,jj] <- loss
        # Check correctness   
        if(jj == 1){
          print(sum((abs(alpha.draw)*norm.full) - abs(ZR)))
          A.draw.1 <-  matrix(a.draw.temp, K, M)
        }  

    }
      
    A.draw <- matrix(a.draw.temp, K, M)
    plot(x = colnames(loss.store), y = loss.store[irep,], type = "l")
      
    }else{
    ind.change <- (abs(alpha.draw)*norm.full)>mu.vec
    a.draw[ind.change] <- (sign(alpha.draw)*1/norm.full * ((abs(alpha.draw)*norm.full)-mu.vec))[ind.change]
    a.draw[!ind.change] <- 0  
    A.draw <- matrix(a.draw, K, M)  
      
    }  
      
      
    if(wo1own) diag(A.draw[1:M,1:M]) <- diag(Alpha.draw[1:M,1:M]) #diagonal of first lag not-sparsified
    
    if(cons){ #constant not-sparsified
      A.draw[K,] <- Alpha.draw[K,]
      rownames(A.draw) <- rownames(Alpha.draw) <- c(rep(var.names, p), "1")
      colnames(A.draw) <- colnames(Alpha.draw) <- var.names
    }else{
      rownames(A.draw) <- rownames(Alpha.draw) <- rep(var.names, p)
      colnames(A.draw) <- colnames(Alpha.draw) <- var.names
    }
    
    delta.draw <- (A.draw != 0)*(A.draw != 0)
    #Step 2: Sparsify covariances for each draw
    chol.sig <- (chol(Sigma.draw))
    dd.sig <- diag(chol.sig)
    L.draw <- t(chol.sig/dd.sig)
    DD.draw <- diag(dd.sig)
    
    eta <- (Y-X%*%A.draw)%*%t(solve(L.draw))
    epsilon.draw <- diag(1,M)
    
    if(cov.sparse)
    {
      
      if(cov.glasso){
        #sig.pen <- lambda.v/abs(Sigma.draw)^(kappa.v*0.5)
        sig.pen <- try(lambda.v/abs(solve(Sigma.draw))^(kappa.v*0.5), silent = TRUE)
        if(is(sig.pen, "try-error")) sig.pen <- lambda.v/abs(MASS::ginv(Sigma.draw))^(kappa.v*0.5)
        glasso.obj <- glasso::glasso(Sigma.draw, thr = 1e-2, rho = sig.pen, maxit = loss.iter, approx = FALSE) 
        S.draw <- glasso.obj$w
        if(eval.loss) niter.sig.store[irep,] <- glasso.obj$niter
        epsilon.draw <- (S.draw != 0)*(S.draw != 0)
      }else{
        L.sps <- L.draw
        for (ii in 3:M){
          X.ii <- eta[,1:(ii-1),drop=F]
          b.ii <- as.matrix(L.draw[ii,1:(ii-1)])
          b.sps <- sparsify(X.ii,b.ii,nrow(b.ii),kappa = kappa.v, lambda = lambda.v)
          L.sps[ii,1:(ii-1)] <- b.sps
        }
        epsilon.draw <- (L.sps != 0)*(L.sps != 0)
        
        S.draw <- L.sps%*%(DD.draw^2)%*%t(L.sps)
      }
      
    }else{
      S.draw <- Sigma.draw
    }
    
    delta.store[irep,,] <- delta.draw
    epsilon.store[irep,,] <- epsilon.draw
    A.store[irep,,] <- A.draw
    if(all(S.draw != Sigma.draw)) S.store[irep,,] <- S.draw

    get.comp <- get.companion(Beta_=Alpha.draw,varndxv=c(M,cons,p))
    get.comp.sps <- get.companion(Beta_=A.draw,varndxv=c(M,cons,p))
    
    MM <- get.comp$MM
    MM.sps <- get.comp.sps$MM
    Jm <- get.comp$Jm
    
    stab.draw <- ifelse(max(abs(Re(eigen(MM)$values)))>1.07,0,1)
    eig[irep,] <- max(abs(Re(eigen(MM)$values)))
    stab.ind[irep,] <- stab.draw
    
    stab.sps.draw <- ifelse(max(abs(Re(eigen(MM.sps)$values)))>1.07,0,1)
    eig.sps[irep,] <- max(abs(Re(eigen(MM.sps)$values)))
    stab.sps.ind[irep,] <- stab.sps.draw
    Sig2.pred <- Sig2.t[T]
    
    pred.sps.draw <- do.fcst(Y,X,A.draw = A.draw,Sig.t = Sig2.pred*S.draw,fhorz = fhorz, var.names = var.names, forc.var =  forc.var, T = T, M = M,K= K,p=p,cons=TRUE)
    pred.draw <- do.fcst(Y,X,A.draw = Alpha.draw,Sig.t = Sig2.pred*Sigma.draw,fhorz = fhorz, var.names = var.names, forc.var =  forc.var, T=T, M = M,K= K,p=p,cons=TRUE)
    
    cov.pred.sps <- pred.sps.draw[[3]]
    mean.pred.sps <- pred.sps.draw[[2]]
    pred.sps.draw <- pred.sps.draw[[1]]
    
    cov.pred <- pred.draw[[3]]
    mean.pred <- pred.draw[[2]]
    pred.draw <- pred.draw[[1]]
    
    lps.sps.tot.draw <- lps.tot.draw <- c()
    lps.sps.mar.draw <- lps.mar.draw <- matrix(0,length(forc.var), fhorz)
    
    for(zz in 1:fhorz){
      lps.sps.tot.draw[zz] <- mvtnorm::dmvnorm(as.numeric(Y.out[,zz]), mean = mean.pred.sps[,zz], sigma = cov.pred.sps[,,zz], log = TRUE)
      lps.sps.mar.draw[,zz] <- dnorm(as.numeric(Y.out[,zz]), mean = mean.pred.sps[,zz], sd = sqrt(diag(cov.pred.sps[,,zz])), log = TRUE)
      
      lps.tot.draw[zz] <- mvtnorm::dmvnorm(as.numeric(Y.out[,zz]), mean = mean.pred[,zz], sigma = cov.pred[,,zz], log = TRUE)
      lps.mar.draw[,zz] <- dnorm(as.numeric(Y.out[,zz]), mean = mean.pred[,zz], sd = sqrt(diag(cov.pred[,,zz])), log = TRUE)
    }
    
    pred.store[irep,,] <- pred.draw
    lps.tot.store[irep,] <- lps.tot.draw
    lps.mar.store[irep,,] <- lps.mar.draw
    
    pred.sps.store[irep,,] <- pred.sps.draw
    lps.sps.tot.store[irep,] <- lps.sps.tot.draw
    lps.sps.mar.store[irep,,] <- lps.sps.mar.draw
    
    setTxtProgressBar(pb, irep) 
  }
  end <- Sys.time()
  duration.sps <- end-start
  (duration.sps) 
  
  A.median <- apply(A.store,c(2,3),median)
  A.sd <- apply(A.store,c(2,3),sd)
  S.median <- apply(S.store, c(2,3), median, na.rm = T)
  S.sd <- apply(S.store, c(2,3), sd, na.rm = T)
  
  epsilon.mean <- apply(epsilon.store, c(2,3), mean)
  delta.mean <- apply(delta.store, c(2,3), mean)
  
  eht.median <- apply(eht.store, 2, median)
  eht.low <- apply(eht.store, 2, quantile,0.05)
  eht.high <- apply(eht.store, 2, quantile,0.95)
  
  eht.overview <- rbind(Mean = eht.median, Low = eht.low, High = eht.high)
  
  loss.mean <- apply(loss.store, 2, mean)
  niter.sig.mean <- mean(niter.sig.store)
  
  
  coeff.sps.list <- list(A.median = A.median, A.sd = A.sd, S.median = S.median, S.sd = S.sd, epsilon.mean = epsilon.mean, delta.mean = delta.mean, loss.mean = loss.mean, niter.sig.mean = niter.sig.mean, duration.sps = duration.sps)
  
  coeff.sps.exp.list <- list(A.median = A.exp.median, S.median = S.exp.median,  epsilon.mean = epsilon.exp.mean, delta.mean = delta.exp.mean)
  
  coeff.list <- list(A.median = ALPHA.median, A.sd = ALPHA.sd, S.median = SIGMA.median, S.sd = SIGMA.sd,hyperpara.summary = hyperpara.summary, eht.overview = eht.overview)
  
  pred.list <- pred.sps.list <- list()
  pred.sps.store <- pred.sps.store[stab.sps.ind == 1,,]
  lps.sps.tot.store <- lps.sps.tot.store[stab.sps.ind == 1,]
  lps.sps.mar.store <- lps.sps.mar.store[stab.sps.ind == 1,,]
  
  pred.sps.list <- list(pred.sps.store = pred.sps.store,  lps.sps.tot.store = lps.sps.tot.store, lps.sps.mar.store = lps.sps.mar.store, Y.out = Y.out)
  
  pred.store <- pred.store[stab.ind == 1,,]
  lps.tot.store <- lps.tot.store[stab.ind == 1,]
  lps.mar.store <- lps.mar.store[stab.ind == 1,,]
  
  pred.list <- list(pred.store = pred.store, lps.tot.store = lps.tot.store, lps.mar.store = lps.mar.store, Y.out = Y.out)
  
  return(list(pred.list = pred.list, pred.sps.list = pred.sps.list, coeff.list = coeff.list, coeff.sps.list = coeff.sps.list, coeff.sps.exp.list = coeff.sps.exp.list))
  
}

###--------------------------------------------------------------------------------------------------------###
###---------------- Auxilliary functions for sparsification and forecasting -------------------------------###
###--------------------------------------------------------------------------------------------------------###


norm_vec <- function(x) sqrt(sum(x^2))

sparsify <- function(X,b,K.max,kappa, lambda){
  b.sparse <- matrix(0,K.max,1)
  for (jj in seq_len(K.max)){
    mu.jj <- lambda/abs(b[jj,1])^kappa
    norm.j <- norm_vec(X[,jj])^2
    if ((abs(b[jj,1])*norm.j) < mu.jj){
      b.sparse[jj,1] <- 0
    }else{
      b.sparse[jj,1] <- sign(b[jj,1])* 1/norm.j * ((abs(b[jj,1])*norm.j)-mu.jj)
    }
  }
  return(b.sparse)
}

savs.fun=function(X,beta.in){
  # Input: X is nXp design matrix; beta.in: posterior mean of beta (pX1)
  # Output: Sparse estimate beta.est
  p <- ncol(X)
  beta.est=double()
  mu=(beta.in)^(-2)
  for(j in 1:p){
    xtx = t(X[,j])%*%X[,j]
    if(mu[j] >= abs(beta.in[j])*xtx){
      beta.est[j]=0
    }else{
      beta.est[j]=sign(beta.in[j])*(abs(beta.in[j])*xtx - mu[j])/xtx
    }
  }
  return(beta.est)
}


loss.func <- function(Z, alpha.draw, a.draw, mu){
  fit <- as.vector(Z%*%alpha.draw)
  fit.sparse <- as.vector(Z%*%a.draw)
  #fit.test <- kronecker(diag(1,M), X)%*%a.draw
  loss <- 0.5*as.numeric(crossprod(fit - fit.sparse)) +  sum(mu*abs(a.draw))
  
  return(loss)
}

part.res.func <- function(Z = Z, alpha.draw = alpha.draw, a.draw = a.draw)
{
  n <- ncol(Z)
  T <- nrow(Z)
  R <- matrix(NA, T,n)
  fit.draw <- as.numeric(Z%*%alpha.draw)
  
  for (xx in 1:n){
    R[,xx] <- (fit.draw - as.numeric(Z[,-xx]%*%a.draw[-xx]))
  }
  return(R)
}  

### Auxilliary VAR functions: 
get.companion <- function(Beta_,varndxv){
  nn <- varndxv[[1]]
  nd <- varndxv[[2]]
  nl <- varndxv[[3]]
  
  nkk <- nn*nl+nd
  
  Jm <- matrix(0,nkk,nn)
  Jm[1:nn,1:nn] <- diag(nn)
  
  if(nd <= 1)
  {
    MM <- rbind(t(Beta_),cbind(diag((nl-1)*nn), matrix(0,(nl-1)*nn,nn+1)),c(matrix(0,1,(nn*nl)),1))
  }else
  {
    MM <- rbind(t(Beta_),cbind(diag((nl-1)*nn), matrix(0,(nl-1)*nn,nn+nd)),cbind(matrix(0,nd,(nn*nl)),diag(1,nd)))
  }
  
  return(list(MM=MM,Jm=Jm))
}

# get IRF
impulsdtrf <- function(B,smat,nstep,time=FALSE,B1=NULL){
  neq <- dim(B)[1]
  nvar <- dim(B)[2]
  lags <- dim(B)[3]
  dimnB <- dimnames(B)
  if(dim(smat)[2] != dim(B)[2]) stop("B and smat conflict on # of variables")
  response <- array(0,dim=c(neq,nvar,nstep+lags-1));
  response[ , , lags] <- smat
  response <- aperm(response, c(1,3,2))
  irhs <- 1:(lags*nvar)
  ilhs <- lags * nvar + (1:nvar)
  response <- matrix(response, ncol=neq)
  B <- B[, , seq(from=lags, to=1, by=-1)]  #reverse time index to allow matrix mult instead of loop
  B <- matrix(B,nrow=nvar)
  for (it in 1:(nstep-1)) {
    if (time){
      if (it==8){
        B <- B1[, , seq(from=lags, to=1, by=-1)]  #reverse time index to allow matrix mult instead of loop
        B <- matrix(B1,nrow=nvar)
      }
    }
    #browser()
    response[ilhs, ] <- B %*% response[irhs, ]
    irhs <- irhs + nvar
    ilhs <- ilhs + nvar
  }
  ## for (it in 2:nstep)
  ##       {
  ##         for (ilag in 1:min(lags,it-1))
  ##           response[,,it] <- response[,,it]+B[,,ilag] %*% response[,,it-ilag]
  ##       }
  dim(response) <- c(nvar, nstep + lags - 1, nvar)
  response <- aperm(response[ , -(1:(lags-1)), ], c(1, 3, 2)) #drop the zero initial conditions; array in usual format
  dimnames(response) <- list(dimnB[[1]], dimnames(smat)[[2]], NULL)
  ## dimnames(response)[2] <- dimnames(smat)[1]
  ## dimnames(response)[1] <- dimnames(B)[2]
  return(response)
}

do.irf <- function(A.draw, cons, shock, nhor, var.names, irf.var, ident, p,m){
  # drop constant in an elegant way
  #if(cons)
  #{
  # A.draw <- A.draw[,-ncol(A.draw)]
  #}
  A_array <- array(0,c(m,m,p))
  for (k in 1:p){
    A_array[,,k] <- t(A.draw[(((k-1)*m+1):(k*m)),])
  }
  
  dimnames(A_array)[[1]] <- dimnames(A_array)[[2]] <- var.names
  
  #sign restrictions
  if(ident == "sign")
  {
    print("To be implemented.")
  }
  
  #external instrument
  if(ident == "ext.instr")
  {
    print("To be implemented.")
  }
  
  impls <-impulsdtrf(A_array,shock,nhor)# #
  dimnames(impls)[[1]] <- dimnames(impls)[[2]] <- var.names
  
  impls_temp <-impls[,irf.var,,drop=FALSE]
  
  return(impls_temp)
}

# calculate forecast error variance decomposition
do.fevd <- function(){
  print("To be implemented.")
}

# calculate historical decomposition
do.hd <- function(Y, X, p, Sig.chol, Fcomp, A.post, K, M, T, red.resid, dates = NA){
  
  Atilda <- A.post
  nlag  <- p   # number of lags
  invA    <- Sig.chol   # inverse of the A matrix
  rownames(invA) <- colnames(invA)  <- colnames(Y)
  
  Fcomp   <- Fcomp    # Companion matrix
  
  eps <- try(solve(invA) %*% t(red.resid),silent=TRUE)
  if (is(eps,"try-error")) eps <- ginv(invA)  %*% t(red.resid)  # structural residuals = A0 x reduced-form residuals
  
  ## Compute historical decompositions
  
  invA_big <- matrix(0,K,M) # A_tilde
  invA_big[1:M,] <- invA
  Icomp <- cbind(diag(M), matrix(0,M,(p-1)*M))
  HDshock <- array(0, dim=c(M,T,M))
  dimnames(HDshock)[1] <- dimnames(HDshock)[3]  <- colnames(Y)
  if(dates)
  {
    dimnames(HDshock)[2] <- dates
  }else{
    dimnames(HDshock)[2] <- 1:T
  }
  
  HDinit <- matrix(0,M,T)
  HDinit[,1] <- X[1,]
  
  ## Contribution of each shock in each period
  for(nn in 2:T)
  {
    eps_i <- solve(invA)%%(Y[nn,]-t(Atilda)%%X[nn,])
    for (jj in 1:M)
    {
      eps_big <- matrix(0,M,1)
      eps_big[jj,] <- eps_i[jj,]
      HDshock[,nn,jj] <- (invA_big) %% eps_big + Fcomp %% HDshock[,nn-1,jj]
    }
    HDinit[,nn] <- Fcomp %*% HDinit[,nn-1]
  }
  return(HD.shock)
}

do.fcst <- function(Y,X, A.draw,Sig.t,fhorz, var.names, forc.var, T, M,K,p,cons){
  #Predict Sigma_t multi-steps ahead
  A.draw <- A.draw
  Sig.t <- Sig.t
  
  get.comp <- get.companion(Beta_=A.draw,varndxv=c(M,cons,p))
  MM <- get.comp$MM
  Jm <- get.comp$Jm
  
  if(p > 1){
    if(cons){
      X0 <- c(Y[T,],X[T,(1:(K-M-1))],1)
    }else{
      X0 <- c(Y[T,],X[T,(1:(K-M))])
    }
  }else{
    if(cons){
      X0 <- c(Y[T,],1)
    }else{
      X0 <- c(Y[T,])
    }
  }  
  
  
  X0 <- as.matrix(X0)
  
  Sig.0 <- matrix(0,K,K)
  Sigma00 <- as.matrix(Sig.t)
  
  
  #Predict Sigma_t multi-steps ahead
  Sigma.pred <- array(NA,c(M,M,fhorz))
  Mean.pred <- matrix(NA, M, fhorz)
  pred.fhorz <- matrix(NA,M,fhorz)
  rownames(pred.fhorz) <- rownames(Mean.pred) <- var.names
  dimnames(Sigma.pred) <- list(var.names,var.names,1:fhorz)
  
  for (jj in 1:fhorz){
    Sig.0 <- MM%*%Sig.0%*%t(MM)+Jm%*%Sigma00%*%t(Jm)
    cholSig.0 <- try(t(chol(Sig.0[1:M,1:M])),silent=TRUE)
    
    X0 <- MM%*%X0
    
    if (is(cholSig.0,"try-error")){
      y.forecast <- rmvnorm(1,mean=X0[1:M],sigma=Sig.0[1:M,1:M])#X0[1:m]+t(chol(Sig.0[1:m,1:m]))%*%rnorm(m)#t(rmvnorm(1,mean=X0[1:m],sigma=Sig.0[1:m,1:m]))
    }else{
      y.forecast <- X0[1:M]+cholSig.0%*%rnorm(M,0,1)
    }  
    pred.fhorz[,jj] <- y.forecast
    Sigma.pred[,,jj] <- Sig.0[1:M,1:M]
    Mean.pred[,jj] <- X0[1:M]
  }
  
  #if(normalise){
  #mean.in <- as.numeric(mean.in)
  #sd.in <- as.numeric(sd.in)
  #pred.fhorz <- apply(pred.fhorz, 2, function(x){x <- x*sd.in + mean.in})
  #for(zz in 1:fhorz){
  #  Sigma.pred[,,zz] <- diag(sd.in)%*%Sigma.pred[,,zz]%*%diag(sd.in) #cov.in element-wise 
  #}
  #}
  
  pred.fhorz <- pred.fhorz[forc.var,]
  Sigma.pred <- Sigma.pred[forc.var,forc.var,]
  Mean.pred <- Mean.pred[forc.var,]
  
  return(list(pred.fhorz, Mean.pred, Sigma.pred))
}

mk_fevd <- function(irfa){
  ny <- dim(irfa)[[1]];nH <- dim(irfa)[[3]]
  
  fevda <- apply(irfa*irfa,c(1,2),cumsum);
  fevda <- aperm(fevda,c(2,3,1))
  accm <- matrix(0,ny,ny)
  for (ih in 1:nH){
    accm <- accm+irfa[,,ih]%*%t(irfa[,,ih])
    denm <- matrix((diag(accm)),ny,ny)
    fevda[,,ih]=fevda[,,ih]/denm 
  }
  return(fevda)
} 

#Inputs
sign_irf_bb <- function(A_array,M,shock,nhor,srots=5,maxrep=6500){
  imps <- seq(1:1)
  impulse_rot <- array(0,c(M,M,nhor,srots))
  store_rot <- array(0,c(M,M,srots))
  for (kk in 1:srots){
    icounter <- 0
    icheck <- 0
    a <- 0;b <- 0;c <- 0;d <- 0
    while(icheck<1 && icounter<maxrep){
      icounter <- icounter+1
      #icounter <- icounter+1
      #Step 1: Draw a rotation matrix
      A <- matrix(rnorm(M*M,0,1),M,M)
      qA <- qr(A)
      rotA <- qr.Q(qA)
      rotA <- rotA%*%diag(((diag(rotA)>0)-(diag(rotA)<0)))
      Abar <- shock%*%t(rotA)
      rownames(Abar) <- colnames(Abar) <- dimnames(A_array)[[1]]
      R_bar <- diag(M)
      colnames(R_bar) <- rownames(R_bar) <- dimnames(A_array)[[1]]
      
      theta <- atan(Abar["stir","spread"]/Abar["stir","stir"])
      R_bar["stir","stir"] <- cos(theta);R_bar["stir","spread"] <- -sin(theta)
      R_bar["spread","stir"] <- sin(theta);R_bar["spread","spread"] <- cos(theta)
      
      irf_o <- impulsdtrf(A_array,shock%*%t(rotA)%*%R_bar,2)
      
      colnames(rotA) <- rownames(rotA) <- dimnames(irf_o)[[1]] <- dimnames(irf_o)[[2]] <- dimnames(A_array)[[1]] #CHG to dimanmes(A_array)[[1]]
      #     #Impose AD shock
      #     a <- (irf_o["rgdp","rgdp",1]>0)*(irf_o["infl","rgdp",1]>0)*(irf_o["stir","rgdp",1]>0)
      #     if (!(all(a)==1)){
      #       next
      #     }
      #     #impose restrictions on AS shock
      #     b <- (irf_o["rgdp","infl",1]<0)*(irf_o["infl","infl",1]>0)*(irf_o["stir","infl",1]>0)#*(irf_o["inv","infl",1]<0)*(irf_o["cons","infl",1]>0)
      #       if (!(all(b)==1)){
      #       next
      #     }
      #     #impose restrictions on MP shock
      c <- (irf_o["rgdp","stir",imps]<=0)*(irf_o["infl","stir",imps]<=0)*(irf_o["stir","stir",1]>=0)*(irf_o["spread","stir",1]<=0)*(irf_o["banks_assets","stir",1]<0)*(irf_o["banks_deposits","stir",1]<0)*(irf_o["wealth","stir",1]<0)*(irf_o["nim_large","stir",1]<0)#*(irf_o["inv","stir",1]<0)#*(irf_o["infl_exp","stir",1]<0)#*(irf_o["cons","stir",1]<0)
      if (!(all(c)==1)){
        next 
      }
      
      #impose restrictions on SPREAD shock
      d <- (irf_o["rgdp","spread",imps]<=0)*(irf_o["infl","spread",imps]<=0)*(irf_o["spread","spread",1]>=0)*(irf_o["banks_deposits","spread",1]<0)*(irf_o["wealth","spread",1]<0)*(irf_o["nim_large","spread",1]>0)#*(irf_o["inv","spread",1]<0)#*(irf_o["infl_exp","spread",1]<0)#*(irf_o["inv","stir",1]<0)*(irf_o["cons","stir",1]<0)#*(irf_o["inv","spread",1]<0)*(irf_o["cons","spread",1]<0)#*(irf_o["wealth"])
      if (!(all(d)==1)){
        next 
      }
      
      icheck <- 1
    }
    
    st_impulses <- impulsdtrf(A_array,shock%*%t(rotA)%*%R_bar,nhor)
    impulse_rot[,,,kk] <- st_impulses
    store_rot[,,kk] <- t(rotA)%*%R_bar
  }
  st_impulses_1 <- apply(impulse_rot,c(1,2,3),median)
  dimnames(st_impulses_1)[[1]] <- dimnames(st_impulses_1)[[2]] <-dimnames(A_array)[[1]] #CHG to dimanmes(A_array)[[1]]
  
  irflev <- impulse_rot
  signvars <- NULL
  irffp <- array(0,c(3,dim(irflev)[2],dim(irflev)[3],dim(irflev)[4]))
  
  for (jj in 1:dim(irflev)[2]){ 
    for (k in 1:3){
      for (i in 1:dim(irflev)[3]){
        for (j in 1:dim(irflev)[4]){
          irffp[k,jj,i,j] <- (irflev[k,jj,i,j] - median(irflev[k,jj,i,]))/sd(irflev[k,jj,i,])
        }
      }
    }
  }
  
  near <- NULL
  for (jj in 1:dim(irflev)[2]){
    for (k in 1:3){
      for (j in 1:nhor){
        near <- c(near,which(abs(irffp[k,jj,j,]-0)==min(abs(irffp[k,jj,j,]-0))))
      }
    }
  }
  pickrot <- as.numeric(names(sort(-table(near)))[1])
  # if (srots>1){
  rotpick <- store_rot[,,pickrot]
  # }else{
  rotpick <- t(rotA)%*%R_bar
  # }
  return(list(impl=st_impulses_1,rot=rotpick,counter=icounter))
}


get_companion <- function(Beta_,varndxv){
  nn <- varndxv[[1]]
  nd <- varndxv[[2]]
  nl <- varndxv[[3]]
  
  nkk <- nn*nl+nd
  Jm <- matrix(0,nkk,nn)
  MM <- matrix(0,nkk,nkk)
  Jm[1:nn,1:nn] <- diag(nn)
  if (nd==1){
    MM <- rbind(t(Beta_), cbind(diag((nl-1)*nn),matrix(0,(nl-1)*nn,nn+nd)),c(matrix(0,nd,nn*nl),nd))
  }else{
    MM <- rbind(t(Beta_), cbind(diag((nl-1)*nn),matrix(0,(nl-1)*nn,nn+nd)))
  }
  return(list(MM=MM,Jm=Jm))
}

#Inputs
sign_irf <- function(A_array,M,shock,nhor,srots=5,maxrep=6500,Z=Z.list,fA0A=fA0Aplus){
  imps <- seq(1:1)
  impulse_rot <- array(0,c(M,M,nhor,srots))
  store_rot <- array(0,c(M,M,srots))
  for (kk in 1:srots){
    icounter <- 0
    icheck <- 0
    a <- 0;b <- 0;c <- 0;d <- 0
    while(icheck<1 && icounter<maxrep){
      icounter <- icounter+1
      #icounter <- icounter+1
      #Step 1: Draw a rotation matrix
      R0 <- get.ROT(Z.list=Z,S.list=NULL,fA0Aplus=fA0A,M=M)
      
      irf_o <- shock%*%R0#impulsdtrf(A_array,shock%*%R0,2)
      
      colnames(R0) <- rownames(R0) <- dimnames(irf_o)[[1]] <- dimnames(irf_o)[[2]] <- dimnames(A_array)[[1]] #CHG to dimanmes(A_array)[[1]]
      #     #Impose AD shock
      #     a <- (irf_o["rgdp","rgdp",1]>0)*(irf_o["infl","rgdp",1]>0)*(irf_o["stir","rgdp",1]>0)
      #     if (!(all(a)==1)){
      #       next
      #     }
      #     #impose restrictions on AS shock
      #     b <- (irf_o["rgdp","infl",1]<0)*(irf_o["infl","infl",1]>0)*(irf_o["stir","infl",1]>0)#*(irf_o["inv","infl",1]<0)*(irf_o["cons","infl",1]>0)
      #       if (!(all(b)==1)){
      #       next
      #     }
      #impose restrictions on SPREAD shock
      d <- (irf_o["spread","spread"]>0)*(irf_o["banks_deposits","spread"]<0)*(irf_o["wealth","spread"]<0)*(irf_o["nim_large","spread"]>0)#d <- (irf_o["rgdp","spread",imps]<=0)*(irf_o["infl","spread",imps]<=0)*(irf_o["spread","spread",1]>=0)*(irf_o["banks_deposits","spread",1]<0)*(irf_o["wealth","spread",1]<0)*(irf_o["nim_large","spread",1]>0)#*(irf_o["inv","spread",1]<0)#*(irf_o["infl_exp","spread",1]<0)#*(irf_o["inv","stir",1]<0)*(irf_o["cons","stir",1]<0)#*(irf_o["inv","spread",1]<0)*(irf_o["cons","spread",1]<0)#*(irf_o["wealth"])
      if (!(all(d)==1)){
        next
      }
      #(irf_o["rgdp","spread"]<=0)*(irf_o["infl","spread"]<=0)*
      #print(d)
      #
      #     #impose restrictions on MP shock
      c <-(irf_o["stir","stir"]>=0)*(irf_o["spread","stir"]<=0)*(irf_o["banks_assets","stir"]<0)*(irf_o["banks_deposits","stir"]<0)#*(irf_o["wealth","stir"]<0)#*(irf_o["nim_large","stir"]<0)#*(irf_o["inv","stir",1]<0)#*(irf_o["infl_exp","stir",1]<0)#*(irf_o["cons","stir",1]<0)#(irf_o["stir","stir"]>0)*(irf_o["spread","stir"]<0)*(irf_o["infl","stir"]<0)*(irf_o["rgdp","stir"]<0)#*(irf_o["inv","stir",1]<0)#*(irf_o["infl_exp","stir",1]<0)#*(irf_o["cons","stir",1]<0)#
      if (!(all(c)==1)){
        next
      }
      #(irf_o["infl","stir"]<0)*(irf_o["rgdp","stir"]<0)
      
      
      icheck <- 1
    }
    
    st_impulses <- impulsdtrf(A_array,shock%*%R0,nhor)
    impulse_rot[,,,kk] <- st_impulses
    store_rot[,,kk] <- R0
  }
  
  return(list(impl=st_impulses,rot=R0,counter=icounter))
}


impulsdtrf <- function(B,smat,nstep,time=FALSE,B1=NULL)
  ### By:             As emerges from rfvar, neqn x nvar x lags array of rf VAR coefficients.
  ### smat:           nshock x nvar matrix of initial shock vectors.  To produce "orthogonalized
  ###                 impulse responses" it should have the property that crossprod(t(smat))=sigma,
  ###                 where sigma is the Var(u(t)) matrix and u(t) is the rf residual vector.  One
  ###                 way to get such a smat is to set smat=t(chol(sigma)).  To get the smat
  ###                 corresponding to a different ordering, use
  ###                 smat = t(chol(P %*% Sigma %*% t(P)) %*% P), where P is a permutation matrix.
  ###                 To get impulse responses for a structural VAR in the form A(L)y=eps, with
  ###                 Var(eps)=I, use B(L)=-A_0^(-1)A_+(L) (where A_+ is the coefficients on strictly
  ###                 positive powers of L in A), smat=A_0^(-1).
  ###                 In general, though, it is not required that smat be invertible.
### response:       nvar x nshocks x nstep array of impulse responses.
###
### Code written by Christopher Sims, based on 6/03 matlab code.  This version 3/27/04.
### Added dimension labeling, 8/02/04.
{
  ##-----debug--------
  ##browser()
  ##------------------
  neq <- dim(B)[1]
  nvar <- dim(B)[2]
  lags <- dim(B)[3]
  dimnB <- dimnames(B)
  if(dim(smat)[2] != dim(B)[2]) stop("B and smat conflict on # of variables")
  response <- array(0,dim=c(neq,nvar,nstep+lags-1));
  response[ , , lags] <- smat
  response <- aperm(response, c(1,3,2))
  irhs <- 1:(lags*nvar)
  ilhs <- lags * nvar + (1:nvar)
  response <- matrix(response, ncol=neq)
  B <- B[, , seq(from=lags, to=1, by=-1)]  #reverse time index to allow matrix mult instead of loop
  B <- matrix(B,nrow=nvar)
  for (it in 1:(nstep-1)) {
    if (time){
      if (it==8){
        B <- B1[, , seq(from=lags, to=1, by=-1)]  #reverse time index to allow matrix mult instead of loop
        B <- matrix(B1,nrow=nvar)
      }
    }
    #browser()
    response[ilhs, ] <- B %*% response[irhs, ]
    irhs <- irhs + nvar
    ilhs <- ilhs + nvar
  }
  ## for (it in 2:nstep)
  ##       {
  ##         for (ilag in 1:min(lags,it-1))
  ##           response[,,it] <- response[,,it]+B[,,ilag] %*% response[,,it-ilag]
  ##       }
  dim(response) <- c(nvar, nstep + lags - 1, nvar)
  response <- aperm(response[ , -(1:(lags-1)), ], c(1, 3, 2)) #drop the zero initial conditions; array in usual format
  dimnames(response) <- list(dimnB[[1]], dimnames(smat)[[2]], NULL)
  ## dimnames(response)[2] <- dimnames(smat)[1]
  ## dimnames(response)[1] <- dimnames(B)[2]
  return(response)
}

