 #---------------------------------------------------Data Settings---------------------------------
 extract <- function(data,k){
   t <- nrow(data);n <- ncol(data)
   xx <- crossprod(data)
   eigs <- eigen(xx)
   evec <- eigs$vectors;eval <- eigs$values
   
   lam <- sqrt(n)*evec[,1:k]
   fac <- data%*%lam/n
   
   return(list(fac,lam))
 }
 
 
optim.func <- function(Yraw = Yraw, p = p, cons = cons, optim.setup = optim.setup, prior.list = prior.list)
{
  
   ML.prior <- prior.list$ML.prior
   theta.prior <- ML.prior$theta.prior
   w.1.prior <- ML.prior$w.1.prior
   w.2.prior <- ML.prior$w.2.prior
   
   grid.list <- prior.list$grid.list
   theta.grid <- grid.list$theta.grid
   w.1.grid <- grid.list$w.1.grid
   w.2.grid <- grid.list$w.2.grid
   hyperpara.grid <- expand.grid(theta.grid, w.1.grid, w.2.grid)
   colnames(hyperpara.grid) <- c("shrink.1", "w.1", "w.2")
   hyperpara.grid$ML_pr <- NA
   hyperpara.grid$ML_wopr <- NA

   optim.out <- optim.setup$optim.out 
   prior <- optim.setup$prior.on
   var.set <- optim.setup$var.set

   if(cons){
    X <- cbind(mlag(Yraw,p),1)
    Xfull <- cbind(mlag(Yraw,p),1)
   }else{
    X <- mlag(Yraw,p)
    Xfull <- mlag(Yraw,p)
  }
  
  Y <- Yraw[(p+1):nrow(Yraw),]
  X <- X[(p+1):nrow(X),]
  
  T <- nrow(X)
  K <- ncol(X)
  M <- ncol(Y)
  n <- K*M
  v <- (M*(M-1))/2

  if(trans == "I1"){
  prmean <- rep(1,M)
  }else{
  prmean <- rep(0, M)  
  }
  
  
  n0 <- M + 2 
  
  #Start constructing a VAR prior
  #Step A: Run a set of AR(p) models
  mysigma <- matrix(NA,M,1)
  for (ii in 1:M){
    Y.i <- Yraw[,ii,drop=F]
    X.i <- mlag(Yraw[,ii],p)
    Y.i <- Y.i[(p+1):nrow(Y.i),,drop=F]
    X.i <- X.i[(p+1):nrow(X.i),,drop=F]
    
    rho.i <- ginv(crossprod(X.i))%*%crossprod(X.i,Y.i)
    er.i <- Y.i-X.i%*%rho.i
    SSE.i <- crossprod(er.i)/(nrow(X.i)-p)
    
    #  tmpar <- arima(Y[,ii],order=c(1,0,0),method="ML")
    mysigma[ii,1] <- sqrt(SSE.i)#sqrt(tmpar$sigma2)
  }    
  
#---------------------------------- Optimize with MSE -----------------------  
# optimise S&Z hyperparameter
for(ii in 1:nrow(hyperpara.grid)){
      hyperpara.opt <- hyperpara.grid[ii,]
      ML.wo.pr <- objective.func(dummy.type = dummy.type, hyperpara.opt = hyperpara.opt, prior = TRUE, ML.pr = ML.prior, Y = Y, X = X,  X.in = Yraw[1:p,,drop=F], delta = prmean, mysigma = mysigma, M = M, K =K, T=T, p = p)
      ML.pr <- objective.func(dummy.type = dummy.type, hyperpara.opt = hyperpara.opt, prior = FALSE, ML.prior = ML.prior, Y = Y, X = X,  X.in = Yraw[1:p,,drop=F], delta = prmean, mysigma = mysigma, M = M, K =K, T=T, p = p)
      
      hyperpara.grid[ii,"ML_pr"] <- ML.pr
      hyperpara.grid[ii,"ML_wopr"] <- ML.wo.pr
      
}

return(list(hyperpara.grid = hyperpara.grid, ML.prior = ML.prior))
}
  

### Auxilliary functions for optimizing
gammacoef <- function(mode, sd){
  k.shape <- (2+mode^2/sd^2+sqrt((4+mode^2/sd^2)*mode^2/sd^2))/2
  theta.scale <- sqrt(sd^2/k.shape)
  return(data.frame(shape = k.shape, scale = theta.scale))
}


mlag <- function(X,lag){
  p <- lag
  X <- as.matrix(X)
  Traw <- nrow(X)
  N <- ncol(X)
  Xlag <- matrix(0,Traw,p*N)
  for (ii in 1:p){
    Xlag[(p+1):Traw,(N*(ii-1)+1):(N*ii)]=X[(p+1-ii):(Traw-ii),(1:N)]
  }
  return(Xlag)
}

get.dum.sur <- function(w.2,X.in,p){
  #X.in <- Xraw[1:p,,drop=F]
  if (nrow(X.in)==1) y.star <- t(t(X.in)/w.2) else y.star <- (t(apply(X.in,2,mean))/w.2)
  X.dum <- cbind(do.call(cbind, replicate(p, y.star, simplify=FALSE)),1/w.2)
  
  return(list(Ydum=y.star, Xdum=X.dum))
}

get.dum.soc <- function(w.1,X.in,p){
  
  if (nrow(X.in)==1) y.star <- diag(as.numeric(X.in)/w.1) else y.star <- diag(apply(X.in,2,mean)/w.1)
  X.dum <- cbind(do.call(cbind, replicate(p, y.star, simplify=FALSE)),0)
  
  return(list(Ydum=y.star, Xdum=X.dum))
}

get.dum.min <- function(theta,gamma.prior,delta,mysigma,M,p){
  #-----------
  ydummy <- matrix(0,2*M+M*(p-1)+1,M)
  xdummy <- matrix(0,2*M+M*(p-1)+1,M*p+1)
  
  ydummy[1:M,] <- diag((as.numeric(mysigma)*delta)/theta)
  ydummy[(M*(p-1)+M+1):(M*(p-1)+2*M),] <- diag(as.numeric(mysigma))
  
  jp <- diag(1:p)
  xdummy[1:(M*p),1:(M*p)] <- kronecker(jp,diag(as.numeric(mysigma)))/theta
  xdummy[nrow(xdummy),ncol(xdummy)] <- gamma.prior
  return(list(Ydum=ydummy, Xdum=xdummy))
}


# Marginal likelihood (simplyfied: without constant terms)
get_ML <- function(X = X, Y = Y, Xdum = Xdum, Ydum = Ydum,T,M,p, sparse, lambda){
  X_ML <- rbind(X,Xdum)
  Y_ML <- rbind(Y,Ydum)
  
  #v_prior <- nrow(Ydum)
  v_prior <- M+2
  
  V_prior <- try(solve(crossprod(Xdum)),silent=TRUE)
  if (is(V_prior,"try-error")) V_prior <- MASS::ginv(crossprod(Xdum))
  V_post <- solve(crossprod(X_ML))
  A_post <- V_post%*%t(X_ML)%*%Y_ML
  
  S_post <- crossprod(Y_ML-X_ML%*%A_post) 
  
  S.det <- as.numeric(determinant(S_post, logarithm = TRUE)[[1]])
  X.det <- as.numeric(determinant(crossprod(X_ML), logrithm = TRUE)[[1]])
  V.det <- as.numeric(determinant(V_prior, logrithm = TRUE)[[1]])
  
  
  ml <- -M/2 * (V.det + X.det) + (-(T+v_prior-1)/2)*S.det
  
  if (is.infinite(ml)) ml <- -10^10
  return(ml)
}


get_ML_stable <- function(X = X, Y = Y, Xdum = Xdum, Ydum = Ydum,T,M,p){
  X_ML <- rbind(X,Xdum)
  Y_ML <- rbind(Y,Ydum)
  
  v_prior <- nrow(Ydum)
  
  V_prior <- solve(crossprod(Xdum))
  V_post <- solve(crossprod(X_ML))
  A_post <- V_post%*%t(X_ML)%*%Y_ML
  
  S_post <- crossprod(Y_ML-X_ML%*%A_post)  
  
  S.diag <- 2*sum(log(diag(chol(S_post))))
  X.diag <- 2*sum(log(diag(chol(crossprod(X_ML)))))
  V.diag <- 2*sum(log(diag(chol(V_prior))))
  
  ml <- -M/2 * (V.diag+X.diag)+(-(T+v_prior)/2)*S.diag
  
  return(ml)
}

objective.func <- function(dummy.type = dummy.type, hyperpara.opt = hyperpara.opt, prior = TRUE, ML.prior = ML.prior, Y = Y, X = X,  X.in = Xraw[1:p,,drop=F], delta = prmean, mysigma = mysigma, M = M, K =K, T=T, p = p)
{
  theta.prior <- ML.prior[["theta.prior"]]
  w.1.prior <- ML.prior[["w.1.prior"]]
  w.2.prior <- ML.prior[["w.2.prior"]]
  gamma.prior <- ML.prior[["gamma.prior"]]
  if(dummy.type == "MIN"){# only Minnesota
    theta <- hyperpara.opt[["shrink.1"]]
    
    min.dum <- get.dum.min(theta = theta,gamma.prior = gamma.prior,delta = delta,mysigma = mysigma,M = M,p = p)
    X.dum <- rbind(min.dum[["Xdum"]])
    Y.dum <-rbind(min.dum[["Ydum"]])
    
  }else{
    if(dummy.type == "MIN-SOC-SUR"){#Minnesota - SOC - SUR
      theta <-  hyperpara.opt[["shrink.1"]]
      w.1 <-  hyperpara.opt[["w.1"]]
      w.2 <-  hyperpara.opt[["w.2"]]
      
      min.dum <- get.dum.min(theta = theta,gamma.prior = gamma.prior,delta = delta,mysigma = mysigma,M = M,p = p)
      soc.dum <- get.dum.soc(w.1 = w.1,X.in = X.in,p = p)
      sur.dum <- get.dum.sur(w.2 = w.2,X.in = X.in,p = p)
      X.dum <- rbind(min.dum[["Xdum"]], soc.dum[["Xdum"]], sur.dum[["Xdum"]])
      Y.dum <-rbind(min.dum[["Ydum"]], soc.dum[["Ydum"]], sur.dum[["Ydum"]])
    }
  }
  
  ml<- get_ML(X = X, Y = Y, Xdum = X.dum, Ydum = Y.dum, T,M,p)
  
  if(prior)
  {
    
    if(dummy.type == "MIN-SOC-SUR"){
      pr <- dgamma(theta, shape = theta.prior[,1], scale = theta.prior[,2], log = TRUE) + dgamma(w.1, shape = w.1.prior[,1], scale = w.1.prior[,2], log = TRUE) + dgamma(w.2, shape = w.2.prior[,1], scale = w.2.prior[,2], log = TRUE)  
    }else{
      if(dummy.type == "MIN"){
        pr <- dgamma(theta, shape = theta.prior[,1], scale = theta.prior[,2], log = TRUE)
      }
    }
    
  }else
  {
    pr <- 0
  }  
  post <- ml+pr
  
  if (!is.finite(post)) post <- 10^10
  return(post)
}

