
sim.VAR <- function(N=10, T=100, p = p,sparse=0.9,scale.a.mat= 0.1^2, scale.v.mat =  0.1^2,persistence=0.6, seed){

T <- T + p
K <- N*p
k <- N*K

seed <- as.numeric(seed)  
  
set.seed(round(seed))

Y.true <- matrix(0, T, N)
Y.true[1:p,] <- rnorm(N*p,0, sqrt(scale.v.mat))

eig.re <- eig.im <- 1 

# Coefficients
constant <- rnorm(N,0,0.1)
while(eig.re > 0.9 || eig.im > 0.6) # Stability check
{  

A.mat <- matrix(rnorm(k),K,N)
# Sparsification 
ind.main <- c(which(A.mat== diag(A.mat[1:N,1:N])), which(A.mat== diag(A.mat[(N+1):(2*N),])))
ind.main <- c(which(A.mat== diag(A.mat[1:N,1:N])))
n.zero.c <- round(sparse*k)
zero.c <- matrix(1, k, 1)
zero.set <- setdiff(1:k,ind.main)
ind.zero.c <- try(sample(zero.set, n.zero.c))
if(is(ind.zero.c, "try-error")){ind.zero.c <- zero.set}
zero.c[ind.zero.c] <- 0
zero.mat <- matrix(zero.c, K, N)

for(ii in 1:p){
  A.mat[((ii-1)*N+1):((ii)*N),] <- matrix(rnorm(N^2, 0, sqrt(scale.a.mat)/ii^2), N, N)*zero.mat[((ii-1)*N+1):((ii)*N),]
}

diag(A.mat[1:N,1:N]) <- diag(A.mat[1:N,1:N]) + persistence                                        
#diag(A.mat[(N+1):(2*N),1:N]) <- (-1)*abs(diag(A.mat[(N+1):(2*N),1:N]))


MM <- rbind(t(A.mat),cbind(diag((p-1)*N), matrix(0,(p-1)*N,N)))


eig.re <- max(Re(eigen(MM)$values))
eig.im <- max(Im(eigen(MM)$values))
print(paste0("RE ", round(eig.re,3), " --- IM ", round(eig.im, 3)))

}

# Covs 
n.zero.v <- round(sparse*(N*(N-1)/2))
zero.v <- matrix(1, (N*(N-1)/2), 1)
ind.zero.v <- sample(1:(N*(N-1)/2), n.zero.v)
zero.v[ind.zero.v] <- 0
Sig.low <- matrix(0,N,N)
diag(Sig.low) <- sqrt(scale.v.mat)
Sig.low[lower.tri(Sig.low, diag = FALSE)] <- rnorm((N*(N-1)/2), 0, sqrt(scale.a.mat))*zero.v

Sig <- Sig.low%*%t(Sig.low)


for (tt in (p+1):T){
  Xlag <- matrix(0,1,p*N)
  Xlag[] <- as.vector(t(Y.true[(tt-1):(tt-p),]))
  Y.true[tt,] <- constant+ as.numeric(Xlag%*%A.mat) +Sig.low%*%rnorm(N,0,1)
}

A.mat <- rbind(A.mat, constant)
matplot(abs(A.mat), type = "l")
return(list(Y=Y.true,A=A.mat,Sig=Sig, eigen = c(eig.re, eig.im)))
}
