rm(list = ls())
w.dir <- ""

###----------------------------------- Packages and functions ---------------------------
library(mvtnorm)
library(MASS)
library(glasso)

source(paste0(w.dir, "xx_post.func.R")) #EX-POST parsification and forecasting function

###----------------------------------- Preliminaries ---------------------------
trans <- "I0"
application <- "US" #US, simulation
data.freq <- "Q"
type.conj <- c("MIN") #"MIN" versus "MIN-SOC-SUR"
end.in <- seq(1988, 2018.75,1/4)
type.shrink <- c("SSVS")
hyperXL.grid <- c(0.025, 0.05, 0.075)
var_set <- c("small", "PCA-3", "medium")
var_set.shrink <- c("small", "PCA-3", "medium")
sv <- "no.sv"
p <- 5
fhorz <- 8

# SAVS settings (penalty is given by lambda_i/abs(beta_i)^kappa_i

# Penalty in the numerator (linear term)
lambda <- c(0.01, 0.1, 0.5, 1) 
lambda.pen <- 2 #1 no increasing penalty for more distant lags
# Penalty in the denominator (non-linear term)
kappa <- 2
kappa.pen <- 0.5 #0.5 no lagwise penality for kappa

wo1own <- TRUE # do not sparsify 1st own lag
cov.sparse <- TRUE #sparsify covariances
cov.glasso <- TRUE

##################################### BEGIN GRID #######################################
if(application == "simulation"){
  T.grid <- c(80,240) #Values for T
  M.grid <- c(3,10,30) #Values for m
  sparse.grid <- c(0.1,0.4,0.6,0.9) #degree of sparsity
  scale.v.mat.grid <- 0.5 #structural shocks
  set.seed(571)
  seed.grid <- sample(1:50000, 150, replace = FALSE)
  
  grid.conj <- expand.grid(end.in = T.grid, var_set = M.grid, sparse = sparse.grid, scale.v.mat = scale.v.mat.grid, seed = seed.grid,  type = type.conj ,hyperpara.type = "fix", sv = sv, kappa = kappa, lambda = lambda, lambda.pen = lambda.pen, kappa.pen = kappa.pen, eval.loss = FALSE, stringsAsFactors = FALSE)
  
  grid.conj.loss <- expand.grid(end.in = T.grid, var_set = M.grid, sparse = sparse.grid, scale.v.mat = scale.v.mat.grid, seed = seed.grid,  type = type.conj ,hyperpara.type = "fix", sv = sv, kappa = 2, lambda = 1, lambda.pen = lambda.pen, kappa.pen = kappa.pen, eval.loss = TRUE, stringsAsFactors = FALSE)

  grid.shrink <- expand.grid(end.in = T.grid, var_set = M.grid, sparse = sparse.grid, scale.v.mat = scale.v.mat.grid, seed = seed.grid, type = type.shrink, hyperpara.type = "w_o", sv = sv, kappa = 2, lambda = 1, lambda.pen = lambda.pen, kappa.pen = kappa.pen, eval.loss = FALSE, stringsAsFactors = FALSE)
  
  grid <- rbind(grid.conj, grid.shrink, grid.conj.loss)
}else{
  # Small model set
  grid.conj <- expand.grid(end.in = end.in, var_set = var_set, type = type.conj, hyperpara.type = "ML", sv = sv, kappa = kappa, lambda = lambda, lambda.pen = lambda.pen, kappa.pen = kappa.pen, stringsAsFactors = FALSE)
  grid.conjXL <- expand.grid(end.in = end.in, var_set = "xlarge", type = type.conj, hyperpara.type = hyperXL.grid, sv = sv, kappa = kappa, lambda = lambda, lambda.pen = lambda.pen, kappa.pen = kappa.pen, stringsAsFactors = FALSE)
  grid.shrink <- expand.grid(end.in = end.in, var_set = var_set.shrink, type = type.shrink, hyperpara.type = "w_o", sv = sv, kappa = 2, lambda = 1, lambda.pen = lambda.pen, kappa.pen = kappa.pen, stringsAsFactors = FALSE)
  
  grid <-  rbind(grid.conj, grid.conjXL, grid.shrink)
  
}
##################################### END GRID #######################################

for(run in 1:nrow(grid)){
###----------------------------------------- Specifications --------------------------
type <- grid[run, "type"]
var.set <- grid[run,"var_set"]
end.in <- grid[run,"end.in"]
sv <- grid[run, "sv"]
hyperpara.type <- grid[run, "hyperpara.type"]

# SAVS versus more iteration only for lambda = 1; kappa = 2
if(application == "simulation"){
  eval.loss <- grid[run, "eval.loss"] # eval.loss only lambda = 1; kappa = 2 (Bhattacharya et al., 2018)
  loss.iter <- 5
}else{
  eval.loss <- FALSE
  loss.iter <- 1
}


###----------------------------------------- Sparsification set-up --------------------
#if lagwise: : do sparsify 1st-lag with lambda.1st; start with second lag and lambda and increase penalty with lambda.pen
#if lagwise_wo1: do not sparsify 1st-lag completely; start with second lag and lambda and increase penalty with lambda.p.pen
#if lagwise_wo1own: : do not sparsify 1st-lag OWN lag, all others with lambda.1st; start with second lag and lambda and increase penalty with lambda.p.pen

kappa <- grid[run, "kappa"]
lambda <- grid[run, "lambda"] #lambda for the 1st-lag
sparse.values <- c(kappa, lambda)
names(sparse.values) <- c("kappa", "lambda") 

lambda.pen <- grid[run, "lambda.pen"] #1 no increasing penalty for more distant lags
kappa.pen <- grid[run, "kappa.pen"] #0.5 no pen for kappa
sparse.pen <- c(kappa.pen, lambda.pen)
names(sparse.pen) <- c("kappa", "lambda")

sparsify.setup <- list(wo1own = wo1own, sparse.values = sparse.values, sparse.pen = sparse.pen, cov.sparse = cov.sparse, cov.glasso = cov.glasso, loss.iter = loss.iter, eval.loss = eval.loss)

###------------------------------- Load Conjugate VAR specification ------------------------- 
if(application == "simulation"){
  if(var.set == 3) hyperpara.type <- 0.4
  if(var.set == 7) hyperpara.type <- 0.2
  if(var.set == 30) hyperpara.type <- 0.1
  
  scale.v.mat <- grid[run, "scale.v.mat"]
  sparse.deg <- grid[run,"sparse"]
  persistence <- 0.2
  seed <- grid[run, "seed"]
  var.set <- paste0(seed, "-", var.set, "-", scale.v.mat, "-", sparse.deg)
  forc.var <- paste0("Var", 1:3)

}else{
  output.var <- "GDPC1"
  inf.var <- "CPIAUCSL"
  forc.var <- c(output.var, inf.var,  "FEDFUNDS")
}

dir <- paste0(w.dir, application, "_", trans)
dir.create(dir, showWarnings = FALSE)  
foldername <- paste0(dir, "/", "FORC", "_", var.set, "_", sv, "_", type, "_", "hyperpara-", hyperpara.type, "_", "p", p, "_", end.in,  ".rda")
load(foldername)

if(application == "simulation_I0"){
  Y.out <- matrix(NA, length(forc.var), fhorz)
  rownames(Y.out) <- forc.var
  coeff.list$Y.out <- Y.out
}else{
  coeff.list$Y.out <- coeff.list$Y.out[forc.var,]
}

###----------------------------------------- Forecast set-up -------------------------
forecast.setup <- list(fhorz = fhorz, forc.var = forc.var, end.in = end.in)

###----------------------------------------- SAVS and predictions -------------------------
post.obj <- post.func(coeff.list = coeff.list, trans = trans, sparsify.setup = sparsify.setup)

foldername2 <- paste0(dir, "/", "SPS", "_", var.set, "_", sv, "_", type, "_", "hyperpara-", hyperpara.type, "_", "wo1own", "_", wo1own, "-", "values", paste0(sparse.values, collapse = "-"), "-", "pen", paste0(sparse.pen, collapse = "-"), "-", cov.sparse, "_", cov.glasso, "_", eval.loss, "_", "p", p, "_", end.in,  ".rda")

list2env(x = post.obj, envir = .GlobalEnv)

if(application == "simulation"){
  save(file = foldername2, list = c("coeff.list", "coeff.sps.list", "coeff.sps.exp.list", "var.sim", "seed"))
}else{
  save(file = foldername2, list = "post.obj") 
}
}