rm(list = ls())
w.dir <- ""

###----------------------------------- Packages and functions ---------------------------
require(GIGrvg)
require(Matrix)
require(stochvol)
library(MASS)
library(mvtnorm)

source(paste0(w.dir, "xx_VAR.func.R")) # Estimation functions
source(paste0(w.dir, "xx_data.sim.script.R")) # Data script for simulation study

###----------------------------------- Preliminaries ---------------------------
check.exist <- FALSE
trans <- "I0"
application <- "US" #US, simulation
data.freq <- "Q"
type.conj <- c("MIN") #"MIN" versus "MIN-SOC-SUR"
end.in <- seq(1988, 2018.75,1/4)
type.shrink <- c("SSVS")
hyperXL.grid <- c(0.025, 0.05, 0.075)
var_set <- c("small", "PCA-3", "medium")
var_set.shrink <- c("small", "PCA-3", "medium")
sv <- c("no.sv")
p <- 5
fhorz <- 8
nsave <- 1000
nburn <- 500

##################################### BEGIN GRID #######################################
if(application == "simulation"){
    T.grid <- c(80,240) #Values for T
    M.grid <- c(3,10,30) #Values for m
    sparse.grid <- c(0.1,0.4,0.6,0.9) #degree of sparsity
    scale.v.mat.grid <- 0.5 #structural shocks
    set.seed(571)
    seed.grid <- sample(1:50000, 150, replace = FALSE)
    
    grid.conj <- expand.grid(end.in = T.grid, var_set = M.grid, sparse = sparse.grid, scale.v.mat = scale.v.mat.grid, seed = seed.grid,  type = type.conj ,hyperpara.type = "fix", sv = sv, stringsAsFactors = FALSE)
    grid.shrink <- expand.grid(end.in = T.grid, var_set = M.grid, sparse = sparse.grid, scale.v.mat = scale.v.mat.grid, seed = seed.grid, type = type.shrink, hyperpara.type = "w_o", sv = sv, stringsAsFactors = FALSE)
    
    grid <- rbind(grid.conj, grid.shrink)
    
}else{
  grid.conj <- expand.grid(end.in = end.in, var_set = var_set, type = type.conj, hyperpara.type = "ML", sv = sv, stringsAsFactors = FALSE)
  grid.conjXL <- expand.grid(end.in = end.in, var_set = "xlarge", type = type.conj, hyperpara.type = hyperXL.grid, sv = sv, stringsAsFactors = FALSE)
  grid.shrink <- expand.grid(end.in = end.in, var_set = var_set.shrink, type = type.shrink, hyperpara.type = "w_o", sv = sv, stringsAsFactors = FALSE)
  grid <-  rbind(grid.conj, grid.shrink, grid.conjXL)
 
}
##################################### END GRID #######################################

for(run in 1:nrow(grid)){
###----------------------------------------- Specifications --------------------------
type <- grid[run, "type"]
var.set <- grid[run,"var_set"]
end.in <- grid[run,"end.in"]
sv <- grid[run, "sv"]
hyperpara.type <- grid[run, "hyperpara.type"]

if(sv == "no.sv") nthin <- 1 else nthin <- 10
if(type %in% c("SSVS", "NG")) nthin <- 5

if(application == "simulation"){
  if(var.set > 19){
    scale.a.mat <- 0.1^2
  }else if(var.set > 9){
    scale.a.mat <- 0.2^2
  }else{
    scale.a.mat <- 0.3^2
  }
  
  scale.v.mat <- grid[run, "scale.v.mat"]
  
  if(var.set == 3) hyperpara.type <- 0.5
  if(var.set == 10) hyperpara.type <- 0.25
  if(var.set == 30) hyperpara.type <- 0.1
  
  sparse.deg <- grid[run,"sparse"]
  persistence <- 0.2
  seed <- grid[run, "seed"]
  
  var.sim <- sim.VAR(N=var.set, T=end.in, p = p, sparse=sparse.deg,scale.a.mat=scale.a.mat, scale.v.mat = scale.v.mat, persistence=persistence, seed = seed)
  print(var.sim$eigen) 
  Yraw <- var.sim$Y
  colnames(Yraw) <- paste0("Var", 1:var.set)
  Y.out <- matrix(NA, 3, fhorz)
  rownames(Y.out) <- forc.var <- paste0("Var", 1:3)
  
  var.set <- paste0(seed, "-", var.set, "-", scale.v.mat, "-", sparse.deg)
  
}else{
  output.var <- c("GDPC1")
  inf.var <- c("CPIAUCSL")
  forc.var <- c(output.var, inf.var,  "FEDFUNDS")

  load(paste0(w.dir, "FREDdata/Xraw_Q.rda"))
  if(trans == "I0") Yraw <- Xraw.stat else if(trans == "I1") Yraw <- Xraw.int
    
  if(var.set == "small")  Yraw <- Yraw[,forc.var]
  if(var.set == "medium") Yraw <- Yraw[,variables.medium]
  
  Y.out <- t(window(Yraw, start = end.in+1/4, end = end.in+ fhorz/4, extend = TRUE))
  Y.out <- Y.out[forc.var,]
  
  Yraw <- window(Yraw, end = end.in)
  var.names <- colnames(Yraw)
  
  mean.in <- apply(Yraw, 2, mean)
  sd.in <- apply(Yraw, 2, sd)
  Yraw <- apply(Yraw, 2, function(x)(x-mean(x))/sd(x))
  
  for(xx in 1:nrow(Y.out)){Y.out[xx,] <- (Y.out[xx,] - mean.in[[xx]])/sd.in[[xx]]}
  
  if(substr(var.set,1,3) == "PCA"){
    
    #Yfac <- Yraw[,-which(colnames(Yraw) %in% unique(c(irf.var, forc.var)))]
    Yfac <- Yraw[,-which(colnames(Yraw) %in% forc.var)]
    nfac <- as.numeric(substr(var.set, 5,5))
    Yfac <- extract(data = Yfac, k = nfac)[[1]]
    Yfac <- apply(Yfac, 2, function(x){(x-mean(x))/sd(x)})
    
    Yraw <- cbind(Yraw[,forc.var], Yfac)
    colnames(Yraw) <-  c(forc.var, paste0("fac", "", (1:nfac)))
  } 
  
}

matplot(Yraw, type = "l")
cons <- TRUE
OLS <- (type == "OLS")

dir <- paste0(w.dir, application, "_", trans)
dir.create(dir, showWarnings = FALSE)  


###----------------------------------------- Specify/Load hyperparameters -----------------------
if(type %in% c("MIN", "MIN-SOC-SUR"))
{
if(hyperpara.type == "ML"){
  load(paste0(dir, "/", "hyperpara", "_", var.set, "_", type, "_", "p", p, "_", end.in, ".rda"))
  dummy.type <- type  
  ML.prior <- hyperpara.obj$ML.prior
  hyperpara.grid <- hyperpara.obj$hyperpara.grid
  
  hyperpara <- hyperpara.grid[which(hyperpara.grid$ML_wopr == max(hyperpara.grid$ML_wopr)),]
  hyperpara <- hyperpara[,1:3]
}else{
  hyperpara <- as.data.frame(matrix(c(as.numeric(hyperpara.type),1,1), 1, 3))
  colnames(hyperpara) <- c("shrink.1", "w.1", "w.2") 
  ML.prior <- list(theta.prior =NA, w.1.prior = NA, w.2.prior = NA)
  dummy.type <- type
}
}else{
  if(type == "RW"){
    hyperpara <- as.data.frame(matrix(1e-10, 1, 3))
    colnames(hyperpara) <- c("shrink.1", "w.1", "w.2")
    ML.prior <- list(theta.prior =NA, w.1.prior = NA, w.2.prior = NA)
    dummy.type <- "MIN"
}
}

###----------------------------------------- Estimation --------------------------

file.check <- paste0("FORC", "_", var.set, "_", sv, "_", type, "_", "hyperpara-", hyperpara.type, "_", "p", p, "_", end.in,  ".rda")
foldername <- paste0(dir, "/", "FORC", "_", var.set, "_", sv, "_", type, "_", "hyperpara-", hyperpara.type, "_", "p", p, "_", end.in,  ".rda")
#file.check <- "texttext"

if(check.exist && file.check %in% dir(dir)){
  stop("File already exists!")
}else{
  
if(type == "NG" || type == "SSVS"){
  VAR.obj <- NGSSVS.func(Yraw = Yraw, type = type, nsave =nsave, nburn = nburn, nthin = nthin, p = p, cons = cons, trans = trans)
}else{
  VAR.obj <- conjVAR.func(Yraw = Yraw, hyperpara = hyperpara, dummy.type = dummy.type, nsave =nsave, nburn = nburn, nthin = nthin, p, cons = cons, ML.prior = ML.prior, trans = trans)
}

dir.create(dir, showWarnings = FALSE)  
list2env(x = VAR.obj, envir = .GlobalEnv)

if(application == "simulation"){
  save(file = foldername, list = c("coeff.list", "var.sim")) 
}else{
  save(file = foldername, list = c("coeff.list", "mean.in", "sd.in")) 
}

}

}

