hessb <- function(f, xx, ep = 0.0001, ...)
{ 
  
  eps <- ep * xx
  n <- length(xx)
  m <- matrix(0., ncol = n, nrow = n)
  for(i in 1.:n) {
    for(j in 1.:n) {
      x1 <- xx
      x1[i] <- x1[i] + eps[i]
      x1[j] <- x1[j] + eps[j]
      x2 <- xx
      x2[i] <- x2[i] + eps[i]
      x2[j] <- x2[j] - eps[j]
      x3 <- xx
      x3[i] <- x3[i] - eps[i]
      x3[j] <- x3[j] + eps[j]
      x4 <- xx
      x4[i] <- x4[i] - eps[i]
      x4[j] <- x4[j] - eps[j]
      m[i, j] <- (f(x1, ...) - f(x2, ...) - f(x3, ...) + f(
        x4, ...))/(4. * eps[i] * eps[j])
    }
  }
  m
}


#-------------------------------------------------------------------------------

PP<-  function (values, p){
threshold<-quantile(values,p)
n <- length(values)

starttime <- 0
alltimes<-c(1:n)
times <- alltimes[values> threshold]
timesT <-c(times,n)
durations<-diff(c(0,times))
durations<-durations[durations>0]
endtime<-times[length(times)]
durationsT<-diff(c(0,timesT))
durationsT<-durationsT[durationsT>0]
marks <- values[values > threshold] - threshold
marksT<-c(marks,0)
 out <- list(times = times, marks = marks, durations=durations,starttime = starttime,
        endtime = endtime, threshold = threshold,values=values,marksT=marksT,timesT=timesT,durationsT=durationsT)
    oldClass(out) <- c("MPP")
    out
}
#-------------------------------------------------------------------------------


 hgb2<-function(x, shape1, scale, shape2, shape3) {

 dgb2(x, shape1, scale, shape2, shape3)/(1-pgb2(x, shape1, scale, shape2, shape3))
 }

 Hgb2<-function(x, shape1, scale, shape2, shape3) {

-log(1-pgb2(x, shape1, scale, shape2, shape3))
 }
 #------------------------------------------------------------------------------


 dGPD<-function (x, xi, beta = 1, logvalue = FALSE)
{

    xx <- x/beta
    if (xi == 0)
        out <- log(dexp(xx)) - log(beta)
    else {
        out <- rep(-Inf, length(x))
        cond <- (xx > 0)
        if (xi < 0) cond <- cond & (xx < 1/abs(xi))
        out[cond] <- (-1/xi - 1) * log(1 + xi * xx[cond]) - log(beta)
    }
    if (!(logvalue))
        out <- exp(out)
    out
}
#-------------------------------------------------------------------------------

DQVaR.test<-function(hit,VaR){
hit<-c(0,hit)
tt<-length(hit)
m_tt<-tt-1
hit1 <- hit[1:m_tt]
hit2 <- hit[2:tt]
var2 <- VaR[2:tt]
mylogit<- glm(hit2~hit1+var2, family=binomial(link="logit"), na.action=na.pass)
logLik(mylogit)
alpha <- -log(length(hit)/sum(hit)-1)
loglik1 <- -sum(1-hit2)*alpha-(tt-1)*log(1+exp(-alpha))
emv <- mylogit$coefficients
emv1 <- emv[1]
emv2 <- emv[2]
emv3 <- emv[3]
loglik2 <- -sum((1-hit2)*(emv1+emv2*hit1+emv3*var2))-sum(log(1+exp(-emv1-emv2*hit1-emv3*var2)))
out<- -2*(loglik1-loglik2)
#cat(out,"\n")
return(pchisq(out,2,lower.tail=F))
}

DQhit.test<-function(hit){
hit<-c(0,hit)
tt<-length(hit)
m_tt<-tt-1
hit1 <- hit[1:m_tt]
hit2 <- hit[2:tt]
#var2 <- VaR[2:tt]
mylogit<- glm(hit2~hit1, family=binomial(link="logit"), na.action=na.pass)
logLik(mylogit)
alpha <- -log(length(hit)/sum(hit)-1)
loglik1 <- -sum(1-hit2)*alpha-(tt-1)*log(1+exp(-alpha))
emv <- mylogit$coefficients
emv1 <- emv[1]
emv2 <- emv[2]

loglik2 <- -sum((1-hit2)*(emv1+emv2*hit1))-sum(log(1+exp(-emv1-emv2*hit1)))
out<- -2*(loglik1-loglik2)
return(pchisq(out,1,lower.tail=F))
}

Markov.test<-function(hit){
zz <- 0
umz <- 0
zum <- 0
umum <- 0
tt<-length(hit)
m_tt <- tt-1
for(k in 1:m_tt) {
i<-k+1
if (hit[k]==0 & hit[i]==0){
zz <- zz +1
}
else if (hit[k]==0 & hit[i]==1){
zum <- zum +1
}
else if (hit[k]==1 & hit[i]==1){
umum <- umum +1
}
else{
umz <- umz +1
}
}
p00 <- zz/(zz+zum)
p01 <- zum/(zz+zum)
p10 <- umz/(umz+umum)
p11 <- umum/(umz+umum)
llp <- (zum+umum)/(zz+umz+zum+umum)

if(sum(hit)<120){
ll2 <- ((1-llp)^(zz+umz))*(llp^(zum+umum))
ll1 <- (p00^zz)*(p01^zum)*(p10^umz)*(p11^umum)
out2<- -2*log(ll2/ll1)}

else{
ll2 <- (zz+umz)*log(1-llp)+(zum+umum)*log(llp)
ll1 <- zz*log(p00)+zum*log(p01)+umz*log(p10)+umum*log(p11)
out2<- -2*(ll2-ll1)}


(pchisq(out2,1,lower.tail=F))



}   

LRuc.test<-function(hit,p){
n<-length(hit)
T1<-sum(hit>0)
T0<-n-T1

out<--2*log((((1-p)*n/T0)**T0)*((p*n/T1)**T1))


(pchisq(out,1,lower.tail=F))

}

LRcc.test<-function(hit,p){
n<-length(hit)
T1<-sum(hit>0)
T0<-n-T1
out1<- -2*log((((1-p)*n/T0)**T0)*((p*n/T1)**T1))


zz <- 0
umz <- 0
zum <- 0
umum <- 0
tt<-length(hit)
m_tt <- tt-1
for(k in 1:m_tt) {
i<-k+1
if (hit[k]==0 & hit[i]==0){
zz <- zz +1
}
else if (hit[k]==0 & hit[i]==1){
zum <- zum +1
}
else if (hit[k]==1 & hit[i]==1){
umum <- umum +1
}
else{
umz <- umz +1
}
}
p00 <- zz/(zz+zum)
p01 <- zum/(zz+zum)
p10 <- umz/(umz+umum)
p11 <- umum/(umz+umum)
llp <- (zum+umum)/(zz+umz+zum+umum)

if(sum(hit)<120){
ll2 <- ((1-llp)^(zz+umz))*(llp^(zum+umum))
ll1 <- (p00^zz)*(p01^zum)*(p10^umz)*(p11^umum)
out2<- -2*log(ll2/ll1)}

else{
ll2 <- (zz+umz)*log(1-llp)+(zum+umum)*log(llp)
ll1 <- zz*log(p00)+zum*log(p01)+umz*log(p10)+umum*log(p11)
out2<- -2*(ll2-ll1)}

(pchisq(out1+out2,2,lower.tail=F))


}

# Test VaR

TestVaR<-function(mod){

 mod$error<-na.omit(mod$error)
 bin1<-LRuc.test(mod$error[,1],1-mod$VaRa)
 in1<-LRcc.test(mod$error[,1],1-mod$VaRa)
 Ma1<-Markov.test(mod$error[,1])
 Na1<-DQhit.test(mod$error[,1]*mod$VaRa)
 La1<-DQVaR.test(mod$error[,1]*mod$VaRa,mod$VaR[,1])
 B1<-Box.test(mod$error[,1],lag=5,type="Ljung") 

 bin2<-LRuc.test(mod$error[,2],1-mod$VaRa)
 in2<-LRcc.test(mod$error[,2],1-mod$VaRa)
 Ma2<-Markov.test(mod$error[,2])
 Na2<-DQhit.test(mod$error[,2]*mod$VaRa)
 La2<-DQVaR.test(mod$error[,2]*mod$VaRa,mod$VaR[,2])
 B2<-Box.test(mod$error[,2],lag=5,type="Ljung") 

 
  
 
  cmat<- cbind(rbind(sum(mod$error[,1]),bin1,Ma1,in1,B1$p.value,Na1,La1),
               rbind(sum(mod$error[,2]),bin2,Ma2,in2,B2$p.value,Na2,La2))
 
 colnames(cmat)<-c("Marks1","Marks2") 
 cmat<-round(cmat,2)
 rownames(cmat)<-c("failures","LRuc","LRind","LRcc","BT","QTh","QTv")
                                

 cat("________________________________________________________________________________________________________________________ ","\n")
 printCoefmat(t(cmat), digits=5)
 cat("________________________________________________________________________________________________________________________ ","\n")

 }
 
 TestVaR3<-function(mod,output=F){
  
   mod$error<-na.omit(mod$error)
 bin1<-LRuc.test(mod$error[,1],1-mod$VaRa)
 in1<-LRcc.test(mod$error[,1],1-mod$VaRa)
 Ma1<-Markov.test(mod$error[,1])
 Na1<-DQhit.test(mod$error[,1]*mod$VaRa)
 La1<-DQVaR.test(mod$error[,1]*mod$VaRa,mod$VaR[,1])
 

 bin2<-LRuc.test(mod$error[,2],1-mod$VaRa)
 in2<-LRcc.test(mod$error[,2],1-mod$VaRa)
 Ma2<-Markov.test(mod$error[,2])
 Na2<-DQhit.test(mod$error[,2]*mod$VaRa)
 La2<-DQVaR.test(mod$error[,2]*mod$VaRa,mod$VaR[,2])
 

 bin3<-LRuc.test(mod$error[,3],1-mod$VaRa)
 in3<-LRcc.test(mod$error[,3],1-mod$VaRa)
 Ma3<-Markov.test(mod$error[,3])
 Na3<-DQhit.test(mod$error[,3]*mod$VaRa)
 La3<-DQVaR.test(mod$error[,3]*mod$VaRa,mod$VaR[,3])

  
 
  cmat<- cbind(rbind(sum(mod$error[,1]),bin1,Ma1,in1,Na1,La1,mod$VES[1]),
               rbind(sum(mod$error[,2]),bin2,Ma2,in2,Na2,La2,mod$VES[2]),
               rbind(sum(mod$error[,3]),bin3,Ma3,in3,Na3,La3,mod$VES[3]))
 
 colnames(cmat)<-c("Marks1","Marks2","Marks3") 
 cmat<-round(cmat,2)
 rownames(cmat)<-c("failures","LRuc","LRind","LRcc","QTh","QTv","VES")
                                

 cat("________________________________________________________________________________________________________________________ ","\n")
 printCoefmat(t(cmat), digits=5)
 cat("________________________________________________________________________________________________________________________ ","\n")
if(output) cmat
 }
 

 
 thres<-function(dato,a,b,d,e){
 n<-length(dato)
 dato.sort<-sort(dato,decreasing = T)
 n1<-floor(a*n)
 n2<-floor(b*n)
 
 xi<-numeric(n2-n1)
 m<-matrix(0,n2-n1,n2-n1)
 betas<-seq(0.01,0.49,length=(n2-n1))
 
 for( i in n1:(n2-1)) xi[i-n1+1]<-gpd.fit(dato,dato.sort[i])$mle[2]
  
 for( j in 1:(n2-n1)) m[,j]<-(cumsum((c(1:(n2-n1))**betas[j])*abs(xi-median(xi)))/c(1:(n2-n1)))
 
 contour(c(n1:(n2-1)),betas,m,xlab=expression(k),nlevels=20,ylab=expression(beta))
 rect(d,0,e,0.5,col="grey80",border=NA)
 contour(c(n1:(n2-1)),betas,m,xlab=expression(k),nlevels=20,ylab=expression(beta),add=T)
 
 list(k=c(n1:(n2-1)),betas=betas,m=m)
 }
 
# par(mfrow=c(1,2),mar=c(4,4,2,2))
# thres(-dato,0.05,0.15,391,440)   #quantile 0.91,0.92
# thres(dato,0.05,0.15,415,464)    #quantile 0.905,0.915
# 
# 
# 
