


VARMA<-function(L1,L2,alphas,betas,n,y1,y2){

psihat1<-numeric(n+1)
psihat2<-numeric(n+1)

a11<-alphas[1,1]
a12<-alphas[1,2]
a21<-alphas[2,1]
a22<-alphas[2,2]

b11<-betas[1,1]
b12<-betas[1,2]
b21<-betas[2,1]
b22<-betas[2,2]

L1<-c(0,L1)
L2<-c(0,L2)
y1<-c(0,y1)
y2<-c(0,y2)


psihat1[1]<-0
psihat2[1]<-0

for(i in 1:n){
  e1<-(1-psihat1[i]*L1[i])*y1[i]
  e2<-(1-psihat2[i]*L2[i])*y2[i]
psihat1[i+1]<-a11*e1 + a12*e2 +   b11*psihat1[i] + b12*psihat2[i]
psihat2[i+1]<-a21*e1 + a22*e2 +   b21*psihat1[i] + b22*psihat2[i]

}
list(psihat1=psihat1[-1],psihat2=psihat2[-1])
}   

VARMA2.1<-function(L1,L2,alphas1, alphas2,betas1,n,y1,y2){
  
  psihat1<-numeric(n+2)
  psihat2<-numeric(n+2)

  
  a11<-alphas1[1,1]
  a12<-alphas1[1,2]
  a21<-alphas1[2,1]
  a22<-alphas1[2,2]

  
  A11<-alphas2[1,1]
  A12<-alphas2[1,2]
  A21<-alphas2[2,1]
  A22<-alphas2[2,2]

  
  b11<-betas1[1,1]
  b12<-betas1[1,2]
  b21<-betas1[2,1]
  b22<-betas1[2,2]

  L1<-c(0,0,L1)
  L2<-c(0,0,L2)
  y1<-c(0,0,y1)
  y2<-c(0,0,y2)
 

  e1<-rep(0,n+2)
  e2<-rep(0,n+2)
 
  
  for(i in 2:(n+1)){
    
    e1[i]<-(1-psihat1[i]*L1[i])*y1[i]
    e2[i]<-(1-psihat2[i]*L2[i])*y2[i]
    
    psihat1[i+1]<-a11*e1[i] + a12*e2[i] +  A11*e1[i-1]  + A12*e2[i-1]    +  b11*psihat1[i] + b12*psihat2[i] 
    psihat2[i+1]<-a21*e1[i] + a22*e2[i] +  A21*e1[i-1]  + A22*e2[i-1]    +  b21*psihat1[i] + b22*psihat2[i]  
   
    
    
  }
  list(psihat1=psihat1[-c(1:2)],psihat2=psihat2[-c(1:2)])
}

VARMA1.2<-function(L1,L2,alphas,betas1,betas2,n,y1,y2){
  
  psihat1<-numeric(n+2)
  psihat2<-numeric(n+2)

  
  a11<-alphas[1,1]
  a12<-alphas[1,2]
  a21<-alphas[2,1]
  a22<-alphas[2,2]
 
  b11<-betas1[1,1]
  b12<-betas1[1,2]
  b21<-betas1[2,1]
  b22<-betas1[2,2]
  
  B11<-betas2[1,1]
  B12<-betas2[1,2]
  B21<-betas2[2,1]
  B22<-betas2[2,2]
  
  L1<-c(0,0,L1)
  L2<-c(0,0,L2)
 
  y1<-c(0,0,y1)
  y2<-c(0,0,y2)
  

  e1<-numeric(n+2)
  e2<-numeric(n+2)
 
  
  for(i in 2:(n+1)){
    
    e1[i]<-(1-psihat1[i]*L1[i])*y1[i]
    e2[i]<-(1-psihat2[i]*L2[i])*y2[i]
   
    psihat1[i+1]<-a11*e1[i] + a12*e2[i] +  b11*psihat1[i] + b12*psihat2[i] +  B11*psihat1[i-1] + B12*psihat2[i-1] 
    psihat2[i+1]<-a21*e1[i] + a22*e2[i] +  b21*psihat1[i] + b22*psihat2[i] +  B21*psihat1[i-1] + B22*psihat2[i-1] 
   
    
  }
  list(psihat1=psihat1[-c(1:2)],psihat2=psihat2[-c(1:2)])
} 

VARMA3<-function(L1,L2,L3,alphas,betas,n,y1,y2,y3){

psihat1<-numeric(n+1)
psihat2<-numeric(n+1)
psihat3<-numeric(n+1)

a11<-alphas[1,1]
a12<-alphas[1,2]
a13<-alphas[1,3]
a21<-alphas[2,1]
a22<-alphas[2,2]
a23<-alphas[2,3]
a31<-alphas[3,1]
a32<-alphas[3,2]
a33<-alphas[3,3]

b11<-betas[1,1]
b12<-betas[1,2]
b13<-betas[1,3]
b21<-betas[2,1]
b22<-betas[2,2]
b23<-betas[2,3]
b31<-betas[3,1]
b32<-betas[3,2]
b33<-betas[3,3]



L1<-c(0,L1)
L2<-c(0,L2)
L3<-c(0,L3)
y1<-c(0,y1)
y2<-c(0,y2)
y3<-c(0,y3)

psihat1[1]<-0
psihat2[1]<-0
psihat3[1]<-0

for(i in 1:n){
  
  e1<-(1-psihat1[i]*L1[i])*y1[i]
  e2<-(1-psihat2[i]*L2[i])*y2[i]
  e3<-(1-psihat3[i]*L3[i])*y3[i]
  psihat1[i+1]<-a11*e1 + a12*e2 + a13*e3 +  b11*psihat1[i] + b12*psihat2[i] + b13*psihat3[i]
  psihat2[i+1]<-a21*e1 + a22*e2 + a23*e3 +  b21*psihat1[i] + b22*psihat2[i] + b23*psihat3[i]
  psihat3[i+1]<-a31*e1 + a32*e2 + a33*e3 +  b31*psihat1[i] + b32*psihat2[i] + b33*psihat3[i]
  
  
}
list(psihat1=psihat1[-1],psihat2=psihat2[-1],psihat3=psihat3[-1])
} 

VARMA3.1.2<-function(L1,L2,L3,alphas,betas1,betas2,n,y1,y2,y3){
  
  psihat1<-numeric(n+2)
  psihat2<-numeric(n+2)
  psihat3<-numeric(n+2)
  
  a11<-alphas[1,1]
  a12<-alphas[1,2]
  a13<-alphas[1,3]
  a21<-alphas[2,1]
  a22<-alphas[2,2]
  a23<-alphas[2,3]
  a31<-alphas[3,1]
  a32<-alphas[3,2]
  a33<-alphas[3,3]
  
  b11<-betas1[1,1]
  b12<-betas1[1,2]
  b13<-betas1[1,3]
  b21<-betas1[2,1]
  b22<-betas1[2,2]
  b23<-betas1[2,3]
  b31<-betas1[3,1]
  b32<-betas1[3,2]
  b33<-betas1[3,3]
  
  
  B11<-betas2[1,1]
  B12<-betas2[1,2]
  B13<-betas2[1,3]
  B21<-betas2[2,1]
  B22<-betas2[2,2]
  B23<-betas2[2,3]
  B31<-betas2[3,1]
  B32<-betas2[3,2]
  B33<-betas2[3,3]
   L1<-c(0,0,L1)
   L2<-c(0,0,L2)
   L3<-c(0,0,L3)
   y1<-c(0,0,y1)
   y2<-c(0,0,y2)
   y3<-c(0,0,y3)
  
  # psihat1[1]<-0
  # psihat2[1]<-0
  # psihat3[1]<-0
  
  e1<-numeric(n+2)
  e2<-numeric(n+2)
  e3<-numeric(n+2)
  
  for(i in 2:(n+1)){
    
    e1[i]<-(1-psihat1[i]*L1[i])*y1[i]
    e2[i]<-(1-psihat2[i]*L2[i])*y2[i]
    e3[i]<-(1-psihat3[i]*L3[i])*y3[i]
    psihat1[i+1]<-a11*e1[i] + a12*e2[i] + a13*e3[i] +  b11*psihat1[i] + b12*psihat2[i] + b13*psihat3[i] +  B11*psihat1[i-1] + B12*psihat2[i-1] + B13*psihat3[i-1]
    psihat2[i+1]<-a21*e1[i] + a22*e2[i] + a23*e3[i] +  b21*psihat1[i] + b22*psihat2[i] + b23*psihat3[i] +  B21*psihat1[i-1] + B22*psihat2[i-1] + B23*psihat3[i-1]
    psihat3[i+1]<-a31*e1[i] + a32*e2[i] + a33*e3[i] +  b31*psihat1[i] + b32*psihat2[i] + b33*psihat3[i] +  B31*psihat1[i-1] + B32*psihat2[i-1] + B33*psihat3[i-1]
    
    
  }
  list(psihat1=psihat1[-c(1:2)],psihat2=psihat2[-c(1:2)],psihat3=psihat3[-c(1:2)])
} 

VARMA3.1.3<-function(L1,L2,L3,alphas,betas1,betas2,betas3,n,y1,y2,y3){
  
  psihat1<-numeric(n+3)
  psihat2<-numeric(n+3)
  psihat3<-numeric(n+3)
  
  a11<-alphas[1,1]
  a12<-alphas[1,2]
  a13<-alphas[1,3]
  a21<-alphas[2,1]
  a22<-alphas[2,2]
  a23<-alphas[2,3]
  a31<-alphas[3,1]
  a32<-alphas[3,2]
  a33<-alphas[3,3]
  
  b11<-betas1[1,1]
  b12<-betas1[1,2]
  b13<-betas1[1,3]
  b21<-betas1[2,1]
  b22<-betas1[2,2]
  b23<-betas1[2,3]
  b31<-betas1[3,1]
  b32<-betas1[3,2]
  b33<-betas1[3,3]
  
  
  B11<-betas2[1,1]
  B12<-betas2[1,2]
  B13<-betas2[1,3]
  B21<-betas2[2,1]
  B22<-betas2[2,2]
  B23<-betas2[2,3]
  B31<-betas2[3,1]
  B32<-betas2[3,2]
  B33<-betas2[3,3]
  
  B.11<-betas3[1,1]
  B.12<-betas3[1,2]
  B.13<-betas3[1,3]
  B.21<-betas3[2,1]
  B.22<-betas3[2,2]
  B.23<-betas3[2,3]
  B.31<-betas3[3,1]
  B.32<-betas3[3,2]
  B.33<-betas3[3,3]
  
  L1<-c(0,0,0,L1)
  L2<-c(0,0,0,L2)
  L3<-c(0,0,0,L3)
  y1<-c(0,0,0,y1)
  y2<-c(0,0,0,y2)
  y3<-c(0,0,0,y3)
  
  # psihat1[1]<-0
  # psihat2[1]<-0
  # psihat3[1]<-0
  
  e1<-numeric(n+3)
  e2<-numeric(n+3)
  e3<-numeric(n+3)
  
  for(i in 3:(n+2)){
    
    e1[i]<-(1-psihat1[i]*L1[i])*y1[i]
    e2[i]<-(1-psihat2[i]*L2[i])*y2[i]
    e3[i]<-(1-psihat3[i]*L3[i])*y3[i]
    psihat1[i+1]<-a11*e1[i] + a12*e2[i] + a13*e3[i] +  b11*psihat1[i] + b12*psihat2[i] + b13*psihat3[i] +  B11*psihat1[i-1] + B12*psihat2[i-1] + B13*psihat3[i-1] +  B.11*psihat1[i-2] + B.12*psihat2[i-2] + B.13*psihat3[i-2]
    psihat2[i+1]<-a21*e1[i] + a22*e2[i] + a23*e3[i] +  b21*psihat1[i] + b22*psihat2[i] + b23*psihat3[i] +  B21*psihat1[i-1] + B22*psihat2[i-1] + B23*psihat3[i-1] +  B.21*psihat1[i-2] + B.22*psihat2[i-2] + B.23*psihat3[i-2]
    psihat3[i+1]<-a31*e1[i] + a32*e2[i] + a33*e3[i] +  b31*psihat1[i] + b32*psihat2[i] + b33*psihat3[i] +  B31*psihat1[i-1] + B32*psihat2[i-1] + B33*psihat3[i-1] +  B.31*psihat1[i-2] + B.32*psihat2[i-2] + B.33*psihat3[i-2]
    
    
  }
  list(psihat1=psihat1[-c(1:3)],psihat2=psihat2[-c(1:3)],psihat3=psihat3[-c(1:3)])
}

VARMA3.2.2<-function(L1,L2,L3,alphas1, alphas2,betas1,betas2,n,y1,y2,y3){
  
  psihat1<-numeric(n+2)
  psihat2<-numeric(n+2)
  psihat3<-numeric(n+2)
  
  a11<-alphas1[1,1]
  a12<-alphas1[1,2]
  a13<-alphas1[1,3]
  a21<-alphas1[2,1]
  a22<-alphas1[2,2]
  a23<-alphas1[2,3]
  a31<-alphas1[3,1]
  a32<-alphas1[3,2]
  a33<-alphas1[3,3]
  
  A11<-alphas2[1,1]
  A12<-alphas2[1,2]
  A13<-alphas2[1,3]
  A21<-alphas2[2,1]
  A22<-alphas2[2,2]
  A23<-alphas2[2,3]
  A31<-alphas2[3,1]
  A32<-alphas2[3,2]
  A33<-alphas2[3,3]
  
  b11<-betas1[1,1]
  b12<-betas1[1,2]
  b13<-betas1[1,3]
  b21<-betas1[2,1]
  b22<-betas1[2,2]
  b23<-betas1[2,3]
  b31<-betas1[3,1]
  b32<-betas1[3,2]
  b33<-betas1[3,3]
  
  
  B11<-betas2[1,1]
  B12<-betas2[1,2]
  B13<-betas2[1,3]
  B21<-betas2[2,1]
  B22<-betas2[2,2]
  B23<-betas2[2,3]
  B31<-betas2[3,1]
  B32<-betas2[3,2]
  B33<-betas2[3,3]
  L1<-c(0,0,L1)
  L2<-c(0,0,L2)
  L3<-c(0,0,L3)
  y1<-c(0,0,y1)
  y2<-c(0,0,y2)
  y3<-c(0,0,y3)
  
  # psihat1[1]<-0
  # psihat2[1]<-0
  # psihat3[1]<-0
  
  e1<-rep(0,n+2)
  e2<-rep(0,n+2)
  e3<-rep(0,n+2)
  
  for(i in 2:(n+1)){
    
    e1[i]<-(1-psihat1[i]*L1[i])*y1[i]
    e2[i]<-(1-psihat2[i]*L2[i])*y2[i]
    e3[i]<-(1-psihat3[i]*L3[i])*y3[i]
    psihat1[i+1]<-a11*e1[i]      + a12*e2[i]      + a13*e3[i]      +  A11*e1[i-1]       + A12*e2[i-1]      + A13*e3[i-1] +  b11*psihat1[i] + b12*psihat2[i] + b13*psihat3[i] +  B11*psihat1[i-1]  + B12*psihat2[i-1] + B13*psihat3[i-1]
    psihat2[i+1]<-a21*e1[i]      + a22*e2[i]      + a23*e3[i]      +  A21*e1[i-1]       + A22*e2[i-1]      + A23*e3[i-1] +  b21*psihat1[i] + b22*psihat2[i] + b23*psihat3[i] +  B21*psihat1[i-1]  + B22*psihat2[i-1] + B23*psihat3[i-1]
    psihat3[i+1]<-a31*e1[i]      + a32*e2[i]      + a33*e3[i]      +  A31*e1[i-1]       + A32*e2[i-1]      + A33*e3[i-1] +  b31*psihat1[i] + b32*psihat2[i] + b33*psihat3[i] +  B31*psihat1[i-1]  + B32*psihat2[i-1] + B33*psihat3[i-1]
    
    
  }
  list(psihat1=psihat1[-c(1:2)],psihat2=psihat2[-c(1:2)],psihat3=psihat3[-c(1:2)])
} 


VARMA3.2.1<-function(L1,L2,L3,alphas1, alphas2,betas1,n,y1,y2,y3){
  
  psihat1<-numeric(n+2)
  psihat2<-numeric(n+2)
  psihat3<-numeric(n+2)
  
  a11<-alphas1[1,1]
  a12<-alphas1[1,2]
  a13<-alphas1[1,3]
  a21<-alphas1[2,1]
  a22<-alphas1[2,2]
  a23<-alphas1[2,3]
  a31<-alphas1[3,1]
  a32<-alphas1[3,2]
  a33<-alphas1[3,3]
  
  A11<-alphas2[1,1]
  A12<-alphas2[1,2]
  A13<-alphas2[1,3]
  A21<-alphas2[2,1]
  A22<-alphas2[2,2]
  A23<-alphas2[2,3]
  A31<-alphas2[3,1]
  A32<-alphas2[3,2]
  A33<-alphas2[3,3]
  
  b11<-betas1[1,1]
  b12<-betas1[1,2]
  b13<-betas1[1,3]
  b21<-betas1[2,1]
  b22<-betas1[2,2]
  b23<-betas1[2,3]
  b31<-betas1[3,1]
  b32<-betas1[3,2]
  b33<-betas1[3,3]
  
  

  L1<-c(0,0,L1)
  L2<-c(0,0,L2)
  L3<-c(0,0,L3)
  y1<-c(0,0,y1)
  y2<-c(0,0,y2)
  y3<-c(0,0,y3)
  
  # psihat1[1]<-0
  # psihat2[1]<-0
  # psihat3[1]<-0
  
  e1<-rep(0,n+2)
  e2<-rep(0,n+2)
  e3<-rep(0,n+2)
  
  for(i in 2:(n+1)){
    
    e1[i]<-(1-psihat1[i]*L1[i])*y1[i]
    e2[i]<-(1-psihat2[i]*L2[i])*y2[i]
    e3[i]<-(1-psihat3[i]*L3[i])*y3[i]
    psihat1[i+1]<-a11*e1[i]      + a12*e2[i]      + a13*e3[i]      +  A11*e1[i-1]       + A12*e2[i-1]      + A13*e3[i-1]  +  b11*psihat1[i] + b12*psihat2[i] + b13*psihat3[i]
    psihat2[i+1]<-a21*e1[i]      + a22*e2[i]      + a23*e3[i]      +  A21*e1[i-1]       + A22*e2[i-1]      + A23*e3[i-1]  +  b21*psihat1[i] + b22*psihat2[i] + b23*psihat3[i] 
    psihat3[i+1]<-a31*e1[i]      + a32*e2[i]      + a33*e3[i]      +  A31*e1[i-1]       + A32*e2[i-1]      + A33*e3[i-1]  +  b31*psihat1[i] + b32*psihat2[i] + b33*psihat3[i] 
    
    
  }
  list(psihat1=psihat1[-c(1:2)],psihat2=psihat2[-c(1:2)],psihat3=psihat3[-c(1:2)])
}
#-------------------------------------------------------------------------------
bivPP<-  function (values1, p1,values2,p2){
values1<-as.numeric(values1)
values2<-as.numeric(values2)
threshold1<-quantile(values1,p1,na.rm=T)
threshold2<-quantile(values2,p2,na.rm=T)
n <- max(length(values1),length(values2))


starttime <- 0
alltimes<-c(1:n)
times1 <- alltimes[values1> threshold1]
times2 <- alltimes[values2> threshold2]
max.times<-max(times1,times2)
times1<-c(times1,max.times)
times2<-c(times2,max.times)

times1<-times1[!duplicated(times1)]
times2<-times2[!duplicated(times2)]

times<-sort(c(times1,times2))
times<-times[!duplicated(times)]

durations1<-diff(c(0,times1))
durations1<-durations1[durations1>0]

durations2<-diff(c(0,times2))
durations2<-durations2[durations2>0]

durations<-diff(c(0,times))
durations<-durations[durations>0]

endtime<-times[length(times)]


marks1 <- pmax(0,values1[times1] - threshold1)
marks2 <- pmax(0,values2[times2]- threshold2)

marks1[marks1==0]<- min(marks1[marks1!=0])
marks2[marks2==0]<- min(marks2[marks2!=0])

 mpp1 <- list(times = times1, marks = marks1,durations=durations1, threshold = threshold1,values=values1)
 mpp2 <- list(times = times2, marks = marks2, durations=durations2, threshold = threshold2,values=values2)
 biv<-list(times=times,bivdur2=real.time(durations2)[times],bivdur1=real.time(durations1)[times],starttime = starttime,
        endtime = endtime,durations=durations)

out<-list(mpp1=mpp1,mpp2=mpp2,biv=biv)

    oldClass(out) <- c("MPP")
    out
}

triPP<-  function (values1, p1,values2,p2,values3,p3){

values1<-as.numeric(values1)
values2<-as.numeric(values2)
values3<-as.numeric(values3)

threshold1<-quantile(values1,p1)
threshold2<-quantile(values2,p2)
threshold3<-quantile(values3,p3)

n <- max(length(values1),length(values2),length(values3))


starttime <- 0
alltimes<-c(1:n)
times1 <- alltimes[values1> threshold1]
times2 <- alltimes[values2> threshold2]
times3 <- alltimes[values3> threshold3]
max.times<-max(times1,times2,times3)
times1<-c(times1,max.times)
times2<-c(times2,max.times)
times3<-c(times3,max.times)

times1<-times1[!duplicated(times1)]
times2<-times2[!duplicated(times2)]
times3<-times3[!duplicated(times3)]

times<-sort(c(times1,times2,times3))
times<-times[!duplicated(times)]

durations1<-diff(c(0,times1))
durations1<-durations1[durations1>0]

durations2<-diff(c(0,times2))
durations2<-durations2[durations2>0]

durations3<-diff(c(0,times3))
durations3<-durations3[durations3>0]

durations<-diff(c(0,times))
durations<-durations[durations>0]

endtime<-times[length(times)]


marks1 <- pmax(0,values1[times1] - threshold1)
marks2 <- pmax(0,values2[times2] - threshold2)
marks3 <- pmax(0,values3[times3] - threshold3)

marks1[marks1==0]<- min(marks1[marks1!=0])
marks2[marks2==0]<- min(marks2[marks2!=0])
marks3[marks3==0]<- min(marks3[marks3!=0])

 mpp1 <- list(times = times1, marks = marks1, durations=durations1, threshold = threshold1,values=values1)
 mpp2 <- list(times = times2, marks = marks2, durations=durations2, threshold = threshold2,values=values2)
 mpp3 <- list(times = times3, marks = marks3, durations=durations3, threshold = threshold3,values=values3)
 
 tri<-list(times=times,tridur2=real.time(durations2)[times],tridur1=real.time(durations1)[times],tridur3=real.time(durations3)[times],starttime = starttime,
        endtime = endtime,durations=durations)

out<-list(mpp1=mpp1,mpp2=mpp2,mpp3=mpp3,tri=tri)

    oldClass(out) <- c("MPP")
    out
}

 real.time<-function(dur){
 m<-sum(dur)
 n<-length(dur)
 x<-numeric(m)
 y<-cumsum(dur)
 y<-c(0,y)
 for(i in 1:n) x[(y[i]+1):y[i+1]]<-c(1:dur[i])
 x
 }

 real.phi<-function(phi,dur){
 m<-sum(dur)
 n<-length(dur)
 x<-numeric(m)
 y<-cumsum(dur)
 y<-c(0,y)
 for(i in 1:n) x[(y[i]+1):y[i+1]]<-phi[i]
 x
 }
 
 quant <- function(p,mu,xi, beta,u) {
   u + (beta/xi)*((mu/(1-p))^xi -1)
 }

matriz<-function(mat) matrix(mat,ncol=2)
matriz3<-function(mat) matrix(mat,ncol=3)

#-------------------------------------------------------------------------------


ACI_times2<-function(param,mpp){


param<-matrix(param,ncol=2)

times1<-mpp$mpp1$times
times2<-mpp$mpp2$times

d1<-mpp$mpp1$durations
d2<-mpp$mpp2$durations

dur<-mpp$biv$durations
dur1<-mpp$biv$bivdur1
dur2<-mpp$biv$bivdur2





times<-mpp$biv$times


n<-length(times)


y1<-as.numeric(times%in%times1)
y2<-as.numeric(times%in%times2)

 ind1<-y1*c(1:n)
 ind2<-y2*c(1:n)

marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold

Marks1<-numeric(n)
Marks2<-numeric(n)

Marks1[ind1[ind1>0]]<-marks1
Marks2[ind2[ind2>0]]<-marks2


Lambda01<-numeric(n)
psihat1<-rep(1,n)

condInt1<-rep(NA,times[n])




Lambda02<-numeric(n)
psihat2<-rep(1,n)

condInt2<-rep(NA,times[n])


#Define Psi

alphas<-matriz(param[1:2,])
betas<-matriz(param[3:4,])
cova<-matriz(param[dim(param)[1],])

# define baselines

# 
# if(unrestricted==T){
# 
# 
# 
#   mu1<-matriz(param[5,])
#   sigma1<-matriz(param[6,])
#   Q1<-matriz((param[7,]))
#   mu2<-matriz(param[8,])
#   sigma2<-matriz(param[9,])
#   Q2<-matriz((param[10,]))
#   
# 
#   lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
#   Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
# 
#   lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])
#   Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])
# 
# 
# 
# }

#if(unrestricted==F){

  mu1<-matriz((param[5,]))
  sigma1<-matriz((param[6,]))
  Q1<-matriz((param[7,]))

  

  lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
  Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])

  lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2]) 
  Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])



#}



# random exponentials for psi
phi<-VARMA(Lambda01,Lambda02,alphas,betas,n,y1,y2)




psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)



# scale specifications

# 
# if(Grad){
#   grad1<- phi$psihat1*(1-psi1*Lambda01)[ind1]
#   grad2<- phi$psihat2*(1-psi2*Lambda02)[ind2]
#   
#   out<-cbind(grad1,grad2)
# }

#else{
  if(is.na(sum(psi1)) || abs(sum(psi1))== Inf || sum(psi1)==0
     || is.na(sum(psi2)) || abs(sum(psi2))== Inf || sum(psi2)==0) {
      out<- 1e7}
      
else {
loglik1<- sum(log(psi1*lambda01)[ind1])-sum((psi1*Lambda01)[ind1])
loglik2<- sum(log(psi2*lambda02)[ind2])-sum((psi2*Lambda02)[ind2])


out<- -(loglik1+loglik2)
#}

}

#cat(loglik,"\n")
return(out)
}
ACI_times2.1.2<-function(param,mpp){
  
  
  param<-matrix(param,ncol=2)
  
  times1<-mpp$mpp1$times
  times2<-mpp$mpp2$times
  
  d1<-mpp$mpp1$durations
  d2<-mpp$mpp2$durations
  
  dur<-mpp$biv$durations
  dur1<-mpp$biv$bivdur1
  dur2<-mpp$biv$bivdur2
  
  
  
  
  
  times<-mpp$biv$times
  
  
  n<-length(times)
  
  
  y1<-as.numeric(times%in%times1)
  y2<-as.numeric(times%in%times2)
  
  ind1<-y1*c(1:n)
  ind2<-y2*c(1:n)
  
  marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
  marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
  
  Marks1<-numeric(n)
  Marks2<-numeric(n)
  
  Marks1[ind1[ind1>0]]<-marks1
  Marks2[ind2[ind2>0]]<-marks2
  
  
  Lambda01<-numeric(n)
  psihat1<-rep(1,n)
  
  condInt1<-rep(NA,times[n])
  
  
  
  
  Lambda02<-numeric(n)
  psihat2<-rep(1,n)
  
  condInt2<-rep(NA,times[n])
  
  
  #Define Psi
  
  alphas<-matriz(param[1:2,])
  betas1<-matriz(param[3:4,])
  betas2<-matriz(param[5:6,])
  cova<-matriz(param[dim(param)[1],])
  
  # define baselines
  
  # 
  # if(unrestricted==T){
  # 
  # 
  # 
  #   mu1<-matriz(param[5,])
  #   sigma1<-matriz(param[6,])
  #   Q1<-matriz((param[7,]))
  #   mu2<-matriz(param[8,])
  #   sigma2<-matriz(param[9,])
  #   Q2<-matriz((param[10,]))
  #   
  # 
  #   lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
  #   Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
  # 
  #   lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])
  #   Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])
  # 
  # 
  # 
  # }
  
  #if(unrestricted==F){
  
  mu1<-matriz((param[7,]))
  sigma1<-matriz((param[8,]))
  Q1<-matriz((param[9,]))
  
  
  
  lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
  Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
  
  lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2]) 
  Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
  
  
  
  #}
  
  
  
  # random exponentials for psi
  phi<-VARMA1.2(Lambda01,Lambda02,alphas,betas1,betas2,n,y1,y2)
  
  
  
  
  psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
  psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
  
  
  
  # scale specifications
  
  # 
  # if(Grad){
  #   grad1<- phi$psihat1*(1-psi1*Lambda01)[ind1]
  #   grad2<- phi$psihat2*(1-psi2*Lambda02)[ind2]
  #   
  #   out<-cbind(grad1,grad2)
  # }
  
  #else{
  if(is.na(sum(psi1)) || abs(sum(psi1))== Inf || sum(psi1)==0
     || is.na(sum(psi2)) || abs(sum(psi2))== Inf || sum(psi2)==0) {
    out<- 1e7}
  
  else {
    loglik1<- sum(log(psi1*lambda01)[ind1])-sum((psi1*Lambda01)[ind1])
    loglik2<- sum(log(psi2*lambda02)[ind2])-sum((psi2*Lambda02)[ind2])
    
    
    out<- -(loglik1+loglik2)
    #}
    
  }
  
  #cat(loglik,"\n")
  return(out)
}
ACI_times2.2.1<-function(param,mpp){
  
  
  param<-matrix(param,ncol=2)
  
  times1<-mpp$mpp1$times
  times2<-mpp$mpp2$times
  
  d1<-mpp$mpp1$durations
  d2<-mpp$mpp2$durations
  
  dur<-mpp$biv$durations
  dur1<-mpp$biv$bivdur1
  dur2<-mpp$biv$bivdur2
  
  
  
  
  
  times<-mpp$biv$times
  
  
  n<-length(times)
  
  
  y1<-as.numeric(times%in%times1)
  y2<-as.numeric(times%in%times2)
  
  ind1<-y1*c(1:n)
  ind2<-y2*c(1:n)
  
  marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
  marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
  
  Marks1<-numeric(n)
  Marks2<-numeric(n)
  
  Marks1[ind1[ind1>0]]<-marks1
  Marks2[ind2[ind2>0]]<-marks2
  
  
  Lambda01<-numeric(n)
  psihat1<-rep(1,n)
  
  condInt1<-rep(NA,times[n])
  
  
  
  
  Lambda02<-numeric(n)
  psihat2<-rep(1,n)
  
  condInt2<-rep(NA,times[n])
  
  
  #Define Psi
  
  alphas1<-matriz(param[1:2,])
  alphas2<-matriz(param[3:4,])
  betas1<-matriz(param[5:6,])
  cova<-matriz(param[dim(param)[1],])
  
  # define baselines
  
  # 
  # if(unrestricted==T){
  # 
  # 
  # 
  #   mu1<-matriz(param[5,])
  #   sigma1<-matriz(param[6,])
  #   Q1<-matriz((param[7,]))
  #   mu2<-matriz(param[8,])
  #   sigma2<-matriz(param[9,])
  #   Q2<-matriz((param[10,]))
  #   
  # 
  #   lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
  #   Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
  # 
  #   lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])
  #   Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])
  # 
  # 
  # 
  # }
  
  #if(unrestricted==F){
  
  mu1<-matriz((param[7,]))
  sigma1<-matriz((param[8,]))
  Q1<-matriz((param[9,]))
  
  
  
  lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
  Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
  
  lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2]) 
  Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
  
  
  
  #}
  
  
  
  # random exponentials for psi
  phi<-VARMA2.1(Lambda01,Lambda02,alphas1,alphas2,betas1,n,y1,y2)
  
  
  
  
  psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
  psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
  
  
  
  # scale specifications
  
  # 
  # if(Grad){
  #   grad1<- phi$psihat1*(1-psi1*Lambda01)[ind1]
  #   grad2<- phi$psihat2*(1-psi2*Lambda02)[ind2]
  #   
  #   out<-cbind(grad1,grad2)
  # }
  
  #else{
  if(is.na(sum(psi1)) || abs(sum(psi1))== Inf || sum(psi1)==0
     || is.na(sum(psi2)) || abs(sum(psi2))== Inf || sum(psi2)==0) {
    out<- 1e7}
  
  else {
    loglik1<- sum(log(psi1*lambda01)[ind1])-sum((psi1*Lambda01)[ind1])
    loglik2<- sum(log(psi2*lambda02)[ind2])-sum((psi2*Lambda02)[ind2])
    
    
    out<- -(loglik1+loglik2)
    #}
    
  }
  
  #cat(loglik,"\n")
  return(out)
}
ACI_times3<-function(param,mpp,unrestricted=F){

param<-matrix(param,ncol=3)

times1<-mpp$mpp1$times
times2<-mpp$mpp2$times
times3<-mpp$mpp3$times

d1<-mpp$mpp1$durations
d2<-mpp$mpp2$durations
d3<-mpp$mpp3$durations

dur<-mpp$tri$durations
dur1<-mpp$tri$tridur1
dur2<-mpp$tri$tridur2
dur3<-mpp$tri$tridur3

times<-mpp$tri$times


n<-length(times)


y1<-as.numeric(times%in%times1)
y2<-as.numeric(times%in%times2)
y3<-as.numeric(times%in%times3)

 ind1<-y1*c(1:n)
 ind2<-y2*c(1:n)
 ind3<-y3*c(1:n)
 
marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
marks3<-(mpp$mpp3$marks+ mpp$mpp3$threshold)/mpp$mpp3$threshold

Marks1<-numeric(n)
Marks2<-numeric(n)
Marks3<-numeric(n)

Marks1[ind1[ind1>0]]<-marks1
Marks2[ind2[ind2>0]]<-marks2
Marks3[ind3[ind3>0]]<-marks3

Lambda01<-numeric(n)
psihat1<-rep(1,n)

condInt1<-rep(1,times[n])



Lambda02<-numeric(n)
psihat2<-rep(1,n)

condInt2<-rep(1,times[n])


Lambda03<-numeric(n)
psihat3<-rep(1,n)

condInt3<-rep(1,times[n])

#Define Psi

alphas<-matriz3(param[1:3,])
betas<-matriz3(param[4:6,])
cova<-matriz3(param[dim(param)[1],])


# define baselines

if(unrestricted==T){

  mu1<-matriz3(param[7,])
  sigma1<-matriz3(param[8,])
  Q1<-matriz3((param[9,]))
  mu2<-matriz3(param[10,])
  sigma2<-matriz3(param[11,])
  Q2<-matriz3((param[12,]))
  mu3<-matriz3(param[13,])
  sigma3<-matriz3(param[14,])
  Q3<-matriz3((param[15,]))

  lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
  Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])

  lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
  Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])

  lambda03<-  hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])
  Lambda03<-Hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])* hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])

}

if(unrestricted==F){

  mu1<-matriz3((param[7,]))
  sigma1<-matriz3((param[8,]))
  Q1<-matriz3((param[9,]))
 

  lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
  Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])

  lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
  Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])

  lambda03<-hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
  Lambda03<-Hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])


}



# random exponentials for psi
phi<-VARMA3(Lambda01,Lambda02,Lambda03,alphas,betas,n,y1,y2,y3)




psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
psi3<-exp(phi$psihat3 + cova[1,3]*Marks3)



# scale specifications




  if(is.na(sum(psi1)) || abs(sum(psi1))== Inf || sum(psi1)==0||
     is.na(sum(psi2)) || abs(sum(psi2))== Inf || sum(psi2)==0||
     is.na(sum(psi3)) || abs(sum(psi3))== Inf || sum(psi3)==0) {
      loglik<- -1e7}

else {
loglik1<-sum(log(psi1*lambda01)[ind1])-sum((psi1*Lambda01)[ind1])
loglik2<-sum(log(psi2*lambda02)[ind2])-sum((psi2*Lambda02)[ind2])
loglik3<-sum(log(psi3*lambda03)[ind3])-sum((psi3*Lambda03)[ind3])

loglik<-loglik1+loglik2+loglik3
}


#cat(loglik,"\n")
return(-(loglik))
}
ACI_times3.1.2<-function(param,mpp,unrestricted=F){
  
  param<-matrix(param,ncol=3)
  
  times1<-mpp$mpp1$times
  times2<-mpp$mpp2$times
  times3<-mpp$mpp3$times
  
  d1<-mpp$mpp1$durations
  d2<-mpp$mpp2$durations
  d3<-mpp$mpp3$durations
  
  dur<-mpp$tri$durations
  dur1<-mpp$tri$tridur1
  dur2<-mpp$tri$tridur2
  dur3<-mpp$tri$tridur3
  
  times<-mpp$tri$times
  
  
  n<-length(times)
  
  
  y1<-as.numeric(times%in%times1)
  y2<-as.numeric(times%in%times2)
  y3<-as.numeric(times%in%times3)
  
  ind1<-y1*c(1:n)
  ind2<-y2*c(1:n)
  ind3<-y3*c(1:n)
  
  marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
  marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
  marks3<-(mpp$mpp3$marks+ mpp$mpp3$threshold)/mpp$mpp3$threshold
  
  Marks1<-numeric(n)
  Marks2<-numeric(n)
  Marks3<-numeric(n)
  
  Marks1[ind1[ind1>0]]<-marks1
  Marks2[ind2[ind2>0]]<-marks2
  Marks3[ind3[ind3>0]]<-marks3
  
  Lambda01<-numeric(n)
  psihat1<-rep(1,n)
  
  condInt1<-rep(1,times[n])
  
  
  
  Lambda02<-numeric(n)
  psihat2<-rep(1,n)
  
  condInt2<-rep(1,times[n])
  
  
  Lambda03<-numeric(n)
  psihat3<-rep(1,n)
  
  condInt3<-rep(1,times[n])
  
  #Define Psi
  
  alphas<-matriz3(param[1:3,])
  betas1<-matriz3(param[4:6,])
  betas2<-matriz3(param[7:9,])
  cova<-matriz3(param[dim(param)[1],])
  
  
  # define baselines
  
  if(unrestricted==T){
    
    mu1<-matriz3(param[7,])
    sigma1<-matriz3(param[8,])
    Q1<-matriz3((param[9,]))
    mu2<-matriz3(param[10,])
    sigma2<-matriz3(param[11,])
    Q2<-matriz3((param[12,]))
    mu3<-matriz3(param[13,])
    sigma3<-matriz3(param[14,])
    Q3<-matriz3((param[15,]))
    
    lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    
    lambda03<-  hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])
    Lambda03<-Hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])* hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])
    
  }
  
  if(unrestricted==F){
    
    mu1<-matriz3((param[10,]))
    sigma1<-matriz3((param[11,]))
    Q1<-matriz3((param[12,]))
    
    
    lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    
    lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
    lambda03<-hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda03<-Hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    
  }
  
  
  
  # random exponentials for psi
  phi<-VARMA3.1.2(Lambda01,Lambda02,Lambda03,alphas,betas1,betas2,n,y1,y2,y3)
  
  
  
  
  psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
  psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
  psi3<-exp(phi$psihat3 + cova[1,3]*Marks3)
  
  
  
  # scale specifications
  
  
  
  
  if(is.na(sum(psi1)) || abs(sum(psi1))== Inf || sum(psi1)==0||
     is.na(sum(psi2)) || abs(sum(psi2))== Inf || sum(psi2)==0||
     is.na(sum(psi3)) || abs(sum(psi3))== Inf || sum(psi3)==0) {
    loglik<- -1e7}
  
  else {
    loglik1<-sum(log(psi1*lambda01)[ind1])-sum((psi1*Lambda01)[ind1])
    loglik2<-sum(log(psi2*lambda02)[ind2])-sum((psi2*Lambda02)[ind2])
    loglik3<-sum(log(psi3*lambda03)[ind3])-sum((psi3*Lambda03)[ind3])
    
    loglik<-loglik1+loglik2+loglik3
  }
  
  
  #cat(loglik,"\n")
  return(-(loglik))
}
ACI_times3.1.3<-function(param,mpp,unrestricted=F){
  
  param<-matrix(param,ncol=3)
  
  times1<-mpp$mpp1$times
  times2<-mpp$mpp2$times
  times3<-mpp$mpp3$times
  
  d1<-mpp$mpp1$durations
  d2<-mpp$mpp2$durations
  d3<-mpp$mpp3$durations
  
  dur<-mpp$tri$durations
  dur1<-mpp$tri$tridur1
  dur2<-mpp$tri$tridur2
  dur3<-mpp$tri$tridur3
  
  times<-mpp$tri$times
  
  
  n<-length(times)
  
  
  y1<-as.numeric(times%in%times1)
  y2<-as.numeric(times%in%times2)
  y3<-as.numeric(times%in%times3)
  
  ind1<-y1*c(1:n)
  ind2<-y2*c(1:n)
  ind3<-y3*c(1:n)
  
  marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
  marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
  marks3<-(mpp$mpp3$marks+ mpp$mpp3$threshold)/mpp$mpp3$threshold
  
  Marks1<-numeric(n)
  Marks2<-numeric(n)
  Marks3<-numeric(n)
  
  Marks1[ind1[ind1>0]]<-marks1
  Marks2[ind2[ind2>0]]<-marks2
  Marks3[ind3[ind3>0]]<-marks3
  
  Lambda01<-numeric(n)
  psihat1<-rep(1,n)
  
  condInt1<-rep(1,times[n])
  
  
  
  Lambda02<-numeric(n)
  psihat2<-rep(1,n)
  
  condInt2<-rep(1,times[n])
  
  
  Lambda03<-numeric(n)
  psihat3<-rep(1,n)
  
  condInt3<-rep(1,times[n])
  
  #Define Psi
  
  alphas<-matriz3(param[1:3,])
  betas1<-matriz3(param[4:6,])
  betas2<-matriz3(param[7:9,])
  betas3<-matriz3(param[10:12,])
  cova<-matriz3(param[dim(param)[1],])
  
  
  # define baselines
  
  if(unrestricted==T){
    
    mu1<-matriz3(param[7,])
    sigma1<-matriz3(param[8,])
    Q1<-matriz3((param[9,]))
    mu2<-matriz3(param[10,])
    sigma2<-matriz3(param[11,])
    Q2<-matriz3((param[12,]))
    mu3<-matriz3(param[13,])
    sigma3<-matriz3(param[14,])
    Q3<-matriz3((param[15,]))
    
    lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    
    lambda03<-  hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])
    Lambda03<-Hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])* hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])
    
  }
  
  if(unrestricted==F){
    
    mu1<-matriz3((param[13,]))
    sigma1<-matriz3((param[14,]))
    Q1<-matriz3((param[15,]))
    
    
    lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    
    lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
    lambda03<-hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda03<-Hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    
  }
  
  
  
  # random exponentials for psi
  phi<-VARMA3.1.3(Lambda01,Lambda02,Lambda03,alphas,betas1,betas2,betas3,n,y1,y2,y3)
  
  
  
  
  psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
  psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
  psi3<-exp(phi$psihat3 + cova[1,3]*Marks3)
  
  
  
  # scale specifications
  
  
  
  
  if(is.na(sum(psi1)) || abs(sum(psi1))== Inf || sum(psi1)==0||
     is.na(sum(psi2)) || abs(sum(psi2))== Inf || sum(psi2)==0||
     is.na(sum(psi3)) || abs(sum(psi3))== Inf || sum(psi3)==0) {
    loglik<- -1e7}
  
  else {
    loglik1<-sum(log(psi1*lambda01)[ind1])-sum((psi1*Lambda01)[ind1])
    loglik2<-sum(log(psi2*lambda02)[ind2])-sum((psi2*Lambda02)[ind2])
    loglik3<-sum(log(psi3*lambda03)[ind3])-sum((psi3*Lambda03)[ind3])
    
    loglik<-loglik1+loglik2+loglik3
  }
  
  
  #cat(loglik,"\n")
  return(-(loglik))
}
ACI_times3.2.1<-function(param,mpp,unrestricted=F){
  
  param<-matrix(param,ncol=3)
  
  times1<-mpp$mpp1$times
  times2<-mpp$mpp2$times
  times3<-mpp$mpp3$times
  
  d1<-mpp$mpp1$durations
  d2<-mpp$mpp2$durations
  d3<-mpp$mpp3$durations
  
  dur<-mpp$tri$durations
  dur1<-mpp$tri$tridur1
  dur2<-mpp$tri$tridur2
  dur3<-mpp$tri$tridur3
  
  times<-mpp$tri$times
  
  
  n<-length(times)
  
  
  y1<-as.numeric(times%in%times1)
  y2<-as.numeric(times%in%times2)
  y3<-as.numeric(times%in%times3)
  
  ind1<-y1*c(1:n)
  ind2<-y2*c(1:n)
  ind3<-y3*c(1:n)
  
  marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
  marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
  marks3<-(mpp$mpp3$marks+ mpp$mpp3$threshold)/mpp$mpp3$threshold
  
  Marks1<-numeric(n)
  Marks2<-numeric(n)
  Marks3<-numeric(n)
  
  Marks1[ind1[ind1>0]]<-marks1
  Marks2[ind2[ind2>0]]<-marks2
  Marks3[ind3[ind3>0]]<-marks3
  
  Lambda01<-numeric(n)
  psihat1<-rep(1,n)
  
  condInt1<-rep(1,times[n])
  
  
  
  Lambda02<-numeric(n)
  psihat2<-rep(1,n)
  
  condInt2<-rep(1,times[n])
  
  
  Lambda03<-numeric(n)
  psihat3<-rep(1,n)
  
  condInt3<-rep(1,times[n])
  
  #Define Psi
  
  alphas1<-matriz3(param[1:3,])
  alphas2<-matriz3(param[4:6,])
  betas1<-matriz3(param[7:9,])
  cova<-matriz3(param[dim(param)[1],])
  
  
  # define baselines
  
  if(unrestricted==T){
    
    mu1<-matriz3(param[7,])
    sigma1<-matriz3(param[8,])
    Q1<-matriz3((param[9,]))
    mu2<-matriz3(param[10,])
    sigma2<-matriz3(param[11,])
    Q2<-matriz3((param[12,]))
    mu3<-matriz3(param[13,])
    sigma3<-matriz3(param[14,])
    Q3<-matriz3((param[15,]))
    
    lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    
    lambda03<-  hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])
    Lambda03<-Hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])* hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])
    
  }
  
  if(unrestricted==F){
    
    mu1<-matriz3((param[10,]))
    sigma1<-matriz3((param[11,]))
    Q1<-matriz3((param[12,]))
    
    
    lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    
    lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
    lambda03<-hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda03<-Hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    
  }
  
  
  
  # random exponentials for psi
  phi<-VARMA3.2.1(Lambda01,Lambda02,Lambda03,alphas1,alphas2,betas1,n,y1,y2,y3)
  
  
  
  
  psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
  psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
  psi3<-exp(phi$psihat3 + cova[1,3]*Marks3)
  
  
  
  # scale specifications
  
  
  
  
  # if(is.na(sum(psi1)) || abs(sum(psi1))== Inf || sum(psi1)==0||
  #    is.na(sum(psi2)) || abs(sum(psi2))== Inf || sum(psi2)==0||
  #    is.na(sum(psi3)) || abs(sum(psi3))== Inf || sum(psi3)==0) {
  #   loglik<- -Inf}
  # 
  # else {
  loglik1<-sum(log(psi1*lambda01)[ind1])-sum((psi1*Lambda01)[ind1])
  loglik2<-sum(log(psi2*lambda02)[ind2])-sum((psi2*Lambda02)[ind2])
  loglik3<-sum(log(psi3*lambda03)[ind3])-sum((psi3*Lambda03)[ind3])
  
  loglik<-loglik1+loglik2+loglik3
  # }
  # 
  
  #cat(loglik,"\n")
  return(-(loglik))
}
ACI_times3.2.2<-function(param,mpp,unrestricted=T){
  
  param<-matrix(param,ncol=3)
  
  times1<-mpp$mpp1$times
  times2<-mpp$mpp2$times
  times3<-mpp$mpp3$times
  
  d1<-mpp$mpp1$durations
  d2<-mpp$mpp2$durations
  d3<-mpp$mpp3$durations
  
  dur<-mpp$tri$durations
  dur1<-mpp$tri$tridur1
  dur2<-mpp$tri$tridur2
  dur3<-mpp$tri$tridur3
  
  times<-mpp$tri$times
  
  
  n<-length(times)
  
  
  y1<-as.numeric(times%in%times1)
  y2<-as.numeric(times%in%times2)
  y3<-as.numeric(times%in%times3)
  
  ind1<-y1*c(1:n)
  ind2<-y2*c(1:n)
  ind3<-y3*c(1:n)
  
  marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
  marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
  marks3<-(mpp$mpp3$marks+ mpp$mpp3$threshold)/mpp$mpp3$threshold
  
  Marks1<-numeric(n)
  Marks2<-numeric(n)
  Marks3<-numeric(n)
  
  Marks1[ind1[ind1>0]]<-marks1
  Marks2[ind2[ind2>0]]<-marks2
  Marks3[ind3[ind3>0]]<-marks3
  
  Lambda01<-numeric(n)
  psihat1<-rep(1,n)
  
  condInt1<-rep(1,times[n])
  
  
  
  Lambda02<-numeric(n)
  psihat2<-rep(1,n)
  
  condInt2<-rep(1,times[n])
  
  
  Lambda03<-numeric(n)
  psihat3<-rep(1,n)
  
  condInt3<-rep(1,times[n])
  
  #Define Psi
  
  alphas1<-matriz3(param[1:3,])
  alphas2<-matriz3(param[4:6,])
  betas1<-matriz3(param[7:9,])
  betas2<-matriz3(param[10:12,])
  cova<-matriz3(param[dim(param)[1],])
  
  
  # define baselines
  
  if(unrestricted==T){
    
    mu1<-matriz3(param[7,])
    sigma1<-matriz3(param[8,])
    Q1<-matriz3((param[9,]))
    mu2<-matriz3(param[10,])
    sigma2<-matriz3(param[11,])
    Q2<-matriz3((param[12,]))
    mu3<-matriz3(param[13,])
    sigma3<-matriz3(param[14,])
    Q3<-matriz3((param[15,]))
    
    lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    
    lambda03<-  hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])
    Lambda03<-Hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])* hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])
    
  }
  
  if(unrestricted==F){
    
    mu1<-matriz3((param[13,]))
    sigma1<-matriz3((param[14,]))
    Q1<-matriz3((param[15,]))
    
    
    lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    
    lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
    lambda03<-hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda03<-Hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    
  }
  
  
  
  # random exponentials for psi
  phi<-VARMA3.2.2(Lambda01,Lambda02,Lambda03,alphas1,alphas2,betas1,betas2,n,y1,y2,y3)
  
  
  
  
  psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
  psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
  psi3<-exp(phi$psihat3 + cova[1,3]*Marks3)
  
  
  
  # scale specifications
  
  
  
  
  # if(is.na(sum(psi1)) || abs(sum(psi1))== Inf || sum(psi1)==0||
  #    is.na(sum(psi2)) || abs(sum(psi2))== Inf || sum(psi2)==0||
  #    is.na(sum(psi3)) || abs(sum(psi3))== Inf || sum(psi3)==0) {
  #   loglik<- -1e7}
  # 
  # else {
    loglik1<-sum(log(psi1*lambda01)[ind1])-sum((psi1*Lambda01)[ind1])
    loglik2<-sum(log(psi2*lambda02)[ind2])-sum((psi2*Lambda02)[ind2])
    loglik3<-sum(log(psi3*lambda03)[ind3])-sum((psi3*Lambda03)[ind3])
    
    loglik<-loglik1+loglik2+loglik3
  # }
  
  
  #cat(loglik,"\n")
  return(-(loglik))
}

#--------------------------------------------------------------------------------
volfunction<-function(a,covar,s){


   # matrix time
    I<-s>0
    s[s==0]<-Inf
    
    if(length(covar)==1){
      
      result =rowSums(contrib(s,a,0))
    }
    
    else{
    covar<-t(covar*t(I))  # matrix marks
    result =rowSums(contrib(s,a,covar))
    }

 result

}
contrib<-function(s,a,covar){

a*exp(covar-a*s)               #kernel before integration

}
volfunction2<-function(a,covar,s){


   # matrix time
    I<-s>0
    s[s==0]<-Inf
    
    if(length(covar)==1){
      
      result =rowSums(contrib2(s,a,0))
    }
    
    else{
      covar<-t(covar*t(I))  # matrix marks
      result =rowSums(contrib2(s,a,covar))
    }
    

 result

}
contrib2<-function(s,a,covar){

exp(covar)*(-exp(-a*s))               #kernel before integration

}


Hawkes_times2<-function(theta, mpp){

   
   
   theta<-(theta)
   times1<-mpp$mpp1$times
   times2<-mpp$mpp2$times
   marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
   marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
   endtime<- mpp$biv$endtime
   starttime<-mpp$biv$starttime
    s1 <-mpp$mpp1$s1
    s12<-mpp$mpp1$s12
    s2 <-mpp$mpp2$s2
    s21<-mpp$mpp2$s21
    times<-sort(c(times1,times2))
    times<-times[!duplicated(times)]

    mu1   <-theta[1]
    e11   <-theta[2]
    e12   <-theta[3]
    a11   <-theta[4]
    #a12   <-theta[5]
    b11   <-theta[5]
   # b12   <-theta[6]
    mu2   <-theta[6]
    e21   <-theta[7]
    e22   <-theta[8]
    #a21   <-theta[11]
    a22   <-theta[9]
   # b21   <-theta[11]
    b22   <-theta[10]
   
    kern11<- volfunction(a11,b11*marks1,s1)
    kern12<- volfunction(a22,b22*marks2,s12)
    kern21<- volfunction(a11,b11*marks1,s21)
    kern22<- volfunction(a22,b22*marks2,s2)

    Kern1<- mu1+ e11*kern11 +  e12*kern12
    Kern2<- mu2+ e22*kern22 +  e21*kern21
    
    Kern1[Kern1<=0]<-0.001
    Kern2[Kern2<=0]<-0.001
    # sum log lambda.g
    term1 <- sum(log(Kern1))+sum(log(Kern2))


Int11<- sum((exp(-a11 * (endtime - times1))-1)*exp(b11*marks1))
Int12<- sum((exp(-a22 * (endtime - times2))-1)*exp(b22*marks2))
Int21<- sum((exp(-a11 * (endtime - times1))-1)*exp(b11*marks1))
Int22<- sum((exp(-a22 * (endtime - times2))-1)*exp(b22*marks2))

term2<- -mu1*(endtime - starttime)+ e11*Int11-mu2*(endtime - starttime)+e22*Int22+e12*Int12+e21*Int21

# marks




out <- term1 + term2 
return(-out)
}
Filter_Hawkes_POT2<-function(Hawk,POT,s1,s2,mpp,VaR=0.99){

   theta<-Hawk$par
   times1<-mpp$mpp1$times
   times2<-mpp$mpp2$times
   marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
   marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
   endtime<- mpp$biv$endtime
   starttime<-mpp$biv$starttime
   times<-sort(c(times1,times2))
    times<-times[!duplicated(times)]


   mu1   <-theta[1]
   e11   <-theta[2]
   e12   <-theta[3]
   a11   <-theta[4]
   #a12   <-theta[5]
   b11   <-theta[5]
   # b12   <-theta[6]
   mu2   <-theta[6]
   e21   <-theta[7]
   e22   <-theta[8]
   #a21   <-theta[11]
   a22   <-theta[9]
   # b21   <-theta[11]
   b22   <-theta[10]
   
   kern11<- volfunction(a11,b11*marks1,s1)
   kern12<- volfunction(a22,b22*marks2,s2)
   kern21<- volfunction(a11,b11*marks1,s1)
   kern22<- volfunction(a22,b22*marks2,s2)
   

    condInt1<- mu1+ e11*kern11 +  e12*kern12
    condInt2<- mu2+ e22*kern22 +  e21*kern21

  #  
  
  # POT part

d1<-mpp$mpp1$durations
d2<-mpp$mpp2$durations

param1<-matriz((POT$par))
marks1<-mpp$mpp1$marks
marks2<-mpp$mpp2$marks

n1<-length(marks1)
n2<-length(marks2)

betahat1<-rep(0,n1)
betahat2<-rep(0,n2)

delta0<-(matriz(param1[1,]))
xi<-matriz((param1[2,]))
delta<-(matriz(param1[3,]))
w<-(matriz(param1[4,]))
covas<-(matriz(param1[5,]))




for ( i in 1:(n1-1)) betahat1[i+1]<-w[,1] +delta0[,1]*log(marks1[i])+delta[,1]*betahat1[i]+covas[,1]*d1[i+1]
for ( i in 1:(n2-1)) betahat2[i+1]<-w[,2] +delta0[,2]*log(marks2[i])+delta[,2]*betahat2[i]+covas[,2]*d2[i+1]


betaexp1<-exp(betahat1)*(1-xi[,1])
betaexp2<-exp(betahat2)*(1-xi[,2])



 
  betaInt1<-real.phi(betaexp1,d1)
  betaInt2<-real.phi(betaexp2,d2)


y1<-as.numeric(times%in%times1)
y2<-as.numeric(times%in%times2)



   Var1<-quant(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
   Var2<-quant(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
   Var1[is.infinite(Var1)]<-min(Var1)
   Var2[is.infinite(Var2)]<-min(Var2)
   
  Var1[Var1<mpp$mpp1$threshold]<-mpp$mpp1$threshold
  Var2[Var2<mpp$mpp2$threshold]<-mpp$mpp2$threshold

marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold

Kern11<- volfunction2(a11,b11*marks1,mpp$mpp1$s1)
Kern12<- volfunction2(a22,b22*marks2,mpp$mpp1$s12)
Kern21<- volfunction2(a11,b11*marks1,mpp$mpp2$s21)
Kern22<- volfunction2(a22,b22*marks2,mpp$mpp2$s2)

   

e1<- diff(mu1*times1+e11*Kern11+e12*Kern12)
e2<- diff(mu2*times2+e21*Kern21+e22*Kern22)

   
   error1<-(Var1<mpp$mpp1$values[2:(mpp$biv$endtime+1)])
   error2<-(Var2<mpp$mpp2$values[2:(mpp$biv$endtime+1)])
   error<-cbind(as.numeric(error1),as.numeric(error2))
   
   
   error1<-error1*quantile(mpp$mpp1$values,0.9995)
   error2<-error2*quantile(mpp$mpp2$values,0.9995)
   
   error1[error1==0]<-NA
   error2[error2==0]<-NA
     
   Var1<-c(NA,Var1)
   Var2<-c(NA,Var2)
   
   m1<-mpp$mpp1$values
   m2<-mpp$mpp2$values
   m1[m1<=0]<-NA
   m2[m2<=0]<-NA


    #plot.ts(condInt1)
    #plot.ts(condInt2)
   # x11()
   coll<-c("skyblue1","skyblue2","skyblue3","skyblue4")  
   layout(matrix(c(1,1,2,2,3,3),6,1))
   par(mar=c(0,4,1,1))
   plot(m1, ylim=range(m1[!is.na(m1)]*1.2),xaxt="n",ylab="Marks 1" ,xlab=" Times 1",col=coll[1],cex=0.5)
   lines(c(Var1),col=coll[4])
   points(error1,pch=3, cex=0.5)
   
   par(mar=c(0,4,1,1))
   plot(m2, ylim=range(m2[!is.na(m2)]*1.2),xaxt="n",ylab="Marks 2" ,xlab=" Times 2",col=coll[2],cex=0.5) 
   lines(c(Var2),col=coll[4])
   points(error2,pch=3, cex=0.5)
   
   
   par(mar=c(4,4,4,1))
   xx<-rowSums(cbind(y1,y2*2))
   plot(times,rep(1,length(times)),yaxt="n",col=coll[xx],typ="h",ylim=c(0,1),ylab="Barcode plot",xlab="Pooled Process Time")
   
   
 list(error=error,VaR=cbind(Var1,Var2),VaRa=VaR,condInt1=condInt1, condInt2=condInt2,e1=e1,e2=e2,betaInt1=betaInt1,betaInt2=betaInt2,xx=xx)


}
Hawkes_times3<-function(theta, mpp){



   theta<-(theta)
   times1<-mpp$mpp1$times
   times2<-mpp$mpp2$times
   times3<-mpp$mpp3$times
   marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
   marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
   marks3<-(mpp$mpp3$marks+ mpp$mpp3$threshold)/mpp$mpp3$threshold
   endtime<- mpp$tri$endtime
   starttime<-mpp$tri$starttime
    s1 <-mpp$mpp1$s1
    s12<-mpp$mpp1$s12
    s13<-mpp$mpp1$s13
    s2 <-mpp$mpp2$s2
    s21<-mpp$mpp2$s21
    s23<-mpp$mpp2$s23
    s31 <-mpp$mpp3$s31
    s32<-mpp$mpp3$s32
    s3<-mpp$mpp3$s3
    times<-sort(c(times1,times2,times3))
    times<-times[!duplicated(times)]

    mu1   <-theta[1]
    e11   <-theta[2]
    e12   <-theta[3]
    e13   <-theta[4]
    a11   <-theta[5]
    # a12   <-theta[6]
    # a13   <-theta[7]
    b11   <-theta[6]
   # b12   <-theta[7]
    #b13   <-theta[8]

    mu2   <-theta[7]
    e21   <-theta[8]
    e22   <-theta[9]
    e23   <-theta[10]
    # a21   <-theta[13]
    a22   <-theta[11]
    #a23   <-theta[15]
    #b21   <-theta[14]
    b22   <-theta[12]
   # b23   <-theta[16]
    
    mu3   <-theta[13]
    e31   <-theta[14]
    e32   <-theta[15]
    e33   <-theta[16]
   # a31   <-theta[21]
   # a32   <-theta[22]
    a33   <-theta[17]
   # b31   <-theta[22]
   # b32   <-theta[23]
    b33   <-theta[18]

    kern11<- volfunction(a11,b11*marks1,s1)
    kern12<- volfunction(a22,b22*marks2,s12)
    kern13<- volfunction(a33,b33*marks3,s13)
    kern21<- volfunction(a11,b11*marks1,s21)
    kern22<- volfunction(a22,b22*marks2,s2)
    kern23<- volfunction(a33,b33*marks3,s23)
    kern31<- volfunction(a11,b11*marks1,s31)
    kern32<- volfunction(a22,b22*marks2,s32)
    kern33<- volfunction(a33,b33*marks3,s3)
    
    Kern1<- mu1+ e11*kern11 +  e12*kern12 +e13*kern13
    Kern2<- mu2+ e21*kern21 +  e22*kern22 +e23*kern23
    Kern3<- mu3+ e31*kern31 +  e32*kern32 +e33*kern33

    # Kern1[Kern1<=0]<-0.001
    # Kern2[Kern2<=0]<-0.001
    # Kern3[Kern3<=0]<-0.001
    # sum log lambda.g
    term1 <- sum(log(Kern1))+sum(log(Kern2))+sum(log(Kern3))


Int11<- sum((exp(-a11 * (endtime - times1))-1)*exp(b11*marks1))
#Int12<- sum((exp(-a22 * (endtime - times2))-1)*exp(b22*marks2))
#Int13<- sum((exp(-a33 * (endtime - times3))-1)*exp(b33*marks3))
#Int21<- sum((exp(-a11 * (endtime - times1))-1)*exp(b11*marks1))
Int22<- sum((exp(-a22 * (endtime - times2))-1)*exp(b22*marks2))
#Int23<- sum((exp(-a33 * (endtime - times3))-1)*exp(b33*marks3))
#Int31<- sum((exp(-a11 * (endtime - times1))-1)*exp(b11*marks1))
#Int32<- sum((exp(-a22 * (endtime - times2))-1)*exp(b22*marks2))
Int33<- sum((exp(-a33 * (endtime - times3))-1)*exp(b33*marks3))

# term2<- (-mu1*(endtime - starttime)+e11*Int11+e12*Int12+e13*Int13
#         -mu2*(endtime - starttime) +e21*Int21+e22*Int22+e23*Int23
#         -mu3*(endtime - starttime) +e31*Int31+e32*Int32+e33*Int33)

 term2<- (-mu1*(endtime - starttime)+e11*Int11+e12*Int22+e13*Int33
          -mu2*(endtime - starttime)+e21*Int11+e22*Int22+e23*Int33
          -mu3*(endtime - starttime)+e31*Int11+e32*Int22+e33*Int33)
# marks




out <- term1 + term2
return(-out)
}
Filter_Hawkes_POT3<-function(Hawk,POT,s1,s2,s3,mpp,VaR=0.99){
  
   theta<-(Hawk$par)
   times1<-mpp$mpp1$times
   times2<-mpp$mpp2$times
   times3<-mpp$mpp3$times
   marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
   marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
   marks3<-(mpp$mpp3$marks+ mpp$mpp3$threshold)/mpp$mpp3$threshold
   endtime<- mpp$tri$endtime
   starttime<-mpp$tri$starttime
   times<-sort(c(times1,times2,times3))
    times<-times[!duplicated(times)]


   mu1   <-theta[1]
   e11   <-theta[2]
   e12   <-theta[3]
   e13   <-theta[4]
   a11   <-theta[5]
   #a12   <-theta[6]
   #a13   <-theta[7]
   b11   <-theta[6]
   # b12   <-theta[7]
   #b13   <-theta[8]
   
   mu2   <-theta[7]
   e21   <-theta[8]
   e22   <-theta[9]
   e23   <-theta[10]
   # a21   <-theta[15]
   a22   <-theta[11]
   # a23   <-theta[17]
   #b21   <-theta[14]
   b22   <-theta[12]
   # b23   <-theta[16]
   
   mu3   <-theta[13]
   e31   <-theta[14]
   e32   <-theta[15]
   e33   <-theta[16]
   # a31   <-theta[25]
   # a32   <-theta[26]
   a33   <-theta[17]
   # b31   <-theta[22]
   # b32   <-theta[23]
   b33   <-theta[18]

   kern11<- volfunction(a11,b11*marks1,s1)
   kern12<- volfunction(a22,b22*marks2,s2)
   kern13<- volfunction(a33,b33*marks3,s3)
   kern21<- volfunction(a11,b11*marks1,s1)
   kern22<- volfunction(a22,b22*marks2,s2)
   kern23<- volfunction(a33,b33*marks3,s3)
   kern31<- volfunction(a11,b11*marks1,s1)
   kern32<- volfunction(a22,b22*marks2,s2)
   kern33<- volfunction(a33,b33*marks3,s3)

    condInt1<- mu1+ e11*kern11 +  e12*kern12 +e13*kern13
    condInt2<- mu2+ e21*kern21 +  e22*kern22 +e23*kern23
    condInt3<- mu3+ e31*kern31 +  e32*kern32 +e33*kern33

  #

  # POT part

d1<-mpp$mpp1$durations
d2<-mpp$mpp2$durations
d3<-mpp$mpp3$durations

param1<-matriz3((POT$par))
marks1<-mpp$mpp1$marks
marks2<-mpp$mpp2$marks
marks3<-mpp$mpp3$marks

n1<-length(marks1)
n2<-length(marks2)
n3<-length(marks3)

betahat1<-rep(0,n1)
betahat2<-rep(0,n2)
betahat3<-rep(0,n3)

delta0<-(matriz3(param1[1,]))
xi<-matriz3(param1[2,])
delta<-(matriz3(param1[3,]))
w<-(matriz3(param1[4,]))
covas<-(matriz3(param1[5,]))




for ( i in 1:(n1-1)) betahat1[i+1]<-w[,1] +delta0[,1]*log(marks1[i])+delta[,1]*betahat1[i]+covas[,1]*d1[i+1]
for ( i in 1:(n2-1)) betahat2[i+1]<-w[,2] +delta0[,2]*log(marks2[i])+delta[,2]*betahat2[i]+covas[,2]*d2[i+1]
for ( i in 1:(n3-1)) betahat3[i+1]<-w[,3] +delta0[,3]*log(marks3[i])+delta[,3]*betahat3[i]+covas[,3]*d3[i+1]




 betaexp1<-exp(betahat1)*(1-xi[,1])
 betaexp2<-exp(betahat2)*(1-xi[,2])
 betaexp3<-exp(betahat3)*(1-xi[,3])

 betaInt1<-real.phi(betaexp1,d1)
 betaInt2<-real.phi(betaexp2,d2)
 betaInt3<-real.phi(betaexp3,d3)
  
y1<-as.numeric(times%in%times1)
y2<-as.numeric(times%in%times2)
y3<-as.numeric(times%in%times3)


   Var1<-quant(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
   Var2<-quant(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
   Var3<-quant(VaR,condInt3,xi[,3],betaInt3,mpp$mpp3$threshold)

ES1<-ES(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
ES2<-ES(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
ES3<-ES(VaR,condInt3,xi[,3],betaInt3,mpp$mpp3$threshold)


   #Var1[is.infinite(Var1)]<-min(Var1)
   #Var2[is.infinite(Var2)]<-min(Var2)
   #Var3[is.infinite(Var3)]<-min(Var3)
marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
marks3<-(mpp$mpp3$marks+ mpp$mpp3$threshold)/mpp$mpp3$threshold

Kern11<- volfunction2(a11,b11*marks1,mpp$mpp1$s1)
Kern12<- volfunction2(a22,b22*marks2,mpp$mpp1$s12)
Kern13<- volfunction2(a33,b33*marks3,mpp$mpp1$s13)
Kern21<- volfunction2(a11,b11*marks1,mpp$mpp2$s21)
Kern22<- volfunction2(a22,b22*marks2,mpp$mpp2$s2)
Kern23<- volfunction2(a33,b33*marks3,mpp$mpp2$s23)
Kern31<- volfunction2(a11,b11*marks1,mpp$mpp3$s31)
Kern32<- volfunction2(a22,b22*marks2,mpp$mpp3$s32)
Kern33<- volfunction2(a33,b33*marks3,mpp$mpp3$s3)

e1<- mu1*times1+e11*Kern11+e12*Kern12+e13*Kern13
e2<- mu2*times2+e21*Kern21+e22*Kern22+e23*Kern23
e3<- mu3*times3+e31*Kern31+e32*Kern32+e33*Kern33




   # Var1[Var1<mpp$mpp1$threshold]<-mpp$mpp1$threshold
   # Var2[Var2<mpp$mpp2$threshold]<-mpp$mpp2$threshold
   # Var3[Var3<mpp$mpp3$threshold]<-mpp$mpp3$threshold

   error1<-(Var1<mpp$mpp1$values[1:(mpp$tri$endtime)])
   error2<-(Var2<mpp$mpp2$values[1:(mpp$tri$endtime)])
   error3<-(Var3<mpp$mpp3$values[1:(mpp$tri$endtime)])
   
   VES1<-  mean((ES1-mpp$mpp1$values[1:(mpp$tri$endtime)])[error1],na.rm=T)
   VES2<-  mean((ES2-mpp$mpp2$values[1:(mpp$tri$endtime)])[error2],na.rm=T)
   VES3<-  mean((ES3-mpp$mpp3$values[1:(mpp$tri$endtime)])[error3],na.rm=T)
   
   VES<-cbind(VES1,VES2,VES3)

   error<-cbind(as.numeric(error1),as.numeric(error2),as.numeric(error3))

   error1<-error1*quantile(mpp$mpp1$values,0.9995)
   error2<-error2*quantile(mpp$mpp2$values,0.9995)
   error3<-error3*quantile(mpp$mpp3$values,0.9995)

   error1[error1==0]<-NA
   error2[error2==0]<-NA
   error3[error3==0]<-NA

   Var1<-c(NA,Var1)
   Var2<-c(NA,Var2)
   Var3<-c(NA,Var3)

   m1<-mpp$mpp1$values
   m2<-mpp$mpp2$values
   m3<-mpp$mpp3$values

   m1[m1<=0]<-NA
   m2[m2<=0]<-NA
   m3[m3<=0]<-NA

marks1<-mpp$mpp1$marks
marks2<-mpp$mpp2$marks
marks3<-mpp$mpp3$marks



  layout(matrix(c(1,1,2,2,3,3,4,4),8,1))
   par(mar=c(0,4,1,1))
   plot(m1, ylim=range(marks1*1.5),xaxt="n",ylab="Marks 1" ,xlab=" Times 1",col=1,cex=0.5)
   lines(c(Var1),col=8)
   points(error1,pch=3, cex=0.5)

   par(mar=c(0,4,1,1))
   plot(m2, ylim=range(marks2*1.5),xaxt="n",ylab="Marks 2" ,xlab=" Times 2",col=2,cex=0.5)
   lines(c(Var2),col=8)
   points(error2,pch=3, cex=0.5)

   par(mar=c(0,4,1,1))
   plot(m3, ylim=range(marks3*1.5),xaxt="n",ylab="Marks 3" ,xlab=" Times 3",col=4,cex=0.5)
   lines(c(Var3),col=8)
   points(error3,pch=3, cex=0.5)

   par(mar=c(4,4,4,1))
   xx<-rowSums(cbind(y1,y2*2,y3*4))
   plot(times,rep(1,length(times)),yaxt="n",col=xx,typ="h",ylim=c(0,1),ylab="Barcode plot",xlab="Pooled Process Time")


 list(error=error,VaR=cbind(Var1,Var2,Var3),ES=cbind(ES1,ES2,ES3),VaRa=VaR,e1=diff(e1),e2=diff(e2),e3=diff(e3), VES=VES)

}


#--------------------------------------------------------------------------------
 ACD_marks1<-function(param,mpp){
 
param<-matrix((param),ncol=1)
marks<-mpp$marks
durations<-mpp$durations


n<-length(marks)


betahat<-rep(0,n)

delta0<-param[1]
xi<-(param[2])
delta<-param[3]
w<-param[4]
covas<-param[5]


#for ( i in 1:(n-1)) betahat[i+1]<-w+delta0*(marks[i]/((1-xi)*exp(betahat[i])))+delta*betahat[i]+covas*durations[i+1]
for ( i in 1:(n-1)) betahat[i+1]<-w+delta0*log(marks[i])+delta*betahat[i]+covas*durations[i+1]

betaexp<-exp(betahat)*(1-xi)


  # if(is.na(sum(betaexp)) || abs(sum(betaexp))== Inf || sum(betaexp)==0) {
  #     out<- -1e7}
      
# else{
 out<-sum(dgpd(marks,location=0,shape= xi,scale=betaexp, log = T))
 #}
 return(-out)
 }
 
 

#_______________________________________________________________________________
# Intensities and VaR and ES


Filter_ACI_POT2<-function(ACI,POT,mpp,VaR=0.99,unrestricted=T){


#ACI Part
param<-matrix(ACI$par,ncol=2)


times1<-mpp$mpp1$times
times2<-mpp$mpp2$times

d1<-mpp$mpp1$durations
d2<-mpp$mpp2$durations

dur<-mpp$biv$durations
dur1<-mpp$biv$bivdur1
dur2<-mpp$biv$bivdur2




times<-mpp$biv$times


n<-length(times)


y1<-as.numeric(times%in%times1)
y2<-as.numeric(times%in%times2)

 ind1<-y1*c(1:n)
 ind2<-y2*c(1:n)

marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold


Marks1<-numeric(n)
Marks2<-numeric(n)

Marks1[ind1[ind1>0]]<-marks1
Marks2[ind2[ind2>0]]<-marks2

Lambda01<-numeric(n)
psihat1<-rep(1,n)

condInt1<-rep(NA,times[n])




Lambda02<-numeric(n)
psihat2<-rep(1,n)

condInt2<-rep(NA,times[n])


#Define Psi

alphas<-matriz(param[1:2,])
betas<-matriz(param[3:4,])
cova<-matriz(param[dim(param)[1],])


# POT part


param1<-matriz((POT$par))


n1<-length(marks1)
n2<-length(marks2)

betahat1<-rep(0,n1)
betahat2<-rep(0,n2)

delta0<-(matriz(param1[1,]))
xi<-matriz((param1[2,]))
delta<-(matriz(param1[3,]))
w<-(matriz(param1[4,]))
covas<-(matriz(param1[5,]))


marks1<-(mpp$mpp1$marks)
marks2<-(mpp$mpp2$marks)

for ( i in 1:(n1-1)) betahat1[i+1]<-w[,1] +delta0[,1]*log(marks1[i])+delta[,1]*betahat1[i]+covas[,1]*d1[i+1]
for ( i in 1:(n2-1)) betahat2[i+1]<-w[,2] +delta0[,2]*log(marks2[i])+delta[,2]*betahat2[i]+covas[,2]*d2[i+1]

                                           
betaexp1<-exp(betahat1)*(1-xi[,1])
betaexp2<-exp(betahat2)*(1-xi[,2])
                                             



# define baselines

if(unrestricted==T){

  mu1<-matriz(param[5,])
  sigma1<-matriz(param[6,])
  Q1<-matriz(param[7,])
  mu2<-matriz(param[8,])
  sigma2<-matriz(param[9,])
  Q2<-matriz((param[10,]))
  

  lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
  Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])

  lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])
  Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])


}

if(unrestricted==F){


  mu1<-matriz((param[5,]))
  sigma1<-matriz((param[6,]))
  Q1<-matriz((param[7,]))

  

  lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
  Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])

  lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2]) 
  Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])

}



# random exponentials for psi
phi<-VARMA(Lambda01,Lambda02,alphas,betas,n,y1,y2)




psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)



e1<-1-(psi1*Lambda01)[ind1]
e2<-1-(psi2*Lambda02)[ind2]


y.1<-real.time(d1)
r.psi1<-real.phi(psi1,dur)
r.betahat1<-real.phi(betaexp1,d1)

y.2<-real.time(d2)
r.psi2<-real.phi(psi2,dur)
r.betahat2<-real.phi(betaexp2,d2)


 if(unrestricted==F){


   condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
   condInt2<-r.psi2* hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])

  }
  
  if(unrestricted==T){


   condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
   condInt2<-r.psi2* hgengamma(y.1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(y.2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])

  }



   betaInt1<- r.betahat1
   betaInt2<- r.betahat2





   Var1<-quant(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
   Var2<-quant(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
   Var1[is.infinite(Var1)]<-min(Var1)
   Var2[is.infinite(Var2)]<-min(Var2)
   
  #Var1[Var1<mpp$mpp1$threshold]<-mpp$mpp1$threshold
  # Var2[Var2<mpp$mpp2$threshold]<-mpp$mpp2$threshold
   
   error1<-(Var1<mpp$mpp1$values[1:(mpp$biv$endtime)])
   error2<-(Var2<mpp$mpp2$values[1:(mpp$biv$endtime)])
   error<-cbind(as.numeric(error1),as.numeric(error2))
   
   
   error1<-error1*quantile(mpp$mpp1$values,0.9995)
   error2<-error2*quantile(mpp$mpp2$values,0.9995)
   
   error1[error1==0]<-NA
   error2[error2==0]<-NA
     
   Var1<-c(NA,Var1)
   Var2<-c(NA,Var2)
   
   m1<-mpp$mpp1$values
   m2<-mpp$mpp2$values
   m1[m1<=0]<-NA
   m2[m2<=0]<-NA
     
   layout(matrix(c(1,1,2,2,3,3),6,1))
   par(mar=c(0,4,1,1))
   plot(m1, ylim=range(m1[!is.na(m1)]*1.2),xaxt="n",ylab="Marks 1" ,xlab=" Times 1",col=1,cex=0.5)
   lines(c(Var1),col=8)
   points(error1,pch=3, cex=0.5)
   
   par(mar=c(0,4,1,1))
   plot(m2, ylim=range(m2[!is.na(m2)]*1.2),xaxt="n",ylab="Marks 2" ,xlab=" Times 2",col=2,cex=0.5) 
   lines(c(Var2),col=8)
   points(error2,pch=3, cex=0.5)
   
   
   par(mar=c(4,4,4,1))
   xx<-rowSums(cbind(y1,y2*2))
   plot(times,rep(1,length(times)),yaxt="n",col=xx,typ="h",ylim=c(0,1),ylab="Barcode plot",xlab="Pooled Process Time")
   
   
 list(error=error,VaR=cbind(Var1,Var2),VaRa=VaR,condInt1=condInt1, condInt2=condInt2,betaInt1=betaInt1,betaInt2=betaInt2,xx=xx, e1=e1,e2=e2)


}

Filter_ACI_POT2.1.2<-function(ACI,POT,mpp,VaR=0.99,unrestricted=T){
  
  
  #ACI Part
  param<-matrix(ACI$par,ncol=2)
  
  
  times1<-mpp$mpp1$times
  times2<-mpp$mpp2$times
  
  d1<-mpp$mpp1$durations
  d2<-mpp$mpp2$durations
  
  dur<-mpp$biv$durations
  dur1<-mpp$biv$bivdur1
  dur2<-mpp$biv$bivdur2
  
  
  
  
  times<-mpp$biv$times
  
  
  n<-length(times)
  
  
  y1<-as.numeric(times%in%times1)
  y2<-as.numeric(times%in%times2)
  
  ind1<-y1*c(1:n)
  ind2<-y2*c(1:n)
  
  marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
  marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
  
  
  Marks1<-numeric(n)
  Marks2<-numeric(n)
  
  Marks1[ind1[ind1>0]]<-marks1
  Marks2[ind2[ind2>0]]<-marks2
  
  Lambda01<-numeric(n)
  psihat1<-rep(1,n)
  
  condInt1<-rep(NA,times[n])
  
  
  
  
  Lambda02<-numeric(n)
  psihat2<-rep(1,n)
  
  condInt2<-rep(NA,times[n])
  
  
  #Define Psi
  
  alphas<-matriz(param[1:2,])
  betas1<-matriz(param[3:4,])
  betas2<-matriz(param[5:6,])
  cova<-matriz(param[dim(param)[1],])
  
  
  # POT part
  
  
  param1<-matriz((POT$par))
  
  
  n1<-length(marks1)
  n2<-length(marks2)
  
  betahat1<-rep(0,n1)
  betahat2<-rep(0,n2)
  
  delta0<-(matriz(param1[1,]))
  xi<-matriz((param1[2,]))
  delta<-(matriz(param1[3,]))
  w<-(matriz(param1[4,]))
  covas<-(matriz(param1[5,]))
  
  
  marks1<-(mpp$mpp1$marks)
  marks2<-(mpp$mpp2$marks)
  
  for ( i in 1:(n1-1)) betahat1[i+1]<-w[,1] +delta0[,1]*log(marks1[i])+delta[,1]*betahat1[i]+covas[,1]*d1[i+1]
  for ( i in 1:(n2-1)) betahat2[i+1]<-w[,2] +delta0[,2]*log(marks2[i])+delta[,2]*betahat2[i]+covas[,2]*d2[i+1]
  
  
  betaexp1<-exp(betahat1)*(1-xi[,1])
  betaexp2<-exp(betahat2)*(1-xi[,2])
  
  
  
  
  # define baselines
  
  if(unrestricted==T){
    
    mu1<-matriz(param[5,])
    sigma1<-matriz(param[6,])
    Q1<-matriz(param[7,])
    mu2<-matriz(param[8,])
    sigma2<-matriz(param[9,])
    Q2<-matriz((param[10,]))
    
    
    lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
    lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])
    Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])
    
    
  }
  
  if(unrestricted==F){
    
    
    mu1<-matriz((param[7,]))
    sigma1<-matriz((param[8,]))
    Q1<-matriz((param[9,]))
    
    
    
    lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    
    lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2]) 
    Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
  }
  
  
  
  # random exponentials for psi
  phi<-VARMA1.2(Lambda01,Lambda02,alphas,betas1,betas2,n,y1,y2)
  
  
  
  
  psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
  psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
  
  
  
  e1<-1-(psi1*Lambda01)[ind1]
  e2<-1-(psi2*Lambda02)[ind2]
  
  
  y.1<-real.time(d1)
  r.psi1<-real.phi(psi1,dur)
  r.betahat1<-real.phi(betaexp1,d1)
  
  y.2<-real.time(d2)
  r.psi2<-real.phi(psi2,dur)
  r.betahat2<-real.phi(betaexp2,d2)
  
  
  if(unrestricted==F){
    
    
    condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    condInt2<-r.psi2* hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
  }
  
  if(unrestricted==T){
    
    
    condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    condInt2<-r.psi2* hgengamma(y.1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(y.2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])
    
  }
  
  
  
  betaInt1<- r.betahat1
  betaInt2<- r.betahat2
  
  
  
  
  
  Var1<-quant(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
  Var2<-quant(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
  Var1[is.infinite(Var1)]<-min(Var1)
  Var2[is.infinite(Var2)]<-min(Var2)
  
  #Var1[Var1<mpp$mpp1$threshold]<-mpp$mpp1$threshold
  # Var2[Var2<mpp$mpp2$threshold]<-mpp$mpp2$threshold
  
  error1<-(Var1<mpp$mpp1$values[1:(mpp$biv$endtime)])
  error2<-(Var2<mpp$mpp2$values[1:(mpp$biv$endtime)])
  error<-cbind(as.numeric(error1),as.numeric(error2))
  
  
  error1<-error1*quantile(mpp$mpp1$values,0.9995)
  error2<-error2*quantile(mpp$mpp2$values,0.9995)
  
  error1[error1==0]<-NA
  error2[error2==0]<-NA
  
  Var1<-c(NA,Var1)
  Var2<-c(NA,Var2)
  
  m1<-mpp$mpp1$values
  m2<-mpp$mpp2$values
  m1[m1<=0]<-NA
  m2[m2<=0]<-NA
  
  layout(matrix(c(1,1,2,2,3,3),6,1))
  par(mar=c(0,4,1,1))
  plot(m1, ylim=range(m1[!is.na(m1)]*1.2),xaxt="n",ylab="Marks 1" ,xlab=" Times 1",col=1,cex=0.5)
  lines(c(Var1),col=8)
  points(error1,pch=3, cex=0.5)
  
  par(mar=c(0,4,1,1))
  plot(m2, ylim=range(m2[!is.na(m2)]*1.2),xaxt="n",ylab="Marks 2" ,xlab=" Times 2",col=2,cex=0.5) 
  lines(c(Var2),col=8)
  points(error2,pch=3, cex=0.5)
  
  
  par(mar=c(4,4,4,1))
  xx<-rowSums(cbind(y1,y2*2))
  plot(times,rep(1,length(times)),yaxt="n",col=xx,typ="h",ylim=c(0,1),ylab="Barcode plot",xlab="Pooled Process Time")
  
  
  list(error=error,VaR=cbind(Var1,Var2),VaRa=VaR,condInt1=condInt1, condInt2=condInt2,betaInt1=betaInt1,betaInt2=betaInt2,xx=xx, e1=e1,e2=e2)
  
  
}

Filter_ACI_POT2.2.1<-function(ACI,POT,mpp,VaR=0.99,unrestricted=T){
  
  
  #ACI Part
  param<-matrix(ACI$par,ncol=2)
  
  
  times1<-mpp$mpp1$times
  times2<-mpp$mpp2$times
  
  d1<-mpp$mpp1$durations
  d2<-mpp$mpp2$durations
  
  dur<-mpp$biv$durations
  dur1<-mpp$biv$bivdur1
  dur2<-mpp$biv$bivdur2
  
  
  
  
  times<-mpp$biv$times
  
  
  n<-length(times)
  
  
  y1<-as.numeric(times%in%times1)
  y2<-as.numeric(times%in%times2)
  
  ind1<-y1*c(1:n)
  ind2<-y2*c(1:n)
  
  marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
  marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
  
  
  Marks1<-numeric(n)
  Marks2<-numeric(n)
  
  Marks1[ind1[ind1>0]]<-marks1
  Marks2[ind2[ind2>0]]<-marks2
  
  Lambda01<-numeric(n)
  psihat1<-rep(1,n)
  
  condInt1<-rep(NA,times[n])
  
  
  
  
  Lambda02<-numeric(n)
  psihat2<-rep(1,n)
  
  condInt2<-rep(NA,times[n])
  
  
  #Define Psi
  
  alphas1<-matriz(param[1:2,])
  alphas2<-matriz(param[3:4,])
  betas<-matriz(param[5:6,])
  cova<-matriz(param[dim(param)[1],])
  
  
  # POT part
  
  
  param1<-matriz((POT$par))
  
  
  n1<-length(marks1)
  n2<-length(marks2)
  
  betahat1<-rep(0,n1)
  betahat2<-rep(0,n2)
  
  delta0<-(matriz(param1[1,]))
  xi<-matriz((param1[2,]))
  delta<-(matriz(param1[3,]))
  w<-(matriz(param1[4,]))
  covas<-(matriz(param1[5,]))
  
  
  marks1<-(mpp$mpp1$marks)
  marks2<-(mpp$mpp2$marks)
  
  for ( i in 1:(n1-1)) betahat1[i+1]<-w[,1] +delta0[,1]*log(marks1[i])+delta[,1]*betahat1[i]+covas[,1]*d1[i+1]
  for ( i in 1:(n2-1)) betahat2[i+1]<-w[,2] +delta0[,2]*log(marks2[i])+delta[,2]*betahat2[i]+covas[,2]*d2[i+1]
  
  
  betaexp1<-exp(betahat1)*(1-xi[,1])
  betaexp2<-exp(betahat2)*(1-xi[,2])
  
  
  
  
  # define baselines
  
  if(unrestricted==T){
    
    mu1<-matriz(param[5,])
    sigma1<-matriz(param[6,])
    Q1<-matriz(param[7,])
    mu2<-matriz(param[8,])
    sigma2<-matriz(param[9,])
    Q2<-matriz((param[10,]))
    
    
    lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
    lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])
    Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])
    
    
  }
  
  if(unrestricted==F){
    
    
    mu1<-matriz((param[7,]))
    sigma1<-matriz((param[8,]))
    Q1<-matriz((param[9,]))
    
    
    
    lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    
    lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2]) 
    Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
  }
  
  
  
  # random exponentials for psi
  phi<-VARMA2.1(Lambda01,Lambda02,alphas1,alphas2,betas,n,y1,y2)
  
  
  
  
  psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
  psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
  
  
  
  e1<-1-(psi1*Lambda01)[ind1]
  e2<-1-(psi2*Lambda02)[ind2]
  
  
  y.1<-real.time(d1)
  r.psi1<-real.phi(psi1,dur)
  r.betahat1<-real.phi(betaexp1,d1)
  
  y.2<-real.time(d2)
  r.psi2<-real.phi(psi2,dur)
  r.betahat2<-real.phi(betaexp2,d2)
  
  
  if(unrestricted==F){
    
    
    condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    condInt2<-r.psi2* hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
  }
  
  if(unrestricted==T){
    
    
    condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    condInt2<-r.psi2* hgengamma(y.1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(y.2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])
    
  }
  
  
  
  betaInt1<- r.betahat1
  betaInt2<- r.betahat2
  
  
  
  
  
  Var1<-quant(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
  Var2<-quant(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
  Var1[is.infinite(Var1)]<-min(Var1)
  Var2[is.infinite(Var2)]<-min(Var2)
  
  #Var1[Var1<mpp$mpp1$threshold]<-mpp$mpp1$threshold
  # Var2[Var2<mpp$mpp2$threshold]<-mpp$mpp2$threshold
  
  error1<-(Var1<mpp$mpp1$values[1:(mpp$biv$endtime)])
  error2<-(Var2<mpp$mpp2$values[1:(mpp$biv$endtime)])
  error<-cbind(as.numeric(error1),as.numeric(error2))
  
  
  error1<-error1*quantile(mpp$mpp1$values,0.9995)
  error2<-error2*quantile(mpp$mpp2$values,0.9995)
  
  error1[error1==0]<-NA
  error2[error2==0]<-NA
  
  Var1<-c(NA,Var1)
  Var2<-c(NA,Var2)
  
  m1<-mpp$mpp1$values
  m2<-mpp$mpp2$values
  m1[m1<=0]<-NA
  m2[m2<=0]<-NA
  
  layout(matrix(c(1,1,2,2,3,3),6,1))
  par(mar=c(0,4,1,1))
  plot(m1, ylim=range(m1[!is.na(m1)]*1.2),xaxt="n",ylab="Marks 1" ,xlab=" Times 1",col=1,cex=0.5)
  lines(c(Var1),col=8)
  points(error1,pch=3, cex=0.5)
  
  par(mar=c(0,4,1,1))
  plot(m2, ylim=range(m2[!is.na(m2)]*1.2),xaxt="n",ylab="Marks 2" ,xlab=" Times 2",col=2,cex=0.5) 
  lines(c(Var2),col=8)
  points(error2,pch=3, cex=0.5)
  
  
  par(mar=c(4,4,4,1))
  xx<-rowSums(cbind(y1,y2*2))
  plot(times,rep(1,length(times)),yaxt="n",col=xx,typ="h",ylim=c(0,1),ylab="Barcode plot",xlab="Pooled Process Time")
  
  
  list(error=error,VaR=cbind(Var1,Var2),VaRa=VaR,condInt1=condInt1, condInt2=condInt2,betaInt1=betaInt1,betaInt2=betaInt2,xx=xx, e1=e1,e2=e2)
  
  
}

Filter_ACI_POT3<-function(ACI,POT,mpp,VaR=0.99,unrestricted=F){


#ACI Part
param<-matrix(ACI$par,ncol=3)


times1<-mpp$mpp1$times
times2<-mpp$mpp2$times
times3<-mpp$mpp3$times

d1<-mpp$mpp1$durations
d2<-mpp$mpp2$durations
d3<-mpp$mpp3$durations

dur<-mpp$tri$durations
dur1<-mpp$tri$tridur1
dur2<-mpp$tri$tridur2
dur3<-mpp$tri$tridur3

times<-mpp$tri$times


n<-length(times)


y1<-as.numeric(times%in%times1)
y2<-as.numeric(times%in%times2)
y3<-as.numeric(times%in%times3)

 ind1<-y1*c(1:n)
 ind2<-y2*c(1:n)
 ind3<-y3*c(1:n)

marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
marks3<-(mpp$mpp3$marks+ mpp$mpp3$threshold)/mpp$mpp3$threshold

Marks1<-numeric(n)
Marks2<-numeric(n)
Marks3<-numeric(n)

Marks1[ind1[ind1>0]]<-marks1
Marks2[ind2[ind2>0]]<-marks2
Marks3[ind3[ind3>0]]<-marks3

Lambda01<-numeric(n)
psihat1<-rep(1,n)

condInt1<-rep(NA,times[n])



Lambda02<-numeric(n)
psihat2<-rep(1,n)

condInt2<-rep(NA,times[n])


Lambda03<-numeric(n)
psihat3<-rep(1,n)

condInt3<-rep(NA,times[n])


#Define Psi

alphas<-matriz3(param[1:3,])
betas<-matriz3(param[4:6,])
cova<-matriz3(param[dim(param)[1],])


# POT part


param1<-matriz3(POT$par)


n1<-length(marks1)
n2<-length(marks2)
n3<-length(marks3)

betahat1<-rep(0,n1)
betahat2<-rep(0,n2)
betahat3<-rep(0,n3)

delta0<-(matriz3(param1[1,]))
xi<-matriz3(param1[2,])
delta<-(matriz3(param1[3,]))
w<-(matriz3(param1[4,]))
covas<-(matriz3(param1[5,]))

marks1<-mpp$mpp1$marks
marks2<-mpp$mpp2$marks
marks3<-mpp$mpp3$marks






for ( i in 1:(n1-1)) betahat1[i+1]<-w[,1] +delta0[,1]*log(marks1[i])+delta[,1]*betahat1[i]+covas[,1]*d1[i+1]
for ( i in 1:(n2-1)) betahat2[i+1]<-w[,2] +delta0[,2]*log(marks2[i])+delta[,2]*betahat2[i]+covas[,2]*d2[i+1]
for ( i in 1:(n3-1)) betahat3[i+1]<-w[,3] +delta0[,3]*log(marks3[i])+delta[,3]*betahat3[i]+covas[,3]*d3[i+1]



 betaexp1<-exp(betahat1)*(1-xi[,1])
 betaexp2<-exp(betahat2)*(1-xi[,2])
 betaexp3<-exp(betahat3)*(1-xi[,3])

# define baselines

if(unrestricted==T){



  mu1<-matriz3(param[7,])
  sigma1<-matriz3(param[8,])
  Q1<-matriz3(param[9,])
  mu2<-matriz3(param[10,])
  sigma2<-matriz3(param[11,])
  Q2<-matriz3(param[12,])
  mu3<-matriz3(param[13,])
  sigma3<-matriz3(param[14,])
  Q3<-matriz3(param[15,])

  lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
  Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])

  lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
  Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])

  lambda03<-  hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])
  Lambda03<-Hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])* hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])



}

if(unrestricted==F){



  mu1<-matriz3(param[7,])
  sigma1<-matriz3(param[8,])
  Q1<-matriz3(param[9,])
 

  lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
  Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])

  lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
  Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])

  lambda03<-hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
  Lambda03<-Hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])






}


# random exponentials for psi
phi<-VARMA3(Lambda01,Lambda02,Lambda03,alphas,betas,n,y1,y2,y3)




psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
psi3<-exp(phi$psihat3 + cova[1,3]*Marks3)



e1<-1-(psi1*Lambda01)[ind1]
e2<-1-(psi2*Lambda02)[ind2]
e3<-1-(psi3*Lambda03)[ind3]


y.1<-real.time(d1)
r.psi1<-real.phi(psi1,dur)
r.betahat1<-real.phi(betaexp1,d1)

y.2<-real.time(d2)
r.psi2<-real.phi(psi2,dur)
r.betahat2<-real.phi(betaexp2,d2)

y.3<-real.time(d3)
r.psi3<-real.phi(psi3,dur)
r.betahat3<-real.phi(betaexp3,d3)


if(unrestricted==T){

   condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(y.3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
   condInt2<-r.psi2* hgengamma(y.1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(y.2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(y.3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
   condInt3<-r.psi3* hgengamma(y.1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(y.2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(y.3, mu=mu3[,3], sigma=sigma2[,3], Q=Q3[,3])

  }

  if(unrestricted==F){


   condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
   condInt2<-r.psi2* hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
   condInt3<-r.psi3* hgengamma(y.3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
 

  }


   betaInt1<- r.betahat1
   betaInt2<- r.betahat2
   betaInt3<- r.betahat3





   Var1<-quant(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
   Var2<-quant(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
   Var3<-quant(VaR,condInt3,xi[,3],betaInt3,mpp$mpp3$threshold)


ES1<-ES(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
ES2<-ES(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
ES3<-ES(VaR,condInt3,xi[,3],betaInt3,mpp$mpp3$threshold)

   Var1[is.infinite(Var1)]<-min(Var1)
   Var2[is.infinite(Var2)]<-min(Var2)
   Var3[is.infinite(Var3)]<-min(Var3)

    # Var1[Var1<mpp$mpp1$threshold]<-mpp$mpp1$threshold
    # Var2[Var2<mpp$mpp2$threshold]<-mpp$mpp2$threshold
    # Var3[Var3<mpp$mpp3$threshold]<-mpp$mpp3$threshold

   error1<-(Var1<mpp$mpp1$values[1:(mpp$tri$endtime)])
   error2<-(Var2<mpp$mpp2$values[1:(mpp$tri$endtime)])
   error3<-(Var3<mpp$mpp3$values[1:(mpp$tri$endtime)])
   
   
   VES1<-  mean((ES1-mpp$mpp1$values[1:(mpp$tri$endtime)])[error1],na.rm=T)
   VES2<-  mean((ES2-mpp$mpp2$values[1:(mpp$tri$endtime)])[error2],na.rm=T)
   VES3<-  mean((ES3-mpp$mpp3$values[1:(mpp$tri$endtime)])[error3],na.rm=T)
   
   VES<-cbind(VES1,VES2,VES3)

   error<-cbind(as.numeric(error1),as.numeric(error2),as.numeric(error3))

   error1<-error1*quantile(mpp$mpp1$values,0.9995)
   error2<-error2*quantile(mpp$mpp2$values,0.9995)
   error3<-error3*quantile(mpp$mpp3$values,0.9995)

   error1[error1==0]<-NA
   error2[error2==0]<-NA
   error3[error3==0]<-NA

   Var1<-c(NA,Var1)
   Var2<-c(NA,Var2)
   Var3<-c(NA,Var3)

   m1<-mpp$mpp1$values
   m2<-mpp$mpp2$values
   m3<-mpp$mpp3$values

   m1[m1<=0]<-NA
   m2[m2<=0]<-NA
   m3[m3<=0]<-NA

  layout(matrix(c(1,1,2,2,3,3,4,4),8,1))
   par(mar=c(0,4,1,1))
   plot(m1, ylim=range(marks1*1.5),xaxt="n",ylab="Marks 1" ,xlab=" Times 1",col=1,cex=0.5)
   lines(c(Var1),col=8)
   points(error1,pch=3, cex=0.5)

   par(mar=c(0,4,1,1))
   plot(m2, ylim=range(marks2*1.5),xaxt="n",ylab="Marks 2" ,xlab=" Times 2",col=2,cex=0.5)
   lines(c(Var2),col=8)
   points(error2,pch=3, cex=0.5)

   par(mar=c(0,4,1,1))
   plot(m3, ylim=range(marks3*1.5),xaxt="n",ylab="Marks 3" ,xlab=" Times 3",col=4,cex=0.5)
   lines(c(Var3),col=8)
   points(error3,pch=3, cex=0.5)

   par(mar=c(4,4,4,1))
   xx<-rowSums(cbind(y1,y2*2,y3*4))
   plot(times,rep(1,length(times)),yaxt="n",col=xx,typ="h",ylim=c(0,1),ylab="Barcode plot",xlab="Pooled Process Time")

   
 list(error=error,VaR=cbind(Var1,Var2,Var3),condInt1=condInt1, condInt2=condInt2,condInt3=condInt3,ES=cbind(ES1,ES2,ES3),VaRa=VaR,e1=e1,e2=e2,e3=e3, VES=VES)
}

Filter_ACI_POT3.1.2<-function(ACI,POT,mpp,VaR=0.99,unrestricted=F){
  
  
  #ACI Part
  param<-matrix(ACI$par,ncol=3)
  
  
  times1<-mpp$mpp1$times
  times2<-mpp$mpp2$times
  times3<-mpp$mpp3$times
  
  d1<-mpp$mpp1$durations
  d2<-mpp$mpp2$durations
  d3<-mpp$mpp3$durations
  
  dur<-mpp$tri$durations
  dur1<-mpp$tri$tridur1
  dur2<-mpp$tri$tridur2
  dur3<-mpp$tri$tridur3
  
  times<-mpp$tri$times
  
  
  n<-length(times)
  
  
  y1<-as.numeric(times%in%times1)
  y2<-as.numeric(times%in%times2)
  y3<-as.numeric(times%in%times3)
  
  ind1<-y1*c(1:n)
  ind2<-y2*c(1:n)
  ind3<-y3*c(1:n)
  
  marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
  marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
  marks3<-(mpp$mpp3$marks+ mpp$mpp3$threshold)/mpp$mpp3$threshold
  
  Marks1<-numeric(n)
  Marks2<-numeric(n)
  Marks3<-numeric(n)
  
  Marks1[ind1[ind1>0]]<-marks1
  Marks2[ind2[ind2>0]]<-marks2
  Marks3[ind3[ind3>0]]<-marks3
  
  Lambda01<-numeric(n)
  psihat1<-rep(1,n)
  
  condInt1<-rep(NA,times[n])
  
  
  
  Lambda02<-numeric(n)
  psihat2<-rep(1,n)
  
  condInt2<-rep(NA,times[n])
  
  
  Lambda03<-numeric(n)
  psihat3<-rep(1,n)
  
  condInt3<-rep(NA,times[n])
  
  
  #Define Psi
  
  alphas<-matriz3(param[1:3,])
  betas1<-matriz3(param[4:6,])
  betas2<-matriz3(param[7:9,])
  cova<-matriz3(param[dim(param)[1],])
  
  
  # POT part
  
  
  param1<-matriz3(POT$par)
  
  
  n1<-length(marks1)
  n2<-length(marks2)
  n3<-length(marks3)
  
  betahat1<-rep(0,n1)
  betahat2<-rep(0,n2)
  betahat3<-rep(0,n3)
  
  delta0<-(matriz3(param1[1,]))
  xi<-matriz3(param1[2,])
  delta<-(matriz3(param1[3,]))
  w<-(matriz3(param1[4,]))
  covas<-(matriz3(param1[5,]))
  
  marks1<-mpp$mpp1$marks
  marks2<-mpp$mpp2$marks
  marks3<-mpp$mpp3$marks
  
  
  
  
  
  
  for ( i in 1:(n1-1)) betahat1[i+1]<-w[,1] +delta0[,1]*log(marks1[i])+delta[,1]*betahat1[i]+covas[,1]*d1[i+1]
  for ( i in 1:(n2-1)) betahat2[i+1]<-w[,2] +delta0[,2]*log(marks2[i])+delta[,2]*betahat2[i]+covas[,2]*d2[i+1]
  for ( i in 1:(n3-1)) betahat3[i+1]<-w[,3] +delta0[,3]*log(marks3[i])+delta[,3]*betahat3[i]+covas[,3]*d3[i+1]
  
  
  
  betaexp1<-exp(betahat1)*(1-xi[,1])
  betaexp2<-exp(betahat2)*(1-xi[,2])
  betaexp3<-exp(betahat3)*(1-xi[,3])
  
  # define baselines
  
  if(unrestricted==T){
    
    
    
    mu1<-matriz3(param[7,])
    sigma1<-matriz3(param[8,])
    Q1<-matriz3(param[9,])
    mu2<-matriz3(param[10,])
    sigma2<-matriz3(param[11,])
    Q2<-matriz3(param[12,])
    mu3<-matriz3(param[13,])
    sigma3<-matriz3(param[14,])
    Q3<-matriz3(param[15,])
    
    lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    
    lambda03<-  hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])
    Lambda03<-Hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])* hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])
    
    
    
  }
  
  if(unrestricted==F){
    
    
    
    mu1<-matriz3(param[10,])
    sigma1<-matriz3(param[11,])
    Q1<-matriz3(param[12,])
    
    
    lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    
    lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
    lambda03<-hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda03<-Hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    
    
    
    
    
  }
  
  
  # random exponentials for psi
  phi<-VARMA3.1.2(Lambda01,Lambda02,Lambda03,alphas,betas1,betas2,n,y1,y2,y3)
  
  
  
  
  psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
  psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
  psi3<-exp(phi$psihat3 + cova[1,3]*Marks3)
  
  
  
  e1<-1-(psi1*Lambda01)[ind1]
  e2<-1-(psi2*Lambda02)[ind2]
  e3<-1-(psi3*Lambda03)[ind3]
  
  
  y.1<-real.time(d1)
  r.psi1<-real.phi(psi1,dur)
  r.betahat1<-real.phi(betaexp1,d1)
  
  y.2<-real.time(d2)
  r.psi2<-real.phi(psi2,dur)
  r.betahat2<-real.phi(betaexp2,d2)
  
  y.3<-real.time(d3)
  r.psi3<-real.phi(psi3,dur)
  r.betahat3<-real.phi(betaexp3,d3)
  
  
  if(unrestricted==T){
    
    condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(y.3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    condInt2<-r.psi2* hgengamma(y.1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(y.2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(y.3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    condInt3<-r.psi3* hgengamma(y.1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(y.2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(y.3, mu=mu3[,3], sigma=sigma2[,3], Q=Q3[,3])
    
  }
  
  if(unrestricted==F){
    
    
    condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    condInt2<-r.psi2* hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    condInt3<-r.psi3* hgengamma(y.3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    
  }
  
  
  betaInt1<- r.betahat1
  betaInt2<- r.betahat2
  betaInt3<- r.betahat3
  
  
  
  
  
  Var1<-quant(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
  Var2<-quant(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
  Var3<-quant(VaR,condInt3,xi[,3],betaInt3,mpp$mpp3$threshold)
  
  
  ES1<-ES(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
  ES2<-ES(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
  ES3<-ES(VaR,condInt3,xi[,3],betaInt3,mpp$mpp3$threshold)
  
  Var1[is.infinite(Var1)]<-min(Var1)
  Var2[is.infinite(Var2)]<-min(Var2)
  Var3[is.infinite(Var3)]<-min(Var3)
  
  # Var1[Var1<mpp$mpp1$threshold]<-mpp$mpp1$threshold
  # Var2[Var2<mpp$mpp2$threshold]<-mpp$mpp2$threshold
  # Var3[Var3<mpp$mpp3$threshold]<-mpp$mpp3$threshold
  
  error1<-(Var1<mpp$mpp1$values[1:(mpp$tri$endtime)])
  error2<-(Var2<mpp$mpp2$values[1:(mpp$tri$endtime)])
  error3<-(Var3<mpp$mpp3$values[1:(mpp$tri$endtime)])
  
  
  VES1<-  mean((ES1-mpp$mpp1$values[1:(mpp$tri$endtime)])[error1],na.rm=T)
  VES2<-  mean((ES2-mpp$mpp2$values[1:(mpp$tri$endtime)])[error2],na.rm=T)
  VES3<-  mean((ES3-mpp$mpp3$values[1:(mpp$tri$endtime)])[error3],na.rm=T)
  
  VES<-cbind(VES1,VES2,VES3)
  
  error<-cbind(as.numeric(error1),as.numeric(error2),as.numeric(error3))
  
  error1<-error1*quantile(mpp$mpp1$values,0.9995)
  error2<-error2*quantile(mpp$mpp2$values,0.9995)
  error3<-error3*quantile(mpp$mpp3$values,0.9995)
  
  error1[error1==0]<-NA
  error2[error2==0]<-NA
  error3[error3==0]<-NA
  
  Var1<-c(NA,Var1)
  Var2<-c(NA,Var2)
  Var3<-c(NA,Var3)
  
  m1<-mpp$mpp1$values
  m2<-mpp$mpp2$values
  m3<-mpp$mpp3$values
  
  m1[m1<=0]<-NA
  m2[m2<=0]<-NA
  m3[m3<=0]<-NA
  
  layout(matrix(c(1,1,2,2,3,3,4,4),8,1))
  par(mar=c(0,4,1,1))
  plot(m1, ylim=range(marks1*1.5),xaxt="n",ylab="Marks 1" ,xlab=" Times 1",col=1,cex=0.5)
  lines(c(Var1),col=8)
  points(error1,pch=3, cex=0.5)
  
  par(mar=c(0,4,1,1))
  plot(m2, ylim=range(marks2*1.5),xaxt="n",ylab="Marks 2" ,xlab=" Times 2",col=2,cex=0.5)
  lines(c(Var2),col=8)
  points(error2,pch=3, cex=0.5)
  
  par(mar=c(0,4,1,1))
  plot(m3, ylim=range(marks3*1.5),xaxt="n",ylab="Marks 3" ,xlab=" Times 3",col=4,cex=0.5)
  lines(c(Var3),col=8)
  points(error3,pch=3, cex=0.5)
  
  par(mar=c(4,4,4,1))
  xx<-rowSums(cbind(y1,y2*2,y3*4))
  plot(times,rep(1,length(times)),yaxt="n",col=xx,typ="h",ylim=c(0,1),ylab="Barcode plot",xlab="Pooled Process Time")
  
  
  list(error=error,VaR=cbind(Var1,Var2,Var3),condInt1=condInt1, condInt2=condInt2,condInt3=condInt3,ES=cbind(ES1,ES2,ES3),VaRa=VaR,e1=e1,e2=e2,e3=e3, VES=VES)
}

Filter_ACI_POT3.1.3<-function(ACI,POT,mpp,VaR=0.99,unrestricted=F){
  
  
  #ACI Part
  param<-matrix(ACI$par,ncol=3)
  
  
  times1<-mpp$mpp1$times
  times2<-mpp$mpp2$times
  times3<-mpp$mpp3$times
  
  d1<-mpp$mpp1$durations
  d2<-mpp$mpp2$durations
  d3<-mpp$mpp3$durations
  
  dur<-mpp$tri$durations
  dur1<-mpp$tri$tridur1
  dur2<-mpp$tri$tridur2
  dur3<-mpp$tri$tridur3
  
  times<-mpp$tri$times
  
  
  n<-length(times)
  
  
  y1<-as.numeric(times%in%times1)
  y2<-as.numeric(times%in%times2)
  y3<-as.numeric(times%in%times3)
  
  ind1<-y1*c(1:n)
  ind2<-y2*c(1:n)
  ind3<-y3*c(1:n)
  
  marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
  marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
  marks3<-(mpp$mpp3$marks+ mpp$mpp3$threshold)/mpp$mpp3$threshold
  
  Marks1<-numeric(n)
  Marks2<-numeric(n)
  Marks3<-numeric(n)
  
  Marks1[ind1[ind1>0]]<-marks1
  Marks2[ind2[ind2>0]]<-marks2
  Marks3[ind3[ind3>0]]<-marks3
  
  Lambda01<-numeric(n)
  psihat1<-rep(1,n)
  
  condInt1<-rep(NA,times[n])
  
  
  
  Lambda02<-numeric(n)
  psihat2<-rep(1,n)
  
  condInt2<-rep(NA,times[n])
  
  
  Lambda03<-numeric(n)
  psihat3<-rep(1,n)
  
  condInt3<-rep(NA,times[n])
  
  
  #Define Psi
  
  alphas<-matriz3(param[1:3,])
  betas1<-matriz3(param[4:6,])
  betas2<-matriz3(param[7:9,])
  betas3<-matriz3(param[10:12,])
  cova<-matriz3(param[dim(param)[1],])
  
  
  # POT part
  
  
  param1<-matriz3(POT$par)
  
  
  n1<-length(marks1)
  n2<-length(marks2)
  n3<-length(marks3)
  
  betahat1<-rep(0,n1)
  betahat2<-rep(0,n2)
  betahat3<-rep(0,n3)
  
  delta0<-(matriz3(param1[1,]))
  xi<-matriz3(param1[2,])
  delta<-(matriz3(param1[3,]))
  w<-(matriz3(param1[4,]))
  covas<-(matriz3(param1[5,]))
  
  marks1<-mpp$mpp1$marks
  marks2<-mpp$mpp2$marks
  marks3<-mpp$mpp3$marks
  
  
  
  
  
  
  for ( i in 1:(n1-1)) betahat1[i+1]<-w[,1] +delta0[,1]*log(marks1[i])+delta[,1]*betahat1[i]+covas[,1]*d1[i+1]
  for ( i in 1:(n2-1)) betahat2[i+1]<-w[,2] +delta0[,2]*log(marks2[i])+delta[,2]*betahat2[i]+covas[,2]*d2[i+1]
  for ( i in 1:(n3-1)) betahat3[i+1]<-w[,3] +delta0[,3]*log(marks3[i])+delta[,3]*betahat3[i]+covas[,3]*d3[i+1]
  
  
  
  betaexp1<-exp(betahat1)*(1-xi[,1])
  betaexp2<-exp(betahat2)*(1-xi[,2])
  betaexp3<-exp(betahat3)*(1-xi[,3])
  
  # define baselines
  
  if(unrestricted==T){
    
    
    
    mu1<-matriz3(param[7,])
    sigma1<-matriz3(param[8,])
    Q1<-matriz3(param[9,])
    mu2<-matriz3(param[10,])
    sigma2<-matriz3(param[11,])
    Q2<-matriz3(param[12,])
    mu3<-matriz3(param[13,])
    sigma3<-matriz3(param[14,])
    Q3<-matriz3(param[15,])
    
    lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    
    lambda03<-  hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])
    Lambda03<-Hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])* hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])
    
    
    
  }
  
  if(unrestricted==F){
    
    
    
    mu1<-matriz3(param[13,])
    sigma1<-matriz3(param[14,])
    Q1<-matriz3(param[15,])
    
    
    lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    
    lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
    lambda03<-hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda03<-Hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    
    
    
    
    
  }
  
  
  # random exponentials for psi
  phi<-VARMA3.1.3(Lambda01,Lambda02,Lambda03,alphas,betas1,betas2,betas3,n,y1,y2,y3)
  
  
  
  
  psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
  psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
  psi3<-exp(phi$psihat3 + cova[1,3]*Marks3)
  
  
  
  e1<-1-(psi1*Lambda01)[ind1]
  e2<-1-(psi2*Lambda02)[ind2]
  e3<-1-(psi3*Lambda03)[ind3]
  
  
  y.1<-real.time(d1)
  r.psi1<-real.phi(psi1,dur)
  r.betahat1<-real.phi(betaexp1,d1)
  
  y.2<-real.time(d2)
  r.psi2<-real.phi(psi2,dur)
  r.betahat2<-real.phi(betaexp2,d2)
  
  y.3<-real.time(d3)
  r.psi3<-real.phi(psi3,dur)
  r.betahat3<-real.phi(betaexp3,d3)
  
  
  if(unrestricted==T){
    
    condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(y.3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    condInt2<-r.psi2* hgengamma(y.1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(y.2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(y.3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    condInt3<-r.psi3* hgengamma(y.1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(y.2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(y.3, mu=mu3[,3], sigma=sigma2[,3], Q=Q3[,3])
    
  }
  
  if(unrestricted==F){
    
    
    condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    condInt2<-r.psi2* hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    condInt3<-r.psi3* hgengamma(y.3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    
  }
  
  
  betaInt1<- r.betahat1
  betaInt2<- r.betahat2
  betaInt3<- r.betahat3
  
  
  
  
  
  Var1<-quant(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
  Var2<-quant(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
  Var3<-quant(VaR,condInt3,xi[,3],betaInt3,mpp$mpp3$threshold)
  
  
  ES1<-ES(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
  ES2<-ES(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
  ES3<-ES(VaR,condInt3,xi[,3],betaInt3,mpp$mpp3$threshold)
  
  Var1[is.infinite(Var1)]<-min(Var1)
  Var2[is.infinite(Var2)]<-min(Var2)
  Var3[is.infinite(Var3)]<-min(Var3)
  
  # Var1[Var1<mpp$mpp1$threshold]<-mpp$mpp1$threshold
  # Var2[Var2<mpp$mpp2$threshold]<-mpp$mpp2$threshold
  # Var3[Var3<mpp$mpp3$threshold]<-mpp$mpp3$threshold
  
  error1<-(Var1<mpp$mpp1$values[1:(mpp$tri$endtime)])
  error2<-(Var2<mpp$mpp2$values[1:(mpp$tri$endtime)])
  error3<-(Var3<mpp$mpp3$values[1:(mpp$tri$endtime)])
  
  
  VES1<-  mean((ES1-mpp$mpp1$values[1:(mpp$tri$endtime)])[error1],na.rm=T)
  VES2<-  mean((ES2-mpp$mpp2$values[1:(mpp$tri$endtime)])[error2],na.rm=T)
  VES3<-  mean((ES3-mpp$mpp3$values[1:(mpp$tri$endtime)])[error3],na.rm=T)
  
  VES<-cbind(VES1,VES2,VES3)
  
  error<-cbind(as.numeric(error1),as.numeric(error2),as.numeric(error3))
  
  error1<-error1*quantile(mpp$mpp1$values,0.9995)
  error2<-error2*quantile(mpp$mpp2$values,0.9995)
  error3<-error3*quantile(mpp$mpp3$values,0.9995)
  
  error1[error1==0]<-NA
  error2[error2==0]<-NA
  error3[error3==0]<-NA
  
  Var1<-c(NA,Var1)
  Var2<-c(NA,Var2)
  Var3<-c(NA,Var3)
  
  m1<-mpp$mpp1$values
  m2<-mpp$mpp2$values
  m3<-mpp$mpp3$values
  
  m1[m1<=0]<-NA
  m2[m2<=0]<-NA
  m3[m3<=0]<-NA
  
  layout(matrix(c(1,1,2,2,3,3,4,4),8,1))
  par(mar=c(0,4,1,1))
  plot(m1, ylim=range(marks1*1.5),xaxt="n",ylab="Marks 1" ,xlab=" Times 1",col=1,cex=0.5)
  lines(c(Var1),col=8)
  points(error1,pch=3, cex=0.5)
  
  par(mar=c(0,4,1,1))
  plot(m2, ylim=range(marks2*1.5),xaxt="n",ylab="Marks 2" ,xlab=" Times 2",col=2,cex=0.5)
  lines(c(Var2),col=8)
  points(error2,pch=3, cex=0.5)
  
  par(mar=c(0,4,1,1))
  plot(m3, ylim=range(marks3*1.5),xaxt="n",ylab="Marks 3" ,xlab=" Times 3",col=4,cex=0.5)
  lines(c(Var3),col=8)
  points(error3,pch=3, cex=0.5)
  
  par(mar=c(4,4,4,1))
  xx<-rowSums(cbind(y1,y2*2,y3*4))
  plot(times,rep(1,length(times)),yaxt="n",col=xx,typ="h",ylim=c(0,1),ylab="Barcode plot",xlab="Pooled Process Time")
  
  
  list(error=error,VaR=cbind(Var1,Var2,Var3),condInt1=condInt1, condInt2=condInt2,condInt3=condInt3,ES=cbind(ES1,ES2,ES3),VaRa=VaR,e1=e1,e2=e2,e3=e3, VES=VES)
}
Filter_ACI_POT3.2.1<-function(ACI,POT,mpp,VaR=0.99,unrestricted=F){
  
  
  #ACI Part
  param<-matrix(ACI$par,ncol=3)
  
  
  times1<-mpp$mpp1$times
  times2<-mpp$mpp2$times
  times3<-mpp$mpp3$times
  
  d1<-mpp$mpp1$durations
  d2<-mpp$mpp2$durations
  d3<-mpp$mpp3$durations
  
  dur<-mpp$tri$durations
  dur1<-mpp$tri$tridur1
  dur2<-mpp$tri$tridur2
  dur3<-mpp$tri$tridur3
  
  times<-mpp$tri$times
  
  
  n<-length(times)
  
  
  y1<-as.numeric(times%in%times1)
  y2<-as.numeric(times%in%times2)
  y3<-as.numeric(times%in%times3)
  
  ind1<-y1*c(1:n)
  ind2<-y2*c(1:n)
  ind3<-y3*c(1:n)
  
  marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
  marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
  marks3<-(mpp$mpp3$marks+ mpp$mpp3$threshold)/mpp$mpp3$threshold
  
  Marks1<-numeric(n)
  Marks2<-numeric(n)
  Marks3<-numeric(n)
  
  Marks1[ind1[ind1>0]]<-marks1
  Marks2[ind2[ind2>0]]<-marks2
  Marks3[ind3[ind3>0]]<-marks3
  
  Lambda01<-numeric(n)
  psihat1<-rep(1,n)
  
  condInt1<-rep(NA,times[n])
  
  
  
  Lambda02<-numeric(n)
  psihat2<-rep(1,n)
  
  condInt2<-rep(NA,times[n])
  
  
  Lambda03<-numeric(n)
  psihat3<-rep(1,n)
  
  condInt3<-rep(NA,times[n])
  
  
  #Define Psi
  
  alphas1<-matriz3(param[1:3,])
  alphas2<-matriz3(param[4:6,])
  betas1<-matriz3(param[7:9,])
  cova<-matriz3(param[dim(param)[1],])
  
  
  # POT part
  
  
  param1<-matriz3(POT$par)
  
  
  n1<-length(marks1)
  n2<-length(marks2)
  n3<-length(marks3)
  
  betahat1<-rep(0,n1)
  betahat2<-rep(0,n2)
  betahat3<-rep(0,n3)
  
  delta0<-(matriz3(param1[1,]))
  xi<-matriz3(param1[2,])
  delta<-(matriz3(param1[3,]))
  w<-(matriz3(param1[4,]))
  covas<-(matriz3(param1[5,]))
  
  marks1<-mpp$mpp1$marks
  marks2<-mpp$mpp2$marks
  marks3<-mpp$mpp3$marks
  
  
  
  
  
  
  for ( i in 1:(n1-1)) betahat1[i+1]<-w[,1] +delta0[,1]*log(marks1[i])+delta[,1]*betahat1[i]+covas[,1]*d1[i+1]
  for ( i in 1:(n2-1)) betahat2[i+1]<-w[,2] +delta0[,2]*log(marks2[i])+delta[,2]*betahat2[i]+covas[,2]*d2[i+1]
  for ( i in 1:(n3-1)) betahat3[i+1]<-w[,3] +delta0[,3]*log(marks3[i])+delta[,3]*betahat3[i]+covas[,3]*d3[i+1]
  
  
  
  betaexp1<-exp(betahat1)*(1-xi[,1])
  betaexp2<-exp(betahat2)*(1-xi[,2])
  betaexp3<-exp(betahat3)*(1-xi[,3])
  
  # define baselines
  
  if(unrestricted==T){
    
    
    
    mu1<-matriz3(param[7,])
    sigma1<-matriz3(param[8,])
    Q1<-matriz3(param[9,])
    mu2<-matriz3(param[10,])
    sigma2<-matriz3(param[11,])
    Q2<-matriz3(param[12,])
    mu3<-matriz3(param[13,])
    sigma3<-matriz3(param[14,])
    Q3<-matriz3(param[15,])
    
    lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    
    lambda03<-  hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])
    Lambda03<-Hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])* hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])
    
    
    
  }
  
  if(unrestricted==F){
    
    
    
    mu1<-matriz3(param[10,])
    sigma1<-matriz3(param[11,])
    Q1<-matriz3(param[12,])
    
    
    lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    
    lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
    lambda03<-hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda03<-Hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    
    
    
    
    
  }
  
  
  # random exponentials for psi
  phi<-VARMA3.2.1(Lambda01,Lambda02,Lambda03,alphas1,alphas2,betas1,n,y1,y2,y3)
  
  
  
  
  psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
  psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
  psi3<-exp(phi$psihat3 + cova[1,3]*Marks3)
  
  
  
  e1<-1-(psi1*Lambda01)[ind1]
  e2<-1-(psi2*Lambda02)[ind2]
  e3<-1-(psi3*Lambda03)[ind3]
  
  
  y.1<-real.time(d1)
  r.psi1<-real.phi(psi1,dur)
  r.betahat1<-real.phi(betaexp1,d1)
  
  y.2<-real.time(d2)
  r.psi2<-real.phi(psi2,dur)
  r.betahat2<-real.phi(betaexp2,d2)
  
  y.3<-real.time(d3)
  r.psi3<-real.phi(psi3,dur)
  r.betahat3<-real.phi(betaexp3,d3)
  
  
  if(unrestricted==T){
    
    condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(y.3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    condInt2<-r.psi2* hgengamma(y.1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(y.2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(y.3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    condInt3<-r.psi3* hgengamma(y.1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(y.2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(y.3, mu=mu3[,3], sigma=sigma2[,3], Q=Q3[,3])
    
  }
  
  if(unrestricted==F){
    
    
    condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    condInt2<-r.psi2* hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    condInt3<-r.psi3* hgengamma(y.3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    
  }
  
  
  betaInt1<- r.betahat1
  betaInt2<- r.betahat2
  betaInt3<- r.betahat3
  
  
  
  
  
  Var1<-quant(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
  Var2<-quant(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
  Var3<-quant(VaR,condInt3,xi[,3],betaInt3,mpp$mpp3$threshold)
  
  
  ES1<-ES(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
  ES2<-ES(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
  ES3<-ES(VaR,condInt3,xi[,3],betaInt3,mpp$mpp3$threshold)
  
  Var1[is.infinite(Var1)]<-min(Var1)
  Var2[is.infinite(Var2)]<-min(Var2)
  Var3[is.infinite(Var3)]<-min(Var3)
  
  # Var1[Var1<mpp$mpp1$threshold]<-mpp$mpp1$threshold
  # Var2[Var2<mpp$mpp2$threshold]<-mpp$mpp2$threshold
  # Var3[Var3<mpp$mpp3$threshold]<-mpp$mpp3$threshold
  
  error1<-(Var1<mpp$mpp1$values[1:(mpp$tri$endtime)])
  error2<-(Var2<mpp$mpp2$values[1:(mpp$tri$endtime)])
  error3<-(Var3<mpp$mpp3$values[1:(mpp$tri$endtime)])
  
  
  VES1<-  mean((ES1-mpp$mpp1$values[1:(mpp$tri$endtime)])[error1],na.rm=T)
  VES2<-  mean((ES2-mpp$mpp2$values[1:(mpp$tri$endtime)])[error2],na.rm=T)
  VES3<-  mean((ES3-mpp$mpp3$values[1:(mpp$tri$endtime)])[error3],na.rm=T)
  
  VES<-cbind(VES1,VES2,VES3)
  
  error<-cbind(as.numeric(error1),as.numeric(error2),as.numeric(error3))
  
  error1<-error1*quantile(mpp$mpp1$values,0.9995)
  error2<-error2*quantile(mpp$mpp2$values,0.9995)
  error3<-error3*quantile(mpp$mpp3$values,0.9995)
  
  error1[error1==0]<-NA
  error2[error2==0]<-NA
  error3[error3==0]<-NA
  
  Var1<-c(NA,Var1)
  Var2<-c(NA,Var2)
  Var3<-c(NA,Var3)
  
  m1<-mpp$mpp1$values
  m2<-mpp$mpp2$values
  m3<-mpp$mpp3$values
  
  m1[m1<=0]<-NA
  m2[m2<=0]<-NA
  m3[m3<=0]<-NA
  
  layout(matrix(c(1,1,2,2,3,3,4,4),8,1))
  par(mar=c(0,4,1,1))
  plot(m1, ylim=range(marks1*1.5),xaxt="n",ylab="Marks 1" ,xlab=" Times 1",col=1,cex=0.5)
  lines(c(Var1),col=8)
  points(error1,pch=3, cex=0.5)
  
  par(mar=c(0,4,1,1))
  plot(m2, ylim=range(marks2*1.5),xaxt="n",ylab="Marks 2" ,xlab=" Times 2",col=2,cex=0.5)
  lines(c(Var2),col=8)
  points(error2,pch=3, cex=0.5)
  
  par(mar=c(0,4,1,1))
  plot(m3, ylim=range(marks3*1.5),xaxt="n",ylab="Marks 3" ,xlab=" Times 3",col=4,cex=0.5)
  lines(c(Var3),col=8)
  points(error3,pch=3, cex=0.5)
  
  par(mar=c(4,4,4,1))
  xx<-rowSums(cbind(y1,y2*2,y3*4))
  plot(times,rep(1,length(times)),yaxt="n",col=xx,typ="h",ylim=c(0,1),ylab="Barcode plot",xlab="Pooled Process Time")
  
  
  list(error=error,VaR=cbind(Var1,Var2,Var3),condInt1=condInt1, condInt2=condInt2,condInt3=condInt3,ES=cbind(ES1,ES2,ES3),VaRa=VaR,e1=e1,e2=e2,e3=e3, VES=VES)
}

Filter_ACI_POT3.2.2<-function(ACI,POT,mpp,VaR=0.99,unrestricted=F){
  
  
  #ACI Part
  param<-matrix(ACI$par,ncol=3)
  
  
  times1<-mpp$mpp1$times
  times2<-mpp$mpp2$times
  times3<-mpp$mpp3$times
  
  d1<-mpp$mpp1$durations
  d2<-mpp$mpp2$durations
  d3<-mpp$mpp3$durations
  
  dur<-mpp$tri$durations
  dur1<-mpp$tri$tridur1
  dur2<-mpp$tri$tridur2
  dur3<-mpp$tri$tridur3
  
  times<-mpp$tri$times
  
  
  n<-length(times)
  
  
  y1<-as.numeric(times%in%times1)
  y2<-as.numeric(times%in%times2)
  y3<-as.numeric(times%in%times3)
  
  ind1<-y1*c(1:n)
  ind2<-y2*c(1:n)
  ind3<-y3*c(1:n)
  
  marks1<-(mpp$mpp1$marks+ mpp$mpp1$threshold)/mpp$mpp1$threshold
  marks2<-(mpp$mpp2$marks+ mpp$mpp2$threshold)/mpp$mpp2$threshold
  marks3<-(mpp$mpp3$marks+ mpp$mpp3$threshold)/mpp$mpp3$threshold
  
  Marks1<-numeric(n)
  Marks2<-numeric(n)
  Marks3<-numeric(n)
  
  Marks1[ind1[ind1>0]]<-marks1
  Marks2[ind2[ind2>0]]<-marks2
  Marks3[ind3[ind3>0]]<-marks3
  
  Lambda01<-numeric(n)
  psihat1<-rep(1,n)
  
  condInt1<-rep(NA,times[n])
  
  
  
  Lambda02<-numeric(n)
  psihat2<-rep(1,n)
  
  condInt2<-rep(NA,times[n])
  
  
  Lambda03<-numeric(n)
  psihat3<-rep(1,n)
  
  condInt3<-rep(NA,times[n])
  
  
  #Define Psi
  
  alphas1<-matriz3(param[1:3,])
  alphas2<-matriz3(param[4:6,])
  betas1<-matriz3(param[7:9,])
  betas2<-matriz3(param[10:12,])
  cova<-matriz3(param[dim(param)[1],])
  
  
  # POT part
  
  
  param1<-matriz3(POT$par)
  
  
  n1<-length(marks1)
  n2<-length(marks2)
  n3<-length(marks3)
  
  betahat1<-rep(0,n1)
  betahat2<-rep(0,n2)
  betahat3<-rep(0,n3)
  
  delta0<-(matriz3(param1[1,]))
  xi<-matriz3(param1[2,])
  delta<-(matriz3(param1[3,]))
  w<-(matriz3(param1[4,]))
  covas<-(matriz3(param1[5,]))
  
  marks1<-mpp$mpp1$marks
  marks2<-mpp$mpp2$marks
  marks3<-mpp$mpp3$marks
  
  
  
  
  
  
  for ( i in 1:(n1-1)) betahat1[i+1]<-w[,1] +delta0[,1]*log(marks1[i])+delta[,1]*betahat1[i]+covas[,1]*d1[i+1]
  for ( i in 1:(n2-1)) betahat2[i+1]<-w[,2] +delta0[,2]*log(marks2[i])+delta[,2]*betahat2[i]+covas[,2]*d2[i+1]
  for ( i in 1:(n3-1)) betahat3[i+1]<-w[,3] +delta0[,3]*log(marks3[i])+delta[,3]*betahat3[i]+covas[,3]*d3[i+1]
  
  
  
  betaexp1<-exp(betahat1)*(1-xi[,1])
  betaexp2<-exp(betahat2)*(1-xi[,2])
  betaexp3<-exp(betahat3)*(1-xi[,3])
  
  # define baselines
  
  if(unrestricted==T){
    
    
    
    mu1<-matriz3(param[7,])
    sigma1<-matriz3(param[8,])
    Q1<-matriz3(param[9,])
    mu2<-matriz3(param[10,])
    sigma2<-matriz3(param[11,])
    Q2<-matriz3(param[12,])
    mu3<-matriz3(param[13,])
    sigma3<-matriz3(param[14,])
    Q3<-matriz3(param[15,])
    
    lambda01<- hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    lambda02<-  hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    Lambda02<-Hgengamma(dur2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])* hgengamma(dur1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(dur3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    
    lambda03<-  hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])
    Lambda03<-Hgengamma(dur3, mu=mu3[,3], sigma=sigma3[,3], Q=Q3[,3])* hgengamma(dur1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(dur2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])
    
    
    
  }
  
  if(unrestricted==F){
    
    
    
    mu1<-matriz3(param[13,])
    sigma1<-matriz3(param[14,])
    Q1<-matriz3(param[15,])
    
    
    lambda01<-hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    Lambda01<-Hgengamma(dur1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    
    lambda02<-hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    Lambda02<-Hgengamma(dur2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    
    lambda03<-hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    Lambda03<-Hgengamma(dur3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    
    
    
    
    
  }
  
  
  # random exponentials for psi
  phi<-VARMA3.2.2(Lambda01,Lambda02,Lambda03,alphas1,alphas2,betas1,betas2,n,y1,y2,y3)
  
  
  
  
  psi1<-exp(phi$psihat1 + cova[1,1]*Marks1)
  psi2<-exp(phi$psihat2 + cova[1,2]*Marks2)
  psi3<-exp(phi$psihat3 + cova[1,3]*Marks3)
  
  
  
  e1<-1-(psi1*Lambda01)[ind1]
  e2<-1-(psi2*Lambda02)[ind2]
  e3<-1-(psi3*Lambda03)[ind3]
  
  
  y.1<-real.time(d1)
  r.psi1<-real.phi(psi1,dur)
  r.betahat1<-real.phi(betaexp1,d1)
  
  y.2<-real.time(d2)
  r.psi2<-real.phi(psi2,dur)
  r.betahat2<-real.phi(betaexp2,d2)
  
  y.3<-real.time(d3)
  r.psi3<-real.phi(psi3,dur)
  r.betahat3<-real.phi(betaexp3,d3)
  
  
  if(unrestricted==T){
    
    condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])*hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])*hgengamma(y.3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    condInt2<-r.psi2* hgengamma(y.1, mu=mu2[,1], sigma=sigma2[,1], Q=Q2[,1])*hgengamma(y.2, mu=mu2[,2], sigma=sigma2[,2], Q=Q2[,2])*hgengamma(y.3, mu=mu2[,3], sigma=sigma2[,3], Q=Q2[,3])
    condInt3<-r.psi3* hgengamma(y.1, mu=mu3[,1], sigma=sigma3[,1], Q=Q3[,1])*hgengamma(y.2, mu=mu3[,2], sigma=sigma3[,2], Q=Q3[,2])*hgengamma(y.3, mu=mu3[,3], sigma=sigma2[,3], Q=Q3[,3])
    
  }
  
  if(unrestricted==F){
    
    
    condInt1<-r.psi1* hgengamma(y.1, mu=mu1[,1], sigma=sigma1[,1], Q=Q1[,1])
    condInt2<-r.psi2* hgengamma(y.2, mu=mu1[,2], sigma=sigma1[,2], Q=Q1[,2])
    condInt3<-r.psi3* hgengamma(y.3, mu=mu1[,3], sigma=sigma1[,3], Q=Q1[,3])
    
    
  }
  
  
  betaInt1<- r.betahat1
  betaInt2<- r.betahat2
  betaInt3<- r.betahat3
  
  
  
  
  
  Var1<-quant(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
  Var2<-quant(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
  Var3<-quant(VaR,condInt3,xi[,3],betaInt3,mpp$mpp3$threshold)
  
  
  ES1<-ES(VaR,condInt1,xi[,1],betaInt1,mpp$mpp1$threshold)
  ES2<-ES(VaR,condInt2,xi[,2],betaInt2,mpp$mpp2$threshold)
  ES3<-ES(VaR,condInt3,xi[,3],betaInt3,mpp$mpp3$threshold)
  
  Var1[is.infinite(Var1)]<-min(Var1)
  Var2[is.infinite(Var2)]<-min(Var2)
  Var3[is.infinite(Var3)]<-min(Var3)
  
  # Var1[Var1<mpp$mpp1$threshold]<-mpp$mpp1$threshold
  # Var2[Var2<mpp$mpp2$threshold]<-mpp$mpp2$threshold
  # Var3[Var3<mpp$mpp3$threshold]<-mpp$mpp3$threshold
  
  error1<-(Var1<mpp$mpp1$values[1:(mpp$tri$endtime)])
  error2<-(Var2<mpp$mpp2$values[1:(mpp$tri$endtime)])
  error3<-(Var3<mpp$mpp3$values[1:(mpp$tri$endtime)])
  
  
  VES1<-  mean((ES1-mpp$mpp1$values[1:(mpp$tri$endtime)])[error1],na.rm=T)
  VES2<-  mean((ES2-mpp$mpp2$values[1:(mpp$tri$endtime)])[error2],na.rm=T)
  VES3<-  mean((ES3-mpp$mpp3$values[1:(mpp$tri$endtime)])[error3],na.rm=T)
  
  VES<-cbind(VES1,VES2,VES3)
  
  error<-cbind(as.numeric(error1),as.numeric(error2),as.numeric(error3))
  
  error1<-error1*quantile(mpp$mpp1$values,0.9995)
  error2<-error2*quantile(mpp$mpp2$values,0.9995)
  error3<-error3*quantile(mpp$mpp3$values,0.9995)
  
  error1[error1==0]<-NA
  error2[error2==0]<-NA
  error3[error3==0]<-NA
  
  Var1<-c(NA,Var1)
  Var2<-c(NA,Var2)
  Var3<-c(NA,Var3)
  
  m1<-mpp$mpp1$values
  m2<-mpp$mpp2$values
  m3<-mpp$mpp3$values
  
  m1[m1<=0]<-NA
  m2[m2<=0]<-NA
  m3[m3<=0]<-NA
  
  layout(matrix(c(1,1,2,2,3,3,4,4),8,1))
  par(mar=c(0,4,1,1))
  plot(m1, ylim=range(marks1*1.5),xaxt="n",ylab="Marks 1" ,xlab=" Times 1",col=1,cex=0.5)
  lines(c(Var1),col=8)
  points(error1,pch=3, cex=0.5)
  
  par(mar=c(0,4,1,1))
  plot(m2, ylim=range(marks2*1.5),xaxt="n",ylab="Marks 2" ,xlab=" Times 2",col=2,cex=0.5)
  lines(c(Var2),col=8)
  points(error2,pch=3, cex=0.5)
  
  par(mar=c(0,4,1,1))
  plot(m3, ylim=range(marks3*1.5),xaxt="n",ylab="Marks 3" ,xlab=" Times 3",col=4,cex=0.5)
  lines(c(Var3),col=8)
  points(error3,pch=3, cex=0.5)
  
  par(mar=c(4,4,4,1))
  xx<-rowSums(cbind(y1,y2*2,y3*4))
  plot(times,rep(1,length(times)),yaxt="n",col=xx,typ="h",ylim=c(0,1),ylab="Barcode plot",xlab="Pooled Process Time")
  
  
  list(error=error,VaR=cbind(Var1,Var2,Var3),condInt1=condInt1, condInt2=condInt2,condInt3=condInt3,ES=cbind(ES1,ES2,ES3),VaRa=VaR,e1=e1,e2=e2,e3=e3, VES=VES)
}




ES<-function(p, mu, xi, beta,u){
  (quant(p, mu, xi, beta,u)+beta-xi*u )/(1-xi)
}
