#-------------------------------------------------------------------------------
library(tseries)
library(zoo)
library(ismev)
library(flexsurv)
library(VGAM)
library(numDeriv)
require(compiler)
enableJIT(3)


source("Utilities.r")
source("MI_POTv.R")



dax<-read.csv("GDAXI.csv",sep=",",header=T)
sp<-read.csv("GSPC.csv",sep=",",header=T)
ftse<-read.csv("FTSE.csv",sep=",",header=T)

day.dax<-as.Date(dax[,1], format = "%d-%m-%Y")
day.sp<-as.Date(sp[,1], format = "%d-%m-%Y")
day.ftse<-as.Date(ftse[,1], format = "%d-%m-%Y")

dax<-zoo(dax[,2],order.by=day.dax)
sp<-zoo(sp[,2],order.by=day.sp)
ftse<-zoo(ftse[,2],order.by=day.ftse)

eur<-read.csv("EURUSDv.csv",sep=",",header=T)
gbp<-read.csv("GBPUSDv.csv",sep=",",header=T)

day.eur<-as.Date(eur[,1], format = "%d-%m-%Y")
day.gbp<-as.Date(gbp[,1], format = "%d-%m-%Y")

eur<-zoo(eur[,2],order.by=day.eur)
gbp<-zoo(gbp[,2],order.by=day.gbp)


plot(eur)
plot(gbp)

dato<-merge(dax,sp,ftse,gbp,eur)
dato<-cbind(dato[,1]*dato[,5],dato[,2],dato[,3]*dato[,4])
colnames(dato)<-c("DAX","SP","FTSE")


dato<-na.omit(dato)
dato.fore<-dato[5622:6111,]
dato<-dato[494:5621,]
plot(dato)
plot(dato.fore)


returns<-function(x) diff(log(x))

dato<-apply(dato,2,returns)
dato<-rowSums(dato*c(1/3,1/3,1/3))*100
plot(dato,typ="l")

#----------------------------------------------------------------------------------------------------------------------
# Figure 5 in the paper

 par(mfrow=c(1,2),mar=c(1,1,1,1))
 res1<-thres(-dato,0.01,0.11,410,461)   #quantile 0.91,0.90
 res2<-thres(dato,0.01,0.11,410,461)    #quantile 0.925,0.91
 
 color1<-matrix("gray90",length(res1$k),length(res1$betas))
 color1[,359:410]<-"gray50"

 nn<-length(res1$k)-1

 persp(res1$k,res1$betas,res1$m, theta = -30, phi = 25, col =t(color1[1:nn,1:nn]) , scale = T,nticks=4,
      ltheta = -120, shade = 0.75, border = NA, box = T,ticktype = "detailed",expand=0.75,xlab="k",ylab="??",zlab="")
 
 persp(res2$k,res2$betas,res2$m, theta = -30, phi = 25, col =t(color1[1:nn,1:nn]) , scale = T,nticks=4,
       ltheta = -120, shade = 0.75, border = NA, box = T,ticktype = "detailed",expand=0.75,xlab="k",ylab="??",zlab="")
 
#--------------------------------------------------------------------------------------------------------------------
# Bivariate estimation
#
# mpp    define the bivariate point process 

mpp<-bivPP(dato,0.915,-dato,0.915) 

#----------------------------------------------------------------------------------------------------------------
# POT parameter estimation bivariate
 
param<-runif(5,0,0.1)  

fitb.1<- nlminb(start=param,objective=ACD_marks1,mpp=mpp$mpp1,control=list(trace=10,eval.max=20000,iter.max=20000))  
fitb.2<- nlminb(start=param,objective=ACD_marks1,mpp=mpp$mpp2,control=list(trace=10,eval.max=20000,iter.max=20000))  

#likelihood
-fitb.1$objective
-fitb.2$objective

#Hessians and s.e.

hessb.1<-hessb(ACD_marks1,fitb.1$par,mpp=mpp$mpp1)
e1<-sqrt(diag(solve(hessb.1)))

hessb.2<-hessian(ACD_marks1,fitb.2$par,mpp=mpp$mpp2)
e2<-sqrt(diag(solve(hessb.2)))

# Parameters and s.e
cbind(fitb.1$par,e1,fitb.2$par,e2)


#-------------------------------------------------------------------------------
#           ACI-POT  ggamma
#-------------------------------------------------------------------------------

# ACI-POT (1,1)  Table 1.

# Contraints
lower=rep(c(rep(-100,2),rep(-0.999,2),rep(0.001,2),-100,-100),2)
upper=rep(c(rep(100,2),rep(0.999,2),rep(100,4)),2)


# Initialization
param<-rep(c(runif(4,0,1),5,5,3,1),2)


#ACI(1,1) bivariate
fit1.1<- nlminb(param,ACI_times2,mpp=mpp,lower=lower,upper=upper,control=list(trace=10,eval.max=20000,iter.max=20000)) 

#likelihood
-fit1.1$objective

#Hessian
hess1.1<-hessb(ACI_times2,fit1.1$par,mpp=mpp)




#Residuals Analyses

se1.1<-sqrt(diag(solve(hess1.1)))
matriz(fit1.1$par)
matriz(se1.1)
eigen(matriz(fit1.1$par)[3:4,])
fit1.1$objective

rest1.1<-Filter_ACI_POT2(fit1.1,list(par=c(fitb.1$par,fitb.2$par)),mpp,unrestricted=F,VaR=0.975)
e1<-rest1.1$e1
e2<-rest1.1$e2
mean(e1)
mean(e2)
sd(e1)
sd(e2)

sqrt(length(e1)/8)*(var(e1)-1)
sqrt(length(e2)/8)*(var(e2)-1)

Box.test(e1,lag=5)
Box.test(e2,lag=5)



#Hawkes-POT

s1<-pmax(outer(c(0,mpp$mpp1$times),c(0,mpp$mpp1$times),"-"),0)
s1<-s1[-1,-dim(s1)[2]]

s2<-pmax(outer(c(0,mpp$mpp2$times),c(0,mpp$mpp2$times),"-"),0)
s2<-s2[-1,-dim(s2)[2]]

s21<-pmax(outer(mpp$mpp2$times,mpp$mpp1$times,"-"),0)
s12<-pmax(outer(mpp$mpp1$times,mpp$mpp2$times,"-"),0)

mpp$mpp1$s1<-s1
mpp$mpp1$s12<-s12
mpp$mpp2$s2<-s2
mpp$mpp2$s21<-s21

fith<- nlminb(runif(10),Hawkes_times2,lower=rep(c(rep(0.0001,4),-2),2),mpp=mpp,control=list(trace=1,eval.max=10000,iter.max=1000))

matriz(fith$par)

ss1<-pmax(outer(c(1:mpp$biv$endtime),mpp$mpp1$times,"-"),0)
ss2<-pmax(outer(c(1:mpp$biv$endtime),mpp$mpp2$times,"-"),0)


rest<-Filter_Hawkes_POT2(fith,list(par=c(fitb.1$par,fitb.2$par)),ss1,ss2,mpp,VaR=0.975)

TestVaR(rest)
e1<-rest$e1
e2<-rest$e2
mean(e1)
mean(e2)
sd(e1)
sd(e2)

sqrt(length(e1)/8)*(var(e1)-1)
sqrt(length(e2)/8)*(var(e2)-1)

Box.test(e1,lag=1)
Box.test(e2,lag=1)



hess.h<-hessian(Hawkes_times2,fith$par,mpp=mpp)

seh<-sqrt(diag(solve(hess.h)))
matriz(seh)

eigen(matriz(fith$par)[2:3,])

#-----------------------------------------------------------------------------
# Figure 6 in the paper just for the ACI(1,1)-POT

 dates<-as.Date(as.character(names(dato)))

library(latex2exp)

layout(matrix(c(1,1,1,2,2,2,3,3,3),9,1))
par(mar=c(0,5,0.1,1))
plot(rest1.1$condInt1,typ="l",xaxt="n",yaxt="n",ylab=TeX("$\\lambda_{g}^{1}(t|\\mathit{H}_{t})$"))#,ylim=c(0,0.8))
axis(2, at=c(0,0.3,0.6),labels=c(0,0.3,0.6), las=2)


par(mar=c(0,5,0,1))
plot(rest1.1$condInt2,typ="l",col=8,xaxt="n",yaxt="n",ylab=TeX("$\\lambda_{g}^{2}(t|\\mathit{H}_{t})$"),ylim=c(0,1.5))
axis(2, at=c(0,0.6,1.2),labels=c(0,0.6,1.2), las=2)


par(mar=c(4,5,1,1))
xx<-ifelse(rest1.1$xx==2,1,8)
plot(dates[mpp$biv$times],rep(1,length(mpp$biv$times)),yaxt="n",col=xx,typ="h",ylim=c(0,1),ylab="Barcode",xlab="Pooled Process Time")
#--------------------------------------------------------------------------------
#  Trivariate ACI-POT
#
dax<-read.csv("GDAXI.csv",sep=",",header=T)
sp<-read.csv("GSPC.csv",sep=",",header=T)
ftse<-read.csv("FTSE.csv",sep=",",header=T)

day.dax<-as.Date(dax[,1], format = "%d-%m-%Y")
day.sp<-as.Date(sp[,1], format = "%d-%m-%Y")
day.ftse<-as.Date(ftse[,1], format = "%d-%m-%Y")

dax<-zoo(dax[,2],order.by=day.dax)
sp<-zoo(sp[,2],order.by=day.sp)
ftse<-zoo(ftse[,2],order.by=day.ftse)

eur<-read.csv("EURUSDv.csv",sep=",",header=T)
gbp<-read.csv("GBPUSDv.csv",sep=",",header=T)

day.eur<-as.Date(eur[,1], format = "%d-%m-%Y")
day.gbp<-as.Date(gbp[,1], format = "%d-%m-%Y")

eur<-zoo(eur[,2],order.by=day.eur)
gbp<-zoo(gbp[,2],order.by=day.gbp)


plot(eur)
plot(gbp)


dato<-merge(dax,sp,ftse)
dates<-index(dato)[-1] 
colnames(dato)<-c("DAX","SP","FTSE")

dato<-na.omit(dato)
dato.fore<-dato[5622:6111,]
dato<-dato[494:5621,]
plot(dato)
plot(dato.fore)


returns<-function(x) diff(log(x))

dato<-apply(dato,2,returns)*100

plot.ts(dato,typ="l")

#Trivariate MPP model
mpp<-triPP(-dato[,3],0.91,-dato[,1],0.91,-dato[,2],0.91)

#FTSE and DAX
sum((-dato[,3]>quantile(-dato[,3],0.91) & -dato[,1]>quantile(-dato[,1],0.91) ))

#FTSE and SP
sum((-dato[,3]>quantile(-dato[,3],0.91) & -dato[,2]>quantile(-dato[,2],0.91) ))

#SP and DAX
sum((-dato[,2]>quantile(-dato[,2],0.91) & -dato[,1]>quantile(-dato[,1],0.91) ))


#FTSE and DAX and SP
sum((-dato[,3]>quantile(-dato[,3],0.91) & -dato[,1]>quantile(-dato[,1],0.91) & -dato[,2]>quantile(-dato[,2],0.91)))

#----------------------------------------------------------------------------
# GPD estimation (Table 2)
param<-runif(5,0,1)     #
fitb1<- nlminb(start=param,objective=ACD_marks1,mpp=mpp$mpp1,control=list(trace=1,eval.max=20000,iter.max=20000))  
fitb2<- nlminb(start=param,objective=ACD_marks1,mpp=mpp$mpp2,control=list(trace=1,eval.max=20000,iter.max=20000))  
fitb3<- nlminb(start=param,objective=ACD_marks1,mpp=mpp$mpp3,control=list(trace=1,eval.max=20000,iter.max=20000))  

# Loglikelihoods

-fitb1$objective
-fitb2$objective
-fitb3$objective

# Hessian Estimation and s.e
hessb.1<-hessb(ACD_marks1,fitb1$par,mpp=mpp$mpp1)
e1<-sqrt(diag(solve(hessb.1)))

hessb.2<-hessian(ACD_marks1,(fitb2$par),mpp=mpp$mpp2)
e2<-sqrt(diag(solve(hessb.2)))

hessb.3<-hessian(ACD_marks1,fitb3$par,mpp=mpp$mpp3)
e3<-sqrt(diag(solve(hessb.3)))

cbind(fitb1$par,e1,fitb2$par,e2,fitb3$par,e3)[c(4,1,3,5,2),]

fitb1$objective
fitb2$objective
fitb3$objective



#----------------------------------------------------------------------------------------------------
#
#  ACI-POT ggamma (1,1) Table 2


  
# Contraints
lower=rep(c(rep(-10,3),rep(-10,3),rep(0.001,2),-100,-100),3)
upper=rep(c(rep(10,3),rep(10,3),rep(100,4)),3)

#initialization
param<-rep(c(runif(6,0,0.1),5,5,3,1),3)
fit1.1<- nlminb(param,ACI_times3,mpp=mpp,unrestricted=F,lower=lower,upper=upper,control=list(trace=10,eval.max=20000,iter.max=20000)) 

# loglikelihood
-fit1.1$objective


rest1.1<-Filter_ACI_POT3(fit1.1,list(par=c(fitb1$par,fitb2$par,fitb3$par)),mpp,unrestricted=F,VaR=0.99)

e1<-rest1.1$e1
e2<-rest1.1$e2
e3<-rest1.1$e3
mean(e1)
mean(e2)
mean(e3)
sd(e1)
sd(e2)
sd(e3)

sqrt(length(e1)/8)*(var(e1)-1)
sqrt(length(e2)/8)*(var(e2)-1)
sqrt(length(e3)/8)*(var(e3)-1)

Box.test(e1,type="Ljung-Box",lag=1)
Box.test(e2,type="Ljung-Box",lag=1)
Box.test(e3,type="Ljung-Box",lag=1)



hess.g3<-hessian(ACI_times3,fit1.1$par,mpp=mpp,unrestricted=F)
seg<-sqrt(diag(solve(hess.g3)))


matriz3(fit1.1$par)
matriz3(seg)
eigen(matriz3(fit1.1$par)[4:6,])

#-----------------------------------------------------------------------------

# Hawkes -POT
s1<-pmax(outer(c(0,mpp$mpp1$times),c(0,mpp$mpp1$times),"-"),0)
s1<-s1[-1,-dim(s1)[2]]

s2<-pmax(outer(c(0,mpp$mpp2$times),c(0,mpp$mpp2$times),"-"),0)
s2<-s2[-1,-dim(s2)[2]]

s3<-pmax(outer(c(0,mpp$mpp3$times),c(0,mpp$mpp3$times),"-"),0)
s3<-s3[-1,-dim(s3)[2]]

s12<-pmax(outer(mpp$mpp1$times,mpp$mpp2$times,"-"),0)
s13<-pmax(outer(mpp$mpp1$times,mpp$mpp3$times,"-"),0)
s21<-pmax(outer(mpp$mpp2$times,mpp$mpp1$times,"-"),0)
s23<-pmax(outer(mpp$mpp2$times,mpp$mpp3$times,"-"),0)
s31<-pmax(outer(mpp$mpp3$times,mpp$mpp1$times,"-"),0)
s32<-pmax(outer(mpp$mpp3$times,mpp$mpp2$times,"-"),0)

mpp$mpp1$s1<-s1
mpp$mpp1$s12<-s12
mpp$mpp1$s13<-s13
mpp$mpp2$s2<-s2
mpp$mpp2$s21<-s21
mpp$mpp2$s23<-s23
mpp$mpp3$s3<-s3
mpp$mpp3$s31<-s31
mpp$mpp3$s32<-s32


fith3<- nlminb(runif(18),Hawkes_times3,mpp=mpp,lower=rep(c(rep(1e-03,5),-3),3),upper=rep(c(rep(0.999,5),2),3),control=list(trace=10,eval.max=10000,iter.max=1000)) #4478

ss1<-pmax(outer(c(1:mpp$tri$endtime),mpp$mpp1$times,"-"),0)
ss2<-pmax(outer(c(1:mpp$tri$endtime),mpp$mpp2$times,"-"),0)
ss3<-pmax(outer(c(1:mpp$tri$endtime),mpp$mpp3$times,"-"),0)




rest<-Filter_Hawkes_POT3(fith3,list(par=c(fitb1$par,fitb2$par,fitb3$par)),ss1,ss2,ss3,mpp,VaR=0.975)
TestVaR3(rest)

e1<-rest$e1
e2<-rest$e2
e3<-rest$e3
mean(e1)
mean(e2)
mean(e3)
sd(e1)
sd(e2)
sd(e3)

sqrt(length(e1)/8)*(var(e1)-1)
sqrt(length(e2)/8)*(var(e2)-1)
sqrt(length(e3)/8)*(var(e3)-1)

Box.test(e1,type="Ljung-Box",lag=1)
Box.test(e2,type="Ljung-Box",lag=1)
Box.test(e3,type="Ljung-Box",lag=1)


hess.h3<-hessb(Hawkes_times3,fith3$par,mpp=mpp)
seh<-sqrt(diag(solve(hess.h3)))

matriz3(seh)
matriz3(fith3$par)
fith3$objective


eigen(matriz3(fith3$par)[2:4,])
#----------------------------------------------------------------------------------------------
#Backtesting


dato<-dato.fore

dato<-na.omit(dato)
returns<-function(x) diff(log(x))

dato<-apply(dato,2,returns)*100

mpp<-triPP(-dato[,3],0.925,-dato[,1],0.925,-dato[,2],0.925)


#------------------------------------------------------------------------------------------------

#Backtesting graphic

dax<-read.csv("GDAXI.csv",sep=",",header=T)
sp<-read.csv("GSPC.csv",sep=",",header=T)
ftse<-read.csv("FTSE.csv",sep=",",header=T)

day.dax<-as.Date(dax[,1], format = "%d-%m-%Y")
day.sp<-as.Date(sp[,1], format = "%d-%m-%Y")
day.ftse<-as.Date(ftse[,1], format = "%d-%m-%Y")

dax<-zoo(dax[,2],order.by=day.dax)
sp<-zoo(sp[,2],order.by=day.sp)
ftse<-zoo(ftse[,2],order.by=day.ftse)

eur<-read.csv("EURUSDv.csv",sep=",",header=T)
gbp<-read.csv("GBPUSDv.csv",sep=",",header=T)

day.eur<-as.Date(eur[,1], format = "%d-%m-%Y")
day.gbp<-as.Date(gbp[,1], format = "%d-%m-%Y")

eur<-zoo(eur[,2],order.by=day.eur)
gbp<-zoo(gbp[,2],order.by=day.gbp)


plot(eur)
plot(gbp)


dato<-merge(dax,sp,ftse,gbp,eur)
dato<-cbind(dato[,1],dato[,2],dato[,3])
colnames(dato)<-c("DAX","SP","FTSE")

dato<-na.omit(dato)
dato<-dato[494:6111,]
plot(dato)
plot(dato.fore)


returns<-function(x) diff(log(x))






dates<-index(dato)
dato<-apply(dato,2,returns)*100
plot.ts(dato,typ="l")


mpp<-triPP(-dato[,3],0.91,-dato[,1],0.91,-dato[,2],0.91)
ss1<-pmax(outer(c(1:mpp$tri$endtime),mpp$mpp1$times,"-"),0)
ss2<-pmax(outer(c(1:mpp$tri$endtime),mpp$mpp2$times,"-"),0)
ss3<-pmax(outer(c(1:mpp$tri$endtime),mpp$mpp3$times,"-"),0)

fit.g3<-fit1.1

rest.g3<-Filter_ACI_POT3(fit.g3,list(par=c(fitb1$par,fitb2$par,fitb3$par)),mpp,unrestricted=F,VaR=0.99)
rest.h3<-Filter_Hawkes_POT3(fith3,list(par=c(fitb1$par,fitb2$par,fitb3$par)),ss1,ss2,ss3,mpp,VaR=0.99)


#------------------------------------------------------------------------------------------------------------------


marks1<-mpp$mpp1$marks
marks2<-mpp$mpp2$marks
marks3<-mpp$mpp3$marks
times<-mpp$tri$times
times1<-mpp$mpp1$times
times2<-mpp$mpp2$times
times3<-mpp$mpp3$times

y1<-as.numeric(times%in%times1)
y2<-as.numeric(times%in%times2)
y3<-as.numeric(times%in%times3)



m1<-mpp$mpp1$values
m2<-mpp$mpp2$values
m3<-mpp$mpp3$values

m1[m1<=0]<-NA
m2[m2<=0]<-NA
m3[m3<=0]<-NA





VaR.g3<-rest.g3$VaR
VaR.h3<-rest.h3$VaR

rest.g3<-Filter_ACI_POT3(fit.g3,list(par=c(fitb1$par,fitb2$par,fitb3$par)),mpp,unrestricted=F,VaR=0.975)
rest.h3<-Filter_Hawkes_POT3(fith3,list(par=c(fitb1$par,fitb2$par,fitb3$par)),ss1,ss2,ss3,mpp,VaR=0.975)



ES.g3<-rest.g3$ES
ES.h3<-rest.h3$ES


error.g3<-rest.g3$error
error.h3<-rest.h3$error


error.g3[error.g3==0]<-NA
error.h3[error.h3==0]<-NA
# 861X553

#-----------------------------------------------------------------------------------------------------------
#  ACI-POT trivariate. Plot of the VaR and ES
# Figure 9 in the paper


layout(matrix(c(1,1,2,2,3,3,4,4),8,1))
par(mar=c(0,4,1,1))
plot(m1, ylim=c(0,15),xaxt="n",ylab="FTSE" ,xlab=" Times 1",col=gray(1-1/3),cex=0.5)
rect(5127,0,5617,15,col=gray(0.9),border=NA)
points(m1,col=gray(1-1/3),cex=0.5)

lines(VaR.g3[,1],col=gray(0.5))
lines(ES.g3[,1],col=gray(0.2))
#points(error.b3[,1]*max(marks1*1.5),pch=3, cex=0.5)

par(mar=c(0,4,1,1))
plot(m2, ylim=c(0,15),xaxt="n",ylab="DAX" ,xlab=" Times 2",col=gray(1-1/3),cex=0.5)
rect(5127,0,5617,15,col=gray(0.9),border=NA)
points(m2,col=gray(1-1/3),cex=0.5)

lines(VaR.g3[,2],col=gray(0.5))
lines(ES.g3[,2],col=gray(0.2))
#points(error.b3[,2]*max(marks2*1.7),pch=3, cex=0.5)

par(mar=c(0,4,1,1))
plot(m3, ylim=c(0,15),xaxt="n",ylab="S&P 500" ,xlab=" Times 3",col=gray(1-1/3),cex=0.5)
rect(5127,0,5617,15,col=gray(0.9),border=NA)
points(m3,col=gray(1-1/3),cex=0.5)

lines(VaR.g3[,3],col=gray(0.5))
lines(ES.g3[,3],col=gray(0.2))
#points(error.b3[,3]*max(marks3*1.8),pch=3, cex=0.5)

par(mar=c(4,4,3,1))
xx<-rowSums(cbind(y1,y2,y3))
plot(dates[times],rep(1,length(times)),yaxt="n",col=gray(1-xx/3),typ="h",ylim=c(0,1),ylab="Barcode plot",xlab="Pooled Process Time")





#-----------------------------------------------------------------------------------------------------------
#  Hawkes-POT trivariate. Plot of the VaR and ES
#  Figure 10 in the paper




layout(matrix(c(1,1,2,2,3,3,4,4),8,1))
par(mar=c(0,4,1,1))
plot(m1, ylim=c(0,15),xaxt="n",ylab="FTSE" ,xlab=" Times 1",col=gray(1-1/3),cex=0.5)
rect(5127,0,5617,15,col=gray(0.9),border=NA)
points(m1,col=gray(1-1/3),cex=0.5)

lines(VaR.h3[,1],col=gray(0.5))
lines(ES.h3[,1],col=gray(0.2))
#points(error.b3[,1]*max(marks1*1.5),pch=3, cex=0.5)

par(mar=c(0,4,1,1))
plot(m2, ylim=c(0,15),xaxt="n",ylab="DAX" ,xlab=" Times 2",col=gray(1-1/3),cex=0.5)
rect(5127,0,5617,15,col=gray(0.9),border=NA)
points(m2,col=gray(1-1/3),cex=0.5)

lines(VaR.h3[,2],col=gray(0.5))
lines(ES.h3[,2],col=gray(0.2))
#points(error.b3[,2]*max(marks2*1.7),pch=3, cex=0.5)

par(mar=c(0,4,1,1))
plot(m3, ylim=c(0,15),xaxt="n",ylab="S&P 500" ,xlab=" Times 3",col=gray(1-1/3),cex=0.5)
rect(5127,0,5617,15,col=gray(0.9),border=NA)
points(m3,col=gray(1-1/3),cex=0.5)

lines(VaR.h3[,3],col=gray(0.5))
lines(ES.h3[,3],col=gray(0.2))
#points(error.b3[,3]*max(marks3*1.8),pch=3, cex=0.5)

par(mar=c(4,4,3,1))
xx<-rowSums(cbind(y1,y2,y3))
plot(dates[times],rep(1,length(times)),yaxt="n",col=gray(1-xx/3),typ="h",ylim=c(0,1),ylab="Barcode plot",xlab="Pooled Process Time")



#--------------------------------------------------------------------------------------------




