% Table 2.
clear;
addpath('C:\PRdata','C:\PRcode\PRfunctions')
format short

% Data and function inputs.
mfvdata = readmatrix('mfvdata.csv');
taidata = readmatrix('taidata.csv');
ndn = mfvdata(:,1);
y = mfvdata(:,2);
m1 = 15;
m2 = 30;
m3 = 60;
pi = 0.10;
T_star1 = 302-m1;
T_star2 = 302-m2;
T_star3 = 302-m3;
E = size(y,1);
k1 = T_star1-205;
k2 = T_star2-205;
k3 = T_star3-205;

% Compute the results using the app_max and app_seq functions.
Results = cell(20,12);

for i = 1:10
    x = mfvdata(:,i+2);
    
    if i == 9
        [~,frdate,max_alphah] = app_max(y,x,ndn,m1,T_star1,E,k1);    
        Results{i,1} = frdate;
        Results{i,2} = max_alphah;
        [~,frdate,max_alphah] = app_max(y,x,ndn,m2,T_star2,E,k2);
        Results{i,3} = frdate;
        Results{i,4} = max_alphah;
        [~,frdate,max_alphah] = app_max(y,x,ndn,m3,T_star3,E,k3);
        Results{i,5} = frdate;
        Results{i,6} = max_alphah;
    else
        [~,frdate,max_alphah] = app_max(y,x,ndn,m1,T_star1,E,0);    
        Results{i,1} = frdate;
        Results{i,2} = max_alphah;
        [~,frdate,max_alphah] = app_max(y,x,ndn,m2,T_star2,E,0);
        Results{i,3} = frdate;
        Results{i,4} = max_alphah;
        [~,frdate,max_alphah] = app_max(y,x,ndn,m3,T_star3,E,0);
        Results{i,5} = frdate;
        Results{i,6} = max_alphah;
    end  
end

for i = 11:20
    x = taidata(:,i-8);
    [~,frdate,max_alphah] = app_max(y,x,ndn,m1,T_star1,E,0);    
    Results{i,1} = frdate;
    Results{i,2} = max_alphah;
    [~,frdate,max_alphah] = app_max(y,x,ndn,m2,T_star2,E,0);
    Results{i,3} = frdate;
    Results{i,4} = max_alphah;
    [~,frdate,max_alphah] = app_max(y,x,ndn,m3,T_star3,E,0);
    Results{i,5} = frdate;
    Results{i,6} = max_alphah;
end

for i = 1:10
    x = mfvdata(:,i+2);
    
    if i == 9
        [~,frdate,seq_alphah] = app_seq(y,x,ndn,m1,pi,T_star1,E,k1);    
        Results{i,7} = frdate;
        Results{i,8} = seq_alphah;
        [~,frdate,seq_alphah] = app_seq(y,x,ndn,m2,pi,T_star2,E,k2);
        Results{i,9} = frdate;
        Results{i,10} = seq_alphah;
        [~,frdate,seq_alphah] = app_seq(y,x,ndn,m3,pi,T_star3,E,k3);
        Results{i,11} = frdate;
        Results{i,12} = seq_alphah;
    else
        [~,frdate,seq_alphah] = app_seq(y,x,ndn,m1,pi,T_star1,E,0);    
        Results{i,7} = frdate;
        Results{i,8} = seq_alphah;
        [~,frdate,seq_alphah] = app_seq(y,x,ndn,m2,pi,T_star2,E,0);
        Results{i,9} = frdate;
        Results{i,10} = seq_alphah;
        [~,frdate,seq_alphah] = app_seq(y,x,ndn,m3,pi,T_star3,E,0);
        Results{i,11} = frdate;
        Results{i,12} = seq_alphah;  
    end 
end

for i = 11:20
    x = taidata(:,i-8);
    [~,frdate,seq_alphah] = app_seq(y,x,ndn,m1,pi,T_star1,E,0);    
    Results{i,7} = frdate;
    Results{i,8} = seq_alphah;
    [~,frdate,seq_alphah] = app_seq(y,x,ndn,m2,pi,T_star2,E,0);
    Results{i,9} = frdate;
    Results{i,10} = seq_alphah;
    [~,frdate,seq_alphah] = app_seq(y,x,ndn,m3,pi,T_star3,E,0);
    Results{i,11} = frdate;
    Results{i,12} = seq_alphah;
end

Results = cell2table(Results,'VariableNames',{'DATEMAX15','FPRMAX15','DATEMAX30','FPRMAX30','DATEMAX60','FPRMAX60'...
    'DATESEQ15','FPRSEQ15','DATESEQ30','FPRSEQ30','DATESEQ60','FPRSEQ60'})

clearvars -except Results


