% Table 1.
clear;
addpath('C:\PRdata','C:\PRcode\PRfunctions')
format short

% Data and function inputs.
mfvdata = readmatrix('mfvdata.csv');
taidata = readmatrix('taidata.csv');
ndn = mfvdata(:,1);
y = mfvdata(:,2);
m1 = 15;
m2 = 30;
m3 = 60;
pi = 0.10;
T_star1 = 302-m1;
T_star2 = 302-m2;
T_star3 = 302-m3;
E = size(y,1);
k1 = T_star1-205;
k2 = T_star2-205;
k3 = T_star3-205;

% Compute the results using the app_max and app_seq functions.
Results = zeros(20,6);

for i = 1:10
    x = mfvdata(:,i+2);

    if i == 9
        [regnum,~,~] = app_max(y,x,ndn,m1,T_star1,E,k1);
        Results(i,1) = regnum;
        [regnum,~,~] = app_max(y,x,ndn,m2,T_star2,E,k2);
        Results(i,2) = regnum;
        [regnum,~,~] = app_max(y,x,ndn,m3,T_star3,E,k3);
        Results(i,3) = regnum;
    else  
        [regnum,~,~] = app_max(y,x,ndn,m1,T_star1,E,0);
        Results(i,1) = regnum;
        [regnum,~,~] = app_max(y,x,ndn,m2,T_star2,E,0);
        Results(i,2) = regnum;
        [regnum,~,~] = app_max(y,x,ndn,m3,T_star3,E,0);
        Results(i,3) = regnum;   
    end   
end

for i = 11:20
    x = taidata(:,i-8);
    [regnum,~,~] = app_max(y,x,ndn,m1,T_star1,E,0);
    Results(i,1) = regnum;
    [regnum,~,~] = app_max(y,x,ndn,m2,T_star2,E,0);
    Results(i,2) = regnum;
    [regnum,~,~] = app_max(y,x,ndn,m3,T_star3,E,0);
    Results(i,3) = regnum;
end

for i = 1:10
    x = mfvdata(:,i+2);
    
    if i == 9
        [regnum,~,~] = app_seq(y,x,ndn,m1,pi,T_star1,E,k1);
        Results(i,4) = regnum;
        [regnum,~,~] = app_seq(y,x,ndn,m2,pi,T_star2,E,k2);
        Results(i,5) = regnum;
        [regnum,~,~] = app_seq(y,x,ndn,m3,pi,T_star3,E,k3);
        Results(i,6) = regnum;
    else
        [regnum,~,~] = app_seq(y,x,ndn,m1,pi,T_star1,E,0);
        Results(i,4) = regnum;
        [regnum,~,~] = app_seq(y,x,ndn,m2,pi,T_star2,E,0);
        Results(i,5) = regnum;
        [regnum,~,~] = app_seq(y,x,ndn,m3,pi,T_star3,E,0);
        Results(i,6) = regnum;
    end
end

for i = 11:20
    x = taidata(:,i-8);
    [regnum,~,~] = app_seq(y,x,ndn,m1,pi,T_star1,E,0);
    Results(i,4) = regnum;
    [regnum,~,~] = app_seq(y,x,ndn,m2,pi,T_star2,E,0);
    Results(i,5) = regnum;
    [regnum,~,~] = app_seq(y,x,ndn,m3,pi,T_star3,E,0);
    Results(i,6) = regnum;
end

Results = array2table(Results,'VariableNames',{'PRMAX15','PRMAX30','PRMAX60',...
    'PRSEQ15','PRSEQ30','PRSEQ60'})

clearvars -except Results

