% Figure 1.
clear;
set(0,'DefaultFigureVisible','off')

T = 750;
T_star = 400;
m = 30;
E_max = T;

Ei = T_star+m;
while Ei <= E_max
    alphah(Ei,1) = (Ei-T_star-m+1)/(Ei-2*m+1);
    Ei = Ei+1;    
end

x = 450:750;
y = alphah(450:750);

set(gcf,'color', 'white','DefaultAxesColorOrder',[0 0 0]);  
set(gcf,'PaperUnits','inches');
set(gcf,'PaperSize',[11.69 8.27]);
set(gcf,'PaperPositionMode', 'manual');
set(gcf,'PaperPosition',[0 0 11.69 8.27]);
set(gcf,'Position',[200, 200, 1200, 800]);  

plot(x,y,'k','LineWidth',1);
grid on 
tick = x(11:20:292);
set(gca, 'xtick', tick,'XMinorTick','on','YMinorTick','on','Fontsize',14); 
ylabel('FPR','Interpreter','latex','Fontsize',18);
xlabel('E','Interpreter','latex','Fontsize',18);
print(gcf, '-dpdf', 'Figure1.pdf');












