function [tstar] = t_sub_proc(y,x)

% Computes the t-statistic for monitoring.
%
%   INPUTS:
%   y - m by 1 regressand
%   x - m by 1 regressor   
%
%   OUTPUTS:
%   tstar - t-statistic

ixx = inv(x'*x);
beta_hat = ixx*(x'*y); 
r = y - x*beta_hat;
xxw = (x.*r)'*(x.*r);
om = ixx*xxw*ixx;
tstar = (beta_hat/sqrt(om));
end

