function [slope,tstat,IVcomb,R2,Rbar] = preg(y,x,T)

% Computes the regression results.
%
%   INPUTS:
%       y - T by 1 regressand
%       x - T by 1 regressor
%       T - sample size
%
%   OUTPUTS:
%       slope - fitted slope 
%       tstat - t-statistic for slope
%       IVcomb - IVcomb test statistic
%       R2 - R-squared
%       Rbar - R-bar-squared

y = y(1:T,1);
x = x(1:T,1);
dep = trimr(y,1,0);
x_mat = trimr([ones(T,1) lag1(x)],1,0);
beta_hat_OLS = x_mat\dep;
res_OLS = dep-x_mat*beta_hat_OLS;
tr = (1:1:T);
i1 = lag1(sin(pi*tr'/(2*T)));
fx = filt_fi((x-mean(x)),0.5);
fx = fx(1:T,1);
i2 = lag1(fx);
z_mat = trimr([ones(T,1) i1 i2],1,0);
IVcomb = IV_stat(dep,x_mat,z_mat,res_OLS);

lx = trimr(lag1(x),1,0);
y = dep;
X = lx;
[~,~,~,~,stats] = regress(y,x_mat);
R2 = stats(1);
Rbar = 1-(1-R2)*(size(y,1)-1)/(size(y,1)-size(X,2)-1);
maxLag = floor(0.75*(size(y,1)^(1/3)));
[~,se,b] = hac(X,y,'bandwidth',maxLag+1,'display','off');
slope = b(2,1);
tstat = b(2,1)./se(2,1);
R2 = R2*100;
Rbar = Rbar*100;

clearvars -except slope tstat IVcomb R2 Rbar;
end

