function pow_z_str(T_dgp,T_star,m_dgp,gamma,m,bx1_v,rho_x_v,monstart,pi,alpha,prstart,mrep)

% Computes detection power and plots the results: AR(1) predictor, normal errors, smooth change, vs. beta_{1}.
%
%   INPUTS:
%       T_dgp - sample size
%       T_star - end of training period
%       m_dgp - length of PR 
%       gamma - transition speed parameter
%       m - subsample size
%       bx1_v - vector of beta_{1} values
%       rho_x_v - vector of rho values
%       monstart - start of monitoring
%       pi - significance level for SEQ
%       alpha - alpha
%       prstart - start of PR-monstart
%       mrep - number of replications

close;
figure;
rng(43,'twister');

pow_max = zeros(size(bx1_v,2),size(rho_x_v,2));
pow_seq = zeros(size(bx1_v,2),size(rho_x_v,2));

j = 1;
while j <= size(rho_x_v,2)    
    rho_x = rho_x_v(j);
    
    k = 1;
    while k <= size(bx1_v,2)
        bx_1 = bx1_v(k);  
        t1 = monstart+prstart-1;
        s = t1+0.50*m_dgp+1;
        dum_lx_1 = zeros(T_dgp,1);
        t = 1:T_dgp;
        t = t';
        dum_lx_1(1:T_dgp,1) = exp(-gamma*(t-s).^2);
        omega = eye(2);
        omega(1,2) = -0.90;
        omega(2,1) = omega(1,2);
        H = chol(omega)';
        mu = [0,0];
        sigma = [1 0;0 1];
        regnummax = zeros(mrep,1);
        regnumseq = zeros(mrep,1);      
        FME1 = zeros(T_dgp,mrep);
        FME2 = zeros(T_dgp,mrep);
        
        for i = 1:mrep
            ME = mvnrnd(mu,sigma,T_dgp);
            FME1(:,i) = ME(:,1);
            FME2(:,i) = ME(:,2);
        end
        
        parfor i = 1:mrep
            err = [FME1(1:T_dgp,i) FME2(1:T_dgp,i)]; 
            eps = err*H';
            eps_x = eps(1:T_dgp,1);
            eps_y = eps(1:T_dgp,2);
            eps_x(1) = 0;
            x = recserar(eps_x,eps_x(1),rho_x);
            lx = lag1(x);
            y = bx_1*dum_lx_1.*lx+eps_y;
            tm_vec = zeros(T_dgp,1);
            
            e = m+1;
            while e <= T_dgp
                y_sub = y(e-m+1:e,1);
                lx_sub = lx(e-m+1:e,1);
                tm_vec(e,1) = t_sub_proc(y_sub-mean(y_sub),lx_sub-mean(lx_sub));
                e = e+1;
            end
            
            E = floor((T_star+m-1-alpha*(2*m-1))/(1-alpha));            
            trainvec = tm_vec(m+1:T_star,1);
            monvec = tm_vec(T_star+m:E,1);
            maxtrainvec = max(trainvec);
            monrej = monvec > maxtrainvec;
            [maxmaxmon,~,~] = max_proc(monrej);

            if maxmaxmon > 0
                regnummax(i,1) = 1;
            end     
            
            cv_tm = quantile(trainvec,1-pi);
            trainrej = trainvec > cv_tm;
            monrej = monvec > cv_tm;
            [maxseqtrain,~,~] = max_proc(trainrej);
            [maxseqmon,~,~] = max_proc(monrej);

            if maxseqmon > maxseqtrain   
                regnumseq(i,1) = 1;
            end
        end
        
        pow_max(k,j) = mean(regnummax>0);
        pow_seq(k,j) = mean(regnumseq>0);        
        k = k+1;
    end 
    
    j = j+1;
end

set(gcf,'color','white','DefaultAxesColorOrder',[0 0 0]);  
set(gcf,'PaperUnits','inches');
set(gcf,'PaperSize',[11.69 8.27]);
set(gcf,'PaperPositionMode','manual');
set(gcf,'PaperPosition',[0 0 11.69 8.27]);
set(gcf,'Position',[200, 200, 1200, 800]);

plot(bx1_v,pow_seq(:,1),'-b',bx1_v,pow_seq(:,2),'--b',bx1_v,pow_max(:,1),'-r',bx1_v,pow_max(:,2),'--r','LineWidth',1);
xlim([bx1_v(1) bx1_v(end)]);
ylim([0 1]);
set(gca,'XMinorTick','on','YMinorTick','on','FontSize',18);
xlabel({'$\beta_{1}$'},'Interpreter','latex','FontSize',20);
end

