function plot_rt_max(alphah,T_star,db,m,m_star,tm_vec,usr,T,ndn,rsdate,redate,regnum,k,maxtrainvec_s)

% Plots the MAX procedure results.
%
%   INPUTS:
%       alphah - empirical FPR function values
%       T_star - end of training period
%       db - plot start relative to T_star
%       m - subsample size 
%       m_star - m_star 
%       tm_vec - sequence of test statistics
%       usr - NBER indicator
%       T - sample size
%       ndn - T by 1 vector of dates
%       rsdate - start dates
%       redate - end dates
%       regnum - number of PRs 
%       k - separation
%       maxtrainvec_s - training period maximum 

close;
figure;

if  regnum == 1
    h_r1 = redate(1,1)-rsdate(1,1)+1;
end
    
if regnum == 2
    h_r1 = redate(1,1)-rsdate(1,1)+1;
    h_r2 = redate(2,1)-rsdate(2,1)+1;
end
    
if regnum == 3
    h_r1 = redate(1,1)-rsdate(1,1)+1;
    h_r2 = redate(2,1)-rsdate(2,1)+1;
    h_r3 = redate(3,1)-rsdate(3,1)+1;
end

tm_vec(1:m,1) = -99*ones(m,1);
tm_vec = miss(tm_vec,-99);
maxtrainvec_s(1:T_star+m-1,1) = -99*ones(T_star+m-1,1);
maxtrainvec_s = miss(maxtrainvec_s,-99);
j = rsdate(1,1);
rulstart1 = ndn(j-m+1,1);
rulend1 = ndn(j+h_r1-1,1);

if j+h_r1-m >= j
    russtart1 = ndn(j,1);
    rusend1 = ndn(j+h_r1-m,1);
end

if j+h_r1-m < j  
    russtart1 = 0;
    rusend1 = 0;   
end

if regnum > 1
    j = rsdate(2,1);
    rulstart2 = ndn(j-m+1,1);
    rulend2 = ndn(j+h_r2-1,1);

    if j+h_r2-m >= j   
       russtart2 = ndn(j,1);
       rusend2 = ndn(j+h_r2-m,1); 
    end

    if j+h_r2-m < j  
      russtart2 = 0;
      rusend2 = 0; 
    end
end

if regnum > 2
    j = rsdate(3,1);
    rulstart3 = ndn(j-m+1,1);
    rulend3 = ndn(j+h_r3-1,1);

    if j+h_r3-m >= j    
        russtart3 = ndn(j,1);
        rusend3 = ndn(j+h_r3-m,1);    
    end

    if j+h_r3-m < j    
        russtart3 = 0;
       rusend3 = 0;    
    end
end

set(gcf,'color', 'white','DefaultAxesColorOrder',[0 0 0]);  
set(gcf,'PaperUnits','inches');
set(gcf,'PaperSize',[11.69 8.27]);
set(gcf,'PaperPositionMode', 'manual');
set(gcf,'PaperPosition',[0 0 11.69 8.27]);
set(gcf,'Position',[200, 200, 1200, 800]);

yyaxis left
h1 = plot(ndn(T_star-k-db:end,1),tm_vec(T_star-k-db:end,1),'k','LineWidth',1); 
set(gca, 'Layer','top')
mina = round(min(tm_vec(T_star-k-db:end,1))-2);
maxa = round(max(tm_vec(T_star-k-db:end,1))+2);
ylabel('\fontsize{20} \tau_{e,m}','Interpreter','tex');
tick = ndn(2:60:T,1);
set(gca, 'xtick',tick,'XMinorTick','on','YMinorTick','on','Fontsize',16); 
datetick('x', 'yy', 'keepticks');
xlim([ndn(T_star-k-db,1) ndn(end,1)]);
set(gca,'ylim',[mina, maxa],'XMinorTick','off','YMinorTick','on','Fontsize',12);
hold on;
ystart = mina;
yend = maxa;
h2 = plot([ndn(T_star-k,1) ndn(T_star-k,1)], [ystart yend],'--red','LineWidth',1);
h3 = plot([ndn(T_star+m,1) ndn(T_star+m,1)], [ystart yend],'--green','LineWidth',1);
yl = ylim;
x4 = ndn(rsdate(1,1)+m_star,1);
h4 = plot([x4 x4],yl,'--','LineWidth',1,'Color',[0.5 0 0.9]);

if regnum == 2
    x5 = ndn(rsdate(2,1)+m_star,1);
    h5 = plot([x5 x5],yl,'--','LineWidth',1,'Color',[1 0.5 0]);
end

if regnum == 3
    x5 = ndn(rsdate(2,1)+m_star,1);
    h5 = plot([x5 x5],yl,'--','LineWidth',1,'Color',[1 0.5 0]);
    x6 = ndn(rsdate(3,1)+m_star,1);
    h6 = plot([x6 x6],yl,'--','LineWidth',1,'Color',[1 0 1]);
end

h7 = plot(ndn(T_star-db-k:end,1),maxtrainvec_s(T_star-db-k:end,1),'-','Color','b','LineWidth',1); 

uk = 1;
while uk <= T   
    if usr(uk,1) == 1     
       usr(uk,1) = maxa; 
    end
    
    if usr(uk,1) == 0
        usr(uk,1) = mina;
    end    
    uk = uk+1;
end

h8 = plot(ndn(T_star-db-k:end,1),usr(T_star-db-k:end,1),':','Color',[0 0 0],'LineWidth',1); 
qy = [[1 1]*yl(1) [1 1]*yl(2)]; 
qx = [rulstart1 rulend1 rulend1 rulstart1];
h9 = patch(qx,qy,[1 1 1]*0.83,'LineStyle','none');

if russtart1 > 0    
    qxs = [russtart1 rusend1 rusend1 russtart1];
    h10 = patch(qxs,qy,[1 1 1]*0.60,'LineStyle','none');    
end

if regnum > 1
    qx2 = [rulstart2 rulend2 rulend2 rulstart2];
    h11 = patch(qx2,qy,[1 1 1]*0.83,'LineStyle','none');
    
    if russtart2 > 0    
        qx2s = [russtart2 rusend2 rusend2 russtart2];
        h12 = patch(qx2s,qy,[1 1 1]*0.60,'LineStyle','none');    
    end
end

if regnum > 2   
    qx3 = [rulstart3 rulend3 rulend3 rulstart3];
    h13 = patch(qx3,qy,[1 1 1]*0.83,'LineStyle','none');

    if russtart3 > 0   
        qx3s = [russtart3 rusend3 rusend3 russtart3];
        h14 = patch(qx3s,qy,[1 1 1]*0.60,'LineStyle','none');   
    end
end

uistack(h1,'top');
uistack(h9,'bottom');

if russtart1 > 0
    uistack(h10,'down',4);
end

if regnum > 1
    uistack(h11,'bottom');
    
    if russtart2 > 0
        uistack(h12,'down',4);
    end
end

if regnum > 2
    uistack(h13,'bottom');
    
    if russtart3 > 0
        uistack(h14,'down',4);
    end
end

yyaxis right
h15 = plot(ndn(T_star-db-k:end,1),alphah(T_star-db-k:end,1),'-','Color','cyan','LineWidth',1); 
ylim([0 1]);
z = ylabel('\fontsize{20} FPR','rot',270,'Interpreter','tex');
set(gca,'XMinorTick','on','YMinorTick','on','ZMinorTick','on','Fontsize',12);
set(z, 'Units','Normalized','Position',[1.07,0.5,0]);
line([ndn(rsdate(1,1)+m_star,1),ndn(end,1)],[alphah(rsdate(1,1)+m_star,1),alphah(rsdate(1,1)+m_star,1)],'LineStyle',':','LineWidth',1,'Color','cyan');

if regnum > 1
    line([ndn(rsdate(2,1)+m_star,1),ndn(end,1)],[alphah(rsdate(2,1)+m_star,1),alphah(rsdate(2,1)+m_star,1)],'LineStyle',':','LineWidth',1,'Color','cyan');
end

if regnum > 2
    line([ndn(rsdate(3,1)+m_star,1),ndn(end,1)],[alphah(rsdate(3,1)+m_star,1),alphah(rsdate(3,1)+m_star,1)],'LineStyle',':','LineWidth',1,'Color','cyan');
end

hold off;
end





