function [fdout] = filt_fi(y,d)

% Fractional filter e = (1-L)^d.
%
%   INPUTS:
%       y - data
%       d - fraction
%
%   OUTPUTS:
%       fdout - filtered value

t = rows(y);
k = (1:t-1)'; 
tmp = (k-1-abs(d))./k;
tmp = recserp(tmp,zeros(t-1,1));
fdout = conv([1;tmp],y);
end

