function [DM,p] = dm(e1,e2)

% Computes the DM test statistic for one-step ahead forecasts.
%
%   INPUTS:
%       e1 - vector of forecast errors from model 1
%       e2 - vector of forecast errors from model 2
%
%   OUTPUTS:
%       DM - test statistic 
%       p - p-value

n = size(e1,1);
d = abs(e1).^2-abs(e2).^2;
dbar = mean(d);
gamma0 = var(d);
Vdbar = gamma0/n;
hln = sqrt((n+1-2)/n);
DM = dbar/sqrt(Vdbar);
DMstar = hln*DM;
p = 2*tcdf(-abs(DMstar),n-1);
end
    


