function [output] = app_seq_fig(y,x,usr,ndn,m,pi,T_star,E,k)

% Applies the SEQ procedure and plots the results using the plot_rt_seq function.
%
%   INPUTS:
%       y - T by 1 regressand
%       x - T by 1 regressor
%       usr - T by 1 business cycle indicator
%       ndn - T by 1 vector of dates
%       m - subsample size 
%       pi - significance level
%       T_star - end of training period
%       E - end of monitoring
%       k - separation
%
%   OUTPUTS:
%       output - binary indicator  
%       plot 

warning('off');
output = 0;
regnum = 0;
lx = lag1(x);
tm_vec = zeros(E,1);

e = m+1;
while e <= E
    y_sub = y(e-m+1:e,1);
    lx_sub = lx(e-m+1:e,1);
    tm_vec(e,1) = t_sub_proc(y_sub-mean(y_sub),lx_sub-mean(lx_sub));
    e = e+1;
end

alphah = zeros(E,1);
alphah(1:T_star+m-1,1) = NaN([T_star+m-1,1]);
E_max = E;
    
Ei = T_star+m;
while Ei <= E_max
    alphah(Ei,1) = (Ei-T_star-m+1)/(Ei-2*m+1-k);
    Ei = Ei+1;
end

trainvec = tm_vec(m+1:T_star-k,1);
monvec = tm_vec(T_star+m:E,1);
cv_tm = quantile(trainvec,1-pi);
trainrej = trainvec > cv_tm;
monrej = monvec > cv_tm;
[maxseqtrain,~,~] = max_proc(trainrej);
[maxseqmon,dum1m,dum2m] = max_proc(monrej);

if maxseqmon > maxseqtrain  
    output = 1;
    ij = 1;
    while maxseqmon > maxseqtrain
    
        regnum = regnum+1;
       
        rsdate(ij,1) = T_star+m+dum1m-1;
        redate(ij,1) = T_star+m+dum2m-1;
    
        monrej(dum1m:dum2m,1) = zeros(dum2m-dum1m+1,1);
    
        ij = ij+1;

        [maxseqmon,dum1m,dum2m] = max_proc(monrej);
    end

    if regnum > 3
        regnum = 3;
    end
       
    rsdate = sort(rsdate);
    redate = sort(redate);    
    m_star = maxseqtrain;
    cv_tm_s(T_star+m:E,1) = cv_tm*ones(E-(T_star+m)+1,1);    
    db = 60;
    plot_rt_seq(alphah,T_star,db,m,m_star,cv_tm_s,tm_vec,usr,E,ndn,rsdate,redate,regnum,k);
end
end

