function [regnum,frdate,seq_alphah] = app_seq(y,x,ndn,m,pi,T_star,E,k)

% Applies the SEQ procedure.
%
%   INPUTS:
%       y - T by 1 regressand
%       x - T by 1 regressor
%       ndn - T by 1 vector of dates
%       m - subsample size 
%       T_star - end of training period
%       E - end of monitoring
%       k - separation
%
%   OUTPUTS:
%       regnum - number of PRs (<= 3)
%       frdate - first PR date
%       seq_alphah - empirical FPR associated with frdate

warning('off');
formatOut = 'mm/yy';
regnum = 0;
frdate = -99;
seq_alphah = -99;
lx = lag1(x);
tm_vec = zeros(E,1);

e = m+1;
while e <= E
    y_sub = y(e-m+1:e,1);
    lx_sub = lx(e-m+1:e,1);
    tm_vec(e,1) = t_sub_proc(y_sub-mean(y_sub),lx_sub-mean(lx_sub));
    e = e+1;
end

alphah = zeros(E,1);
alphah(1:T_star+m-1,1) = NaN([T_star+m-1,1]);
E_max = E;
    
Ei = T_star+m;
while Ei <= E_max
    alphah(Ei,1) = (Ei-T_star-m+1)/(Ei-2*m+1-k);
    Ei = Ei+1;
end

trainvec = tm_vec(m+1:T_star-k,1);
monvec = tm_vec(T_star+m:E,1);
cv_tm = quantile(trainvec,1-pi);
trainrej = trainvec > cv_tm;
monrej = monvec > cv_tm;
[maxseqtrain,~,~] = max_proc(trainrej);
[maxseqmon,dum1m,dum2m] = max_proc(monrej);

if maxseqmon > maxseqtrain    
    ij = 1;
    while maxseqmon > maxseqtrain
        regnum = regnum+1;
        rsdate(ij,1) = T_star+m+dum1m-1;
        redate(ij,1) = T_star+m+dum2m-1;
        monrej(dum1m:dum2m,1) = zeros(dum2m-dum1m+1,1);
        ij = ij+1;
        [maxseqmon,dum1m,dum2m] = max_proc(monrej); 
    end

    if regnum > 3
        regnum = 3;
    end
    
    rsdate = sort(rsdate);
    redate = sort(redate);    
    frdate = datestr(ndn(rsdate(1,1)+maxseqtrain),formatOut);
    seq_alphah = alphah(rsdate(1,1)+maxseqtrain);
end

frdate = miss(frdate,-99);
seq_alphah = miss(seq_alphah,-99);
end

