function [msfeb,msfepr,p,OSR] = app_max_for(y,x,m,T_star,E,k)

% Applies the MAX procedure and computes forecasts.
%
%   INPUTS:
%       y - T by 1 regressand
%       x - T by 1 regressor
%       m - subsample size 
%       T_star - end of training period
%       E - end of monitoring
%       k - separation 
%
%   OUTPUTS:
%       msfeb - MSFE for baseline approach 
%       msfepr - MSFE for PR approach
%       p_value - p-value for DM test statistic
%       OSR - out-of-sample R-squared 

warning('off');
regnum = 0;
msfeb = -99;
msfepr = -99;
p = -99;
OSR = -99;
lx = lag1(x);
tm_vec = zeros(E,1);

e = m+1;
while e <= E
    y_sub = y(e-m+1:e,1);
    lx_sub = lx(e-m+1:e,1);
    tm_vec(e,1) = t_sub_proc(y_sub-mean(y_sub),lx_sub-mean(lx_sub));
    e = e+1;
end

alphah = zeros(E,1);
alphah(1:T_star+m-1,1) = NaN([T_star+m-1,1]);
E_max = E;
    
Ei = T_star+m;
while Ei <= E_max
    alphah(Ei,1) = (Ei-T_star-m+1)/(Ei-2*m+1-k);
    Ei = Ei+1;
end

trainvec = tm_vec(m+1:T_star-k,1);
monvec = tm_vec(T_star+m:E,1);
maxtrainvec = max(trainvec);
monrej = monvec > maxtrainvec;
[maxmaxmon,dum1m,dum2m] = max_proc(monrej);

if maxmaxmon > 0   
    ij = 1;
    while maxmaxmon > 0
        regnum = regnum+1;  
        rsdate(ij,1) = T_star+m+dum1m-1;
        redate(ij,1) = T_star+m+dum2m-1;
        monrej(dum1m:dum2m,1) = zeros(dum2m-dum1m+1,1);
        ij = ij+1;
        [maxmaxmon,dum1m,dum2m] = max_proc(monrej);
    end

    if regnum > 3
        regnum = 3;
    end
    
    rsdate = sort(rsdate);
    redate = sort(redate);
    fstart = rsdate(1,1);
    fend = redate(1,1);   
    fj = 1;
    
    fc = T_star+m;
    while fc <= fend     
        yfp(fj,1) = y(fc+1,1);
        bfor(fj,1) = mean(y(1:fc,1));
        
        if fc < fstart 
            prfor(fj,1) = bfor(fj,1);
            fj = fj+1;
        end
        
        if fc >= fstart
            wstart = fstart-m+1;
            ye = y(wstart:fc,1);
            nm = fc-wstart+1;
            x_mat = [ones(nm,1) (x(wstart-1:fc-1,1))];
            beta_hat_OLS = x_mat\ye;
            prfor(fj,1) = [1 x(fc,1)]*beta_hat_OLS;
            fj = fj+1;
        end 
        fc = fc+1;
    end
    
    msfeb = mean((yfp-bfor).^2);
    msfepr = mean((yfp-prfor).^2);
    e1 = yfp-bfor;
    e2 = yfp-prfor;
    [~,p] = dm(e1,e2);
    OSR = 100*(1-(msfepr/msfeb));
end

msfeb = miss(msfeb,-99);
msfepr = miss(msfepr,-99);
p = miss(p,-99);
OSR = miss(OSR,-99);
end

