function [IVcomb] = IV_stat(dep,x_mat,z_mat,u_hat)

% IV_{comb} test statistic.
%
%   INPUTS:
%       dep - dependent variables
%       x_mat - x matrix
%       z_mat - z matrix
%       u_hat - residuals
%
%   OUTPUTS:
%       IVcomb - IVcomb test statistic 

zy = z_mat'*dep;
zx = z_mat'*x_mat;
zz = z_mat'*z_mat;
zzu = (z_mat.*u_hat)'*(z_mat.*u_hat);
beta_hat_IV = inv(zx'*inv(zz)*zx)*zx'*inv(zz)*zy;
var_beta_hat_IV = inv(zx'*inv(zz)*zx)*zx'*inv(zz)*zzu*inv(zz)*zx*inv(zx'*inv(zz)*zx);
IVcomb = beta_hat_IV(2,1)/sqrt(var_beta_hat_IV(2,2));
end

