function [x] = obvrule(ptai,vol,lshort,llong)

% On-balance volume indicator.
%
%   INPUTS:
%       ptai - price data
%       vol - volume data
%       lshort - short value
%       llong - long value 
%
%   OUTPUTS:
%       x - binary indicator  

T = size(ptai,1);
obvind = zeros(T,1);
obvind(1) = 1;

i = 2;
while i <= T
    
    if ptai(i) >= ptai(i-1)
        obvind(i) = 1;
    end
    
    if ptai(i) < ptai(i-1)
        obvind(i) = -1;
    end 
    
i = i+1;
end

obv = cumsum(vol.*obvind);
mas = movavg(obv,'simple',lshort);
mal = movavg(obv,'simple',llong);
maind = mas >= mal;
x = maind(12:end,1);
end

