clear;
format long

% Load the original data sets.
% data = the extended Welch and Goyal (2008) data set
% voldata = voldata.csv 
% usr = the NBER indicator data

% Start, end, and date numbers.
ds = 1248;
de = 1740;
dn = datenum(1974,1:504,1);
ndn = dn(12:504)';

% Equity premium.
oret = data(ds:de,17);
ret = log(1+oret);
orf = data(ds:de,11);
rf = log(1+orf);
lrf = [0;rf(1:end-1)];
y = (ret-lrf)*100;

% MFV predictors.
p = data(ds-1:de-1,2);
z = data(ds:de,3);
dy = log(z./p);
p = data(ds:de,2);
z = data(ds:de,3);
dp = log(z./p);
z = data(ds:de,4);
ep = log(z./p);
bm = data(ds:de,5);
st = data(ds:de,6)*-100;
lt = data(ds:de,9)*-100;
agov = data(ds:de,9);
atbill = data(ds:de,6);
sp = (agov-atbill)*100;
aaa = data(ds:de,7);
baa = data(ds:de,8);
dsp = (baa-aaa)*100;
ntis = data(ds:de,10)*-100;
infl = data(ds:de,12)*-100;

% TAI predictors.
ptai = data(ds-11:de,2);
vol = voldata;
[mai19] = marule(ptai,1,9);
[mai112] = marule(ptai,1,12);
[mai29] = marule(ptai,2,9);
[mai212] = marule(ptai,2,12);
[moi9] = morule(ptai,9);
[moi12] = morule(ptai,12);
[obv19] = obvrule(ptai,vol,1,9);
[obv112] = obvrule(ptai,vol,1,12);
[obv29] = obvrule(ptai,vol,2,9);
[obv212] = obvrule(ptai,vol,2,12);

mfvdata = [ndn y dy dp ep bm st lt sp dsp ntis infl usr];
taidata = [ndn y mai19 mai112 mai29 mai212 moi9 moi12 obv19 obv112 obv29 obv212 usr];

clearvars -except mfvdata taidata

writematrix(mfvdata,'mfvdata.csv') 
writematrix(taidata,'taidata.csv') 




