% Table S7.
clear;
addpath('C:\PRdata','C:\PRcode\PRfunctions')
format short

% Data and function inputs.
mfvdata = readmatrix('mfvdata.csv');
ndn = mfvdata(:,1);
y = mfvdata(:,2);
m = 30;
pi = 0.10;
T_star = 302-m;
E = size(y,1);
k = T_star-205;

% Compute the results app_max_for and app_seq_for functions.
Results = zeros(20,4);

for i = 1:10
    x = mfvdata(:,i+2);
    
    if i == 9
        [msfeb,msfepr,p,OSR] = app_max_for(y,x,m,T_star,E,k);
        Results(i,1) = msfeb;
        Results(i,2) = msfepr;
        Results(i,3) = p;
        Results(i,4) = OSR;
    else
        [msfeb,msfepr,p,OSR] = app_max_for(y,x,m,T_star,E,0);
        Results(i,1) = msfeb;
        Results(i,2) = msfepr;
        Results(i,3) = p;
        Results(i,4) = OSR;    
    end
    
    if i == 9
        [msfeb,msfepr,p,OSR] = app_seq_for(y,x,m,pi,T_star,E,k);
        Results(i+10,1) = msfeb;
        Results(i+10,2) = msfepr;
        Results(i+10,3) = p;
        Results(i+10,4) = OSR;
    else
        [msfeb,msfepr,p,OSR] = app_seq_for(y,x,m,pi,T_star,E,0);
        Results(i+10,1) = msfeb;
        Results(i+10,2) = msfepr;
        Results(i+10,3) = p;
        Results(i+10,4) = OSR;       
    end   
end

Results = array2table(Results,'VariableNames',{'MSFEB','MSFEPR','PVALUE','OSRSQUARED'})

clearvars -except Results

