% Table S6.
clear;
addpath('C:\PRdata','C:\PRcode\PRfunctions')
format short

% Data and function inputs.
mfvdata = readmatrix('mfvdata.csv');
taidata = readmatrix('taidata.csv');
ndn = mfvdata(:,1);
y = mfvdata(:,2);
m1 = 15;
m2 = 30;
m3 = 60;
pi = 0.05;
T_star1 = 302-m1;
T_star2 = 302-m2;
T_star3 = 302-m3;
E = size(y,1);

% Compute the results using the app_seq function.
Results = cell(20,6);

for i = 1:10
    x = mfvdata(:,i+2);
    [~,frdate,seq_alphah] = app_seq(y,x,ndn,m1,pi,T_star1,E,0);    
    Results{i,1} = frdate;
    Results{i,2} = seq_alphah;
    [~,frdate,seq_alphah] = app_seq(y,x,ndn,m2,pi,T_star2,E,0);
    Results{i,3} = frdate;
    Results{i,4} = seq_alphah;
    [regnum,frdate,seq_alphah] = app_seq(y,x,ndn,m3,pi,T_star3,E,0);
    Results{i,5} = frdate;
    Results{i,6} = seq_alphah;
end

for i = 11:20
    x = taidata(:,i-8);
    [~,frdate,seq_alphah] = app_seq(y,x,ndn,m1,pi,T_star1,E,0);    
    Results{i,1} = frdate;
    Results{i,2} = seq_alphah;
    [~,frdate,seq_alphah] = app_seq(y,x,ndn,m2,pi,T_star2,E,0);
    Results{i,3} = frdate;
    Results{i,4} = seq_alphah;
    [~,frdate,seq_alphah] = app_seq(y,x,ndn,m3,pi,T_star3,E,0);
    Results{i,5} = frdate;
    Results{i,6} = seq_alphah;
end

Results = cell2table(Results,'VariableNames',{'DATESEQ15','FPRSEQ15','DATESEQ30','FPRSEQ30','DATESEQ60','FPRSEQ60'})

clearvars -except Results



