% Table S5.
clear;
addpath('C:\PRdata','C:\PRcode\PRfunctions')
format short

% Data and function inputs.
mfvdata = readmatrix('mfvdata.csv');
taidata = readmatrix('taidata.csv');
ndn = mfvdata(:,1);
y = mfvdata(:,2);
m1 = 15;
m2 = 30;
m3 = 60;
pi = 0.05;
T_star1 = 302-m1;
T_star2 = 302-m2;
T_star3 = 302-m3;
E = size(y,1);
k1 = T_star1-205;
k2 = T_star2-205;
k3 = T_star3-205;

% Compute the results using the app_seq function.
Results = zeros(20,3);

for i = 1:10
    x = mfvdata(:,i+2);
    
    if i == 9
        [regnum,~,~] = app_seq(y,x,ndn,m1,pi,T_star1,E,k1);
        Results(i,1) = regnum;
        [regnum,~,~] = app_seq(y,x,ndn,m2,pi,T_star2,E,k2);
        Results(i,2) = regnum;
        [regnum,~,~] = app_seq(y,x,ndn,m3,pi,T_star3,E,k3);
        Results(i,3) = regnum;
    else
        [regnum,~,~] = app_seq(y,x,ndn,m1,pi,T_star1,E,0);
        Results(i,1) = regnum;
        [regnum,~,~] = app_seq(y,x,ndn,m2,pi,T_star2,E,0);
        Results(i,2) = regnum;
        [regnum,~,~] = app_seq(y,x,ndn,m3,pi,T_star3,E,0);
        Results(i,3) = regnum;    
    end   
end

for i = 11:20
    x = taidata(:,i-8);
    [regnum,~,~] = app_seq(y,x,ndn,m1,pi,T_star1,E,0);
    Results(i,1) = regnum;
    [regnum,~,~] = app_seq(y,x,ndn,m2,pi,T_star2,E,0);
    Results(i,2) = regnum;
    [regnum,~,~] = app_seq(y,x,ndn,m3,pi,T_star3,E,0);
    Results(i,3) = regnum;
end

Results = array2table(Results,'VariableNames',{'PRSEQ15','PRSEQ30','PRSEQ60'})

clearvars -except Results

