% Table S4.
clear;
addpath('C:\PRdata','C:\PRcode\PRfunctions')
format short

% Data and function inputs.
taidata = readmatrix('taidata.csv');
y = taidata(:,2);
m1 = 15;
m2 = 30;
m3 = 60;
T1 = 302-m1;
T2 = 302-m2;
T3 = 302-m3;

% Compute the results using the preg function.
Results = zeros(30,5);

for i = 1:10
    x = taidata(:,i+2);
    [slope,tstat,IVcomb,R2,Rbar] = preg(y,x,T1);
    Results(i,1) = slope;
    Results(i,2) = tstat;
    Results(i,3) = IVcomb;
    Results(i,4) = R2;
    Results(i,5) = Rbar;
end

for i = 11:20
    x = taidata(:,i-8);
    [slope,tstat,IVcomb,R2,Rbar] = preg(y,x,T2);
    Results(i,1) = slope;
    Results(i,2) = tstat;
    Results(i,3) = IVcomb;
    Results(i,4) = R2;
    Results(i,5) = Rbar;
end

for i = 21:30
    x = taidata(:,i-18);
    [slope,tstat,IVcomb,R2,Rbar] = preg(y,x,T3);
    Results(i,1) = slope;
    Results(i,2) = tstat;
    Results(i,3) = IVcomb;
    Results(i,4) = R2;
    Results(i,5) = Rbar;
end

Results = array2table(Results,'VariableNames',{'BETAHAT','NWTSTAT','IVCOMB','RSQUARED','RBARSQUARED'})

clearvars -except Results

