% Table S2.
clear;
addpath('C:\PRdata','C:\PRcode\PRfunctions')
format short

% Data and function inputs.
mfvdata = readmatrix('mfvdata.csv');
taidata = readmatrix('taidata.csv');
y = mfvdata(:,2);
T = size(y,1);

% Compute the results using the preg function.
Results = zeros(20,5);

for i = 1:10
    x = mfvdata(:,i+2);
    [slope,tstat,IVcomb,R2,Rbar] = preg(y,x,T);
    Results(i,1) = slope;
    Results(i,2) = tstat;
    Results(i,3) = IVcomb;
    Results(i,4) = R2;
    Results(i,5) = Rbar;
end

for i = 11:20
    x = taidata(:,i-8);
    [slope,tstat,IVcomb,R2,Rbar] = preg(y,x,T);
    Results(i,1) = slope;
    Results(i,2) = tstat;
    Results(i,3) = IVcomb;
    Results(i,4) = R2;
    Results(i,5) = Rbar;
end

Results = array2table(Results,'VariableNames',{'BETAHAT','NWTSTAT','IVCOMB','RSQUARED','RBARSQUARED'})

clearvars -except Results
