%% Figures S10 and S11.
clear;
addpath('C:\PRdata','C:\PRcode\PRfunctions')
set(0,'DefaultFigureVisible','off')

% Data and function inputs.
mfvdata=readmatrix('mfvdata.csv');
ndn = mfvdata(:,1);
y = mfvdata(:,2);
usr = mfvdata(:,13);
m = 30;
T_star = 302-m;
E = size(y,1);
k = T_star-205;
pi = 0.10;

% Plot the subfigures using the app_max_fig and app_seq_fig functions.
letter = ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j"];
j = 1;
jj = 1;

for i = 1:10
    x = mfvdata(:,i+2);
    
    if i == 9
        [output] = app_max_fig(y,x,usr,ndn,m,T_star,E,k);
    else
        [output] = app_max_fig(y,x,usr,ndn,m,T_star,E,0);   
    end
    
    if output == 1
        title1 = 'FigureS10';
        title = strcat(title1,letter(j));
        print(gcf,'-dpdf',title);
        j = j+1;
    end
    
    if i == 9
        [output] = app_seq_fig(y,x,usr,ndn,m,pi,T_star,E,k);
    else
        [output] = app_seq_fig(y,x,usr,ndn,m,pi,T_star,E,0);   
    end
    
    if output == 1
        title1 = 'FigureS11';
        title = strcat(title1,letter(jj));
        print(gcf,'-dpdf',title);
        jj = jj+1;
    end
end
%% Figures S12 and S13.
clear;
addpath('C:\PRdata','C:\PRcode\PRfunctions')
set(0,'DefaultFigureVisible','off')

% Data and function inputs.
taidata=readmatrix('taidata.csv');
ndn = taidata(:,1);
y = taidata(:,2);
usr = taidata(:,13);
m = 60;
T_star = 302-m;
E = size(y,1);
pi = 0.10;

% Plot the subfigures using the app_max_fig and app_seq_fig functions.
letter = ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j"];
j = 1;
jj = 1;

for i = 1:10
    x = taidata(:,i+2);
    [output] = app_max_fig(y,x,usr,ndn,m,T_star,E,0);
    
    if output == 1
        title1 = 'FigureS12';
        title = strcat(title1,letter(j));
        print(gcf,'-dpdf',title);
        j = j+1;
    end
    
    [output] = app_seq_fig(y,x,usr,ndn,m,pi,T_star,E,0);
    
    if output == 1
        title1 = 'FigureS13';
        title = strcat(title1,letter(jj));
        print(gcf,'-dpdf',title);
        jj = jj+1;
    end    
end



