function logL = boot_logL(cop_opt, data, theta, dx, dz, weight)

% MY EDITION, Oct 2014

% This function calculate log likelihood of BVP model in Han and Vytlacil (2014) 

% by Sukjin Han

% INPUTS:  
% m is number of simulation repetitions
% n is the sample size


% Fitted probabilities
y = data(:,1);
d = data(:,2);
x = data(:,3:2+dx);
z = data(:,3+dx:2+dx+dz);

alpha = theta(1:dx);
gamma = theta(dx+1:dx+dz) ;
beta = theta(dx+dz+1:2*dx+dz);
delta = theta(2*dx+dz+1);
%gamma = theta(2*dx + 2 :2*dx + dz + 1);
rho = theta(2*dx+dz+2);

% Choose bivariate distribution here
if cop_opt == 0
    copula = @(u1,u2,rho)copulacdf('Gaussian',[u1,u2],[1,rho;rho,1]);
    %copula = @(u1,u2,rho)normcop(u1,u2,rho);
elseif cop_opt == 2
    copula = @(u1,u2,rho)copulacdf('Frank',[u1,u2],rho);
elseif cop_opt == 3
    copula = @(u1,u2,rho)copulacdf('Clayton',[u1,u2],rho);
elseif cop_opt == 5
    copula = @(u1,u2,rho)copulacdf('Gumbel',[u1,u2],rho);
end


s = normcdf(x*alpha + z*gamma);
r0 = normcdf(x*beta);
r1 = normcdf(x*beta + delta);

p11 = copula(r1,s,rho);
p10 = r0 - copula(r0,s,rho);
p01 = s - copula(r1,s,rho);
p00 = 1 - p11 - p10 - p01;

p11(p11<=0) = 1e-10;
p10(p10<=0) = 1e-10;
p01(p01<=0) = 1e-10;
p00(p00<=0) = 1e-10;


L11 = (y==1).*(d==1).*log(p11);
L10 = (y==1).*(d==0).*log(p10);
L01 = (y==0).*(d==1).*log(p01);
L00 = (y==0).*(d==0).*log(p00);

logL0 = (L11 + L10 + L01 + L00) .* weight ;

%fprintf('IsNAN=%d ',sum(isnan(logL0)));
logL0_s = logL0(0==isnan(logL0));
logL0_s = logL0_s(0==isinf(logL0_s));
n_s = size(logL0_s,1);

logL = - sum(logL0_s)/n_s;	% CAUTION: make it minimization problem




