% Matlab code to calculate interpolate daily cpi to match with daily bdi
load bdi_daily.csv
     % 20090316 to 20180716 Index year	month	day	date
load cpi_monthly.csv
     % Jan 2009 to June 2018 cpi	year	month
ndays = size(bdi_daily,1);
bdi_daily = [bdi_daily zeros(ndays,1)];
cpit = cpi_monthly(2,1);
cpit_1 = cpi_monthly(1,1);
month = 2;
day = 1;
  while bdi_daily(day,5) < 20180702
     
    % count days in month
    this_month = bdi_daily(day,3);
    day_count = 1;
    while bdi_daily(day+day_count,3) == this_month
       day_count = day_count + 1;
    end
    
   % interpolate cpi
   slope = (cpit - cpit_1)/(day_count);
   bdi_daily(day,6) = cpit_1;
   for i = 1:day_count
       bdi_daily(day+i,6) = bdi_daily(day+i-1,6) + slope;
       %[i bdi_daily(day+i,6)]
   end

   day = day + day_count;
   month = month + 1;
   cpit = cpi_monthly(month,1);
   cpit_1 = cpi_monthly(month-1,1);
   %[month day this_month day_count]
   
end

% process partial month at end of sample
  
  % calculate how many days so far at end of sample
  day_count = ndays - day;
  % approx how much of month this is likely to be
  
  slope = (cpi_monthly(month,1) - cpi_monthly(month-1,1))/23;

   for i = 1:day_count
       bdi_daily(day+i,6) = bdi_daily(day+i-1,6) + slope;
   end

[bdi_daily(:,1:2)/100 bdi_daily(:,3:4) bdi_daily(1:end,6)]

  




