    // model's variables  
// we matched the names to Dale's notes. variable names come first, then superscripts (if any), then subsricpts.

var c, invest, p_c, r_n, r_m, lambda_c, lambda_k, lambda_ka,
    p_i, r, w, l, k_m, k_n, k, l_m, l_n, y_m, y_n,
    v, a_m, a_n, p_m, p_n, labprod, glabprod, y_cp, g_p_m, g_c, g_invest, 
    govc, govi, y_mc, y_nc, y_mi, y_ni, s, y, betavar;

// innovations to shock processes
varexo eps_v, eps_a_m, eps_a_n, eps_neutral, eps_govc, eps_govi, eps_betavar;

// model's parameters
 parameters betap, delta_m, delta_n, chi_0, chi, alpha_m, alpha_n, alpha_ni, alpha_nc 
    rho_v, rho_a_n, rho_a_m, rho_govc, rho_govi, rho_betavar, eta, nu;

//options_.noprint=1;

model;
/////////////////////////////////////////////////////////////////


// 1
lambda_c*p_c = (1-eta)/(c-eta*c(-1));

// 2
-lambda_c*p_i = lambda_k*(1-nu/2*(invest/invest(-1)-1)^2
     -nu*(invest/invest(-1)-1)*invest/invest(-1))
     +lambda_k(1)*nu*(invest(1)/invest-1)*(invest(1)/invest)^2;

// 3
lambda_c*r_n-lambda_k*(1-delta_n)+lambda_ka = 0;

// 4
lambda_c*r_m-lambda_k*(1-delta_m)+lambda_ka = 0;


lambda_k = betavar*lambda_ka(1);

// 5
lambda_c = betavar*lambda_c(1)*r;

// 6
-chi_0*l^chi*v+lambda_c*w=0;

// 7 
k = (1-delta_m)*k_m + (1-delta_n)*k_n+invest;

k_m +k_n  = k(-1);

// 8
invest + govi = y_ni^(alpha_ni)*y_mi^(1-alpha_ni);

// 9
c + govc = y_nc^(alpha_nc)*y_mc^(1-alpha_nc);

// 10
//p_i = (p_n/alpha_ni)^alpha_ni*(p_m/(1-alpha_ni))^(1-alpha_ni);
y_nc=alpha_nc*(c+govc)*p_c/p_n;


// 11
//p_c = (p_n/alpha_nc)^alpha_nc*(p_m/(1-alpha_nc))^(1-alpha_nc);
y_mc=(1-alpha_nc)*(c+govc)*p_c/p_m;

// 12
y_ni=alpha_ni*(invest+govi)*p_i/p_n;

// 13
y_mi=(1-alpha_ni)*(invest+govi)*p_i/p_m;

// 14
r_m=p_m*alpha_m*y_m/k_m; 

// 15
w  = p_m*(1-alpha_m)*y_m/l_m;

// 16
y_m = k_m^alpha_m*(a_m*l_m)^(1-alpha_m);

// 17
r_n=p_n*alpha_n*y_n/k_n; 

// 18
w = p_n*(1-alpha_n)*y_n/l_n;

// 19
y_n = k_n^alpha_n*(a_n*l_n)^(1-alpha_n);

// 20
l_m + l_n = l;

// 21
y_n = y_nc + y_ni;

// 22
y_m = y_mc + y_mi;

// 23
p_n = 1;

// 24
log(v) = rho_v*log(v(-1))+eps_v;

// 25
log(a_n) = rho_a_n*log(a_n(-1))+eps_a_n+eps_neutral;

// 26
log(a_m) = rho_a_m*log(a_m(-1))+eps_a_m+eps_neutral;

// 27
govc = rho_govc*govc(-1) + eps_govc;

// 28
govi = rho_govi*govi(-1) + eps_govi;

// 29 -- hours worked divided by output at constant prices
labprod = (y_m+y_n)/l;

// 30 -- growth rate of labor productivity
glabprod = log(labprod)-log(labprod(-1));

// 31 -- output at constant prices
y_cp = y_m+y_n;

// 32 growth of relative price
g_p_m = log(p_m)-log(p_m(-1));

// 33 growth of consumption
g_c = log(c)-log(c(-1));

// 34 growth of investment
g_invest = log(invest) - log(invest(-1));

s = p_i*invest/y;

y = p_c*(c+govc)+p_i*(invest+govi);

betavar -betap = rho_betavar *(betavar(-1)-betap)+ eps_betavar; 

end;
shocks;
  var eps_a_n; stderr 0.0;
  var eps_a_m; stderr 0.0;
  var eps_v; stderr 0.0;
end;

steady;
check;
stoch_simul(order=1,nocorr,nomoments,irf=0,noprint);



