% estimate 7 parameters governing the shock processes 

clear
setpath_windows

global M_ oo_
global rho_v_val rho_govc_val rho_govi_val std_neutral std_a_m 


std_neutral= 0.01*0.3696; % standard deviation for the neutral shock
std_a_m = 0.01/0.581*2.951;   % standard deviation for the sectoral technology shock

load_from_disk = 1; % set to 1 if first guess to be used comes from previous run


start_date = 1982.5;
end_date = 2008.5;
[dpi, labprodg, hourspc, espcg, pcepcg] = getdata_long(start_date,end_date);

var_labels =char('Investment Rel. Price','Growth of Lab. Prod.','Hours','Growth of Equipment Investment','Growth of Consumption');

nvars = size(var_labels,1);

dataset = [dpi,labprodg,hourspc/10,pcepcg,espcg];
%dataset = [hourspc,espcg,pcepcg];
dataset = dataset-kron((mean(dataset)),ones(size(dataset,1),1));

%optwt =1; % weighting matrix is diagonal optimal SMM matrix
optwt =2; % optimal GMM matrix
%optwt = -1; % weighting matrix is the identity matrix
[data_momm,wtmat] = wtm_rm_noskew_opt(dataset,optwt);



if load_from_disk
load my_estimates; 
init_theta = distance_param;
else

% change it later
init_theta = [
0.01% std_nshock = distance_param(1);    
0.01% std_cshock = distance_param(2);
0.01% std_govshock = distance_param(3);
0.5% rho_nshock_val = distance_param(4);
0.5% rho_cshock_val = distance_param(5);
0.5% rho_gov_val = distance_param(6);
]; 
end

dynare smallmod4 noclearall



[dist model_momm] = distance_function_smallmod3(init_theta,data_momm,wtmat);

options = optimset('display','iter','MaxIter',200,'MaxFunEvals',1e10,'TolFun',10e-3,'TolX',1e-4);
condn = 0;


% fminunc
%[thetaunc,fval,exitflag] = ...
%    fminunc('distance_function',init_theta,options,var_decomp);
%[likel,thetaunc,firstd,secondd] = csminwel('updatemod',params,0.01*eye(max(size(params))),[],10e-4,10000,paramlabels,modnam,parnam1,parnam2,observedlabels,upperbound,lowerbound,listdrop)

for rep = 1:1
    rep
%fminsearch
 [thetaunc,fval,exitflag] = ...
    fminsearch('distance_function_smallmod3',init_theta,options,data_momm,wtmat);
init_theta = thetaunc;
distance_param = thetaunc;
save my_estimates distance_param
end

[dist model_momm] = distance_function_smallmod3(init_theta,data_momm,wtmat);

[model_momm data_momm]


this_mom = 0;
for i = 1:nvars
    for j=i:nvars
        this_mom = this_mom+1;
    if i == j 
        display(['Variance of ',deblank(var_labels(i,:)),' in the model is ',num2str(model_momm(this_mom)*10000),' and in the data is ',num2str(data_momm(this_mom)*10000)]) 
    else
        display(['The covariance of ',deblank(var_labels(i,:)),' with ',deblank(var_labels(j,:)),' in the model is ',num2str(model_momm(this_mom)),' and in the data is ',num2str(data_momm(this_mom))]) 
 
    end
    end
end