
figure

% The left column  machinery shows PDFs, the right column CDFs.
% The first row shows a sectoral MFP shock in the VAR, MFP model and IST model
% The second row shows a neutral MFP shock for the same cases.


%% Deal with teh VAR results
% load the results
load corr_var corr1ci_var_bc corr2ci_var_bc

% VAR sectoral shock
width = 0.4;


% pdf 
subplot(2,2,1)
pts = linspace(-1,1,200);
[f1,xi1] = ksdensity(corr1ci_var_bc,pts,'width',width,'function','pdf');
h=area(xi1,f1); hold on
set(h,'FaceColor',[.9 0 0])

% CDF
subplot(2,2,2) 
[f1,xi1] = ksdensity(corr1ci_var_bc,pts,'function','cdf','support',[(min(corr1ci_var_bc)-0.0000001) 1.0000001],'width',width);
h=area(xi1,f1); hold on
set(h,'FaceColor',[.9 0 0])

% VAR neutral shock 
%pdf
subplot(2,2,3)
[f1,xi1] = ksdensity(corr2ci_var_bc,pts','width',width,'function','pdf');
h=area(xi1,f1); hold on
set(h,'FaceColor',[.9 0 0])

% CDF
subplot(2,2,4)
[f1,xi1] = ksdensity(corr2ci_var_bc,pts,'function','cdf','support',[-1.000000001 1.0000001],'width',width);
h=area(xi1,f1); hold on
set(h,'FaceColor',[.9 0 0])




%% Monte Carlo results from MFP model
load monte_results corr1ci_bc corr2ci_bc

% sectoral MFP shock

%pdf
subplot(2,2,1)
[f1,xi1] = ksdensity(corr1ci_bc,pts,'width',width,'function','pdf');
plot(xi1,f1,'k','linewidth',1.5);

%cdf
subplot(2,2,2)
[f1,xi1] = ksdensity(corr1ci_bc,pts,'function','cdf','support',[-1.000000000001 1.0000001],'width',width);
plot(xi1,f1,'k','linewidth',1.5);

% neutral shock
% pdf
subplot(2,2,3)
[f1,xi1] = ksdensity(corr2ci_bc,pts,'width',width,'function','pdf');
plot(xi1,f1,'k','linewidth',1.5);

% cdf
subplot(2,2,4)
[f1,xi1] = ksdensity(corr2ci_bc,pts,'function','cdf','support',[-1.000000000001 1.0000001],'width',width);
plot(xi1,f1,'k','linewidth',1.5);

%% Deal with IST model


load monte_ist_results corr1ci_bc  corr2ci_bc nreps 
% sectoral MFP shock

%pdf
subplot(2,2,1)
[f1,xi1] = ksdensity(corr1ci_bc,pts,'width',width,'function','pdf');
plot(xi1,f1,'b--','linewidth',1.5);

this_ylim = ylim;
ylim([0 this_ylim(2)])

legend('VAR','MFP model','IST model','Location','NorthWest')% cdf
title('PDF, conditional on sectoral shock')

%cdf
subplot(2,2,2)
[f1,xi1] = ksdensity(corr1ci_bc,pts,'function','cdf','support',[-1.000000000001 1.0000001],'width',width);
plot(xi1,f1,'b--','linewidth',1.5);
title('CDF, conditional on sectoral shock')
% neutral shock
% pdf
subplot(2,2,3)
[f1,xi1] = ksdensity(corr2ci_bc,pts,'width',width,'function','pdf');
plot(xi1,f1,'b--','linewidth',1.5);
title('PDF, conditional on neutral shock')

subplot(2,2,4)
[f1,xi1] = ksdensity(corr2ci_bc,pts,'function','cdf','support',[-1.000000000001 1.0000001],'width',width);
plot(xi1,f1,'b--','linewidth',1.5);
title('CDF, conditional on neutral shock')



%%%%%%%%%%%%
%% add population moments from the MFP and IST models

load compare_var_data_ist mei_corr neutral_corr

subplot(2,2,1)
mei_corr = mei_corr(1,2);     
h=vline(mei_corr,'b');
set(h,'LineWidth',1.5,'LineStyle','--')


subplot(2,2,2) 
h=vline(mei_corr,'b');
set(h,'LineWidth',1.5,'LineStyle','--')


subplot(2,2,3)
neutral_corr = neutral_corr(1,2);     
h=vline(neutral_corr,'b');
set(h,'LineWidth',1.5,'LineStyle','--')


subplot(2,2,4)     
h=vline(neutral_corr,'b');
set(h,'LineWidth',1.5,'LineStyle','--')


load compare_var_data mei_corr neutral_corr

subplot(2,2,1)
mei_corr = mei_corr(1,2);     
h=vline(mei_corr,'k');
set(h,'LineWidth',1.5,'LineStyle','-')


subplot(2,2,2) 
h=vline(mei_corr,'k');
set(h,'LineWidth',1.5,'LineStyle','-')


subplot(2,2,3)
neutral_corr = neutral_corr(1,2);     
h=vline(neutral_corr,'k');
set(h,'LineWidth',1.5,'LineStyle','-')


subplot(2,2,4)     
h=vline(neutral_corr,'k');
set(h,'LineWidth',1.5,'LineStyle','-')
