%% run Monte Carlo experiment
clear all

setpath_windows

load_from_disk = 1;
compute_correlation = 0;

dynare smallmod4 noclearall

dr_ = oo_.dr;
ys_ = oo_.dr.ys;
lgy_ = M_.endo_names;
lgx_ = M_.exo_names;
if isfield(M_,'nstatic')
    nstatic = M_.nstatic;
    nfwrd = M_.nfwrd;
else
    nstatic = dr_.nstatic;
    nfwrd = dr_.nfwrd;
end

[p,q]=get_pq(dr_,nstatic,nfwrd);

std_neutral= 0.01*0.3696;      % standard deviation for the neutral shock
std_a_m = 0.01/0.581*2.951;   % standard deviation for the sectoral technology shock

std_v_shock = 0.1198;
std_govc_shock = 0.0319;
std_betavar_shock = 0.0002;

shock = [std_v_shock
    std_a_m
    0
    std_neutral
    std_govc_shock
    0
    std_betavar_shock];



 
   

irf_length=100; 
nreps =  1000;

irfs1 = zeros(nreps,4,irf_length);
irfs2 = zeros(nreps,4,irf_length);

corr1ci_bc = zeros(nreps,1);
corr2ci_bc = zeros(nreps,1);

dset = 'f1';
if ~load_from_disk
s1=RandStream('mt19937ar','Seed',1);
    for rep = 1:nreps
    rep
    error = 1;
    while error
        try
            std_mat = diag(shock);
            
            nperiods = 10000;
            
            
            %randn('seed',rep);
            % get monte carlo sample from model
            makedata
            
            % construct dataset for VAR
            %dataset = [f1_grpjepc_data, f1_glabprod_data, f1_n_agg_data, f1_gc_cp_data, f1_gj_cp_data];
            dataset = [f1_g_p_m_data, f1_glabprod_data, f1_l_data, f1_g_c_data, f1_g_invest_data];
            %dataset = dataset-kron((mean(dataset)),ones(size(dataset,1),1));
            
            
            
            
            norbs = size(dataset,1);
            % set the share of investment to the sample average
            
            % set parameters for the estimation exercies
            numvar=size(dataset,2);   % number of dependent variables
            varlag = 50;               % number of lags
            varlagmat = varlag*ones(numvar);
            
            startpos = 1;             % initial observation
            endpos = size(dataset,1); % final observation
            
            % get OLS estimates for VAR
            [coefs,coverr,errmat] = estimate(varlagmat,zeros(numvar),ones(numvar,1),dataset,startpos,endpos);
            [cofb,const_b]=ols2ar(coefs(1:end,:),1,0);
            
            % impose LR restrictions through Cholesky decomposition.
            coverr = errmat'*errmat/(size(errmat,1));
            Vmat = zeros(numvar);
            for i = 1:varlag
                Vmat = Vmat - cofb(:,:,i);
            end
            Vmat = Vmat+eye(numvar);
            Vmatinv = eye(numvar)/Vmat;
            
            [cholmat,pchol] = chol(Vmatinv*coverr*Vmatinv');
            
            A0inv = Vmat*cholmat';
            
            if compute_correlation
            %construct long-run correlation at BC frequencies
            samplelength=nperiods;
            errpos = round((norbs-varlag-1)*rand(samplelength,1)+ones(samplelength,1));
            errmatrep = errmat(errpos,:);
            
            A0=inv(A0inv);
            ierrmat = A0*errmatrep';
            ierrmat1 = 0*ierrmat;
            ierrmat1(1,:) = ierrmat(1,:);
            errmat1 = A0inv*ierrmat1;
            repdata1 = mkymonte_0(dataset,coefs,errmat1');
            
            % compute the consuption and investment levels
            consumption1 =cumsum(repdata1(:,4));
            investment1=cumsum(repdata1(:,5));
            
            thiscorr=corrcoef(bpass(consumption1,6,32),bpass(investment1,6,32));
            corr1ci_bc(rep) = thiscorr(1,2);
            
            
            ierrmat2 = 0*ierrmat;
            ierrmat2(2,:) = ierrmat(2,:);
            errmat2 = A0inv*ierrmat2;
            repdata2 = mkymonte_0(dataset,coefs,errmat2');
            
            % compute the consumption and investment levels
            consumption2 =cumsum(repdata2(:,4));
            investment2=cumsum(repdata2(:,5));
            
            thiscorr=corrcoef(bpass(consumption2,6,32),bpass(investment2,6,32));
            corr2ci_bc(rep) = thiscorr(1,2);
            
    end
            
            
            
            % compute the output level
           
%             consumption1 =cumsum(repdata1(:,4));
%             investment1=cumsum(repdata1(:,5));
            
%             thiscorr=corrcoef(bpass(consumption1,6,32),bpass(investment1,6,32));
%             corr1ci_bc(rep) = thiscorr(1,2);
            
            % construct identified responses to first  shock
            shock1 = [-1;0;0;0;0];
            history1=mkirf(A0inv*shock1,cofb,irf_length);
            
            shock2 = [0;1;0;0;0];
            history2=mkirf(A0inv*shock2,cofb,irf_length);
            
            
            for i=1:numvar
                irfs1(rep,i,:) = 100*history1(i,:);
                irfs2(rep,i,:) = 100*history2(i,:);
            end
            error = 0;
         catch
             junk = 1
         end
    end
end
save monte_results_largesample irfs1 irfs2 nreps 

else
    load monte_results_largesample
end


% now get the IRFs from the DSGE model
shock = [0 std_a_m 0 0 0 0 0]'
niters = irf_length+1;
history = zeros(size(p,1),niters);
for this_iter = 2:niters
    if this_iter == 2
    history(:,this_iter) = p*history(:,this_iter-1)+q*shock;
    else
    history(:,this_iter) = p*history(:,this_iter-1);    
    end
end
history = history(:,2:end);



p_m_pos = strmatch('p_m',lgy_,'exact');
long_run_rel_price = history(p_m_pos,end)/ys_(p_m_pos)*100;


for i=1:nreps
    model_pireps1(i,:) = cumsum(irfs1(i,1,:));
    rescale = model_pireps1(i,end)/long_run_rel_price;
    model_pireps1(i,:)=model_pireps1(i,:)/rescale;
    
    model_labprodreps1(i,:) = cumsum(irfs1(i,2,:))/rescale;
    
    model_hoursreps1(i,:) = irfs1(i,3,:)/rescale;
   
    model_productionreps1(i,:) = model_labprodreps1(i,:)+model_hoursreps1(i,:);
   
    model_creps1(i,:) = cumsum(irfs1(i,4,:))/rescale;
    
    model_ireps1(i,:) = cumsum(irfs1(i,5,:))/rescale;
  
end

model_pireps1 = sort(model_pireps1);
model_labprodreps1 = sort(model_labprodreps1);
model_hoursreps1 = sort(model_hoursreps1);
model_productionreps1 = sort(model_productionreps1);
model_creps1 = sort(model_creps1);
model_ireps1 = sort(model_ireps1);



%% figure with model MC results on top of VAR results

figure; 

subplot(3,2,1);
fill([ 1:irf_length,fliplr(1:irf_length) ], [ model_pireps1(ceil(nreps*.05),:),fliplr(model_pireps1(floor(nreps*.95),:))],[1  0.8  0.8]); hold on

plot(history(p_m_pos,:)/ys_(p_m_pos)*100,'r-','LineWidth',2); hold on
legend( 'Sectoral Model, 90% Conf. Interval','Sectoral Model, MFP shock')
ylabel('Percent')
title('Price of investment')
xlim([1 irf_length])

subplot(3,2,2)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ model_labprodreps1(ceil(nreps*.05),:),fliplr(model_labprodreps1(floor(nreps*.95),:))],[1  0.8  0.8]); hold on
labprod_pos= strmatch('labprod',lgy_,'exact');
plot(history(labprod_pos,:)/ys_(labprod_pos)*100,'r-','LineWidth',2); hold on
ylabel('Percent')
hold off
xlim([1 irf_length])
title('Labor productivity')
ylabel('Percent')


subplot(3,2,3)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ model_hoursreps1(ceil(nreps*.05),:),fliplr(model_hoursreps1(floor(nreps*.95),:))],[1  0.8  0.8]); hold on
plot(history(strmatch('l',lgy_,'exact'),:)*100,'r-','LineWidth',2); hold on
hold off
title('Hours per capita')
xlim([1 irf_length])
ylabel('Percent')


subplot(3,2,4)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ model_productionreps1(ceil(nreps*.05),:),fliplr(model_productionreps1(floor(nreps*.95),:))],[1  0.8  0.8]); hold on
y_cp_pos= strmatch('y_cp',lgy_,'exact');
plot(history(y_cp_pos,:)/ys_(y_cp_pos)*100,'r-','LineWidth',2); hold on
title('Output at constant prices')
xlim([1 irf_length])
ylabel('Percent')

subplot(3,2,5)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ model_creps1(ceil(nreps*.05),:),fliplr(model_creps1(floor(nreps*.95),:))],[1  0.8  0.8]); hold on
c_pos= strmatch('c',lgy_,'exact');
plot(history(c_pos,:)/ys_(c_pos)*100,'r-','LineWidth',2); hold on
title('Consumption')
xlim([1 irf_length])
ylabel('Percent')

subplot(3,2,6)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ model_ireps1(ceil(nreps*.05),:),fliplr(model_ireps1(floor(nreps*.95),:))],[1  0.8  0.8]); hold on
invest_pos= strmatch('invest',lgy_,'exact');
plot(history(invest_pos,:)/ys_(invest_pos)*100,'r-','LineWidth',2); hold on
title('Investment')
xlim([1 irf_length])
ylabel('Percent')

%%
% get VAR IRFs
load corr_var corr1ci_var_bc ...
     history1 pireps1 labprodreps1 hoursreps1...
     productionreps1 esreps1 creps1 ...
     history2 pireps2 labprodreps2 hoursreps2...
     productionreps2 esreps2 creps2 




%% figure with model MC results on top of VAR results

figure; 

subplot(3,2,1);
fill([ 1:irf_length,fliplr(1:irf_length) ], [ model_pireps1(ceil(nreps*.05),:),fliplr(model_pireps1(floor(nreps*.95),:))],[1  0.8  0.8]); hold on

plot(history(p_m_pos,:)/ys_(p_m_pos)*100,'r-','LineWidth',2); hold on
legend( 'VAR, 90% Conf. Interval','Sectoral MFP Model, MFP shock')
ylabel('Percent')
title('Price of investment')
xlim([1 irf_length])

subplot(3,2,2)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ model_labprodreps1(ceil(nreps*.05),:),fliplr(model_labprodreps1(floor(nreps*.95),:))],[1  0.8  0.8]); hold on
labprod_pos= strmatch('labprod',lgy_,'exact');
plot(history(labprod_pos,:)/ys_(labprod_pos)*100,'r-','LineWidth',2); hold on
ylabel('Percent')
hold off
xlim([1 irf_length])
title('Labor productivity')
ylabel('Percent')


subplot(3,2,3)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ model_hoursreps1(ceil(nreps*.05),:),fliplr(model_hoursreps1(floor(nreps*.95),:))],[1  0.8  0.8]); hold on
plot(history(strmatch('l',lgy_,'exact'),:)*100,'r-','LineWidth',2); hold on
hold off
title('Hours per capita')
xlim([1 irf_length])
ylabel('Percent')


subplot(3,2,4)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ model_productionreps1(ceil(nreps*.05),:),fliplr(model_productionreps1(floor(nreps*.95),:))],[1  0.8  0.8]); hold on
y_cp_pos= strmatch('y_cp',lgy_,'exact');
plot(history(y_cp_pos,:)/ys_(y_cp_pos)*100,'r-','LineWidth',2); hold on
title('Output at constant prices')
xlim([1 irf_length])
ylabel('Percent')

subplot(3,2,5)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ model_creps1(ceil(nreps*.05),:),fliplr(model_creps1(floor(nreps*.95),:))],[1  0.8  0.8]); hold on
c_pos= strmatch('c',lgy_,'exact');
plot(history(c_pos,:)/ys_(c_pos)*100,'r-','LineWidth',2); hold on
title('Consumption')
xlim([1 irf_length])
ylabel('Percent')

subplot(3,2,6)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ model_ireps1(ceil(nreps*.05),:),fliplr(model_ireps1(floor(nreps*.95),:))],[1  0.8  0.8]); hold on
invest_pos= strmatch('invest',lgy_,'exact');
plot(history(invest_pos,:)/ys_(invest_pos)*100,'r-','LineWidth',2); hold on
title('Investment')
xlim([1 irf_length])
ylabel('Percent')

