clear
setpath_windows

load_corr = 1;
export_var_results = 0; % set to 1 to export data after computing correlations

full_sample = 0; % set to 1 to consider full sample
durables = 0;    % set to 1 to include durables in investment
if durables == 1
    full_sample =0;
end
bias_correction = 0;   % 0 Runkle confidence intervals
                       % 1 Kilian bias-corrected intervals


if full_sample || durables
    start_date = 1948.25;
    end_date = 2015;
else
    start_date = 1982.5;
    end_date = 2008.5;
end

[dpi, labprodg, hourspc, espcg, pcepcg] = getdata_long(start_date,end_date,durables);

dataset = [dpi,labprodg,hourspc,espcg,pcepcg];
dataset = dataset-kron((mean(dataset)),ones(size(dataset,1),1));

nobs = size(dataset,1);


% set parameters for the estimation exercies
numvar=size(dataset,2);   % number of dependent variables
varlag = 4;               % number of lags
varlagmat = varlag*ones(numvar);
nperiods = 100;           % number of periods for the IRFs

nreps = 10000;             % number of bootstrap repetitions

nreps_corr = 10000;


startpos = 1;             % initial observation
endpos = size(dataset,1); % final observation

% get OLS estimates



if bias_correction
nvars = size(dataset,2);
[cofA,coverr,errmat,const_b]=olsvarc(dataset,varlag);
const_b = const_b(1:nvars);
errmat = errmat(1:nvars,:)';

[cofAnobias]=ASYBC(cofA,coverr,nobs,varlag,nvars);
cofb = cofA2ar(cofAnobias,nvars,varlag);
else
    [coefs,coverr,errmat] = estimate(varlagmat,zeros(numvar),ones(numvar,1),dataset,startpos,endpos);
[cofb,const_b]=ols2ar(coefs(1:end,:),1,0);
end


% impose LR restrictions through Cholesky decomposition.
coverr = errmat'*errmat/(size(errmat,1));
Vmat = zeros(numvar);
for i = 1:varlag
    Vmat = Vmat - cofb(:,:,i);
end
Vmat = Vmat+eye(numvar);
Vmatinv = eye(numvar)/Vmat;

[cholmat,pchol] = chol(Vmatinv*coverr*Vmatinv');
A0inv = Vmat*cholmat';

ierrmat = inv(A0inv)*errmat';
decomp = zeros(numvar);

for i=1:numvar
    ierrmat_tmp = 0*ierrmat;
    ierrmat_tmp(i,:) = ierrmat(i,:);
    errmat_tmp = A0inv*ierrmat_tmp;
    
    if bias_correction
        repdata_tmp = mkymonte_0kilian(dataset,cofb,errmat_tmp');
    else
        repdata_tmp = mkymonte_0(dataset,coefs,errmat_tmp');
    end
    
    % shocks are on the rows of decomp -- variables are on the columns
    for j = 1:numvar
        decomp(i,j) = var(repdata_tmp(:,j));
    end
    
end

for j=1:numvar
    sumdecomp = sum(decomp(:,j));
    for i=1:numvar
        decomp(i,j) = decomp(i,j)/sumdecomp;
    end
end



% construct identified responses to first and second shock
shock1 = [-100;0;0;0;0];
shock2 = [0;100;0;0;0];
history1=mkirf(A0inv*shock1,cofb,nperiods);
history2=mkirf(A0inv*shock2,cofb,nperiods);

monte_sample = size(dataset,1);
isconstant = 1;
iscontemp = 0;
yw = 0;

construct_corrci=1;
if construct_corrci
    % construct confidence intervals
    
    
    pop_factor = 10;
    
    if ~load_corr
        [corr1ci_var_bc, corr2ci_var_bc] = corr_monte(coefs,errmat,dataset,varlag,nreps_corr,monte_sample,isconstant,iscontemp,yw,pop_factor);
        
        if full_sample
            save my_corr1c1_var_bc_full_sample corr1ci_var_bc corr2ci_var_bc start_date end_date
        elseif durables
            save my_corr1c1_var_bc_durables corr1ci_var_bc corr2ci_var_bc start_date end_date
        else
            save my_corr1c1_var_bc corr1ci_var_bc corr2ci_var_bc start_date end_date
        end
    else
        if full_sample
            load my_corr1c1_var_bc_full_sample corr1ci_var_bc corr2ci_var_bc
        elseif durables
            load my_corr1c1_var_bc_durables corr1ci_var_bc corr2ci_var_bc
        else
            load my_corr1c1_var_bc corr1ci_var_bc corr2ci_var_bc
        end
    end
    
    width = 0.4;
    pts = linspace(-1,1,200);
    [f1,xi1] = ksdensity(corr1ci_var_bc,pts,'function','cdf','support',[(min(corr1ci_var_bc)-0.0000001) 1.0000001],'width',width);
    h=area(xi1,f1); hold on
    set(h,'FaceColor',[.9 0 0])
    
end


%%
if bias_correction
    [irfs1, irfs2] = confint_kilian(dataset,cofb,const_b,errmat,varlag,nreps,nperiods,shock1,shock2);
else
    [irfs1, irfs2] = confint(coefs,errmat,dataset,varlag,nreps,nperiods,isconstant,iscontemp,yw,shock1,shock2);
end

%% turn growth rates to levels, and compute output measure
pireps1 = zeros(nreps,nperiods);
pireps2 = zeros(nreps,nperiods);
labprodreps1 = zeros(nreps,nperiods);
labprodreps2 = zeros(nreps,nperiods);
hoursreps1 = zeros(nreps,nperiods);
hoursreps2 = zeros(nreps,nperiods);
productionreps1 = zeros(nreps,nperiods);
productionreps2 = zeros(nreps,nperiods);
esreps1 = zeros(nreps,nperiods);
esreps2 = zeros(nreps,nperiods);
creps1 = zeros(nreps,nperiods);
creps2 = zeros(nreps,nperiods);

for i=1:nreps
    pireps1(i,:) = cumsum(irfs1(i,1,:));
    pireps2(i,:) = cumsum(irfs2(i,1,:));
    
    labprodreps1(i,:) = cumsum(irfs1(i,2,:));
    labprodreps2(i,:) = cumsum(irfs2(i,2,:));
    
    hoursreps1(i,:) = irfs1(i,3,:);
    hoursreps2(i,:) = irfs2(i,3,:);
    
    esreps1(i,:) = cumsum(irfs1(i,4,:));
    esreps2(i,:) = cumsum(irfs2(i,4,:));
    
    productionreps1(i,:) = labprodreps1(i,:)+hoursreps1(i,:);
    productionreps2(i,:) = labprodreps2(i,:)+hoursreps2(i,:);
    
    creps1(i,:) = cumsum(irfs1(i,5,:));
    creps2(i,:) = cumsum(irfs2(i,5,:));
end

pireps1 = sort(pireps1);
pireps2 = sort(pireps2);
labprodreps1 = sort(labprodreps1);
labprodreps2 = sort(labprodreps2);
hoursreps1 = sort(hoursreps1);
hoursreps2 = sort(hoursreps2);
productionreps1 = sort(productionreps1);
productionreps2 = sort(productionreps2);
esreps1 = sort(esreps1);
esreps2 = sort(esreps2);
creps1 = sort(creps1);
creps2 = sort(creps2);

if export_var_results
    
    
    
    if full_sample
            
            save corr_var_full_sample corr1ci_var_bc corr2ci_var_bc...
        history1 pireps1 labprodreps1 hoursreps1...
        productionreps1 esreps1 creps1 ...
        history2 pireps2 labprodreps2 hoursreps2...
        productionreps2 esreps2 creps2
    
        elseif durables
            save corr_var_durables corr1ci_var_bc corr2ci_var_bc...
        history1 pireps1 labprodreps1 hoursreps1...
        productionreps1 esreps1 creps1 ...
        history2 pireps2 labprodreps2 hoursreps2...
        productionreps2 esreps2 creps2
    
        else
            save corr_var corr1ci_var_bc corr1ci_var_bc corr2ci_var_bc...
        history1 pireps1 labprodreps1 hoursreps1...
        productionreps1 esreps1 creps1 ...
        history2 pireps2 labprodreps2 hoursreps2...
        productionreps2 esreps2 creps2
    end 
end


%% Figure 1, responses to a decline in the price of capital, VAR only

figure;

subplot(3,2,1);
plot(cumsum(history1(1,:)))
hold on
plot(pireps1(ceil(nreps*.05),:),'r:')
plot(pireps1(floor(nreps*.95),:),'r:')
hold off
title('Price of investment')

subplot(3,2,2)
plot(cumsum(history1(2,:)))
hold on
plot(labprodreps1(ceil(nreps*.05),:),'r:')
plot(labprodreps1(floor(nreps*.95),:),'r:')
hold off

title('Labor productivity')

subplot(3,2,3)
plot(history1(3,:))
hold on
plot(hoursreps1(ceil(nreps*.05),:),'r:')
plot(hoursreps1(floor(nreps*.95),:),'r:')
hold off
title('Hours per capita')

subplot(3,2,4)
plot(cumsum(history1(2,:))+history1(3,:))
hold on
plot(productionreps1(ceil(nreps*.05),:),'r:')
plot(productionreps1(floor(nreps*.95),:),'r:')
hold off
title('Output per capita')

subplot(3,2,5)
plot(cumsum(history1(4,:)))
hold on
plot(esreps1(ceil(nreps*.05),:),'r:')
plot(esreps1(floor(nreps*.95),:),'r:')
hold off
title('Investment per capita')

subplot(3,2,6)
plot(cumsum(history1(5,:)))
hold on
plot(creps1(ceil(nreps*.05),:),'r:')
plot(creps1(floor(nreps*.95),:),'r:')
hold off
title('Consumption per capita')


% Figure 2, responses to a neutral MFP shock, VAR only
figure;

subplot(3,2,1);
plot(cumsum(history2(1,:)))
hold on
plot(pireps2(ceil(nreps*.05),:),'r:')
plot(pireps2(floor(nreps*.95),:),'r:')
hold off
title('Price of investment')

subplot(3,2,2)
plot(cumsum(history2(2,:)))
hold on
plot(labprodreps2(ceil(nreps*.05),:),'r:')
plot(labprodreps2(floor(nreps*.95),:),'r:')
hold off

title('Labor productivity')

subplot(3,2,3)
plot(history2(3,:))
hold on
plot(hoursreps2(ceil(nreps*.05),:),'r:')
plot(hoursreps2(floor(nreps*.95),:),'r:')
hold off
title('Hours per capita')

subplot(3,2,4)
plot(cumsum(history2(2,:))+history2(3,:))
hold on
plot(productionreps2(ceil(nreps*.05),:),'r:')
plot(productionreps2(floor(nreps*.95),:),'r:')
hold off

title('Output per capita')
subplot(3,2,5)
plot(cumsum(history2(4,:)))
hold on
plot(esreps2(ceil(nreps*.05),:),'r:')
plot(esreps2(floor(nreps*.95),:),'r:')
hold off
title('Investment per capita')

subplot(3,2,6)
plot(cumsum(history2(5,:)))
hold on
plot(creps2(ceil(nreps*.05),:),'r:')
plot(creps2(floor(nreps*.95),:),'r:')
hold off
title('Consumption per capita')


irf_length = nperiods


figure; 

nreps_var = size(pireps1,1);

fill_color = [0  0.6  0.8];
subplot(3,2,1);

fill([ 1:irf_length,fliplr(1:irf_length) ], [ pireps1(ceil(nreps_var*.05),:),fliplr(pireps1(floor(nreps_var*.95),:))],fill_color); 
hold on
plot(cumsum(history1(1,:)),'k--','LineWidth',2); %point estimate from VAR


%plot([1:2:100;1:2:100],[pireps1(ceil(nreps_var*.05),1:2:100);pireps1(floor(nreps_var*.95),1:2:100)],'k--') % VAR CI
ylabel('Percent')
legend('VAR. 90% Conf. Interval','VAR point estimate')
hold on
title('Price of investment')
xlim([1 irf_length])
ylabel('Percent')


subplot(3,2,2)

fill([ 1:irf_length,fliplr(1:irf_length) ], [ labprodreps1(ceil(nreps_var*.05),:),fliplr(labprodreps1(floor(nreps_var*.95),:))],fill_color); 
hold on
plot(cumsum(history1(2,:)),'k--','LineWidth',2); %point estimate from VAR

%plot([1:2:100;1:2:100],[labprodreps1(ceil(nreps*.05),1:2:100);labprodreps1(floor(nreps*.95),1:2:100)],'k--')
ylabel('Percent')
hold off
xlim([1 irf_length])
title('Labor productivity')
ylabel('Percent')


subplot(3,2,3)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ hoursreps1(ceil(nreps_var*.05),:),fliplr(hoursreps1(floor(nreps_var*.95),:))],fill_color); 
hold on
plot(history1(3,:),'k--','LineWidth',2);  %point estimate from VAR
%plot([1:2:100;1:2:100],[hoursreps1(ceil(nreps*.05),1:2:100);hoursreps1(floor(nreps*.95),1:2:100)],'k--')
hold off
title('Hours per capita')
xlim([1 irf_length])
ylabel('Percent')


subplot(3,2,4)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ productionreps1(ceil(nreps_var*.05),:),fliplr(productionreps1(floor(nreps_var*.95),:))],fill_color); 
hold on
plot(cumsum(history1(2,:))+history1(3,:),'k--','LineWidth',2);%point estimate from VAR
%plot([1:2:100;1:2:100],[productionreps1(ceil(nreps*.05),1:2:100);productionreps1(floor(nreps*.95),1:2:100)],'k--')
hold off
title('Output per capita')
xlim([1 irf_length])
ylabel('Percent')


subplot(3,2,5)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ creps1(ceil(nreps_var*.05),:),fliplr(creps1(floor(nreps_var*.95),:))],fill_color); 
hold on
plot(cumsum(history1(5,:)),'k--','LineWidth',2); %point estimate from VAR
%plot([1:2:100;1:2:100],[creps1(ceil(nreps*.05),1:2:100);creps1(floor(nreps*.95),1:2:100)],'k--')
hold off
title('Consumption per capita')
xlabel('Quarters')
xlim([1 irf_length])
ylabel('Percent')


subplot(3,2,6)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ esreps1(ceil(nreps_var*.05),:),fliplr(esreps1(floor(nreps_var*.95),:))],fill_color); 
hold on
plot(cumsum(history1(4,:)),'k--','LineWidth',2);  %point estimate from VAR
%plot([1:2:100;1:2:100],[esreps1(ceil(nreps*.05),1:2:100);esreps1(floor(nreps*.95),1:2:100)],'k--')
hold off
title('Investment per capita')
xlabel('Quarters')
xlim([1 irf_length])
ylabel('Percent')





%% Figure with VAR results only for shock to labor productivity

figure; 

nreps_var = size(pireps2,1);

fill_color = [0  0.6  0.8];
subplot(3,2,1);

fill([ 1:irf_length,fliplr(1:irf_length) ], [ pireps2(ceil(nreps_var*.05),:),fliplr(pireps2(floor(nreps_var*.95),:))],fill_color); 
hold on
plot(cumsum(history2(1,:)),'k--','LineWidth',2); %point estimate from VAR


%plot([1:2:100;1:2:100],[pireps2(ceil(nreps_var*.05),1:2:100);pireps2(floor(nreps_var*.95),1:2:100)],'k--') % VAR CI
ylabel('Percent')
legend('VAR. 90% Conf. Interval','VAR point estimate')
hold on
title('Price of investment')
xlim([1 irf_length])
ylabel('Percent')


subplot(3,2,2)

fill([ 1:irf_length,fliplr(1:irf_length) ], [ labprodreps2(ceil(nreps_var*.05),:),fliplr(labprodreps2(floor(nreps_var*.95),:))],fill_color); 
hold on
plot(cumsum(history2(2,:)),'k--','LineWidth',2); %point estimate from VAR

%plot([1:2:100;1:2:100],[labprodreps2(ceil(nreps*.05),1:2:100);labprodreps2(floor(nreps*.95),1:2:100)],'k--')
ylabel('Percent')
hold off
xlim([1 irf_length])
title('Labor productivity')
ylabel('Percent')


subplot(3,2,3)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ hoursreps2(ceil(nreps_var*.05),:),fliplr(hoursreps2(floor(nreps_var*.95),:))],fill_color); 
hold on
plot(history2(3,:),'k--','LineWidth',2);  %point estimate from VAR
%plot([1:2:100;1:2:100],[hoursreps2(ceil(nreps*.05),1:2:100);hoursreps2(floor(nreps*.95),1:2:100)],'k--')
hold off
title('Hours per capita')
xlim([1 irf_length])
ylabel('Percent')


subplot(3,2,4)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ productionreps2(ceil(nreps_var*.05),:),fliplr(productionreps2(floor(nreps_var*.95),:))],fill_color); 
hold on
plot(cumsum(history2(2,:))+history2(3,:),'k--','LineWidth',2);%point estimate from VAR
%plot([1:2:100;1:2:100],[productionreps2(ceil(nreps*.05),1:2:100);productionreps2(floor(nreps*.95),1:2:100)],'k--')
hold off
title('Output per capita')
xlim([1 irf_length])
ylabel('Percent')


subplot(3,2,5)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ creps2(ceil(nreps_var*.05),:),fliplr(creps2(floor(nreps_var*.95),:))],fill_color); 
hold on
plot(cumsum(history2(5,:)),'k--','LineWidth',2); %point estimate from VAR
%plot([1:2:100;1:2:100],[creps2(ceil(nreps*.05),1:2:100);creps2(floor(nreps*.95),1:2:100)],'k--')
hold off
title('Consumption per capita')
xlabel('Quarters')
xlim([1 irf_length])
ylabel('Percent')


subplot(3,2,6)
fill([ 1:irf_length,fliplr(1:irf_length) ], [ esreps2(ceil(nreps_var*.05),:),fliplr(esreps2(floor(nreps_var*.95),:))],fill_color); 
hold on
plot(cumsum(history2(4,:)),'k--','LineWidth',2);  %point estimate from VAR
%plot([1:2:100;1:2:100],[esreps2(ceil(nreps*.05),1:2:100);esreps2(floor(nreps*.95),1:2:100)],'k--')
hold off
title('Investment per capita')
xlabel('Quarters')
xlim([1 irf_length])
ylabel('Percent')
