
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Make plots with 2 lines per panel
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% plot IRFs

%% First figure

% titles for each panel
titlelist = char('Output, CP (over a long horizon)','Output, CP (medium-run horizon)',...
                 'Consumption, CP','Agg. Investment, CP',...
                 'Agg. Investment (output share)','Relative Price of Equipment Investment');
             
% labels for y axis in each panel
ylabels = char('Percent Dev. From S.S.','Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','P.Pt. Dev. From S.S.','Percent Dev. From S.S.');

scale1 = 1;%/(f1_y_cp_irf(end)/f1_y_cp)/100;
scale2 = 1;%/(f2_y_cp_irf(end)/f2_y_cp)/100;

% needs to match order in titlelist           
first_line = 100*scale1*[f1_y_cp_irf/f1_y_cp, f1_y_cp_irf/f1_y_cp,...
                  f1_c_cp_irf/f1_c_cp, f1_j_cp_irf/f1_j_cp,...
                  f1_j_cp_share_irf,  f1_rpjepc_irf ];%
              
second_line = 100*scale2*[f2_y_cp_irf/f2_y_cp, f2_y_cp_irf/f2_y_cp,...
                   f2_c_cp_irf/f2_c_cp, f2_j_cp_irf/f2_j_cp,...
                   f2_j_cp_share_irf,  f2_rpjepc_irf ];
third_line = [];

% needs to match number of entries and order of variables included in
% first_line (and second and third line if present).
horizons = [nperiods_long,nperiods_short,...
            nperiods_short,nperiods_short,...
            nperiods_short,nperiods_short];
        
% plot figure
makechartmix(titlelist,legendlist,figtitle,first_line,second_line,third_line,horizons,ylabels)


%% Second figure
    
% override the following line to change the horizon             
nnperiods = nperiods_short;
titlelist = char('N Structure Capital','M Structure Capital','N Equipment Capital','M Equipment Capital','N Labor','M Labor',...
    'N Output','M Output');
figlabel = '';
line1 = 100*scale1*[f1_k_sl_irf(1:nnperiods)/f1_k_sl, f1_k_sh_irf(1:nnperiods)/f1_k_sh,...
               f1_k_el_irf(1:nnperiods)/f1_k_el, f1_k_eh_irf(1:nnperiods)/f1_k_eh,...
               f1_n_l_irf(1:nnperiods)/f1_n_l,   f1_n_h_irf(1:nnperiods)/f1_n_h ,...
               f1_y_l_irf(1:nnperiods)/f1_y_l,   f2_y_h_irf(1:nnperiods)/f2_y_h   ];
           
line2 = 100*scale2*[f2_k_sl_irf(1:nnperiods)/f2_k_sl, f2_k_sh_irf(1:nnperiods)/f2_k_sh,...
               f2_k_el_irf(1:nnperiods)/f2_k_el, f2_k_eh_irf(1:nnperiods)/f2_k_eh,...
               f2_n_l_irf(1:nnperiods)/f2_n_l,   f2_n_h_irf(1:nnperiods)/f2_n_h,...
               f2_y_l_irf(1:nnperiods)/f2_y_l,   f2_y_h_irf(1:nnperiods)/f2_y_h ];


ylabels = char('Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.');
           
makechart(titlelist,legendlist,figlabel,ylabels,line1, line2)
      

%% Third figure
titlelist = char('L Structure Investment','H Structure Investment','L Equipment Investment','H Equipment Investment');
figlabel = '';
ylabels = char('Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.');
  
line1 = 100*scale1*[f1_j_sl_irf(1:nnperiods)/f1_j_sl, f1_j_sh_irf(1:nnperiods)/f1_j_sh,...
               f1_j_el_irf(1:nnperiods)/f1_j_el, f1_j_eh_irf(1:nnperiods)/f1_j_eh];
           
line2 = 100*scale2*[f2_j_sl_irf(1:nnperiods)/f2_j_sl, f2_j_sh_irf(1:nnperiods)/f2_j_sh,...
               f2_j_el_irf(1:nnperiods)/f2_j_el, f2_j_eh_irf(1:nnperiods)/f2_j_eh];

makechart(titlelist,legendlist,figlabel,ylabels,line1,line2)
      

%% Fourth figure, substitution wealth effect decomposition


deltaW = sum(beta.^(0:nperiods-1)'.*f1_c_irf/f1_c)*f1_c^(1-gamma);
f1_wec_irf =  (1-beta)*deltaW/f1_c*ones(nperiods,1);
f1_sec_irf(1) = -beta/gamma*sum(beta.^(0:nperiods-1)'.*f1_r_irf);
for i = 2:nperiods
    f1_sec_irf(i) = f1_sec_irf(i-1)+1/gamma*f1_r_irf(i-1);
end
f1_sec_irf = f1_sec_irf';


deltaW = sum(beta.^(0:nperiods-1)'.*f2_c_irf/f2_c)*f2_c^(1-gamma);
f2_wec_irf =  (1-beta)*deltaW/f2_c*ones(nperiods,1);
f2_sec_irf(1) = -beta/gamma*sum(beta.^(0:nperiods-1)'.*f2_r_irf);
for i = 2:nperiods
    f2_sec_irf(i) = f2_sec_irf(i-1)+1/gamma*f2_r_irf(i-1);
end
f2_sec_irf = f2_sec_irf';
                


% titles for each panel
titlelist = char('Output, CP (over a long horizon)','Output, CP (medium-run horizon)',...
                 'Consumption, CP','Agg. Investment, CP',...
                 'Wealth effect on Consumption','L Structure Capital',...
                 'Substitution effect on Consumption','H Structure Capital');
             
% labels for y axis in each panel
ylabels = char('Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.');

scale1 = 1;%/(f1_y_cp_irf(end)/f1_y_cp)/100;
scale2 = 1;%/(f2_y_cp_irf(end)/f2_y_cp)/100;

% needs to match order in titlelist           
first_line = 100*scale1*[f1_y_cp_irf/f1_y_cp, f1_y_cp_irf/f1_y_cp,...
                  f1_c_cp_irf/f1_c_cp, f1_j_cp_irf/f1_j_cp,...
                  f1_wec_irf, f1_k_sl_irf/f1_k_sl,...
                  f1_sec_irf, f1_k_sh_irf/f1_k_sh];
              
second_line = 100*scale2*[f2_y_cp_irf/f2_y_cp, f2_y_cp_irf/f2_y_cp,...
                   f2_c_cp_irf/f2_c_cp, f2_j_cp_irf/f2_j_cp,...
                   f2_wec_irf, f2_k_sl_irf/f2_k_sl,...
                   f2_sec_irf, f2_k_sh_irf/f2_k_sh];
third_line = [];

% needs to match number of entries and order of variables included in
% first_line (and second and third line if present).
horizons = [nperiods_long,nperiods_short,...
            nperiods_short,nperiods_short,...
            nperiods_short,nperiods_short,...
            nperiods_short,nperiods_short];
        
% plot figure
makechartmix(titlelist,legendlist,figtitle,first_line,second_line,third_line,horizons,ylabels)

%% Fifth figure, substitution wealth effect decomposition

% titles for each panel
titlelist = char('Output, CP (over a long horizon)','Output, CP (medium-run horizon)',...
                 'Consumption, CP','Agg. Investment, CP',...
                 'Wealth effect on Consumption','N Sector Output (quality adjusted)',...
                 'Substitution effect on Consumption','M Sector Output (quality adjusted)');
             
% labels for y axis in each panel
ylabels = char('Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.');

scale1 = 1;%/(f1_y_cp_irf(end)/f1_y_cp)/100;
scale2 = 1;%/(f2_y_cp_irf(end)/f2_y_cp)/100;

% needs to match order in titlelist           
first_line = 100*scale1*[f1_y_cp_irf/f1_y_cp, f1_y_cp_irf/f1_y_cp,...
                  f1_c_cp_irf/f1_c_cp, f1_j_cp_irf/f1_j_cp,...
                  f1_wec_irf, f1_y_qa_l_irf/f1_y_qa_l,...
                  f1_sec_irf, f1_y_qa_h_irf/f1_y_qa_h];
              
second_line = 100*scale2*[f2_y_cp_irf/f2_y_cp, f2_y_cp_irf/f2_y_cp,...
                   f2_c_cp_irf/f2_c_cp, f2_j_cp_irf/f2_j_cp,...
                   f2_wec_irf, f2_y_qa_l_irf/f2_y_qa_l,...
                   f2_sec_irf, f2_y_qa_h_irf/f2_y_qa_h];
third_line = [];

% needs to match number of entries and order of variables included in
% first_line (and second and third line if present).
horizons = [nperiods_long,nperiods_short,...
            nperiods_short,nperiods_short,...
            nperiods_short,nperiods_short,...
            nperiods_short,nperiods_short];
        
% plot figure
makechartmix(titlelist,legendlist,figtitle,first_line,second_line,third_line,horizons,ylabels)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Fifth figure, substitution wealth effect decomposition

% titles for each panel
titlelist = char('Output, CP (over a long horizon)','Output, CP (medium-run horizon)',...
                 'Consumption, CP','Agg. Investment, CP',...
                 'Wealth effect on Consumption','M Sector Output (share of aggregate)',...
                 'Substitution effect on Consumption','Relative Price of Equipment Investment');
             
% labels for y axis in each panel
ylabels = char('Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.');

scale1 = 1;%/(f1_y_cp_irf(end)/f1_y_cp)/100;
scale2 = 1;%/(f2_y_cp_irf(end)/f2_y_cp)/100;

% needs to match order in titlelist           
first_line = 100*scale1*[f1_y_cp_irf/f1_y_cp, f1_y_cp_irf/f1_y_cp,...
                  f1_c_cp_irf/f1_c_cp, f1_j_cp_irf/f1_j_cp,...
                  f1_wec_irf, f1_y_cp_share_h_irf,...
                  f1_sec_irf, f1_rpjepc_irf];
              
second_line = 100*scale2*[f2_y_cp_irf/f2_y_cp, f2_y_cp_irf/f2_y_cp,...
                   f2_c_cp_irf/f2_c_cp, f2_j_cp_irf/f2_j_cp,...
                   f2_wec_irf, f2_y_cp_share_h_irf,...
                   f2_sec_irf, f2_rpjepc_irf];
third_line = [];

% needs to match number of entries and order of variables included in
% first_line (and second and third line if present).
horizons = [nperiods_long,nperiods_short,...
            nperiods_short,nperiods_short,...
            nperiods_short,nperiods_short,...
            nperiods_short,nperiods_short];
        
% plot figure
makechartmix(titlelist,legendlist,figtitle,first_line,second_line,third_line,horizons,ylabels)

