function history = mymkdata2(dr_,nperiods,order)

%  dr_ structure returned by dynare with model's decision rule
%  nperiods number of periods for simulated data
%  order of the decision rule to be used.


nvars = size(dr_.ghx,1);
nshocks = size(dr_.ghu,2);
statevar_pos = (dr_.nstatic +1):(nvars-dr_.nfwrd);
%statevar_pos = (dr_.nstatic +1):(dr_.nstatic+size(dr_.ghx,2));


s1 = randstream('mt19937ar','seed',1);
shocks = randn(s1,nshocks,nperiods+1);


history = zeros(nvars,nperiods+1);

for i = 2:nperiods+1 
    history(:,i) = dr_.ghx*history(statevar_pos,i-1)+ dr_.ghu*shocks(:,i);
end
   
if order>1
   history2 = zeros(nvars,nperiods+1);
     for i = 2:nperiods+1
     history2(:,i) = 0.5*dr_.ghs2 + dr_.ghx*history2(statevar_pos,i-1) + dr_.ghu*shocks(:,i) + ... 
                     0.5*dr_.ghxx*kron(history(statevar_pos,i-1),history(statevar_pos,i-1)) + ...
                     0.5*dr_.ghuu*kron(shocks(:,i),shocks(:,i)) + ...
                     dr_.ghxu*kron(history(statevar_pos,i-1),shocks(:,i));
     end
     
     history = history2;
 end