%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Get IRFS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [dset] = makeirfsecondorder(M_,oo_,nperiods,shock,order)

lgy_ = M_.endo_names;
dr_ = oo_.dr;
ys_ = oo_.dr.ys;
nvars = M_.endo_nbr;

if isfield(M_,'nstatic')
   statevar_pos = (M_.nstatic +1):(nvars-M_.nfwrd);
else
   statevar_pos = (dr_.nstatic +1):(nvars-dr_.nfwrd);
end

history = mymkirf2(dr_,statevar_pos,ys_,nperiods,shock,0,order,0);  % returns matrix containing IRFs for all variables


reordered = lgy_(dr_.order_var,:);          % the vector reordered contains names of variables
                                            % corresponding to rows of
                                            % history

% this loop assigns each row of history to its variable
% it also assigns steady state values
% IRFs are stored under varname_irf  where varname is the variable name
% SS values are stored under varname
% NB: SS values are scalar, IRFs are column vectors.

% history = history(dr_.order_var,:);
% history = history';


for indxi = 1:M_.endo_nbr
    eval(['dset.',deblank(reordered(indxi,:)),'_irf=transpose(history(indxi,:));']);
    eval(['dset.',deblank(lgy_(indxi,:)),'_ss= ys_(indxi);']);
end




