
global rho_govc_val rho_v_val rho_govi_val

%syms alpha_m alpha_n alpha_nc alpha_ni betap delta_m delta_n a_n2a_m


eta = .95;
nu = 15;

alpha_m = 0.54;
alpha_n = 0.28;

% alpha_nc = .96;
% alpha_ni = (0.15*(1-0.33)+0.96*0.33); % 0.33 is the average of the share of 
%                                       % structures investment in investment 
%                                       % (structures+equipment) over the 
%                                       % estimation sample 1982Q3:2008Q3;
%                                       
%                                       % 0.15 and 0.96 are shares from the
%                                       % IER paper.

alpha_nc = .9999;
alpha_ni = 0.0001;
                                      
                                      
chi = 1/1000;


betap = 0.99;
delta_m = (0.123*0.43/0.54+0.056*0.11/0.54)/4;  % this is an average depreciation rate
                                                % applying cobb-douglas
                                                % shares to create a convex
                                                % combination of
                                                % depreciation rates for
                                                % machinery and
                                                % non-machinery capital
                                                % stocks
                                                           
delta_n = (0.123*0.15/0.28+0.056*0.13/0.28)/4;

rho_v = 0;
if ~isempty(rho_v_val)
    rho_v = rho_v_val;
end

rho_a_n = 1;
rho_a_m = 1;
rho_govc =  0.838896275329722;
if ~isempty(rho_govc_val)
    rho_govc=rho_govc_val;
end

rho_govi = 0;
if ~isempty(rho_govi_val)
    rho_govi = rho_govi_val;
end

a_n = 1;
a_m = 1;
v=1;

a_n2a_m = a_n/a_m;

psi_2 = (1-alpha_n)*(1-alpha_m)/ ...
             (  (1-alpha_n)*(1-alpha_m) + ...
                (1-alpha_m)*(1-alpha_ni)*alpha_n+...
                (1-alpha_n)*alpha_ni*alpha_m ...
              );

% composite parameters used in the definition of the steady states
psi_1 = ( (1-alpha_n)/(1-alpha_m)*...
           ( (  alpha_n/...
                (  (alpha_ni)^(-alpha_ni)*...
                   (1-alpha_ni)^(alpha_ni-1)*...
                   (1-betap*(1-delta_n))/betap...
                )...
             )^( alpha_n/(1-alpha_n)) ) /...
             (  alpha_m/...
                (  (alpha_ni)^(-alpha_ni)*...
                   (1-alpha_ni)^(alpha_ni-1)*...
                   (1-betap*(1-delta_m))/betap)...
                )^(alpha_m/(1-alpha_m) )...
         )^psi_2;
    

% from equation 41
p_n = 1;

p_m = psi_1*(a_n2a_m)^psi_2*p_n;

p_i = (p_n/alpha_ni)^(alpha_ni)*(p_m/(1-alpha_ni))^(1-alpha_ni); 

p_c = (p_n/alpha_nc)^(alpha_nc)*(p_m/(1-alpha_nc))^(1-alpha_nc); 

r_n = p_i*(1/betap-(1-delta_n));

r_m = p_i*(1/betap-(1-delta_m));


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% the mistake must be between lines 65 and 76

k_n2y_n = alpha_n*p_n/r_n;
k_m2y_m = alpha_m*p_m/r_m;

% from equations 50, 51 and the next one
my_mat = [1 0 -alpha_ni/p_n+alpha_nc/p_n
       0 1 -(1-alpha_ni)/p_m+(1-alpha_nc)/p_m
       delta_n*k_n2y_n*p_i delta_m*k_m2y_m*p_i -1];
my_const=[alpha_nc/p_n
         (1-alpha_nc)/p_m
         0];
     
vec = my_mat\my_const;
%vec = inv(my_mat)*my_const;

y_n2y = vec(1);
y_m2y = vec(2);
s = vec(3);

y_n2y_m = y_n2y/y_m2y;

l = 1;

l_m2l = ( (1-alpha_m)*p_m/p_n )/( ...
            (1-alpha_m)*p_m/p_n+(1-alpha_n)*y_n2y_m ) ;

l_n2l = l-l_m2l;

l_m = l_m2l *l;

l_n = l_n2l *l;

y_n2l_n = a_n*(alpha_n*p_n/r_n)^(alpha_n/(1-alpha_n));
y_m2l_m = a_m*(alpha_m*p_m/r_m)^(alpha_m/(1-alpha_m));

y_n = y_n2l_n*l_n;
y_m = y_m2l_m*l_m;

k_n = k_n2y_n*y_n;
k_m = k_m2y_m*y_m;
 
invest = delta_m*k_m + delta_n*k_n;
y = p_n*y_n+p_m*y_m;
c = (1-s)*y/p_c;

y_ni=alpha_ni*invest*p_i/p_n;
y_mi=(1-alpha_ni)*invest*p_i/p_m;

y_nc = y_n -y_ni;
y_mc = y_m -y_mi;



r=1/betap;

%w = p_m*(1-alpha_m)*y_m/l_m;
w = p_n*(1-alpha_n)*y_n/l_n;

lambda_c = 1/(p_c*c);
lambda_k = -lambda_c*p_i;

% choice of chi_0 supports the choice of l made above
chi_0 = lambda_c*w/(l^chi*v);

% definition of labor productivity
labprod = (y_m+y_n)/l;

% growth rate of labor productivity
glabprod = 0;

y_cp = y_m+y_n;

g_p_m= 0;

g_invest = 0;

g_c = 0;

govi = 0;
govc = 0;
