function [dpi, labprodg, hourspc, espcg, pcepcg] = getdata_long(start_date,end_date,durable_switch)

% returns dpi, the growth rate of the relative price of investment
% constructed as the implicit price deflator for equipment and software from Nipa Table 1.1.9 
% divided by non-farm business output prices (net of equipment and
% software)

% labprodg labor productivity growth
% log-differenced labor productivity in the nonfarm bussiness sector from
% BLS

% hourspc hours per capita
% is the log of hours worked in the nonfarm business sector minus
% the log of civilian noninstitutional population 16 years and over from
% the current population survey

% espcg growth rate of equipment and software per capita
% defined as the log of equipment and software (nominal equipment and
% software divided by its implicit deflator) minus the log of civilian
% noninstitutional population 16 years and over form the current population
% survey, differenced.

% pcepcg growth rate of consumption per capita
% log of personal consumption expenditures in NIPA table 1.1.6 minus the log of civilian
% noninstitutional population 16 years and over form the current population
% survey, differenced.


if ~exist('durable_switch','var')
    durable_switch = 0;
end

% quarterly data from 1947q1 to 2013q1
% hours worked source BLS  see dataset.xlsx
bls_dates = 1947:.25:2015;

% from NIPA_section1.xls -- used later
nipa_dates = 1947:.25:2015;

hours = [48.288	48.292	48.423	48.895
49.207	49.180	49.530	49.072
48.245	47.438	46.940	46.752
47.115	48.278	49.800	50.259
51.104	51.515	51.006	51.030
51.359	51.145	51.513	52.892
53.441	53.534	53.000	52.166
51.465	51.077	50.878	51.515
52.346	53.027	53.578	54.228
54.556	54.675	54.456	54.758
54.807	54.690	54.426	53.298
52.092	51.345	51.956	52.732
53.752	54.781	54.619	54.627
54.965	55.062	54.750	54.242
53.937	53.811	54.127	54.815
55.017	55.672	55.556	55.203
55.539	55.890	56.041	56.476
57.525	57.775	58.145	58.710
59.627	60.218	60.360	60.932
61.812	62.418	62.710	62.541
62.471	62.088	62.292	62.576
62.687	63.288	63.731	64.124
64.725	65.324	65.637	65.438
65.180	64.321	63.994	63.506
63.805	64.011	64.012	64.697
65.485	65.954	66.325	67.018
68.031	68.742	69.207	69.550
69.254	69.435	69.194	68.050
65.915	65.307	65.905	67.036
68.145	68.169	68.440	68.806
69.539	70.866	71.624	72.324
72.658	74.783	75.412	76.326
76.869	77.180	77.828	77.980
77.794	76.438	76.088	77.027
77.452	77.479	77.453	77.155
75.913	76.208	75.668	74.984
75.423	76.266	77.767	79.222
80.742	81.814	82.190	82.732
83.409	83.950	84.178	84.576
84.456	84.258	84.684	85.326
86.349	86.842	87.450	88.351
88.430	89.694	89.941	90.939
91.832	92.199	92.408	92.421
92.643	92.129	91.543	91.078
90.126	89.573	89.472	89.363
88.902	89.292	89.469	90.071
90.856	91.913	92.385	93.166
93.541	95.124	96.285	96.837
97.512	97.502	98.603	98.681
98.520	99.311	100.104	101.353
102.439	103.055	103.684	104.168
104.750	105.234	105.407	106.880
106.902	107.654	108.365	108.732
109.152	109.267	109.255	108.803
108.619	107.518	106.352	105.148
104.208	104.491	104.167	104.271
103.728	103.440	103.587	104.123
104.574	104.634	105.316	105.883
106.068	106.749	106.980	107.663
108.638	108.939	109.566	109.905
109.930	110.324	109.992	109.730
109.406	108.887	107.719	105.029
102.257	100.037	98.821	98.888
98.918	99.695	100.195	100.726
100.945	101.671	102.178	102.876
103.712	103.782	104.261	104.890
105.348	105.626	106.179	106.616
107.245	107.914	108.545	109.845
110.279	 nan nan nan];

% remember that the command reshape works columnwise.
hours = reshape(hours',size(hours,1)*size(hours,2),1);
hours = hours(1:end-3);
hours = hours(find(bls_dates==nipa_dates(1)):end);

labprod = [24.604	25.174	24.433	25.457
25.555	25.492	25.526	25.628
25.878	26.150	26.779	26.636
27.558	27.868	28.472	28.514
28.573	28.473	29.126	29.195
29.319	29.297	29.183	29.762
29.998	30.093	30.241	30.127
30.180	30.395	30.947	31.309
31.907	32.001	32.131	32.032
31.637	31.780	31.783	32.120
32.487	32.366	32.828	32.933
32.477	33.117	33.736	34.306
34.330	34.737	34.667	34.607
35.410	34.932	35.032	34.604
35.048	36.050	36.547	36.889
37.503	37.440	37.929	38.250
38.377	38.766	39.591	39.590
39.945	40.216	40.519	40.157
40.753	40.996	41.731	42.490
43.084	42.823	42.888	43.181
43.545	43.725	43.903	44.060
45.043	45.474	45.460	45.381
45.729	45.361	45.389	45.199
45.317	46.008	46.715	46.315
47.661	47.821	48.248	47.865
48.538	49.528	49.797	50.207
51.330	51.377	50.880	50.550
50.448	50.314	49.780	50.222
50.620	51.465	52.048	52.098
52.866	53.374	53.470	53.643
53.968	54.200	54.739	54.036
54.077	55.132	55.130	55.478
54.985	54.834	54.776	54.728
54.987	54.390	54.573	55.182
56.115	55.413	55.882	55.220
54.823	54.937	55.041	55.542
56.283	57.579	57.992	58.273
58.370	58.731	58.980	59.017
59.116	59.315	60.074	60.335
61.046	61.516	61.813	61.662
61.360	61.802	61.816	62.349
62.564	62.735	62.919	63.165
63.072	63.310	63.639	63.675
64.220	64.801	65.072	64.545
64.742	65.801	66.266	66.624
67.878	68.411	69.011	69.425
68.880	68.494	68.667	69.078
69.468	69.461	69.039	69.736
69.574	69.833	69.842	70.399
71.004	71.850	72.152	72.165
71.966	72.813	73.401	73.708
74.183	74.678	75.703	76.195
76.900	77.035	77.690	78.983
78.710	80.356	80.370	81.174
80.937	82.274	82.720	83.743
85.638	85.702	86.358	86.222
87.075	88.267	90.180	91.044
91.014	91.905	92.206	92.503
93.512	93.408	94.104	94.161
94.749	94.668	94.248	94.989
95.082	95.702	96.791	97.215
96.246	97.190	97.436	96.832
97.594	99.457	100.917	102.117
102.655	103.037	103.568	103.984
103.113	103.499	103.276	104.032
104.042	104.564	105.023	104.422
104.587	104.817	105.705	106.496
105.227	105.978	106.985	106.412
105.570	nan nan nan];

labprod = reshape(labprod',size(labprod,1)*size(labprod,2),1);
labprod = labprod(1:end-3);
labprod = labprod(find(bls_dates==nipa_dates(1)):end);

%nfb deflator
py = [14.273	14.467	15.105	15.050
15.322	15.575	15.873	16.097
15.993	15.833	15.792	15.736
15.784	15.855	16.031	16.364
16.808	17.040	17.145	17.264
17.292	17.294	17.473	17.609
17.639	17.745	17.800	17.828
17.890	17.915	17.891	17.961
18.051	18.117	18.296	18.464
18.642	18.762	18.997	19.112
19.334	19.449	19.546	19.598
19.675	19.687	19.792	19.881
19.980	20.020	20.098	20.199
20.222	20.266	20.346	20.413
20.432	20.472	20.486	20.496
20.590	20.665	20.687	20.670
20.779	20.786	20.779	20.907
20.964	21.028	21.135	21.204
21.273	21.303	21.390	21.466
21.529	21.755	21.919	22.174
22.281	22.404	22.597	22.811
23.049	23.300	23.450	23.775
24.060	24.332	24.572	24.822
25.089	25.460	25.589	25.958
26.231	26.547	26.794	26.894
27.225	27.334	27.505	27.677
27.840	28.148	28.511	29.188
29.841	30.936	31.893	32.864
33.935	34.448	34.989	35.489
35.896	36.297	36.809	37.482
38.021	38.635	39.143	39.834
40.450	41.060	41.777	42.609
43.344	44.593	45.557	46.454
47.630	48.967	49.743	50.819
52.366	53.435	54.557	55.580
56.363	57.051	57.752	58.352
58.611	58.841	59.536	59.876
60.175	60.713	61.221	61.545
62.350	62.767	63.236	63.366
63.686	63.742	63.818	64.071
64.499	64.851	65.372	65.639
66.095	66.674	67.411	68.069
68.556	69.371	69.837	70.177
70.908	71.565	72.156	72.755
73.429	73.813	74.377	74.599
74.722	75.069	75.397	75.932
76.421	76.838	77.262	77.591
77.823	78.222	78.710	79.034
79.389	79.733	79.986	80.183
80.451	80.758	81.028	81.408
81.871	82.223	82.443	82.648
82.669	82.707	82.917	82.899
83.168	83.409	83.661	83.979
84.544	84.958	85.472	85.825
86.212	86.679	86.701	86.907
86.783	87.237	87.492	87.811
88.176	88.292	88.602	88.711
89.391	89.944	90.555	91.336
92.175	92.882	93.834	94.552
95.138	95.944	96.463	96.485
97.370	97.923	98.085	98.354
98.749	99.185	99.923	99.956
100.287	99.871	99.851	99.991
100.383	100.779	101.151	101.631
101.868	102.565	103.199	103.525
103.936	104.517	104.979	105.228
105.475	105.867	106.367	106.736
106.948	107.481	107.940	107.859
107.822	nan nan nan];

py = reshape(py',size(py,1)*size(py,2),1);
py = py(1:end-3);
py = py(find(bls_dates==nipa_dates(1)):end);

y = [11.881	12.157	11.831	12.447
12.575	12.537	12.643	12.576
12.485	12.405	12.570	12.453
12.984	13.454	14.179	14.331
14.602	14.668	14.856	14.898
15.058	14.984	15.033	15.742
16.031	16.110	16.028	15.716
15.532	15.525	15.745	16.129
16.702	16.969	17.215	17.370
17.260	17.376	17.308	17.588
17.805	17.701	17.867	17.553
16.918	17.004	17.528	18.090
18.453	19.029	18.935	18.905
19.463	19.234	19.180	18.770
18.904	19.399	19.782	20.221
20.633	20.844	21.072	21.115
21.314	21.666	22.187	22.359
22.978	23.235	23.560	23.576
24.300	24.687	25.189	25.890
26.631	26.729	26.895	27.006
27.203	27.148	27.348	27.571
28.236	28.780	28.972	29.100
29.598	29.632	29.792	29.577
29.538	29.593	29.895	29.413
30.410	30.611	30.884	30.967
31.785	32.666	33.028	33.648
34.920	35.318	35.212	35.158
34.937	34.936	34.445	34.176
33.366	33.610	34.302	34.924
36.025	36.384	36.595	36.910
37.529	38.409	39.206	39.081
39.291	41.229	41.575	42.344
42.266	42.321	42.631	42.677
42.777	41.575	41.523	42.505
43.462	42.934	43.282	42.605
41.618	41.866	41.649	41.648
42.450	43.913	45.099	46.165
47.129	48.050	48.476	48.826
49.308	49.795	50.569	51.029
51.557	51.832	52.346	52.614
52.984	53.670	54.058	55.086
55.325	56.269	56.590	57.441
57.920	58.371	58.808	58.849
59.495	59.701	59.569	58.786
58.349	58.940	59.289	59.537
60.345	61.086	61.743	62.532
62.581	62.955	63.438	64.357
64.981	66.074	66.474	67.530
67.843	68.089	68.866	69.471
69.953	71.355	72.227	73.142
73.721	75.037	76.105	76.780
77.707	78.587	79.796	81.438
82.207	82.931	84.189	85.880
85.913	87.802	87.808	88.320
87.913	88.460	87.975	88.054
89.241	89.551	89.957	89.904
90.322	91.303	93.414	94.798
95.177	96.164	97.108	97.945
99.186	99.712	100.673	101.377
102.934	103.130	103.263	104.398
104.523	105.582	106.462	106.674
105.298	105.827	104.957	101.701
99.797	99.494	99.728	100.981
101.544	102.722	103.770	104.739
104.088	105.229	105.525	107.024
107.904	108.519	109.498	109.529
110.180	110.714	112.236	113.542
112.851	114.366	116.127	116.888
116.421	nan	nan nan];	

y = reshape(y',size(y,1)*size(y,2),1);
y = y(1:end-3);
y = y(find(bls_dates==nipa_dates(1)):end);


% population 1976-2013
pop_dates = 1948:.25:2015.25;

pop = 100000*[   1.026906666666667
   1.029153333333333
   1.032490000000000
   1.034176666666667
   1.035843333333333
   1.038380000000000
   1.041273333333333
   1.044276666666667
   1.047333333333333
   1.050203333333333
   1.052483333333333
   1.049823333333333
   1.046923333333333
   1.045066666666667
   1.045426666666667
   1.047466666666667
   1.048633333333333
   1.050066666666667
   1.053426666666667
   1.057030000000000
   1.066720000000000
   1.069046666666667
   1.071396666666667
   1.075033333333333
   1.078766666666667
   1.081770000000000
   1.084433333333333
   1.087860000000000
   1.091303333333333
   1.095336666666667
   1.098836666666667
   1.101860000000000
   1.104833333333333
   1.107876666666667
   1.111133333333333
   1.114310000000000
   1.117203333333333
   1.120453333333333
   1.124306666666667
   1.128656666666667
   1.132363333333333
   1.135320000000000
   1.138463333333333
   1.142833333333333
   1.147143333333333
   1.151390000000000
   1.155506666666667
   1.159180000000000
   1.167076666666667
   1.170366666666667
   1.174110000000000
   1.178243333333333
   1.182543333333333
   1.186360000000000
   1.190006666666667
   1.191896666666667
   1.193786666666667
   1.198193333333333
   1.203680000000000
   1.210456666666667
   1.216400000000000
   1.221666666666667
   1.226696666666667
   1.231886666666667
   1.237080000000000
   1.242030000000000
   1.247393333333333
   1.252890000000000
   1.258140000000000
   1.263246666666667
   1.267450000000000
   1.271693333333333
   1.275113333333333
   1.278686666666667
   1.282336666666667
   1.286170000000000
   1.290436666666667
   1.295270000000000
   1.301656666666667
   1.307573333333333
   1.312670000000000
   1.317123333333333
   1.322500000000000
   1.328800000000000
   1.334760000000000
   1.340203333333333
   1.345950000000000
   1.352466666666666
   1.359496666666667
   1.366766666666666
   1.374560000000000
   1.382603333333333
   1.390336666666667
   1.398273333333333
   1.406026666666667
   1.414016666666666
   1.430053333333333
   1.437586666666667
   1.445226666666667
   1.452150000000000
   1.459643333333333
   1.467196666666666
   1.474783333333333
   1.482260000000000
   1.489866666666667
   1.497466666666667
   1.504980000000000
   1.512530000000000
   1.519873333333333
   1.527076666666667
   1.535790000000000
   1.543363333333333
   1.550750000000000
   1.557736666666667
   1.565266666666667
   1.572220000000000
   1.579106666666667
   1.586523333333334
   1.594296666666666
   1.601403333333334
   1.608286666666667
   1.615253333333333
   1.622650000000000
   1.630240000000000
   1.637563333333333
   1.644473333333333
   1.651996666666667
   1.660546666666667
   1.667623333333333
   1.674156666666667
   1.681106666666667
   1.686936666666667
   1.692790000000000
   1.698373333333334
   1.704126666666667
   1.709903333333333
   1.714970000000000
   1.720200000000000
   1.725216666666667
   1.730460000000000
   1.735050000000000
   1.739573333333333
   1.744493333333333
   1.749503333333333
   1.756786666666666
   1.761253333333333
   1.765953333333333
   1.771323333333333
   1.775223333333333
   1.779463333333333
   1.784133333333333
   1.789406666666667
   1.798253333333333
   1.803206666666667
   1.808356666666667
   1.813653333333333
   1.820013333333333
   1.825266666666667
   1.830160000000000
   1.834670000000000
   1.839673333333333
   1.843893333333333
   1.848403333333333
   1.852533333333333
   1.857726666666667
   1.861780000000000
   1.866023333333333
   1.870176666666667
   1.885196666666667
   1.889163333333334
   1.893526666666667
   1.898663333333333
   1.902716666666667
   1.906556666666667
   1.911213333333333
   1.916506666666667
   1.920746666666667
   1.925066666666666
   1.930243333333334
   1.936156666666667
   1.941060000000000
   1.945553333333333
   1.950680000000000
   1.956210000000000
   1.960853333333333
   1.965220000000000
   1.970500000000000
   1.976006666666666
   1.978820000000000
   1.982956666666666
   1.988070000000000
   1.993516666666667
   1.997760000000000
   2.002793333333333
   2.008496666666666
   2.014573333333333
   2.023956666666666
   2.028353333333333
   2.033666666666667
   2.039353333333334
   2.043950000000000
   2.049050000000000
   2.054826666666667
   2.060976666666666
   2.068760000000000
   2.074316666666666
   2.080436666666666
   2.086603333333334
   2.115860000000000
   2.122420000000000
   2.129186666666667
   2.135603333333334
   2.141010000000000
   2.147356666666667
   2.154216666666667
   2.161116666666667
   2.166640000000000
   2.172036666666667
   2.178676666666667
   2.185430000000000
   2.201093333333334
   2.207740000000000
   2.215126666666666
   2.222756666666667
   2.223560000000000
   2.229733333333333
   2.236800000000000
   2.244180000000000
   2.250380000000000
   2.256740000000000
   2.264223333333333
   2.271960000000000
   2.277636666666667
   2.284326666666666
   2.291663333333334
   2.298960000000000
   2.308393333333334
   2.314820000000000
   2.322100000000000
   2.329366666666667
   2.328066666666667
   2.334100000000000
   2.341103333333333
   2.348250000000000
   2.349126666666666
   2.354593333333333
   2.360930000000000
   2.367390000000000
   2.369963333333334
   2.375060000000000
   2.381036666666667
   2.387113333333334
   2.388516666666666
   2.393160000000000
   2.398710000000000
   2.404313333333334
   2.424360000000000
   2.429683333333334
   2.435640000000000
   2.441690000000000
   2.448286666666667
   2.453633333333333
   2.459610000000000
   2.465643333333333
   2.470860000000000
   2.476250000000000
   2.482326666666666
   2.488426666666667
   2.499006666666666
   2.504613333333333];

%Table 1.9.5. Net Value Added by Sector                                                                                                                                                                                                                    																																														
%3	  Nonfarm \2\	A364RC1	\
nipa_dates_annual = 1969:2012;
nfby_ann =[ 688.6	713.4	770.8	849.0	942.5	1016.4	1096.1	1243.5	1397.4	1589.4	1774.5	1910.7	2132.8	2169.8	2403.2	2698.3	2906.7	3052.8	3221.5	3471.0	3731.4	3910.9	3992.4	4240.6	4479.5	4779.6	5018.5	5319.4	5696.9	6028.6	6418.6	6806.8	6931.6	7104.3	7436.5	7954.2	8530.7	9033.0	9402.5	9354.8	8946.2	9382.8	9802.1	10368.6]';


%11	      Equipment	Y033RC1	-- nominal volume $Bn
nes = [63.7	64.7	66.1	66.2	66.4	66.7	67.7	64.8	66.6	68.7	69.3	71.6	74.9	76.9	78.9	84.8	89.8	94.9	96.9	98.7	100.0	102.4	107.1	107.8	104.5	105.6	108.5	111.8	115.0	118.3	123.1	128.5	139.0	144.6	150.6	160.4	164.6	179.7	185.5	192.8	203.4	204.2	212.1	212.5	219.6	209.1	215.2	221.6	232.0	238.3	246.6	246.5	242.8	235.4	232.3	228.9	227.1	237.6	249.8	271.4	275.6	289.0	297.3	305.6	302.6	309.5	306.1	313.4	310.8	317.5	318.6	323.9	312.6	320.2	327.1	323.8	335.6	344.8	349.1	357.7	363.4	371.6	381.0	372.6	376.4	365.7	373.6	371.8	361.3	358.2	362.6	361.4	360.1	379.5	387.6	399.6	406.6	421.5	425.0	447.4	461.8	465.4	476.5	501.9	525.3	525.4	524.8	537.0	546.0	556.9	577.0	581.4	587.5	602.3	630.5	623.1	645.8	655.9	658.4	680.0	695.1	712.1	728.1	719.1	749.4	774.0	774.0	767.0	751.7	716.0	692.4	686.0	671.4	660.7	658.9	647.5	642.2	660.7	679.6	693.4	680.6	709.6	732.0	754.6	765.0	782.6	805.2	810.0	851.3	852.4	857.3	863.6	876.9	888.2	887.6	890.4	878.9	856.9	822.4	742.4	659.0	634.4	639.1	644.8	682.7	719.0	751.2	774.4	798.3	809.7	861.7	883.3	920.4	940.7	935.4	955.2	969.1	968.0	959.3	992.8	1003.5	1023.2	1065.3	1055.0	1063.5]';
% Equipment 1947Q1 to 1968Q4  Y033RC1	
nes_hist = [14.9	15.2	15.0	16.1	17.3	16.7	17.1	18.0	16.8	16.1	15.2	14.8	15.1	17.1	19.3	19.6	19.4	19.7	20.2	20.2	20.4	20.8	17.7	19.9	21.2	21.3	22.1	21.4	20.6	20.4	21.1	21.1	21.1	23.1	25.0	26.3	25.4	25.9	26.8	27.2	28.2	28.1	29.3	28.6	25.5	24.4	24.1	25.5	27.1	28.1	29.1	29.1	30.1	30.7	29.5	28.4	27.4	28.6	28.9	30.6	31.4	32.2	32.3	32.3	32.9	33.5	34.9	36.2	37.1	37.9	39.3	40.4	43.5	44.3	46.8	48.5	51.1	53.0	53.4	54.6	52.7	53.6	53.2	55.3	57.6	56.7	58.6	61.2]';
nes = [nes_hist; nes];


% 11	      Equipment	Y033RD3 -- Table 1.1.9 (10109qtr) -- Implicit Price Deflator -- 
pes = [53.718	54.000	54.487	54.969	55.574	56.104	56.525	57.179	57.799	58.159	58.237	58.231	58.641	58.919	59.032	58.894	59.126	59.717	60.204	60.377	61.150	62.697	65.269	68.470	71.608	73.872	74.999	76.157	77.323	78.064	79.062	80.283	81.584	82.781	84.106	85.522	86.529	87.581	88.686	89.767	91.446	93.128	94.666	96.339	98.852	101.370	103.556	105.053	107.049	109.083	110.439	111.924	114.053	115.595	116.411	116.928	116.771	116.275	115.708	115.551	115.345	115.254	115.002	114.820	114.706	114.825	115.134	115.713	115.909	116.977	118.068	118.663	118.639	118.062	117.500	118.524	119.125	119.426	119.627	121.012	121.482	121.630	122.312	122.960	123.644	123.907	124.798	126.055	127.065	126.770	126.409	126.580	127.127	126.692	126.520	125.789	125.624	125.220	124.809	124.542	124.994	125.224	124.950	124.135	123.619	123.836	123.482	122.863	121.873	120.758	120.299	119.748	118.692	117.779	117.008	115.923	114.156	112.667	111.411	110.166	109.387	108.218	107.029	106.396	106.080	105.652	105.297	104.541	103.243	102.605	101.865	101.326	100.892	100.422	99.915	99.740	98.866	98.429	98.359	98.446	98.238	98.577	98.300	98.326	98.811	98.943	98.449	98.373	98.245	98.027	98.325	98.667	98.959	99.100	98.521	97.842	97.724	97.746	98.896	100.765	100.777	100.439	99.883	98.910	97.860	97.809	98.046	98.290	98.478	98.823	98.931	99.165	99.573	99.656	99.937	100.268	100.184	100.276	100.349	100.349	100.565	100.935	101.161	101.435	101.677]';
% Table 1.1.9. Implicit Price Deflators for Equipment Y033RD3	
pes_hist = [31.197	32.518	33.251	33.565	33.388	34.373	35.800	36.446	36.387	36.591	36.454	36.028	36.116	36.712	37.479	38.581	39.833	40.360	40.558	41.049	41.180	41.420	41.262	41.210	41.145	41.325	41.514	41.439	42.102	42.757	42.232	42.315	41.972	42.160	42.922	43.820	44.638	45.378	46.491	47.243	48.141	48.163	48.542	49.275	49.226	49.522	49.570	49.654	50.006	50.310	50.561	50.681	50.600	50.855	50.942	50.893	50.756	50.606	50.466	50.371	50.342	50.342	50.355	50.180	50.139	50.041	50.019	49.988	50.011	50.051	50.027	49.983	50.067	50.038	50.207	50.014	49.962	50.111	50.255	50.628	50.915	51.196	51.534	51.909	52.100	52.553	52.989	53.528]';
pes = [pes_hist; pes];


% continue from here
% Nominal personal consumption expenditure
npce_hist = [156.3	160.2	163.7	167.8	170.5	174.3	177.2	178.1	177	178.6	177.9	180.4	183.1	187	200.7	198.1	209.4	205.1	207.8	211.7	213.1	217.2	219.7	227.9	231.5	233.2	233.9	233.4	235.4	238.2	240.6	245.4	251.8	256.8	261	265.1	266.6	269.3	272.5	277.9	282.3	284.6	289.2	290.8	290.3	293.2	298.3	302.2	309.9	315.9	321.1	323.2	326.7	332.6	332.5	334.5	335	339.9	342.8	350.1	355.4	361	364.9	371.1	374.7	378.9	385.8	390.5	400.1	408.1	417	419.6	430.3	437.2	446.4	460.4	470.8	475.9	485	490.8	495.1	504.2	511.4	518.9	536.9	550.6	566.7	575.6	587.8	599.2	609.5	621.5	632.6	642.5	654.5	661.2	680.2	694.3	706.7	722.9	740.1	758.6	777.1	801.9	826.5	842	860.5	875.6	893.8	922.3	951.1	960.9	987.1	1015.8	1049.6	1078.5	1112.3	1132	1161.3	1195.1	1230.6	1258.5	1289.7	1327.9	1357.8	1415.3	1446.2	1485.4	1521	1561.5	1616	1659.5	1706.5	1708.9	1767.7	1835.4	1890.7	1921.9	1961.2	1976.1	2014.4	2041.1	2089.2	2150.9	2190.6	2254.5	2324.3	2376.7	2422.8	2481.2	2519.7	2568.9	2643.9	2691.2	2764.7	2790.9	2834.7	2863	2929.7	2966.1	2998.3	3068.8	3133.5	3167.6	3249	3309	3378.3	3451.3	3506.1	3569.5	3625.6	3670.1	3754.5	3800.2	3863.4	3884.4	3890.2	3943.7	3989.6	4017.1	4117.7	4173.4	4245.4	4326.2	4368.5	4437.5	4506	4572	4640.9	4702.9	4773.1	4847.2	4883.3	4955	5020.5	5077.9	5153.8	5244.1	5298.3	5376.1	5456.7	5495.1	5603.5	5687.6	5745.9	5857.8	5952.8	6055.5	6129	6253	6357.2	6488.9	6642.7	6737.3	6845.1	6944.4	7020.4	7072.1	7103.4	7216.6	7251.4	7344.5	7433.1	7507.2	7593.5	7684.6	7845.5	7938.5	8076.8	8186.3	8312.7	8464.3	8573.1	8723.9	8888.1	8991.3	9134.3	9253.7	9374.3	9453.6	9591.9	9700.9	9799.2	9910	9974.4	10095.8	10124.9	9859.6	9770.2	9769.8	9890.8	9957.1	10044.5	10137.7]';
npce = [10233.4	10393.2	10523.5	10651.4	10754.5	10827.9	10956.2	11008.3	11073.6	11164.3	11256.7	11284.5	11379.1	11524.4	11636.1	11800.6	11941	12075.8	12098.9]';
npce = [npce_hist;npce];


% price index for personal consumption expenditure from Table 1.1.9
ppce_hist = [13.03	13.135	13.38	13.713	13.865	14.008	14.223	14.179	14.069	13.983	13.902	13.889	13.864	13.93	14.221	14.476	14.938	15.059	15.08	15.279	15.343	15.34	15.44	15.466	15.526	15.55	15.635	15.703	15.782	15.761	15.709	15.693	15.744	15.761	15.823	15.867	15.932	16.04	16.196	16.292	16.438	16.543	16.676	16.762	16.968	16.999	17.012	17.007	17.125	17.193	17.295	17.389	17.413	17.504	17.572	17.65	17.683	17.681	17.745	17.765	17.843	17.906	17.952	18.006	18.057	18.083	18.169	18.236	18.324	18.366	18.428	18.49	18.549	18.642	18.711	18.768	18.914	19.07	19.216	19.366	19.423	19.514	19.694	19.862	20.071	20.275	20.485	20.713	20.917	21.186	21.446	21.695	21.947	22.19	22.406	22.696	22.911	23.172	23.399	23.544	23.792	23.93	24.141	24.339	24.635	25.11	25.569	26.094	26.87	27.631	28.376	29.095	29.641	30.003	30.564	31.077	31.422	31.686	32.167	32.675	33.265	33.834	34.345	34.836	35.415	36.145	36.781	37.477	38.181	39.222	40.194	41.165	42.398	43.435	44.449	45.547	46.675	47.454	48.231	48.964	49.584	50.056	50.843	51.407	51.85	52.328	53.018	53.371	53.948	54.474	54.897	55.239	55.9	56.371	56.82	57.211	57.621	57.553	57.846	58.192	58.814	59.374	59.931	60.457	60.926	61.599	62.358	62.983	63.689	64.538	64.906	65.415	66.349	66.946	67.787	68.676	69.016	69.382	69.851	70.351	70.783	71.252	71.706	72.211	72.641	73.131	73.451	73.872	74.134	74.547	75.079	75.432	75.794	76.222	76.528	76.864	77.295	77.805	78.138	78.667	79.014	79.209	79.413	79.659	79.655	79.796	80.037	80.24	80.447	80.876	81.302	81.784	82.469	82.847	83.363	83.825	84.386	84.79	84.854	84.91	85.064	85.719	86.151	86.545	87.156	87.231	87.764	88.119	88.791	89.415	89.935	90.645	91.114	91.72	92.726	93.452	93.885	94.609	95.286	95.122	96.008	96.771	97.319	98.296	99.139	100.177	101.197	99.746	99.182	99.626	100.253	100.936	101.279	101.393]';
ppce = [101.693	102.233	102.999	104.041	104.593	104.954	105.561	105.884	106.231	106.803	107.183	107.227	107.623	108.086	108.618	109.13	109.421	109.419	108.976]';
ppce = [ppce_hist; ppce];


% price index for personal consumption expenditure on durables from Table 1.1.9
ppce_d_hist = [44.439	44.852	45.101	45.688	46.042	46.647	48.277	48.372	48.221	47.921	47.341	47.269	47.097	47.441	48.073	48.89	50.736	51.087	51.111	51.609	51.968	51.356	51.884	50.651	51.127	51.179	50.852	50.962	51.395	50.112	49.29	48.991	49.276	49.503	49.969	50.101	50.297	50.411	51.144	51.814	52.233	52.954	52.949	53.052	53.995	53.775	53.72	53.527	54.46	54.666	54.658	54.634	54.556	54.49	54.325	54.226	54.234	54.489	54.738	54.67	54.68	54.753	54.933	54.717	54.732	54.899	55.052	55.226	55.307	55.278	55.218	55.113	55.125	54.953	54.68	54.379	54.301	54.531	54.77	55.021	54.907	55.145	55.751	56.312	56.674	57.018	57.493	58.021	58.364	58.806	59.092	59.461	59.568	59.806	60.244	61.245	62.106	62.542	62.399	62.078	62.612	62.931	63.25	63.046	63.303	63.808	64.137	64.368	65.114	66.777	69.313	71.446	72.505	73.77	74.561	75.713	76.763	77.636	78.591	79.927	80.824	81.234	82.073	83.166	84.352	85.636	87.028	88.56	90.014	91.611	92.671	94.345	97.111	99.405	101.223	102.965	104.284	106.253	107.819	109.208	110.105	110.945	111.328	111.641	112.434	112.85	113.47	114.182	114.227	114.946	115.181	115.398	115.99	116.258	116.055	116.345	116.356	116.881	117.853	118.522	119.53	120.474	121.342	121.842	121.635	122.312	123.185	124.102	124.729	124.83	125.113	125.523	126.193	126.207	126.262	126.516	127.596	127.915	128.388	128.664	128.659	129.01	129.114	129.312	129.24	129.918	130.548	131.409	131.714	132.504	133.442	133.675	134.218	134.077	133.649	133.354	133.455	132.575	132.231	131.66	131.155	129.896	129.032	128.322	127.389	126.445	125.479	124.54	123.481	122.856	122.28	121.545	120.973	120.715	119.979	119.699	119.175	118.335	117.553	116.966	115.931	115.36	114.805	114.07	112.644	111.442	110.328	109.321	109.212	109.111	108.279	108.429	108.211	108.076	107.315	107.082	106.657	106.19	105.743	105.096	104.573	104.102	103.414	102.994	102.657	101.863	101.581	100.831	100.338	100.219	99.55	99.915	99.525	98.921]';
ppce_d = [98.293	97.817	97.68	98.071	97.843	97.32	97.112	96.685	96.131	95.757	95.47	94.883	94.267	93.766	93.213	92.769	92.22	91.51	90.988]';
ppce_d = [ppce_d_hist; ppce_d];

% nominal personal consumption expenditure on durables
npce_d_hist = [20.7	21.4	21.8	23.5	23.5	24	25.3	25	24.4	26.4	27.3	28.4	29.3	29.8	37.4	33.3	35.6	30.7	30.2	30.4	30.8	31	29.5	33.7	35.2	35	34.6	33.7	32.9	33.6	33.2	35.1	38.4	40.7	42.4	41.4	39.7	39.8	39.7	41.5	42.6	42.2	41.9	41.5	39.4	38.6	39.4	40.7	43.6	45.5	46.3	44.1	45.5	46.4	45.9	44.7	42.2	43.3	44.6	46.7	47.7	49	49.6	51.5	52.6	53.9	54.7	55.7	58	59.5	61.4	59.4	64.9	64.8	66.7	69.1	72.3	69.7	72.3	72.6	71.1	74.5	74.7	75.6	80.9	83.1	87.5	87.8	90	90.4	90.6	90.8	89.6	91	92	87.3	98.1	101	103.4	107.3	110.7	114.1	117.6	123.4	131.8	131.3	130.8	128.2	126.7	130.6	136.3	127.1	131.8	136.7	146.8	153.4	163.3	165.9	169.8	175.5	183.9	189.2	194	200.7	198.2	216.2	216.7	222.3	223.3	222.1	230.9	229	232.1	211.9	225.4	236.2	246	240.9	251.9	236.8	246.4	249.2	252.1	264.4	268.9	289.6	302.4	319.3	331.4	341.3	342.1	353.8	368	373.3	396.5	383.8	391.6	407.3	445.7	441.1	418.5	439.1	460.5	449.9	470.4	473.2	470.4	486.2	486.4	493.3	505.6	491.9	515.4	498.4	493.6	480.9	471.7	475.2	484.3	477.5	496.2	501	512.1	523.1	527.9	547.8	556.6	573.8	588.8	598.7	609.3	631.8	621.3	626.9	642.5	652.2	659.8	676.3	679.4	689.6	705.6	696.6	722.8	737.2	737.7	769.2	785	825.2	819.9	854.8	871.2	876.3	920.9	901.9	911.7	915.8	926.8	919.5	923.9	995.9	974.9	979.7	1003.5	983.3	974	1007.8	1042.3	1046	1062.3	1071.7	1084.2	1101.1	1110.5	1140.6	1145.4	1112.4	1153.3	1147	1158	1166.1	1173.4	1184.9	1190.2	1190.1	1152.3	1139.8	1101.9	1015.1	1012	1004.8	1045.8	1030.7	1040.2	1064.7]';
npce_d = [1075.1	1102.8	1115.3	1112.3	1123.8	1149.8	1178.8	1181.6	1194.2	1212.9	1238.4	1237.2	1241.4	1249.8	1256.3	1289.2	1308.5	1325.2	1331 ]';                
npce_d = [npce_d_hist; npce_d];



%% net out price of es from nonfarm business output prices

% express indexes in the same base year  -- NIPA base year is 2009 BLS
% base year is 2005

% rescale so that 2009q1 is base
base_pos = find(nipa_dates==2009);


pes = pes/pes(base_pos)*100;
py = py/py(base_pos)*100;
ppce = ppce/ppce(base_pos)*100;
ppce_d = ppce_d/ppce_d(base_pos)*100;


% extrapolate nominal based on NIPA non-farm business output series
base_year_pos = find(nipa_dates_annual == 2009);
nfby_base_val = nfby_ann(base_year_pos);

ny = py.*y;
scale_factor = nfby_base_val/sum(ny(base_pos:base_pos+3));
ny = ny*scale_factor*4;

% define real quantities by deflating nominal volumes with the price
% indices
y = ny./py;
es = nes./pes;
pce = npce./ppce;
pce_d = npce_d./ppce_d;


% plot(bls_dates,ny,'k'); hold on
% plot(nipa_dates_annual+.75,nfby_ann,'r--')
% legend('BLS','NIPA')

py_expes = 0*py;
py_expes(base_pos)=100;
% roll formula forward from base quarter till end of data
for ipos=base_pos+1:length(py)
    py_expes(ipos) =  py_expes(ipos-1)*...
                  sqrt( (ny(ipos)-nes(ipos))/(py(ipos-1)*y(ipos)-pes(ipos-1)*es(ipos))* ...  
                        (py(ipos)*y(ipos-1)-pes(ipos)*es(ipos-1))/(ny(ipos-1)-nes(ipos-1)) );
end

% roll formula backwards from base quarter till beginning of data
for ipos=base_pos:-1:2
    py_expes(ipos-1) = py_expes(ipos)*...
                  sqrt( (py(ipos-1)*y(ipos)-pes(ipos-1)*es(ipos))/(ny(ipos)-nes(ipos))* ...
                        (ny(ipos-1)-nes(ipos-1))/(py(ipos)*y(ipos-1)-pes(ipos)*es(ipos-1)) );
end



py_expes_exppce_d = 0*py;
py_expes_exppce_d(base_pos)=100;
% roll formula forward from base quarter till end of data
for ipos=base_pos+1:length(py)
    py_expes_exppce_d(ipos) =  py_expes_exppce_d(ipos-1)*...
                  sqrt( (ny(ipos)-nes(ipos)-npce_d(ipos))/(py(ipos-1)*y(ipos)-pes(ipos-1)*es(ipos)-ppce_d(ipos-1)*pce_d(ipos))* ...  
                        (py(ipos)*y(ipos-1)-pes(ipos)*es(ipos-1)-ppce_d(ipos)*pce_d(ipos-1))/(ny(ipos-1)-nes(ipos-1)-npce_d(ipos-1)) );
end

% roll formula backwards from base quarter till beginning of data
for ipos=base_pos:-1:2
    py_expes_exppce_d(ipos-1) = py_expes_exppce_d(ipos)*...
                  sqrt( (py(ipos-1)*y(ipos)-pes(ipos-1)*es(ipos)-ppce_d(ipos-1)*pce_d(ipos))/(ny(ipos)-nes(ipos)-npce_d(ipos))* ...
                        (ny(ipos-1)-nes(ipos-1)-npce_d(ipos-1))/(py(ipos)*y(ipos-1)-pes(ipos)*es(ipos-1)-ppce_d(ipos)*pce_d(ipos-1)) );
end


pes_incppce_d = 0*pes;
pes_incppce_d(base_pos)=100;
% roll formula forward from base quarter till end of data
for ipos=base_pos+1:length(py)
    pes_incppce_d(ipos) =  pes_incppce_d(ipos-1)*...
                  sqrt( (nes(ipos)+npce_d(ipos))/(pes(ipos-1)*es(ipos)+ppce_d(ipos-1)*pce_d(ipos))* ...  
                        (pes(ipos)*es(ipos-1)+ppce_d(ipos)*pce_d(ipos-1))/(nes(ipos-1)+npce_d(ipos-1)) );
end

% roll formula backwards from base quarter till beginning of data
for ipos=base_pos:-1:2
    pes_incppce_d(ipos-1) = pes_incppce_d(ipos)*...
                  sqrt( (pes(ipos-1)*es(ipos)+ppce_d(ipos-1)*pce_d(ipos))/(nes(ipos)+npce_d(ipos))* ...
                        (nes(ipos-1)+npce_d(ipos-1))/(pes(ipos)*es(ipos-1)+ppce_d(ipos)*pce_d(ipos-1)) );
end

es_incpce_d = (nes+npce_d)./pes_incppce_d;


% personal consumption expenditures excluding nondurables
ppce_exppce_d = 0*ppce;
ppce_exppce_d(base_pos)=100;
% roll formula forward from base quarter till end of data
for ipos=base_pos+1:length(py)
    ppce_exppce_d(ipos) =  ppce_exppce_d(ipos-1)*...
                  sqrt( (npce(ipos)-npce_d(ipos))/(ppce(ipos-1)*pce(ipos)-ppce_d(ipos-1)*pce_d(ipos))* ...  
                        (ppce(ipos)*pce(ipos-1)-ppce_d(ipos)*pce_d(ipos-1))/(npce(ipos-1)-npce_d(ipos-1)) );
end

% roll formula backwards from base quarter till beginning of data
for ipos=base_pos:-1:2
    ppce_exppce_d(ipos-1) = ppce_exppce_d(ipos)*...
                  sqrt( (ppce(ipos-1)*pce(ipos)-ppce_d(ipos-1)*pce_d(ipos))/(npce(ipos)-npce_d(ipos))* ...
                        (npce(ipos-1)-npce_d(ipos-1))/(ppce(ipos)*pce(ipos-1)-ppce_d(ipos)*pce_d(ipos-1)) );
end


pce_expce_d = (npce-npce_d)./ppce_exppce_d;


% figure
% plot(bls_dates,py/py(1)*100); hold on
% plot(bls_dates,py_expes/py_expes(1)*100,'r--')
% legend('nonfarm business output prices','ex. equipment and software')


%% get desired start and end positions within date vectors for different data sources
bls_start_pos_level = find(bls_dates==start_date);
bls_end_pos_level = find(bls_dates==end_date);

nipa_start_pos_level = find(nipa_dates==start_date);
nipa_end_pos_level = find(nipa_dates==end_date);

pop_start_pos = find(pop_dates==start_date);
pop_end_pos = find(pop_dates==end_date);

bls_growth_dates = bls_dates(2:end);
bls_start_pos_growth = find(bls_growth_dates==start_date);
bls_end_pos_growth = find(bls_growth_dates==end_date);


%% construct output series
% labor productivity growth
labprodg = diff(log(labprod));
labprodg = labprodg(bls_start_pos_growth:bls_end_pos_growth); 

% growth rate of the relative price of investment
%relpi = log(pi)-log(py);
if durable_switch
relpi = pes_incppce_d(bls_start_pos_level-1:bls_end_pos_level)./py_expes_exppce_d(bls_start_pos_level-1:bls_end_pos_level);
else
relpi = pes(bls_start_pos_level-1:bls_end_pos_level)./py_expes(bls_start_pos_level-1:bls_end_pos_level);
end
dpi = diff(relpi);

% hours worked per capita
hourspc = log(hours(bls_start_pos_level:bls_end_pos_level))-log(pop(pop_start_pos:pop_end_pos));

% equipment investment per capita
if durable_switch
espc = log(es_incpce_d(nipa_start_pos_level-1:nipa_end_pos_level))-log(pop(pop_start_pos-1:pop_end_pos));
else
espc = log(es(nipa_start_pos_level-1:nipa_end_pos_level))-log(pop(pop_start_pos-1:pop_end_pos));
end
espcg = diff(espc);

% pce per capita
if durable_switch
pcepc = log(pce_expce_d(nipa_start_pos_level-1:nipa_end_pos_level))-log(pop(pop_start_pos-1:pop_end_pos));   
else
pcepc = log(pce(nipa_start_pos_level-1:nipa_end_pos_level))-log(pop(pop_start_pos-1:pop_end_pos));
end

pcepcg = diff(pcepc);

