function [dpi, labprodg, hourspc, espcg, pcepcg] = getdata(start_date,end_date)

% returns dpi, the growth rate of the relative price of investment
% constructed as the implicit price deflator for equipment and software from Nipa Table 1.1.9 
% divided by non-farm business output prices (net of equipment and
% software)

% labprodg labor productivity growth
% log-differenced labor productivity in the nonfarm bussiness sector from
% BLS

% hourspc hours per capita
% is the log of hours worked in the nonfarm business sector minus
% the log of civilian noninstitutional population 16 years and over from
% the current population survey

% espcg growth rate of equipment and software per capita
% defined as the log of equipment and software (nominal equipment and
% software divided by its implicit deflator) minus the log of civilian
% noninstitutional population 16 years and over form the current population
% survey, differenced.

% pcepcg growth rate of consumption per capita
% log of personal consumption expenditures in NIPA table 1.1.6 minus the log of civilian
% noninstitutional population 16 years and over form the current population
% survey, differenced.

%start_date = 1983.5;
%end_date = 2008.5;

% quarterly data from 1947q1 to 2013q1
% hours worked source BLS  see dataset.xlsx
bls_dates = 1947:.25:2013;

% from NIPA_section1.xls -- used later
nipa_dates = 1969:.25:2013;

hours = [45.347	45.350	45.473	45.916
46.209	46.185	46.513	46.082
45.306	44.548	44.081	43.904
44.244	45.337	46.766	47.198
47.991	48.377	47.899	47.921
48.230	48.030	48.375	49.670
50.185	50.273	49.772	48.988
48.330	47.966	47.778	48.377
49.157	49.797	50.314	50.924
51.233	51.344	51.139	51.422
51.468	51.359	51.110	50.052
48.919	48.217	48.791	49.520
50.478	51.444	51.292	51.299
51.616	51.708	51.415	50.937
50.651	50.533	50.830	51.476
51.665	52.281	52.172	51.840
52.155	52.485	52.627	53.036
54.020	54.256	54.603	55.134
55.995	56.550	56.683	57.220
58.046	58.615	58.890	58.731
58.665	58.306	58.497	58.764
58.868	59.433	59.849	60.218
60.782	61.345	61.639	61.452
61.210	60.402	60.096	59.637
59.918	60.112	60.112	60.756
61.496	61.936	62.285	62.936
63.886	64.555	64.991	65.314
65.035	65.206	64.979	63.904
61.900	61.329	61.890	62.952
63.993	64.016	64.271	64.615
65.303	66.549	67.261	67.918
68.232	70.227	70.818	71.677
72.186	72.479	73.086	73.229
73.055	71.780	71.451	72.333
72.732	72.757	72.733	72.452
71.286	71.562	71.055	70.413
70.825	71.616	73.025	74.391
75.818	76.825	77.177	77.686
78.322	78.829	79.043	79.416
79.304	79.117	79.517	80.120
81.080	81.543	82.112	82.959
83.033	84.220	84.450	85.387
86.226	86.571	86.766	86.778
86.989	86.511	85.960	85.522
84.627	84.108	84.009	83.906
83.464	83.828	83.993	84.565
85.296	86.285	86.722	87.456
87.809	89.283	90.368	90.886
91.518	91.515	92.540	92.611
92.459	93.198	93.941	95.125
96.143	96.723	97.313	97.771
98.313	98.754	98.909	100.296
100.312	101.010	101.674	102.018
102.418	102.516	102.498	102.059
101.842	100.790	99.681	98.542
97.662	97.924	97.613	97.709
97.186	96.899	97.021	97.512
97.915	97.960	98.593	99.116
99.273	99.902	100.099	100.723
101.602	101.865	102.439	102.725
102.734	103.073	102.746	102.485
102.187	101.695	100.601	98.069
95.467	93.369	92.256	92.345
92.399	93.137	93.562	94.043
94.312	94.962	95.369	96.054
96.859	96.945	97.325	97.914
98.305  nan nan nan];

% remember that the command reshape works columnwise.
hours = reshape(hours',size(hours,1)*size(hours,2),1);
hours = hours(1:end-3);
hours = hours(find(bls_dates==nipa_dates(1)):end);

labprod = [26.838	27.493	26.719	27.820
27.945	27.923	27.962	28.108
28.398	28.692	29.394	29.218
30.228	30.571	31.262	31.311
31.379	31.290	32.005	32.076
32.210	32.155	32.006	32.625
32.878	32.970	33.125	32.981
33.035	33.284	33.882	34.291
34.941	35.038	35.173	35.048
34.595	34.736	34.731	35.096
35.502	35.371	35.879	35.989
35.461	36.145	36.837	37.454
37.547	38.034	38.006	37.926
38.815	38.269	38.343	37.864
38.321	39.422	39.945	40.337
41.008	40.958	41.480	41.758
42.002	42.408	43.273	43.305
43.735	44.012	44.351	43.913
44.549	44.812	45.608	46.468
47.104	46.793	46.857	47.174
47.546	47.722	47.891	48.043
49.122	49.594	49.558	49.464
49.859	49.452	49.493	49.273
49.417	50.175	50.947	50.512
52.016	52.186	52.650	52.207
52.893	54.001	54.326	54.759
56.013	56.064	55.542	55.185
55.072	54.929	54.352	54.854
55.291	56.206	56.859	56.870
57.703	58.248	58.325	58.469
58.774	59.066	59.671	58.872
58.902	60.076	60.059	60.413
59.822	59.647	59.572	59.496
59.723	59.028	59.250	59.890
60.850	60.034	60.564	59.795
59.399	59.525	59.623	60.141
60.877	62.282	62.831	63.126
63.099	63.486	63.756	63.844
63.957	64.125	64.973	65.276
66.104	66.599	66.888	66.709
66.281	66.733	66.720	67.337
67.514	67.747	67.916	68.295
67.986	68.233	68.637	68.703
69.217	69.814	70.082	69.484
69.644	70.680	71.111	71.438
72.662	73.169	73.894	74.450
73.908	73.605	73.862	74.358
74.761	74.706	74.250	74.955
74.692	74.853	74.894	75.475
76.137	77.006	77.241	77.269
77.038	77.902	78.517	78.842
79.300	79.775	80.857	81.472
82.269	82.335	83.027	84.436
84.131	85.990	86.007	86.887
86.656	88.216	88.707	89.963
91.904	91.945	92.828	92.803
93.610	94.883	97.089	97.434
97.598	98.407	98.485	98.741
99.797	99.580	100.328	100.295
101.017	101.059	100.452	101.147
101.095	101.930	103.111	103.614
102.959	103.564	103.293	102.409
103.860	105.516	106.858	108.123
108.940	108.815	109.665	110.141
109.793	109.953	109.919	110.541
110.350	110.827	111.672	111.192
111.331	nan nan nan];

labprod = reshape(labprod',size(labprod,1)*size(labprod,2),1);
labprod = labprod(1:end-3);
labprod = labprod(find(bls_dates==nipa_dates(1)):end);

%nfb deflator
py = [15.022	15.231	15.908	15.846
16.134	16.396	16.712	16.947
16.839	16.670	16.622	16.563
16.617	16.693	16.869	17.221
17.697	17.932	18.041	18.163
18.182	18.190	18.380	18.529
18.556	18.666	18.724	18.757
18.821	18.838	18.817	18.887
18.985	19.059	19.245	19.423
19.607	19.731	19.975	20.095
20.334	20.453	20.553	20.606
20.692	20.707	20.810	20.902
20.968	20.994	21.049	21.161
21.183	21.240	21.329	21.391
21.416	21.454	21.478	21.482
21.590	21.659	21.692	21.708
21.763	21.775	21.790	21.907
21.959	22.038	22.145	22.230
22.306	22.333	22.423	22.488
22.556	22.800	22.976	23.249
23.369	23.501	23.707	23.938
24.192	24.458	24.619	24.961
25.260	25.546	25.798	26.062
26.344	26.737	26.873	27.261
27.539	27.879	28.146	28.261
28.635	28.738	28.912	29.089
29.253	29.580	29.958	30.663
31.339	32.485	33.491	34.509
35.642	36.176	36.753	37.299
37.730	38.140	38.686	39.381
39.972	40.624	41.161	41.900
42.566	43.204	43.957	44.838
45.618	46.950	47.977	48.931
50.180	51.607	52.417	53.558
55.213	56.342	57.537	58.586
59.353	60.063	60.809	61.458
61.765	61.989	62.629	62.993
63.394	63.941	64.445	64.756
65.455	65.821	66.214	66.417
66.765	66.933	67.165	67.517
68.124	68.419	69.037	69.283
69.856	70.426	71.177	71.760
72.459	73.273	73.713	74.062
74.930	75.782	76.447	77.137
77.961	78.423	79.097	79.419
79.710	80.086	80.436	80.904
81.381	81.725	82.054	82.386
82.670	83.080	83.689	84.005
84.395	84.760	85.009	85.212
85.501	85.816	86.150	86.596
87.140	87.506	87.754	88.041
88.098	88.187	88.430	88.417
88.686	89.006	89.321	89.559
90.267	90.625	91.129	91.501
91.903	92.464	92.499	92.721
92.631	93.158	93.393	93.719
94.090	94.171	94.531	94.740
95.507	96.174	96.963	97.803
98.683	99.382	100.512	101.391
101.939	102.830	103.471	103.692
104.738	105.415	105.518	105.791
106.177	106.983	107.970	108.031
107.790	107.787	108.288	108.563
108.896	109.392	109.768	110.270
110.602	111.362	112.321	112.351
112.877	113.332	114.091	114.147
114.287	nan nan nan];

py = reshape(py',size(py,1)*size(py,2),1);
py = py(1:end-3);
py = py(find(bls_dates==nipa_dates(1)):end);

y = [11.788	12.063	11.739	12.350
12.477	12.439	12.545	12.478
12.388	12.309	12.472	12.356
12.883	13.350	14.069	14.220
14.489	14.554	14.740	14.782
14.941	14.868	14.916	15.620
15.906	15.985	15.903	15.594
15.411	15.404	15.623	16.003
16.573	16.837	17.081	17.235
17.126	17.241	17.174	17.451
17.667	17.563	17.728	17.417
16.787	16.872	17.392	17.950
18.310	18.881	18.788	18.758
19.312	19.085	19.031	18.625
18.758	19.249	19.628	20.065
20.473	20.682	20.909	20.952
21.149	21.498	22.015	22.185
22.800	23.055	23.378	23.393
24.112	24.496	24.994	25.689
26.424	26.522	26.687	26.797
26.993	26.938	27.136	27.357
28.018	28.557	28.748	28.875
29.368	29.402	29.561	29.347
29.311	29.365	29.664	29.186
30.175	30.374	30.645	30.726
31.532	32.407	32.766	33.382
34.644	35.039	34.934	34.881
34.661	34.660	34.173	33.905
33.101	33.343	34.029	34.645
35.737	36.092	36.302	36.614
37.228	38.101	38.892	38.767
38.976	40.899	41.241	42.005
41.927	41.981	42.289	42.335
42.434	41.241	41.190	42.164
43.114	42.590	42.935	42.264
41.284	41.530	41.315	41.314
42.110	43.561	44.738	45.796
46.752	47.665	48.088	48.436
48.913	49.396	50.164	50.621
51.144	51.417	51.927	52.193
52.560	53.241	53.625	54.645
54.882	55.819	56.138	56.982
57.457	57.904	58.337	58.377
59.018	59.223	59.093	58.316
57.883	58.469	58.815	59.061
59.862	60.597	61.249	62.031
62.079	62.451	62.930	63.841
64.460	65.544	65.941	66.987
67.298	67.542	68.313	68.913
69.392	70.782	71.647	72.554
73.129	74.435	75.495	76.164
77.084	77.957	79.156	80.784
81.690	82.429	83.696	85.374
85.407	87.285	87.291	87.747
87.339	87.895	87.434	87.473
88.669	88.970	89.368	89.298
90.149	91.501	93.843	95.230
95.506	96.449	97.307	98.110
99.424	99.989	100.907	101.545
103.056	103.200	103.249	104.292
104.332	105.347	106.228	106.509
105.265	105.886	105.051	101.745
99.800	99.516	99.726	100.958
101.475	102.651	103.717	104.783
104.228	105.429	105.883	107.413
108.727	109.156	110.271	110.455
110.382	111.103	nan     nan];	

y = reshape(y',size(y,1)*size(y,2),1);
y = y(1:end-3);
y = y(find(bls_dates==nipa_dates(1)):end);

% reassign bls dates since we have shortened each series to match
% NIPA
bls_dates = nipa_dates;

% population 1976-2013
pop_dates = 1976:.25:2013.25;
pop = [155075
155773
156527
157222
157911
158652
159430
160140
160829
161524
162265
163024
163756
164461
165200
166055
166762
167415
168111
168693
169279
169837
170413
170990
171497
172020
172522
173046
173505
173957
174449
174950
175679
176125
176595
177133
177522
177946
178414
178941
179825
180321
180835
181365
182002
182527
183016
183467
183967
184389
184840
185253
185773
186178
186602
187018
188630
188916
189353
189866
190271
190655
191121
191651
192075
192507
193024
193616
194106
195068
195068
195621
196085
196522
197050
197600
197882
198296
198807
199352
199776
200280
200850
201457
202396
202835
203367
203936
204395
204905
205483
206098
206876
207432
208044
208660
211586
212242
212918
213560
214101
214735
215422
216112
216664
217204
217867
218543
220110
220774
221513
222276
222356
222973
223680
224418
225038
225674
226422
227196
227764
228433
229167
229896
230839
231482
232210
232937
232807
233410
234110
234825
234912
235459
236093
236739
236997
237506
238104
238712
238852
239316
239871
240431
242436
242968
243564
244169
244828
245363];


%Table 1.9.5. Net Value Added by Sector                                                                                                                                                                                                                    																																														
%3	  Nonfarm \2\	A364RC1	\
nipa_dates_annual = 1969:2012;
nfby_ann =[ 688.6	713.4	770.8	849.0	942.5	1016.4	1096.1	1243.5	1397.4	1589.4	1774.5	1910.7	2132.8	2169.8	2403.2	2698.3	2906.7	3052.8	3221.5	3471.0	3731.4	3910.9	3992.4	4240.6	4479.5	4779.6	5018.5	5319.4	5696.9	6028.6	6418.6	6806.8	6931.6	7104.3	7436.5	7954.2	8530.7	9033.0	9402.5	9354.8	8946.2	9382.8	9802.1	10368.6]';


%11	      Equipment	Y033RC1	-- nominal volume $Bn
nes = [63.7	64.7	66.1	66.2	66.4	66.7	67.7	64.8	66.6	68.7	69.3	71.6	74.9	76.9	78.9	84.8	89.8	94.9	96.9	98.7	100.0	102.4	107.1	107.8	104.5	105.6	108.5	111.8	115.0	118.3	123.1	128.5	139.0	144.6	150.6	160.4	164.6	179.7	185.5	192.8	203.4	204.2	212.1	212.5	219.6	209.1	215.2	221.6	232.0	238.3	246.6	246.5	242.8	235.4	232.3	228.9	227.1	237.6	249.8	271.4	275.6	289.0	297.3	305.6	302.6	309.5	306.1	313.4	310.8	317.5	318.6	323.9	312.6	320.2	327.1	323.8	335.6	344.8	349.1	357.7	363.4	371.6	381.0	372.6	376.4	365.7	373.6	371.8	361.3	358.2	362.6	361.4	360.1	379.5	387.6	399.6	406.6	421.5	425.0	447.4	461.8	465.4	476.5	501.9	525.3	525.4	524.8	537.0	546.0	556.9	577.0	581.4	587.5	602.3	630.5	623.1	645.8	655.9	658.4	680.0	695.1	712.1	728.1	719.1	749.4	774.0	774.0	767.0	751.7	716.0	692.4	686.0	671.4	660.7	658.9	647.5	642.2	660.7	679.6	693.4	680.6	709.6	732.0	754.6	765.0	782.6	805.2	810.0	851.3	852.4	857.3	863.6	876.9	888.2	887.6	890.4	878.9	856.9	822.4	742.4	659.0	634.4	639.1	644.8	682.7	719.0	751.2	774.4	798.0	809.9	849.8	873.0	895.4	907.9	902.2	925.0	928.0]';

% 11	      Equipment	Y033RD3 -- Table 1.1.9 (10109qtr) -- Implicit Price Deflator -- 
pes = [53.718	54.000	54.487	54.969	55.574	56.104	56.525	57.179	57.799	58.159	58.237	58.231	58.641	58.919	59.032	58.894	59.126	59.717	60.204	60.377	61.150	62.697	65.269	68.470	71.608	73.872	74.999	76.157	77.323	78.064	79.062	80.283	81.584	82.781	84.106	85.522	86.529	87.581	88.686	89.767	91.446	93.128	94.666	96.339	98.852	101.370	103.556	105.053	107.049	109.083	110.439	111.924	114.053	115.595	116.411	116.928	116.771	116.275	115.708	115.551	115.345	115.254	115.002	114.820	114.706	114.825	115.134	115.713	115.909	116.977	118.068	118.663	118.639	118.062	117.500	118.524	119.125	119.426	119.627	121.012	121.482	121.630	122.312	122.960	123.644	123.907	124.798	126.055	127.065	126.770	126.409	126.580	127.127	126.692	126.520	125.789	125.624	125.220	124.809	124.542	124.994	125.224	124.950	124.135	123.619	123.836	123.482	122.863	121.873	120.758	120.299	119.748	118.692	117.779	117.008	115.923	114.156	112.667	111.411	110.166	109.387	108.218	107.029	106.396	106.080	105.652	105.297	104.541	103.243	102.605	101.865	101.326	100.892	100.422	99.915	99.740	98.866	98.429	98.359	98.446	98.238	98.577	98.300	98.326	98.811	98.943	98.449	98.373	98.245	98.027	98.325	98.667	98.959	99.100	98.521	97.842	97.724	97.746	98.896	100.765	100.777	100.439	99.883	98.910	97.860	97.809	98.046	98.290	98.457	98.864	99.047	99.307	99.832	99.937	100.299	100.673	100.601]';

%2	Personal consumption expenditures	DPCERX1 table 1.1.6 (10106 qtr) 
pce =[2810.3	2828.2	2842.0	2864.7	2882.4	2895.7	2921.1	2913.2	2968.9	2996.2	3020.1	3070.3	3110.8	3170.2	3219.1	3294.7	3354.8	3353.4	3365.4	3355.5	3326.3	3337.9	3351.7	3302.5	3330.2	3385.8	3434.1	3470.5	3539.9	3572.5	3610.4	3657.5	3699.4	3719.8	3755.2	3811.8	3833.9	3915.7	3932.1	3963.6	3983.7	3981.3	4020.5	4031.3	4025.1	3934.5	3976.9	4029.7	4050.9	4050.1	4066.4	4035.9	4062.7	4077.7	4109.2	4184.2	4224.8	4308.5	4384.1	4453.2	4490.9	4555.0	4590.0	4650.7	4729.7	4774.1	4865.8	4878.3	4919.7	4974.7	5064.8	5097.2	5098.0	5168.7	5228.6	5239.6	5332.7	5371.9	5417.7	5479.8	5505.1	5531.0	5585.9	5610.6	5658.8	5676.5	5699.4	5656.3	5636.8	5684.1	5711.7	5710.1	5817.4	5857.3	5920.7	5991.1	6013.9	6067.9	6134.8	6189.2	6260.1	6308.7	6357.6	6426.0	6443.0	6500.8	6560.4	6606.5	6667.8	6740.2	6780.8	6834.1	6906.2	6937.5	7056.2	7140.0	7213.7	7341.1	7437.7	7546.9	7625.8	7744.1	7836.8	7945.9	8067.1	8142.1	8223.1	8296.1	8325.7	8348.3	8376.3	8499.8	8527.0	8572.2	8633.0	8669.1	8712.2	8810.1	8938.2	9004.3	9096.3	9152.4	9239.3	9334.5	9409.5	9507.8	9578.9	9614.9	9722.7	9774.2	9833.4	9929.2	9987.1	10020.4	10060.1	10074.5	10054.1	10073.0	9993.7	9876.2	9843.6	9801.5	9862.7	9863.9	9915.4	9995.3	10063.7	10169.0	10221.3	10258.9	10311.9	10373.1	10447.8	10496.8	10541.0	10584.8	10644.0]';

%% net out price of es from nonfarm business output prices

% express indexes in the same base year  -- NIPA base year is 2009 BLS
% base year is 2005

% rescale so that 2009q1 is base
base_pos = find(nipa_dates==2009);


pes = pes/pes(base_pos)*100;
py = py/py(base_pos)*100;

% extrapolate nominal based on NIPA non-farm business output series
base_year_pos = find(nipa_dates_annual == 2009);
nfby_base_val = nfby_ann(base_year_pos);

ny = py.*y;
scale_factor = nfby_base_val/sum(ny(base_pos:base_pos+3));
ny = ny*scale_factor*4;


y = ny./py;
es = nes./pes;


plot(nipa_dates,ny,'k'); hold on
plot(nipa_dates_annual+.75,nfby_ann,'r--')
legend('BLS','NIPA')

py_expes = 0*py;
py_expes(base_pos)=100;
% roll formula forward from base quarter till end of data
for ipos=base_pos+1:length(py)
    py_expes(ipos) =  py_expes(ipos-1)*...
                  sqrt( (ny(ipos)-nes(ipos))/(py(ipos-1)*y(ipos)-pes(ipos-1)*es(ipos))* ...  
                        (py(ipos)*y(ipos-1)-pes(ipos)*es(ipos-1))/(ny(ipos-1)-nes(ipos-1)) );
end

% roll formula backwards from base quarter till beginning of data
for ipos=base_pos:-1:2
    py_expes(ipos-1) = py_expes(ipos)*...
                  sqrt( (py(ipos-1)*y(ipos)-pes(ipos-1)*es(ipos))/(ny(ipos)-nes(ipos))* ...
                        (ny(ipos-1)-nes(ipos-1))/(py(ipos)*y(ipos-1)-pes(ipos)*es(ipos-1)) );
end


% figure
% plot(bls_dates,py/py(1)*100); hold on
% plot(bls_dates,py_expes/py_expes(1)*100,'r--')
% legend('nonfarm business output prices','ex. equipment and software')


%% get desired start and end positions within date vectors for different data sources
bls_start_pos_level = find(bls_dates==start_date);
bls_end_pos_level = find(bls_dates==end_date);

nipa_start_pos_level = find(nipa_dates==start_date);
nipa_end_pos_level = find(nipa_dates==end_date);

pop_start_pos = find(pop_dates==start_date);
pop_end_pos = find(pop_dates==end_date);

bls_growth_dates = bls_dates(2:end);
bls_start_pos_growth = find(bls_growth_dates==start_date);
bls_end_pos_growth = find(bls_growth_dates==end_date);


%% construct output series
% labor productivity growth
labprodg = diff(log(labprod));
labprodg = labprodg(bls_start_pos_growth:bls_end_pos_growth); 

% growth rate of the relative price of investment
%relpi = log(pi)-log(py);
relpi = pes(nipa_start_pos_level-1:nipa_end_pos_level)./py_expes(bls_start_pos_level-1:bls_end_pos_level);
dpi = diff(relpi);

% hours worked per capita
hourspc = log(hours(bls_start_pos_level:bls_end_pos_level))-log(pop(pop_start_pos:pop_end_pos));

% equipment investment per capita
espc = log(es(nipa_start_pos_level-1:nipa_end_pos_level))-log(pop(pop_start_pos-1:pop_end_pos));
espcg = diff(espc);

% pce per capita
pcepc = log(pce(nipa_start_pos_level-1:nipa_end_pos_level))-log(pop(pop_start_pos-1:pop_end_pos));
pcepcg = diff(pcepc);

