function [distance_val model_momm]=distance_function_smallmod3(distance_param,data_momm,wtmat)

global rho_v_val rho_govc_val rho_betavar_val std_neutral std_a_m 

global M_ oo_

std_v = distance_param(1);    
std_govc = distance_param(2);
std_betavar = distance_param(3);
rho_v_val = distance_param(4);
rho_govc_val = distance_param(5);
rho_betavar_val = distance_param(6);


if (rho_v_val<0.95 && rho_v_val>0 && ...
    rho_govc_val<.95 && rho_govc_val>0 && ...
    rho_betavar_val<.95 && rho_betavar_val >0 &&...
    std_v > 0.0001 && std_govc>0.0001 && std_betavar>0.0001  )


try


stoch_simul([]);

dr_ = oo_.dr;
ys_ = oo_.dr.ys;
lgy_ = M_.endo_names;
lgx_ = M_.exo_names;

shock = [
std_v       % eps_v      
std_a_m     % eps_a_m    
0           % eps_a_n    
std_neutral % eps_neutral
std_govc    % eps_govc   
0    % eps_govi            
std_betavar];


dset = 'f0';
nperiods = 2000;
std_mat = diag(shock);
%errlist = char('eps_v','eps_a_m','eps_neutral','eps_govc','eps_govi');
randn('seed',1); 
makedata

model_dataset = [f0_g_p_m_data, f0_glabprod_data, f0_l_data, f0_g_c_data, f0_g_invest_data];
model_dataset = model_dataset-kron((mean(model_dataset)),ones(size(model_dataset,1),1));

%model_dataset = [f0_n_agg_data ,f0_gj_cp_data, f0_gc_cp_data];


optwt = 0; % no weighting function computed
[model_momm] = wtm_rm_noskew_opt(model_dataset,optwt);


distance_val = (model_momm-data_momm)'*wtmat*(model_momm-data_momm);
catch
model_momm = nan;
distance_val = 100000;   
end

else
model_momm = nan;
distance_val = 100000;
end

% var_labels =char('Investment Rel. Price','Growth of Lab. Prod.','Hours','Growth of Equipment Investment','Growth of Consumption');
% 
% nvars = size(var_labels,1);
% 
% 
% this_mom = 0;
% for i = 1:nvars
%     for j=i:nvars
%         this_mom = this_mom+1;
%     if i == j 
%         display(['Variance of ',deblank(var_labels(i,:)),' in the model is ',num2str(model_momm(this_mom)*10000),' and in the data is ',num2str(data_momm(this_mom)*10000)]) 
%     else
%         display(['The covariance of ',deblank(var_labels(i,:)),' witb ',deblank(var_labels(j,:)),' in the model is ',num2str(model_momm(this_mom)),' and in the data is ',num2str(data_momm(this_mom))]) 
%  
%     end
%     end
% end
% 
